// a simple example to demonstrate how data-input from a file works by using the utility program  oscFileIO
//the program "oscFileIO.exe" must have been started first with the command: oscFileIO 9000
//so the software listens on port 9000 (you can use a different port, but then you also have to adapt this file)
//in this example data of the file "sinusParamsdat" is sent to chuck,
//the file consists of two lines holding two values per line:
// a string (parameter name) and a float (parameter value); the parameters are used as gain and freq of a SinOsc UGen
//the file  is an ASCII textfile
//first a receiveLoop is set up and shredded that waits for the specified file
//then a file request is sent to oscFileIO and the file is received
// a SinOsc UGen is started with the received data
//hanez 19_10_07


//number of parameters that will be read from the file
2 => int numberOfParams;

//array to hold the values of the parameters that will be read from the file
float val[numberOfParams];

//this function listens on  the specified port and collects the data of the sent file
//in this example the data is collected into an associative array
//adapt this function to your needs
fun void receiveLoop(int portFrom)
{
    // create our OSC receiver
    OscRecv recv;
    portFrom => recv.port;

    // start listening (launch thread)
    recv.listen();
    
    //create an address in the receiver, store in new variable
	//the adress "/getData" must NOT be changed, because the program oscFileIO sends the data of a file always
	//to this adress; here we receive a string (=parameter name) and a float (=parameter value); an associative 
	//array is generated from this data
    recv.event( "/getData, s f" ) @=> OscEvent oe;
 
	string parmName;

    // infinite event loop
    while( true ) {
        // wait for event to arrive
        oe => now;
    
        // grab the next message from the queue. 
        while( oe.nextMsg()  ) { 
				//generate the associative array
            oe.getString() => parmName;
            oe.getFloat() => val[parmName];
    
            <<< "got (via OSC):", parmName, val[parmName] >>>;
        }
    }
}

//port at which the receiveloop listens; oscFileIO sets up a osc-sender sending the file to this port
8001 => int portFrom;
spork ~ receiveLoop(portFrom) @=> Shred @ s;
//you need this time to make sure the receiveLoop is ready (maybe it can be set to a smaller value)
1::second => now;


//so we have somebody that is waiting for the data of a file, now build up the file request
/////////////////////////////////////////////////////////////////////
//host to which the file request is sent; must be the one where oscFileIO runs
"localhost" => string hostname;

//port over which the file request is send: must be the same number with which you startet oscFileIO
9000 => int port;

//the file that shall be sent (in this examples the file holds two parameters for a SinOsc UGen: gain and freq) ;
//put your own pathname here!!!
"sinusParam.dat" => string filename;

//every line of the file is buffered by oscFileIO; so if you have lots of data per line in the file, it may 
//be necessary to make the buffer larger; here the buffer has room for 128 bytes
1024 => int bufSize;

//specifies how one line of the file looks like; in this example every line of the file consists of a string and a float 
//the file must be a ASCII text file  consisting of lines with equal number of values per line;
//the values within a line must be separated by one empty space
//attention: no spaces in this format string!!!
"sf" => string formatString;

// send object
OscSend xmit;

//to this host and over this port the filerequest is sent
xmit.setHost( hostname, port );

//this is the file request; must NOT be changed
xmit.startMsg( "/oscFromFile", "s s s i i" );

filename => xmit.addString;
formatString => xmit.addString;

//oscFileIO sends the file to this host (in this example is the same as the one where oscFileIO runs: localhost) ...
hostname => xmit.addString;

//... over this port
portFrom => xmit.addInt;
bufSize => xmit.addInt;


//give some time to receive the file and then remove the receiveLoop shred; 
//for large files this time eventually must be made longer
1::second => now;
Machine.remove( s.id() );
<<<"values: ", val["gain"],val["freq"]>>>;

//finally play the sinus with the values from the file
SinOsc si => dac;
val["gain"] => si.gain;
val["freq"] => si.freq;

 3::second => now;
