// a simple example to demonstrate how data-output to a file works by using the utility program  oscFileIO
//the program "oscFileIO.exe" must have been started first with the command: oscFileIO 9000
//so the software listens on port 9000  (you can use a different port, but then you also have to adapt this file)
//the best way is to first collect the data in some arrays and then send those arrays to oscFileIO via the
//chuck OscSend UGen
//in this example the amplitude values with the corresponding time of a sinus oscilator are collected and then
//output to a file (you must specify your own filename below!!!)
//the file generated here is an ASCII textfile with two columns separated by spaces
//the first column holds the time values, the second column holds the amplitude values of the sinus
//you can load the generated file into (pfui!) microsoft excess - h excel or matlab for example to plot the data
//hanez 19_10_07


//generate the data: amplitude values of a sinus every millisecond
/////////////////////////////////////////////////////////
SinOsc s => dac;

0.5 => s.gain;
1 => s.freq;

//arrays to hold the data
1100 => int nPoints;
float vecSinus[nPoints];
float vecTime[nPoints];

1::second => dur T;

0 => int k ;

while ( now/1::ms < T/1::ms) {
	//collect the data
	s.last() => vecSinus[k];
	now/ms => vecTime[k];
	k++;

	1::ms => now;
}


//and now send the data to a file
////////////////////////////
OscSend oscOutput;

//file name: put your own filename here!!!
//data is appended to the file, so if the file already exist (from an earlier session for example)
//don't forget to delete it first if you dont't want to mix data from different sessions (or change
//the filename here) 
"examples/testOut.dat" => string fileName;

//host to which the data is send (can be any host, not tested however)
"localhost" => string hostname;

//port over which the data is send: must be the same number with which you startet oscFileIO
9000 => int port;		

oscOutput.setHost(hostname, port);

k => int kMax;
0 => k;

//send the data: the first argument is ALWAYS the string which specifies the filename then follows the
//specifier for the data to be sent, in this case two float values; the messages are written line by line into the
//file, within the line the values are separated by one empty space
//it is only possible to write integers, floats and strings
//another example would be to use oscOutput.startMsg( "/oscToFile", "s s f") to save some parameter names with 
//the corresponding values of some patch in a file which later can be loaded back (preset management)
//to see how to load data from a file look at the example "testInput.ck"
while ( k < kMax ) {
	oscOutput.startMsg( "/oscToFile", "s f f");
	fileName => oscOutput.addString;
	vecTime[k] => oscOutput.addFloat;
	vecSinus[k] => oscOutput.addFloat;
	k++;

	//on my machine, when i omit this or make the time samller, values were lost, so maybe you have to 
	//adapt this time step here (make it larger) in case not all data arrives in the file
	1::ms => now;
}
