#include "oscToFile.h"
#include <iostream>
#include <fstream>
#include <string>

using namespace std;

void OscToFilePacketListener::ProcessMessage( const osc::ReceivedMessage& m, 
				const IpEndpointName& remoteEndpoint )
{
    try{
		if( strcmp( m.AddressPattern(), "/oscToFile" ) == 0 ) {
            osc::ReceivedMessage::const_iterator arg = m.ArgumentsBegin();

			const char *fileName = (arg++)->AsString();

			ofstream myFile(fileName,ios::out | ios::app);

			if ( myFile.is_open() ) {
				while ( arg != m.ArgumentsEnd() ) {
					if ( arg->IsFloat() ){
						float a = (arg++)->AsFloat();
						myFile << a << " ";
					} else if ( arg->IsInt32() ) {
						int a = (arg++)->AsInt32();
						myFile << a << " ";
					} else if ( arg->IsString() ) {
						const char *a = (arg++)->AsString();
						myFile << a << " ";
					}
				}
				myFile << "\n";
				myFile.close();
			} else cout << "Unable to open file: " << fileName << endl;
        } 
		else if ( strcmp(m.AddressPattern(), "/oscFromFile" ) == 0 ) {
			cout << "/oscFromFile" << endl;
            osc::ReceivedMessage::const_iterator arg = m.ArgumentsBegin();

			const char *fileName = (arg++)->AsString();
			const char *formatString = (arg++)->AsString();
			const char *hostToSend = (arg++)->AsString();
			int portToSend = (arg++)->AsInt32();
			const int bufSize = (arg++)->AsInt32();

			cout << "fileName: " << fileName << endl;
			cout << "formatString: " << formatString << endl;
			cout << "hostToSend: " << hostToSend << endl;
			cout << "portToSend: " << portToSend << endl;
			cout << "bufsize: " << bufSize << endl;

			UdpTransmitSocket transmitSocket(IpEndpointName(hostToSend, portToSend));

			char *buffer = new char[bufSize];
			osc::OutboundPacketStream p(buffer, bufSize);

			//read the entire file into the buffer
			string strFormat(formatString);

			ifstream myfile(fileName);
			if ( myfile.is_open() ) {
				while (! myfile.eof() ) {
					p.Clear();
					p << osc::BeginMessage( "/getData" );

					for ( unsigned int i = 0; i < strFormat.length(); i++ ) {
						if ( strFormat.at(i) == 's' ) {
							string a;
							myfile >> a;

							//cout << a << " ";
							p << a.c_str();
						} else if ( strFormat.at(i) == 'i' ) {
							int a;
							myfile >> a;

							//cout << a << " ";
							p << a;
						} else if ( strFormat.at(i) == 'f' ) {
							float a;
							myfile >> a;

							//cout << a << " ";
							p << a;
						} else 
							cout << "unknown specifier " << strFormat.at(i) << " in format string" << endl;
					}

					cout << endl;
					p << osc::EndMessage;
					transmitSocket.Send(p.Data(), p.Size());
				}
				myfile.close();
				cout << "file transmitted" << endl;
			} else 
				cout << "Unable to open file"; 
			
			delete[] buffer;
		}
    } catch( osc::Exception& e ){
        // any parsing errors such as unexpected argument types, or 
        // missing arguments get thrown as exceptions.
        std::cout << "error while parsing message: "
            << m.AddressPattern() << ": " << e.what() << "\n";
    }
}
