// oscToFile.cpp : Definiert den Einstiegspunkt fr die Konsolenanwendung.
//

//#include "stdafx.h"
#include <iostream>

#include "oscToFile.h"
#include "osc/OscReceivedElements.h"
#include "osc/OscPrintReceivedElements.h"

#include "ip/UdpSocket.h"
#include "ip/PacketListener.h"

#include "osc/OscOutboundPacketStream.h"

using namespace std;

int main(int argc, char* argv[])
{
	if( argc >= 2 && strcmp( argv[1], "-h" ) == 0 ){
        std::cout << "usage: oscToFile [port]\n";
        return 0;
    }

	int port = 7000;

	if( argc >= 2 )
		port = atoi( argv[1] );

	OscToFilePacketListener listener;
    UdpListeningReceiveSocket s(IpEndpointName(IpEndpointName::ANY_ADDRESS, port),
            &listener );

	std::cout << "listening for input on port " << port << "...\n";
	std::cout << "press ctrl-c to end\n";

	s.RunUntilSigInt();

	std::cout << "finishing.\n";	

	return 0;
}

