/*
 * Decompiled with CFR 0.152.
 */
package se.antimon.monomeclock;

import java.net.SocketException;
import java.util.Calendar;
import se.antimon.monomeclock.OscCommunication;

public class MonomeClock {
    private static final boolean CLOCK_24HOURS = true;
    private static final int TOP = 1;
    private static final int SEGMENT_HEIGHT = 3;
    private static final String PREFIX = "/clock";
    private static final boolean DEBUG = false;
    private static final Integer STATE_ON = new Integer(1);
    private static final Integer STATE_OFF = new Integer(0);
    private static Object[] threeArguments = new Object[3];
    private static OscCommunication osc = null;
    private static int hourMajor = -1;
    private static int hourMinor = -1;
    private static int minuteMajor = -1;
    private static int minuteMinor = -1;

    private static void clear() {
        osc.sendOscCommand("/clock/clear", null, false);
    }

    private static void lightSegment(int segment, int xOffset, boolean state) {
        MonomeClock.threeArguments[2] = state ? STATE_ON : STATE_OFF;
        switch (segment) {
            case 0: {
                MonomeClock.threeArguments[1] = 1;
                int i = 0;
                while (i < 3) {
                    MonomeClock.threeArguments[0] = new Integer(xOffset + i);
                    osc.sendOscCommand("/clock/led", threeArguments, false);
                    ++i;
                }
                break;
            }
            case 1: {
                int i = 0;
                while (i < 4) {
                    MonomeClock.threeArguments[0] = new Integer(xOffset);
                    MonomeClock.threeArguments[1] = new Integer(1 + i);
                    osc.sendOscCommand("/clock/led", threeArguments, false);
                    ++i;
                }
                break;
            }
            case 2: {
                int i = 0;
                while (i < 4) {
                    MonomeClock.threeArguments[0] = new Integer(xOffset + 2);
                    MonomeClock.threeArguments[1] = new Integer(1 + i);
                    osc.sendOscCommand("/clock/led", threeArguments, false);
                    ++i;
                }
                break;
            }
            case 3: {
                MonomeClock.threeArguments[1] = 4;
                int i = 0;
                while (i < 3) {
                    MonomeClock.threeArguments[0] = new Integer(xOffset + i);
                    osc.sendOscCommand("/clock/led", threeArguments, false);
                    ++i;
                }
                break;
            }
            case 4: {
                int i = 0;
                while (i < 4) {
                    MonomeClock.threeArguments[0] = new Integer(xOffset);
                    MonomeClock.threeArguments[1] = new Integer(4 + i);
                    osc.sendOscCommand("/clock/led", threeArguments, false);
                    ++i;
                }
                break;
            }
            case 5: {
                int i = 0;
                while (i < 4) {
                    MonomeClock.threeArguments[0] = new Integer(xOffset + 2);
                    MonomeClock.threeArguments[1] = new Integer(4 + i);
                    osc.sendOscCommand("/clock/led", threeArguments, false);
                    ++i;
                }
                break;
            }
            case 6: {
                MonomeClock.threeArguments[1] = 7;
                int i = 0;
                while (i < 3) {
                    MonomeClock.threeArguments[0] = new Integer(xOffset + i);
                    osc.sendOscCommand("/clock/led", threeArguments, false);
                    ++i;
                }
                break;
            }
            case 7: {
                int i = 0;
                while (i < 7) {
                    MonomeClock.threeArguments[0] = new Integer(xOffset);
                    MonomeClock.threeArguments[1] = new Integer(1 + i);
                    osc.sendOscCommand("/clock/led", threeArguments, false);
                    ++i;
                }
                break;
            }
            case 8: {
                int i = 0;
                while (i < 7) {
                    MonomeClock.threeArguments[0] = new Integer(xOffset + 2);
                    MonomeClock.threeArguments[1] = new Integer(1 + i);
                    osc.sendOscCommand("/clock/led", threeArguments, false);
                    ++i;
                }
                break;
            }
        }
    }

    private static void lightNumber(int number, int xOffset, boolean state) {
        switch (number) {
            case 0: {
                MonomeClock.lightSegment(0, xOffset, state);
                MonomeClock.lightSegment(6, xOffset, state);
                MonomeClock.lightSegment(7, xOffset, state);
                MonomeClock.lightSegment(8, xOffset, state);
                break;
            }
            case 1: {
                MonomeClock.lightSegment(8, xOffset - 1, state);
                break;
            }
            case 2: {
                MonomeClock.lightSegment(0, xOffset, state);
                MonomeClock.lightSegment(2, xOffset, state);
                MonomeClock.lightSegment(3, xOffset, state);
                MonomeClock.lightSegment(4, xOffset, state);
                MonomeClock.lightSegment(6, xOffset, state);
                break;
            }
            case 3: {
                MonomeClock.lightSegment(0, xOffset, state);
                MonomeClock.lightSegment(3, xOffset, state);
                MonomeClock.lightSegment(6, xOffset, state);
                MonomeClock.lightSegment(8, xOffset, state);
                break;
            }
            case 4: {
                MonomeClock.lightSegment(1, xOffset, state);
                MonomeClock.lightSegment(3, xOffset, state);
                MonomeClock.lightSegment(8, xOffset, state);
                break;
            }
            case 5: {
                MonomeClock.lightSegment(0, xOffset, state);
                MonomeClock.lightSegment(1, xOffset, state);
                MonomeClock.lightSegment(3, xOffset, state);
                MonomeClock.lightSegment(5, xOffset, state);
                MonomeClock.lightSegment(6, xOffset, state);
                break;
            }
            case 6: {
                MonomeClock.lightSegment(0, xOffset, state);
                MonomeClock.lightSegment(3, xOffset, state);
                MonomeClock.lightSegment(5, xOffset, state);
                MonomeClock.lightSegment(6, xOffset, state);
                MonomeClock.lightSegment(7, xOffset, state);
                break;
            }
            case 7: {
                MonomeClock.lightSegment(0, xOffset, state);
                MonomeClock.lightSegment(8, xOffset, state);
                break;
            }
            case 8: {
                MonomeClock.lightSegment(0, xOffset, state);
                MonomeClock.lightSegment(3, xOffset, state);
                MonomeClock.lightSegment(6, xOffset, state);
                MonomeClock.lightSegment(7, xOffset, state);
                MonomeClock.lightSegment(8, xOffset, state);
                break;
            }
            case 9: {
                MonomeClock.lightSegment(0, xOffset, state);
                MonomeClock.lightSegment(1, xOffset, state);
                MonomeClock.lightSegment(3, xOffset, state);
                MonomeClock.lightSegment(8, xOffset, state);
                break;
            }
            case 12: {
                MonomeClock.lightSegment(0, xOffset - 1, state);
                MonomeClock.lightSegment(2, xOffset - 1, state);
                MonomeClock.lightSegment(3, xOffset - 1, state);
                MonomeClock.lightSegment(4, xOffset, state);
                MonomeClock.lightSegment(6, xOffset - 1, state);
            }
        }
    }

    public static void updateClock() {
        Calendar cal = Calendar.getInstance();
        int hour = cal.get(11);
        int minute = cal.get(12);
        int newHourMajor = hour / 10;
        int newHourMinor = hour % 10;
        int newMinuteMajor = minute / 10;
        int newMinuteMinor = minute % 10;
        if (newHourMajor != hourMajor) {
            if (hourMajor >= 2) {
                MonomeClock.lightNumber(12, 0, false);
            } else if (hourMajor >= 1) {
                MonomeClock.lightNumber(1, 0, false);
            }
            hourMajor = newHourMajor;
            if (hourMajor >= 2) {
                MonomeClock.lightNumber(12, 0, true);
            } else if (hourMajor >= 1) {
                MonomeClock.lightNumber(1, 0, true);
            }
        }
        if (newHourMinor != hourMinor) {
            MonomeClock.lightNumber(hourMinor, 3, false);
            hourMinor = newHourMinor;
            MonomeClock.lightNumber(hourMinor, 3, true);
        }
        if (newMinuteMajor != minuteMajor) {
            MonomeClock.lightNumber(minuteMajor, 9, false);
            minuteMajor = newMinuteMajor;
            MonomeClock.lightNumber(minuteMajor, 9, true);
        }
        if (newMinuteMinor != minuteMinor) {
            MonomeClock.lightNumber(minuteMinor, 13, false);
            minuteMinor = newMinuteMinor;
            MonomeClock.lightNumber(minuteMinor, 13, true);
        }
    }

    public static void main(String[] args) {
        boolean secondBlink = true;
        try {
            osc = new OscCommunication(8080);
            MonomeClock.clear();
            MonomeClock.updateClock();
            Object[] objectArray = new Object[3];
            objectArray[0] = new Integer(7);
            objectArray[1] = new Integer(4);
            Object[] secondDot1 = objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = new Integer(7);
            objectArray2[1] = new Integer(6);
            Object[] secondDot2 = objectArray2;
            while (true) {
                Thread.sleep(1000L);
                MonomeClock.updateClock();
                secondDot1[2] = secondBlink ? STATE_ON : STATE_OFF;
                osc.sendOscCommand("/clock/led", secondDot1, false);
                secondDot2[2] = secondBlink ? STATE_ON : STATE_OFF;
                osc.sendOscCommand("/clock/led", secondDot2, false);
                secondBlink = !secondBlink;
            }
        }
        catch (SocketException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }
}

