/*
 * Decompiled with CFR 0.152.
 */
package se.antimon.monomeclock;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.text.FieldPosition;
import java.text.NumberFormat;

public class OscCommunication {
    private DatagramSocket socket = null;
    private int sendPort = -1;

    public OscCommunication(int sendPort) throws SocketException {
        this.sendPort = sendPort;
        this.socket = new DatagramSocket();
    }

    private int memAlign(int unalignedMem) {
        return unalignedMem + 4 - unalignedMem % 4;
    }

    private void storeInt(int value, byte[] mem, int memOffset) {
        mem[memOffset + 3] = (byte)(value & 0xFF);
        mem[memOffset + 2] = (byte)((value & 0xFF00) << 8);
        mem[memOffset + 1] = (byte)((value & 0xFF0000) << 16);
        mem[memOffset + 0] = (byte)((value & 0xFF000000) << 24);
    }

    private byte[] createOscBuffer(String command, Object[] arguments) {
        int commandMem = this.memAlign(command.length());
        int argCountMem = arguments == null ? 4 : this.memAlign(arguments.length + 1);
        StringBuffer argumentString = new StringBuffer(",");
        int argumentMem = 0;
        int i = 0;
        while (arguments != null && i < arguments.length) {
            if (arguments[i] instanceof Integer) {
                argumentString.append("i");
                argumentMem += 4;
            } else if (arguments[i] instanceof String) {
                argumentString.append("s");
                argumentMem += this.memAlign(((String)arguments[i]).length());
            } else {
                throw new IllegalArgumentException("OSC argument of type " + arguments[i].getClass().getName() + " not supported");
            }
            ++i;
        }
        byte[] result = new byte[commandMem + argCountMem + argumentMem];
        byte[] commandBytes = command.getBytes();
        System.arraycopy(commandBytes, 0, result, 0, commandBytes.length);
        byte[] argCountBytes = argumentString.toString().getBytes();
        System.arraycopy(argCountBytes, 0, result, commandMem, argCountBytes.length);
        if (arguments != null) {
            int currentMemPos = commandMem + argCountMem;
            int i2 = 0;
            while (i2 < arguments.length) {
                if (arguments[i2] instanceof Integer) {
                    this.storeInt((Integer)arguments[i2], result, currentMemPos);
                    currentMemPos += 4;
                } else if (arguments[i2] instanceof String) {
                    byte[] argBytes = ((String)arguments[i2]).getBytes();
                    System.arraycopy(argBytes, 0, result, currentMemPos, argBytes.length);
                    currentMemPos += this.memAlign(argBytes.length);
                }
                ++i2;
            }
        }
        return result;
    }

    private void printBuffer(byte[] buffer) {
        NumberFormat nf = NumberFormat.getInstance();
        int row = 0;
        while (row < buffer.length) {
            int column = 0;
            while (column < 4) {
                if (buffer[row + column] > 32) {
                    System.out.print((char)buffer[row + column]);
                } else {
                    System.out.print("?");
                }
                ++column;
            }
            System.out.print("  ");
            FieldPosition fp = new FieldPosition(0);
            int column2 = 0;
            while (column2 < 4) {
                StringBuffer outBuffer = new StringBuffer();
                nf.format(buffer[row + column2], outBuffer, fp);
                int i = 0;
                while (i < 4 - fp.getEndIndex()) {
                    System.out.print(" ");
                    ++i;
                }
                System.out.print(outBuffer);
                ++column2;
            }
            System.out.println();
            row += 4;
        }
    }

    public void sendOscCommand(String command, Object[] arguments, boolean print) {
        byte[] oscBuffer = this.createOscBuffer(command, arguments);
        if (print) {
            System.out.println("Sending:");
            this.printBuffer(oscBuffer);
        }
        try {
            DatagramPacket packet = new DatagramPacket(oscBuffer, oscBuffer.length, InetAddress.getLocalHost(), this.sendPort);
            this.socket.send(packet);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

