/****************************************
 *        MonomeClock                   *
 *        by Stefan Blixt               *
 *        2008-03-09                    *
 *                                      *
 *        prefix: /clock                *
 ****************************************/

package se.antimon.monomeclock;

import java.net.SocketException;
import java.util.Calendar;

public class MonomeClock {
	private static final boolean CLOCK_24HOURS = true;
	private static final int TOP = 1;
	private static final int SEGMENT_HEIGHT = 3;
	private static final String PREFIX = "/clock";
	private static final boolean DEBUG = false;
	private static final Integer STATE_ON = new Integer(1);
	private static final Integer STATE_OFF = new Integer(0);
	private static Object[] threeArguments = new Object[] {null, null, null};
	private static OscCommunication osc = null;
	private static int hourMajor = -1;
	private static int hourMinor = -1;
	private static int minuteMajor = -1;
	private static int minuteMinor = -1;
	
	private static void clear() {
		osc.sendOscCommand(PREFIX + "/clear", null, DEBUG);
	}

	private static void lightSegment(int segment, int xOffset, boolean state) {
		threeArguments[2] = state ? STATE_ON : STATE_OFF;
		switch(segment) {
		case 0: // Top
			threeArguments[1] = TOP;
			for (int i = 0; i < 3; i++) {
				threeArguments[0] = new Integer(xOffset+i);
				osc.sendOscCommand(PREFIX + "/led", threeArguments, DEBUG);
			}
			break;
		case 1: // Top left
			for (int i = 0; i < SEGMENT_HEIGHT+1; i++) {
				threeArguments[0] = new Integer(xOffset);
				threeArguments[1] = new Integer(TOP + i);
				osc.sendOscCommand(PREFIX + "/led", threeArguments, DEBUG);
			}
			break;
		case 2: // Top right
			for (int i = 0; i < SEGMENT_HEIGHT+1; i++) {
				threeArguments[0] = new Integer(xOffset + 2);
				threeArguments[1] = new Integer(TOP + i);
				osc.sendOscCommand(PREFIX + "/led", threeArguments, DEBUG);
			}
			break;
		case 3: // Middle
			threeArguments[1] = TOP + SEGMENT_HEIGHT;
			for (int i = 0; i < 3; i++) {
				threeArguments[0] = new Integer(xOffset+i);
				osc.sendOscCommand(PREFIX + "/led", threeArguments, DEBUG);
			}
			break;
		case 4: // Bottom left
			for (int i = 0; i < SEGMENT_HEIGHT+1; i++) {
				threeArguments[0] = new Integer(xOffset);
				threeArguments[1] = new Integer(TOP + SEGMENT_HEIGHT + i);
				osc.sendOscCommand(PREFIX + "/led", threeArguments, DEBUG);
			}
			break;
		case 5: // Bottom right
			for (int i = 0; i < SEGMENT_HEIGHT+1; i++) {
				threeArguments[0] = new Integer(xOffset + 2);
				threeArguments[1] = new Integer(TOP + SEGMENT_HEIGHT + i);
				osc.sendOscCommand(PREFIX + "/led", threeArguments, DEBUG);
			}
			break;
		case 6: // Bottom
			threeArguments[1] = TOP + 2*SEGMENT_HEIGHT;
			for (int i = 0; i < 3; i++) {
				threeArguments[0] = new Integer(xOffset+i);
				osc.sendOscCommand(PREFIX + "/led", threeArguments, DEBUG);
			}
			break;
		case 7: // Left
			for (int i = 0; i < 2*SEGMENT_HEIGHT+1; i++) {
				threeArguments[0] = new Integer(xOffset);
				threeArguments[1] = new Integer(TOP + i);
				osc.sendOscCommand(PREFIX + "/led", threeArguments, DEBUG);
			}
			break;
		case 8: // Right
			for (int i = 0; i < 2*SEGMENT_HEIGHT+1; i++) {
				threeArguments[0] = new Integer(xOffset + 2);
				threeArguments[1] = new Integer(TOP + i);
				osc.sendOscCommand(PREFIX + "/led", threeArguments, DEBUG);
			}
			break;
		}
	}
	private static void lightNumber(int number, int xOffset, boolean state) {
		switch(number) {
		case 0:
			lightSegment(0, xOffset, state);
			lightSegment(6, xOffset, state);
			lightSegment(7, xOffset, state);
			lightSegment(8, xOffset, state);
			break;
		case 1:
			lightSegment(8, xOffset-1, state);
			break;
		case 2:
			lightSegment(0, xOffset, state);
			lightSegment(2, xOffset, state);
			lightSegment(3, xOffset, state);
			lightSegment(4, xOffset, state);
			lightSegment(6, xOffset, state);
			break;
		case 3:
			lightSegment(0, xOffset, state);
			lightSegment(3, xOffset, state);
			lightSegment(6, xOffset, state);
			lightSegment(8, xOffset, state);
			break;
		case 4:
			lightSegment(1, xOffset, state);
			lightSegment(3, xOffset, state);
			lightSegment(8, xOffset, state);
			break;
		case 5:
			lightSegment(0, xOffset, state);
			lightSegment(1, xOffset, state);
			lightSegment(3, xOffset, state);
			lightSegment(5, xOffset, state);
			lightSegment(6, xOffset, state);
			break;
		case 6:
			lightSegment(0, xOffset, state);
			lightSegment(3, xOffset, state);
			lightSegment(5, xOffset, state);
			lightSegment(6, xOffset, state);
			lightSegment(7, xOffset, state);
			break;
		case 7:
			lightSegment(0, xOffset, state);
			lightSegment(8, xOffset, state);
			break;
		case 8:
			lightSegment(0, xOffset, state);
			lightSegment(3, xOffset, state);
			lightSegment(6, xOffset, state);
			lightSegment(7, xOffset, state);
			lightSegment(8, xOffset, state);
			break;
		case 9:
			lightSegment(0, xOffset, state);
			lightSegment(1, xOffset, state);
			lightSegment(3, xOffset, state);
			lightSegment(8, xOffset, state);
			break;
		case 12: // Special case - 24 hour clock '2' at the left end
			lightSegment(0, xOffset-1, state);
			lightSegment(2, xOffset-1, state);
			lightSegment(3, xOffset-1, state);
			lightSegment(4, xOffset, state);
			lightSegment(6, xOffset-1, state);
			break;
		}
	}
	public static void updateClock() {
		Calendar cal = Calendar.getInstance();
		int hour = CLOCK_24HOURS ? cal.get(Calendar.HOUR_OF_DAY) : cal.get(Calendar.HOUR);
		int minute = cal.get(Calendar.MINUTE);
		int newHourMajor = hour / 10;
		int newHourMinor = hour % 10;
		int newMinuteMajor = minute / 10;
		int newMinuteMinor = minute % 10;
		if (newHourMajor != hourMajor) {
			if (hourMajor >= 2) {
				lightNumber(12, 0, false);
			} else if (hourMajor >= 1) {
				lightNumber(1, 0, false);
			}
			hourMajor = newHourMajor;
			if (hourMajor >= 2) {
				lightNumber(12, 0, true);
			} else if (hourMajor >= 1) {
				lightNumber(1, 0, true);
			}
		}
		if (newHourMinor != hourMinor) {
			lightNumber(hourMinor, 3, false);
			hourMinor = newHourMinor;
			lightNumber(hourMinor, 3, true);
		}
		if (newMinuteMajor != minuteMajor) {
			lightNumber(minuteMajor, 9, false);
			minuteMajor = newMinuteMajor;
			lightNumber(minuteMajor, 9, true);
		}
		if (newMinuteMinor != minuteMinor) {
			lightNumber(minuteMinor, 13, false);
			minuteMinor = newMinuteMinor;
			lightNumber(minuteMinor, 13, true);
		}
	}
	public static void main(String[] args) {
		boolean secondBlink = true;
		try {
			osc = new OscCommunication(8080);
			clear();
			updateClock();
			Object[] secondDot1 = new Object[] {new Integer(7), new Integer(4), null};
			Object[] secondDot2 = new Object[] {new Integer(7), new Integer(6), null};
			while (true) {
				Thread.sleep(1000);
				updateClock();
				secondDot1[2] = secondBlink ? STATE_ON : STATE_OFF;
				osc.sendOscCommand(PREFIX + "/led", secondDot1, false);
				secondDot2[2] = secondBlink ? STATE_ON : STATE_OFF;
				osc.sendOscCommand(PREFIX + "/led", secondDot2, false);
				secondBlink = !secondBlink;
			}
		} catch (SocketException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (InterruptedException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}

}
