/*
 * Special Function Registers V0.1
 * FileName: 18Fxx20_reg.h
 *
 * Created on 26.06.2006
 *
 * This is file provides Register definitions for PIC18Fxx20 devices.
 * PIC 18F2525, 18F2620 , 18F4525 and 18F4620
 * Registers can be accessed via pointers. 
 * Registername is the same as in the microchip datasheets used.
 *
 * @author Eric Boger
 */

#define PORTA      0xf80
#define PORTB      0xf81
#define PORTC      0xf82
#define PORTD      0xf83
#define PORTE      0xf84

#define LATA       0xf89
#define LATB       0xf8a
#define LATC       0xf8b
#define LATD       0xf8c
#define LATE       0xf8d

#define TRISA      0xf92
#define TRISB      0xf93
#define TRISC      0xf94
#define TRISD      0xf95
#define TRISE      0xf96

#define OSCTUNE    0xf9b

#define PIE1       0xf9d
#define PIR1       0xf9e
#define IPR1       0xf9f
#define PIE2       0xfa0
#define PIR2       0xfa1
#define IPR2       0xfa2

#define EECON1     0xfa6
#define EECON2     0xfa7
#define EEDATA     0xfa8
#define EEADR      0xfa9
#define EEADRH     0xfaa

#define RCSTA      0xfab
#define TXSTA      0xfac
#define TXREG      0xfad
#define RCREG      0xfae
#define SPBRG      0xfaf
#define SPBRGH     0xfb0

#define T3CON      0xfb1
#define TMR3L      0xfb2
#define TMR3H      0xfb3
#define CMCON      0xfb4
#define CVRCON     0xfb5
#define ECCP1AS    0xfb6
#define PWM1CON    0xfb7
#define BAUDCON    0xfb8

#define CCP2CON    0xfba
#define CCPR2L     0xfbb
#define CCPR2H     0xfbc
#define CCP1CON    0xfbd
#define CCPR1L     0xfbe
#define CCPR1H     0xfbf

#define ADCON2     0xfc0
#define ADCON1     0xfc1
#define ADCON0     0xfc2

#define ADRESL     0xfc3
#define ADRESH     0xfc4
#define SSPCON2    0xfc5
#define SSPCON1    0xfc6
#define SSPSTAT    0xfc7
#define SSPADD     0xfc8
#define SSPBUF     0xfc9
#define T2CON      0xfca
#define PR2        0xfcb
#define TMR2       0xfcc
#define T1CON      0xfcd
#define TMR1L      0xfce
#define TMR1H      0xfcf
#define RCON       0xfd0
#define WDTCON     0xfd1
#define LVDCON     0xfd2
#define OSCCON     0xfd3

#define T0CON      0xfd5
#define TMR0L      0xfd6
#define TMR0H      0xfd7
#define STATUS     0xfd8
#define FSR2L      0xfd9
#define FSR2H      0xfda
#define PLUSW2     0xfdb
#define PREINC2    0xfdc
#define POSTDEC2   0xfdd
#define POSTINC2   0xfde
#define INDF2      0xfdf

#define BSR        0xfe0
#define FSR1L      0xfe1
#define FSR1H      0xfe2
#define PLUSW1     0xfe3
#define PREINC1    0xfe4
#define POSTDEC1   0xfe5
#define POSTINC1   0xfe6
#define INDF1      0xfe7
#define WREG       0xfe8
#define FSR0L      0xfe9
#define FSR0H      0xfea
#define PLUSW0     0xfeb
#define PREINC0    0xfec
#define POSTDEC0   0xfed
#define POSTINC0   0xfee
#define INDF0      0xfef
#define INTCON3    0xff0
#define INTCON2    0xff1
#define INTCON     0xff2
#define PRODL      0xff3
#define PRODH      0xff4
#define TABLAT     0xff5
#define TBLPTRL    0xff6
#define TBLPTRH    0xff7
#define TBLPTRU    0xff8
#define PCL        0xff9
#define PCLATH     0xffa
#define PCLATU     0xffb
#define STKPTR     0xffc
#define TOSL       0xffd
#define TOSH       0xffe
#define TOSU       0xfff
