/*
   PICsynth * API/HAL Layer *
   
   Version 0.4
            
   Eric Boger (2008)
*/



int8  API_AUDIOOUT = 0x7f;
int8  API_POT[8];


        void API_Init (void);
#inline void API_Task (void);


void API_Init(void)
{ 

   //            76543210
   set_tris_a (0b11111111);                                                                                                                                                          
   set_tris_b (0b00111111);                                                                  
   set_tris_c (0b10100000);                                    
   set_tris_d (0b00000000);              
   set_tris_e (0b11111111);    

   // ADC
   setup_adc_ports(AN0_TO_AN7 | VSS_VDD);
   setup_adc(ADC_CLOCK_DIV_32); // div_64                  
   set_adc_channel(0);    
   read_adc(ADC_START_ONLY);

   // PWM                        
   setup_ccp1   (CCP_PWM);         
   setup_timer_2(T2_DIV_BY_1, 255, 1);   
   set_pwm1_duty (0x7f);

}


#inline
void API_Task(void)
{
   static int8 channel=0;

   // audio output
   set_pwm1_duty(API_AUDIOOUT);

   // read ADC
   if (!bit_test(*ADCON0,1)) // ADC finished?
   {
      bit_set(*ADCON0,1);
      API_POT[channel]=read_adc(ADC_READ_ONLY);
   
      channel++; 
      if (channel>7) channel=0;
      set_adc_channel(channel);  
   
      read_adc(ADC_START_ONLY);
   }
   
}

