/*
   XOR Synthesizer
   
   Version 0.4 
               
   Eric Boger (2008)                      
*/                     

//                     
// global variables  
//             

// "API" Potentiometer 0..7 values:
// int8 API_POT[8];

int8  XOR_out       = 0x7f;


void DSP_XOR_Init (void)
{
   XOR_out       = 0x7f;

}


int8 DSP_XOR_Alg_1 (int1 reverse)
{
   static int8  oscA     = 0;
   static int8  oscArate = 1;
   static int8  oscB     = 0;
   static int8  oscBrate = 1;
   static int8  oscC     = 0;
   static int16 oscCrate = 1;  
  
   int8  param_oscArate;
   int8  param_oscBrate;
   int8  param_oscCrate;
   
   int8 temp = 0;

   param_oscArate = (~API_POT[_POT_PARAM1])>>1;
   param_oscBrate = (~API_POT[_POT_PARAM2]);
   param_oscCrate = (~API_POT[_POT_PARAM3])<<4;

   // oscillator A 
   oscArate--; 
   if (oscArate == 0)
   {
      oscArate = param_oscArate;
      oscA = ~oscA;
   }

   // oscillator B 
   oscBrate--; 
   if (oscBrate == 0)
   {
      oscBrate = param_oscBrate;
      oscB = ~oscB;
   }

   // oscillator C 
   oscCrate--; 
   if (oscCrate == 0)
   {
      oscCrate = param_oscCrate;
      if (oscCrate == 0) oscCrate = 16;
      oscC = ~oscC;
   }

   // ringmod  oscA xor oscB -> temp
   temp = oscA ^ oscB; 
   
   // ringmod  oscC xor temp
   XOR_out = temp ^ oscC;

   return XOR_out;
}
