/*
   PICsynth * MAIN Entry Point *
   
   Version 0.4
   
   Eric Boger (2008)
*/

#include "18F4620.h"  // device definitions

#define OSCINTERNAL // use internal oscillator (8Mhz,PLL4 -> 32MHz)

#OPT 11
#CASE
#device adc=8
#device HIGH_INTS=TRUE


// *****************************************************************************
// Config Fuses
// *****************************************************************************
#ifdef OSCINTERNAL
// internal oscillator
   #fuses INTRC_IO, WDT128, PUT, NOPROTECT, NOLVP, NODEBUG, NOBROWNOUT //, XINST
#else
// external crystal
   #fuses H4, WDT128, PUT, NOPROTECT, NOLVP, NODEBUG, NOBROWNOUT //, XINST   
#endif

// *****************************************************************************
// I/O Pin definitions
// *****************************************************************************
// Port A:
// Analog input 0..4
#define _PIN_T0CKI      PIN_A4 // Timer0 clock in

// Port B:                     
#define _PIN_aux2       PIN_B0 // not used
#define _PIN_aux1       PIN_B1 // not used 
#define _PIN_REVERSE    PIN_B4 // Reverse   
#define _PIN_GATE       PIN_B5 // Play
#define _PIN_STORE      PIN_B6 // PGC, Store/Rec
#define _PIN_LEDSTATUS  PIN_B7 // PGD, Status LED 

// Port C:
#define _PIN_BUS_EN     PIN_C0 // optional 8 bit port D input bus driver enable
#define _PIN_SPI_CS     PIN_C1 // SPI chip select (PIC is master)
#define _PIN_PWM        PIN_C2 // PWM output
#define _PIN_SPI_SCK    PIN_C3 // SPI clock
#define _PIN_SPI_SDI    PIN_C4 // SPI data input
#define _PIN_SPI_SDO    PIN_C5 // SPI data output
#define _PIN_UART_TX    PIN_C6 // UART transmit                           
#define _PIN_UART_RX    PIN_C7 // UART receive

// Port D: 
// Bidirectional data bus

// Port E:                                
// Analog input 5..7


#use fast_io (a)
#use fast_io (b)
#use fast_io (c)
#use fast_io (d)             
#use fast_io (e)
                       
                       
// *****************************************************************************
// Delay timing setup
// *****************************************************************************                        
#ifdef OSCINTERNAL                   
// Internal 8MHz oscillator, PLLx4  Fosc=32MHz -> 8 MIPS
   #use delay (clock=32000000, restart_wdt)
#else
// 10MHz crystal, PLLx4  Fosc=40MHz -> 10 MIPS
   #use delay (clock=40000000, restart_wdt)

// Overclocked 16MHz crystal, PLLx4  Fosc=64MHz -> 16 MIPS
// #use delay (clock=64000000, restart_wdt)
#endif      

                 
// *****************************************************************************
// UART/I2C setup
// ***************************************************************************** 
#use RS232 (baud=19200,parity=N,xmit=PIN_C6,rcv=PIN_C7,bits=8,restart_wdt)
                
                
// *****************************************************************************
// UART/I2C
// ***************************************************************************** 
#include "18Fxx20_reg.h"                                       
#include "API.c"
#include "Application.c"


// *****************************************************************************
// Entry Point (MAIN)
// *****************************************************************************  
#ZERO_RAM       
void main (void)                                                           
{        
   #ifdef OSCINTERNAL  
      // setup internal oscillator
      setup_oscillator(OSC_32MHZ, 0); // internal oscillator 8MHz, PLL4 fosc=32MHz
   #endif

   // Init
   API_Init ();
   APP_Init ();
   
   // Watchdog enable
   setup_wdt(WDT_ON);
          
   // Main loop       
   while (42)
   {
      APP_Task ();
      API_Task ();
      restart_wdt();
   }
}
