/*
   Fractal Synthesizer
   
   Version 0.4 
               
   Eric Boger (2008)                      
*/                     

//                     
// global variables  
//             

// "API" Potentiometer 0..7 values:
// int8 API_POT[8];

int8  FS_out        = 0x7f;
int16 FS_cnt        = 0;   
int8  FS_cnthi      = 0;
int8  FS_cntlo      = 0;


void DSP_FS_Init (void)
{
   FS_out        = 0x7f;
   FS_cnt        = 0;
}


int8 DSP_FS_Alg_1 (int1 reverse)
{    
   // Param1 = hi nibble AND mod HI 
   // Param2 = lo nibble AND mod HI
   // Param3 = hi nibble MUL mod
   // Param4 = lo nibble MUL mod 
   // Param5 = output AND mod
   // Param6 = not used
      
   int8 param1;
   int8 param2;
   int8 param3;
   
   param1 = (API_POT[_POT_PARAM1]&0xf0) + (API_POT[_POT_PARAM2]>>4);
   param2 = (API_POT[_POT_PARAM3]&0xf0) + (API_POT[_POT_PARAM4]>>4);
   param3 =  API_POT[_POT_PARAM5];
   if (param3==0) param3=0x80;
   
   FS_cnthi = make8(FS_cnt,1) & param1;
   FS_cntlo = make8(FS_cnt,0);       
   FS_out = _mul(FS_cnthi, FS_cntlo);   
   FS_out = _mul(FS_out,   param2);        

   if (param3 != 255)
   {
      if (FS_out & param3) FS_out=255;
      else                 FS_out=0;  
   }
   
   // pitch down shift register

   if (reverse) FS_cnt--;
   else         FS_cnt++;

   return FS_out;
}


int8 DSP_FS_Alg_2 (int1 reverse)
{
   // Param1 = hi nibble AND mod HI 
   // Param2 = lo nibble AND mod HI
   // Param3 = hi nibble AND mod LO
   // Param4 = lo nibble AND mod LO
   // Param5 = output AND mod
   // Param6 = not used
   
   int8 param1;
   int8 param2;
   int8 param3;

   param1 = (API_POT[_POT_PARAM1]&0xf0) + (API_POT[_POT_PARAM2]>>4);
   param2 = (API_POT[_POT_PARAM3]&0xf0) + (API_POT[_POT_PARAM4]>>4);
   param3 =  API_POT[_POT_PARAM5]; 
   if (param3==0) param3=0x80;
   
   FS_cnthi = make8(FS_cnt,1) & param1;
   FS_cntlo = make8(FS_cnt,0) & param2;                                    
   FS_out   = _mul(FS_cnthi, FS_cntlo);           
   
   if (param3 != 255)
   {   
      if (FS_out & param3) FS_out=255;
      else                 FS_out=0;    
   }
   
   if (reverse) FS_cnt--;
   else         FS_cnt++;    
  
   return FS_out;
}



