/*
   Wired Sound Generator (WSG)
   
   Version 0.4
               
   Eric Boger (2008)                      
*/                     

//                     
// global variables  
//             

// "API" Potentiometer 0..7 values:
// int8 API_POT[0..7];

// Param1 = Main Osc pitch
// Param2 = AM   Osc pitch
// Param3 = FM   Osc pitch
// Param4 = FM   Depth
// Param5 = Switch Voice A/B
// Param6 = 


int8  WSG_out = 0x7f;


void DSP_WSG_Init (void)
{
   WSG_out = 0x7f;
}


int8 DSP_WSG_Alg_1 (int1 reverse)
{
   static int8  oscA     = 0;
   static int8  oscArate = 1;
   static int8  oscB     = 0;
   static int16 oscBrate = 1;
   static int8  oscC     = 0;
   static int8  oscCrate = 1;  
  
   int8  param_oscArate;
   int16 param_oscBrate;
   int8  param_oscCrate;
   int8  param_fmdepth;
   
   int8 temp = 0;

   param_oscArate = (~API_POT[_POT_PARAM2])>>2;
   param_oscBrate = (API_POT[_POT_PARAM3]);
   param_oscBrate = param_oscBrate << 4;
   param_oscCrate = (~API_POT[_POT_PARAM1])>>2;
   param_fmdepth  = (API_POT[_POT_PARAM4])>>3; 

   // oscillator A (AM modulation)
   oscArate--; 
   if (oscArate == 0)
   {
      oscArate = param_oscArate;
      if (oscArate == 0) oscA = 0xff;  // AM off
      else               oscA = ~oscA; // AM on
   }
   
   // oscillator B (LFO FM modulation)
   if (oscBrate > param_oscBrate) oscBrate = param_oscBrate;
   oscBrate--;
   if (oscBrate == 0)
   {
      oscBrate = param_oscBrate;
      if (oscBrate == 0) oscBrate = 1;
      oscB = ~oscB;
   }
      
   // osc B fm modulation
   if (oscB == 0xff) 
   {
      temp = param_fmdepth;
   }

   // oscillator C (main oscillator)
   oscCrate--; 
   if (oscCrate == 0)
   {
      oscCrate = param_oscCrate;
      
      if (oscCrate > temp) oscCrate -= temp;
      else                 oscCrate = 1;
      
      if (oscCrate == 0) oscCrate = 1;
      oscC = ~oscC;
   }
   
   // oscillator C amplitude modulation
   if (oscA == 0) WSG_out = 0x7f;
   else           WSG_out = oscC;
   
   return WSG_out;
}


