/*
   PICsynth * Application Layer *
   
   Version 0.4b 
   
   Eric Boger (2008)
*/

//                     
// API FUNCTIONS
//     
// Potentiometer 0..7 values:
// int8 API_POT[8];
// 
// Audio Output:
// int8 API_AUDIOOUT
//

        void APP_Init(void);
#inline void APP_Task(void);


#define BUFFER_SIZE   2047
int8    BUFFER[BUFFER_SIZE+1];

int8    LED          = 0x7f;
int8    ALGORITHM    = 0;
int8    ALGORITHMOLD = 0xff;
int1    PLAY         = FALSE;
int1    REVERSE      = FALSE;
int8    POTLOCK      = 0;
int8    CLOCK        = 1;

#define _POT_DATA    0 
#define _POT_SPEED   1
#define _POT_PARAM1  2
#define _POT_PARAM2  3
#define _POT_PARAM3  4
#define _POT_PARAM4  5
#define _POT_PARAM5  6
#define _POT_PARAM6  7


const int8 LEDCHAR[17] = 
{
//   .gfedcba
   0b11000000, // 0
   0b11111001, // 1
   0b10100100, // 2
   0b10110000, // 3
   0b10011001, // 4
   0b10010010, // 5
   0b10000010, // 6
   0b11111000, // 7
   0b10000000, // 8
   0b10010000, // 9
   0b10001000, // a
   0b10000011, // b
   0b11000110, // c
   0b10100001, // d
   0b10000110, // e
   0b10001110  // f
   0b11000010  // g
   
};

const int8 LEDSYMBOL[16] = 
{
   0b11010101, // 0   _  .
//   .gfedcba         _  |
   
   0b11101010, // 1     _.
//   .gfedcba        |  _ 
   
   0b10010100, // 2   _  .
//   .gfedcba        |_| |
   
   0b10100010, // 3     _.
//   .gfedcba        | |_|
    
   0b10011100, // 4   _  .
//   .gfedcba        |_|    
               
   0b10100011, // 5     _.
//   .gfedcba          |_|      
   
   0b10011101, // 6   _
//   .gfedcba         _|    
      
   0b10101011, // 7     _
//   .gfedcba          |_    
   
   // not defined
   0b11111111, // 8
   0b11111111, // 9
   0b11111111, // a
   0b11111111, // b
   0b11111111, // c
   0b11111111, // d
   0b11111111, // e
   0b11111111, // f
};


#include "DSP_FractalSynth.c"
#include "DSP_Sequencer.c"
#include "DSP_CellularSynth.c"
#include "DSP_WSG.c"
#include "DSP_XOR.c"


void APP_Init (void)
{     
   output_high(_PIN_BUS_EN);    // bus driver disabled
   set_tris_d(0x00);            // data bus output

   output_high(_PIN_LEDSTATUS); // status LED on
     
   DSP_FS_Init();
   DSP_SEQ_Init();
   DSP_CA_Init();
   DSP_WSG_Init();
   DSP_XOR_Init();
   
   POTLOCK = 0;
}

#inline
void APP_changeAlgorithm (void)
{
   POTLOCK = 0xff;
}


#inline 
void APP_TriggerPlay (void)
{
   CLOCK        = 1;

   // Fraktal Synth
   FS_cnt       = 0;
   
   // FM Step-Sequener
   SEQ_step     = 0;
   SEQ_trigger  = TRUE;
   SEQ_clockdiv = 0x7f;
   
   // WSG
   
   // XOR
   
}

#inline
void APP_getParameter (void)
{
   static int1 playtrigger = TRUE;
   
   ALGORITHM = API_POT[_POT_DATA] >> 5; //   POT 0 = Algorithm 0..7
   REVERSE   = input(_PIN_REVERSE);     //   Reverse play on/off

   // play / retrigger ? 
   if (input(_PIN_GATE))
   {   
      if (playtrigger) 
      {
         PLAY = TRUE;
         playtrigger = FALSE;
         APP_TriggerPlay();
      }
   }
   else 
   {
      API_AUDIOOUT = 0x7f;
      PLAY = FALSE;
      playtrigger = TRUE;
   }
   
   // change algorithm ?
   if (ALGORITHMOLD != ALGORITHM)
   {
      LED = LEDCHAR[ALGORITHM+1]; // show synth number without dp
   }
   ALGORITHMOLD = ALGORITHM;

   output_d(LED); // refresh LED display
}


#inline                           
void APP_Task (void)
{

   APP_getParameter(); // get global parameters

   if (!PLAY) return;

   // process selected algorithm 
   switch(ALGORITHM)
   {
      case 0:  // Fractal Algorithm 1              
               CLOCK--; if (CLOCK!=0) break;
               CLOCK=(~API_POT[_POT_SPEED]) >> 3;
               CLOCK++;
               API_AUDIOOUT = DSP_FS_Alg_1(REVERSE);
               break;
                
      case 1:  // Fractal Algorithm 2
               CLOCK--; if (CLOCK!=0) break;
               CLOCK=(~API_POT[_POT_SPEED]) >> 3;
               CLOCK++;
               API_AUDIOOUT = DSP_FS_Alg_2(REVERSE);
               break;

      case 2:  // 8 Step Sequencer FM-Synth                
               API_AUDIOOUT = DSP_SEQ_Alg_1(REVERSE);               
               
               CLOCK--; if (CLOCK!=0) break;
               CLOCK=(~API_POT[_POT_SPEED]) >> 3;
               CLOCK++;
               DSP_SEQ_Do(REVERSE); 
               break;
               
      case 3:  // WSG
               CLOCK--; if (CLOCK!=0) break;    
               CLOCK=(~API_POT[_POT_SPEED]) >> 3;
               CLOCK++;
               API_AUDIOOUT = DSP_WSG_Alg_1(REVERSE);
               break;
      
      case 4:  // XOR
               CLOCK--; if (CLOCK!=0) break;
               CLOCK=(~API_POT[_POT_SPEED]) >> 3;
               CLOCK++;
               API_AUDIOOUT = DSP_XOR_Alg_1(REVERSE);
               break;

      case 5:  //
      
               break;

      case 6:  //
      
               break;

      case 7:  //
      
               break;

   }
   
}
                     
                      
