// manytones.ck, June, 2008, Dale Parson (Acoustic Interloper),
// acknowledgements to Les Hall (Inventor) and Kassen for getting
// me into my first ChucK program. Thanks!

// Launch as a sound generator for chessgame.py as of 
// 18 June 2008. This OSC type format is patch specific.
// There are 4 banks of ugens with 64 ugens each.
// Bank 0 generates sines and bank 1 triangles in the
// initial test. Incoming OSC fields are describd in PROTOCOL_2.txt.
// SEE PROTOCOL_2.txt for the June, 2008, 9-field protocol.

// Add some additional sounds to chesstones.ck


// The structure of these classes mirrors the structure of the Max/MSP patch.

class OscBlock {                // a single ramped oscillator
    Osc @ gen ;                // SinOsc or TriOsc, set after construction
    new PulseOsc @=> PulseOsc pulser ;
    Envelope pulseramp ;
    0.0 => float savefreq ;
    Envelope ramp ;
    Gain lgain ;                // left channel gain
    Gain rgain ;                // right channel gain
    UGen @ leftdest ;
    UGen @ rightdest ;
    Event oscevent ;
    int isdead ;                // set to 1 when oscillator is off
    1 => isdead ;
    0 => int savefx ;
    0::ms => dur lfosampleperiod ;
    0.0 => float lfophase ;
    // lampl and rampl record levels for output scaling
    0.0 => float lampl ;
    0.0 => float rampl ;
    50::ms => dur gaindelay ;  // duration of a change in amplitude
    ramp => lgain ;
    ramp => rgain ;
    pulseramp => lgain ;
    pulseramp => rgain ;
    0 => int inpulse ;
    10::ms => dur pulsedelay ;
    
    // Invoke init() one time after constructing this object, passing its
    // generator and left and right outputs.
    fun void init(Osc newgen, UGen leftout, UGen rightout) {
        newgen @=> gen ;
        1.0 => gen.gain ;
        gen => ramp ;
        1.0 => pulser.gain ;
        // 0.2 => pulser.width ;
        pulser => pulseramp ;
        leftout @=> leftdest ;
        rightout @=> rightdest ;
        spork ~ osc_run_thread();     // Each oscillator gets a garbage collector.
    }
    // Set up the oscillator path but do not advance time.
    // Use fx to predicate time for FX addition to basic signal.
    // For notes where sustain is short, FX won't be heard, but for sustained
    // tones it will.
    fun void play(float freq, float phase, float left, float right,
            int fx, int piecetype) {
        left => lampl ;
        right => rampl ;
        isdead => int wasdead ;
        if (left == 0.0 && right == 0.0) {
            0 => ramp.target ;
            0 => pulseramp.target ;
            1 => isdead ;
            0 => savefx ;
            0.0 => savefreq ;
            if (! wasdead) {
                oscevent.signal();   // Schedule disconenction after ramp down.
            }
        } else if (freq > -1.0) {
            freq => savefreq ;
            freq => gen.freq ;
            freq * 10 => pulser.freq ;
            phase => gen.phase ;
            left => lgain.gain ;
            right => rgain.gain ;
            1 => ramp.target ;
            0 => isdead ;
            if (wasdead) {
                lgain => leftdest ;
                rgain => rightdest ;
            }
            if (fx != 0) {
                0 => inpulse ;
                0 => pulseramp.target ;
                if (savefx == 0) {
                    // 10 seconds / inter_piece_distance / 45 discrete samples
                    fx => savefx ;
                    ((10000.0 / fx) / 45.0)::ms => lfosampleperiod ;
                    0.0 => lfophase ;
                    oscevent.signal();
                }
            } else {
                if (piecetype == 1) {
                    0.25 => pulseramp.target ;
                    pulsedelay => pulseramp.duration ;
                    1 => inpulse ;
                } else{
                    0 => inpulse ;
                    0 => pulseramp.target ;
                } 
                0 => savefx ;
                0.0::ms => lfosampleperiod ;
                0.0 => lfophase ;
            }
            oscevent.signal();  // switch the pulser
        }
        gaindelay => ramp.duration ;
    }
    // Disconnect a dead oscillator after ramp time expires.
    // Each OscBlock object has a shred whose sole job it is to do this.
    fun void osc_run_thread() {
        while (1) {
            // Wait until awakened and then until ramp down is done.
            if (isdead != 0) {
                gaindelay => now ;  // RAMP DOWN COMPLETED
                lgain =< leftdest ;
                rgain =< rightdest ;
                oscevent => now ;        // AWAKENED
                0 => savefx ;
                0.0::ms => lfosampleperiod ;
                0.0 => lfophase ;
            } else if (inpulse != 0) {
                pulsedelay => now ;
                0 => pulseramp.target ;
                pulsedelay => pulseramp.duration ;
                0 => inpulse ;
            } else if (savefx != 0) {
                lfosampleperiod => now ;
                savefreq + (Math.sin(lfophase) * 1.5 * savefreq) => gen.freq ;
                lfophase + (pi / 11.25) => lfophase ;
            } else {
                oscevent => now ;
            }
        }
    }
}

64 => int OscillatorsPerBank ;
4 => int Banks ;
OscillatorsPerBank * Banks => int NumberOscillators ;

OscBlock blocks[NumberOscillators] ;

Gain leftscale => dac.left ;
Gain rightscale => dac.right ;
1.0 => leftscale.gain ;
1.0 => rightscale.gain ;
0.0 => float leftsum ;
0.0 => float rightsum ;
0 => int osccount ;

// Create and wire the OscBlocks to the gain scalers.
for (0 => int b ; b < Banks ; b++) {
    Osc @ nextgen ;
    for (0 => int o ; o < OscillatorsPerBank ; o++) {
        (b * OscillatorsPerBank) + o => int i ;
        if ((b & 1) == 0) {
            new SinOsc @=> nextgen ;
        } else {
            new TriOsc @=> nextgen ;
        }
        blocks[i].init(nextgen, leftscale, rightscale) ;
    }
}

// Create our OSC (Open Sound Control) receiver.
OscRecv recv;
// port 7401 used by the chess program
57120 => recv.port;
// start listening (launch thread)
recv.listen();

// create an address in the receiver, store in new variable
recv.event( "list, i i f f f f i i i i i i" ) @=> OscEvent @ oe;

second => now ;

// infinite event loop
while( true )
{
    // wait for event to arrive
    oe => now;

    // grab the next message from the queue. 
    while( oe.nextMsg() )
    { 
        int bank, osc, player, piecetype, relationship ;
        int otherplayer, otherpiecetype, movenumber ;
        int piecediff ;
        float freq, phase, leftampl, rightampl ;

        // getFloat fetches the expected float (as indicated by "i f")
        oe.getInt() => bank ;
        oe.getInt() => osc ;
        oe.getFloat() => freq ;
        oe.getFloat() => phase ;
        oe.getFloat() => leftampl ;
        oe.getFloat() => rightampl ;
        oe.getInt() => player ;
        oe.getInt() => piecetype ;
        oe.getInt() => relationship ;
        oe.getInt() => otherplayer ;
        oe.getInt() => otherpiecetype ;
        oe.getInt() => movenumber ;
        // <<< "OSC:", bank, osc, freq, phase, leftampl, rightampl, player, piecetype, relationship, otherplayer, otherpiecetype, movenumber >>>;

        (OscillatorsPerBank * bank) + osc => int oscix ;
        if (oscix >= NumberOscillators) {
            continue ;
        }
        if (! blocks[oscix].isdead) {
            blocks[oscix].lampl -=> leftsum ;
            blocks[oscix].rampl -=> rightsum ;
            osccount-- ;
        }
        if (relationship == 1) {
            otherpiecetype - piecetype => piecediff ;
        } else if (relationship == 3) {
            piecetype - otherpiecetype => piecediff ;
        } else {
            0 => piecediff ;
        }
        if (piecediff < 1) {
            0 => piecediff ;
        }
        blocks[oscix].play(freq, phase, leftampl, rightampl, piecediff, piecetype);
        if (! blocks[oscix].isdead) {
            blocks[oscix].lampl +=> leftsum ;
            blocks[oscix].rampl +=> rightsum ;
            osccount++ ;
        }
        // <<< "SUMS", leftsum, rightsum >>>;
        if (leftsum > 1.0) {
            (1.0 / leftsum) => leftscale.gain ;
        } else {
            1.0 => leftscale.gain ;
        }
        if (rightsum > 1.0) {
            (1.0 / rightsum) => rightscale.gain ;
        } else {
            1.0 => rightscale.gain ;
        }
    }
}
