from Tkinter import *
from tkMessageBox import showerror, showwarning, askyesno
from math import *
import socket
import xmlrpclib
import sys
import time
from threading import *
import xmlrpclib
from SimpleXMLRPCServer import SimpleXMLRPCServer, SimpleXMLRPCRequestHandler
from SocketServer import ThreadingMixIn
import Queue

class XMLRPCThreadingServer(ThreadingMixIn, SimpleXMLRPCServer):
    """ PRIVATE helper class for XMLRPC """


SERVERPORT = 4000
CLIENTPORT = 4001
MAXPIXEL = 800
graphcanvas = False
ipcnxn = -1
mainframe = None
gblcolor = 'white'
notside = {}
notside['white'] = 'black'
notside['black'] = 'white'
hilitecolor = {0 : 'pink', 1 : 'light blue'}    # highlight last move
q = Queue.Queue(0)

def startclient(ip, color, debug):
    global ipcnxn
    global mainframe
    if (ipcnxn != -1):
        print "board already started"
        raise Exception, "board already started"
    mainframe = Mainframe(color, ip, debug)

def client(ip, port):
    url = "http://" + ip + ":" + str(port)
    prox = xmlrpclib.ServerProxy(url)
    return prox

class Mainframe(object):
    def __init__(self, color, srvrip, debug):
        global ipcnxn
        self.isdebug = debug
        self.disablecheckwarning = False
        self.board = {}
        self.rectangle = {}
        self.ismove = False
        self.isreachdisplay = False
        self.reachstr = ""
        self.inmoverecord = None
        self.oldfrom = None
        self.oldto = None
        self.sqcolor = {}
        self.sqcolor[1] = 'light gray'
        self.sqcolor[0] = 'white'
        for x in range(0,8):
            for y in range(0,8):
                self.board[(x, y)] = "EMPTY"
                self.rectangle[(x, y)] = None
        self.gcanvas = None
        self.othersidebutton = None
        self.newgamebutton = None
        self.exbutton = None
        # self.reconnbutton = None
        if (color == 'black'):
            self.color = 'black'
        else:
            self.color = 'white'
        self.showcanvas()
        self.myipaddr = socket.gethostbyname(socket.gethostname())
        self.thread = Thread(target = self.runthread, name="XLMRPC")
        self.thread.setDaemon(1)
        self.thread.start()
        ipcnxn =  client(srvrip, SERVERPORT)
        ipcnxn.subscribe(self.myipaddr)

    def runthread(self):
        self.cbacksrvraddr = (self.myipaddr, CLIENTPORT)
        self.cbacksrvr = SimpleXMLRPCServer(self.cbacksrvraddr,
            SimpleXMLRPCRequestHandler, logRequests=1)
        # self.cbacksrvr.daemon_threads = True
        self.cbacksrvr.register_instance(self)
        self.cbacksrvr.request_queue_size = 2
        try:
            self.cbacksrvr.serve_forever()
        except Exception, estr:
            print "XMLRPC error in service thread: " + estr

    def showcanvas(self):
        global graphcanvas
        makecanvas = False
        if (not graphcanvas):
                makecanvas = True
        else:
            try:
                graphcanvas.create_line(-2,-2,-1,-1,width=1)
            except Exception:
                # This runs if the user has killed the former canvas.
                makecanvas = True
        if (makecanvas):
            self.bframe = Frame()
            self.othersidebutton = Button(self.bframe,
                text="Switch Sides to " + notside[self.color],
                    command=self.otherside)
            self.newgamebutton = Button(self.bframe, text="New Game",
                command=self.newgame)
            self.exbutton = Button(self.bframe, text="Exit GUI",
                command=self.exit)
            # self.reconnbutton = Button(self.bframe,
                # text="Reconnect with Server",
                # command=self.reconnect)
            reachbutton = Button(self.bframe, text="Toggle Graph Trace",
                command=self.togglereach)
            self.gcanvas = Canvas(width=MAXPIXEL,               \
                height=MAXPIXEL,bg='white')
            rectside = MAXPIXEL / 8
            for row in range(0,8):
                for col in range(0,8):
                    colix = (row + col) & 1
                    self.rectangle[(col,row)]              \
                        = self.gcanvas.create_rectangle(col * rectside,   \
                        row * rectside, (col+1) * rectside,         \
                        (row+1) * rectside, fill = self.sqcolor[colix],  \
                        outline='black', width=2, tags='square')
            self.othersidebutton.pack(side=LEFT)
            self.newgamebutton.pack(side=LEFT)
            self.exbutton.pack(side=LEFT)
            reachbutton.pack(side=LEFT)
            # self.reconnbutton.pack(side=LEFT)
            self.gcanvas.pack(side=TOP, expand=YES, fill=BOTH)
            self.bframe.pack(side=BOTTOM)
        graphcanvas = self.gcanvas
        rootwindow.title('Music for 32 Chess Pieces (' + self.color     \
            + ') by Acoustic Interloper')
        return self.gcanvas

    def fetchboard(self, boardstring, oldx, oldy, newx, newy, panicstr):
        """CALLBACK function from board server"""
        global q
        boardlist = boardstring.split(",")
        if (len(boardlist) != 64):
            print "Invalid board string: " + boardstring
            raise Exception, "Invalid board string: " + boardstring
        x = 0
        y = 0
        for piece in boardlist:
            self.board[(x, y)] = piece
            x = x + 1
            if (x > 7):
                x = 0
                y = y + 1
        if (self.oldfrom):
            self.gcanvas.itemconfig(self.rectangle[self.oldfrom],
                fill=self.sqcolor[(self.oldfrom[0]  \
                    + self.oldfrom[1]) & 1])
        if (self.oldto):
            self.gcanvas.itemconfig(self.rectangle[self.oldto],
                fill=self.sqcolor[(self.oldto[0]  \
                    + self.oldto[1]) & 1])
        if (self.color == 'white'):
            ocx = oldx
            ocy = 7 - oldy
            ncx = newx
            ncy = 7 - newy
        else:
            ocx = 7 - oldx
            ocy = oldy
            ncx = 7 -newx
            ncy = newy
        if (oldx > -1 and oldy > -1):
            self.gcanvas.itemconfig(self.rectangle[(ocx,ocy)],
                fill=hilitecolor[(ocx + ocy) & 1])
            self.oldfrom = (ocx, ocy)
        if (newx > -1 and newy > -1):
            self.gcanvas.itemconfig(self.rectangle[(ncx,ncy)],
                fill=hilitecolor[(ncx + ncy) & 1])
            self.oldto = (ncx, ncy)
        q.put(self.updatedisplay)
        if (panicstr and not self.disablecheckwarning):
            def handler(self=self, title='CHECK!', details=panicstr):
                result = askyesno(title, details    \
                    + "\nDo you want to disable this warning?")
                if (result):
                    self.disablecheckwarning = True
            q.put(handler)
        return ""

    def updatedisplay(self):
        iswhite = (self.color == 'white')
        self.gcanvas.delete('piecetag')
        self.gcanvas.delete('loctag')
        self.gcanvas.delete('reachtag')
        if (iswhite):
            leftsq = MAXPIXEL / 16
            botsq = MAXPIXEL * 15 / 16
            incrsq = MAXPIXEL / 8
            absincrsq = MAXPIXEL / 8
        else:
            leftsq = MAXPIXEL * 15 / 16
            botsq = MAXPIXEL / 16
            incrsq = -(MAXPIXEL / 8)
            absincrsq = MAXPIXEL / 8
        for x in range(0,8):
            for y in range(0,8):
                rawtext = self.board[(x, y)]
                pcolor = rawtext[0:5]
                if (pcolor == 'white'):
                    dcolor = 'dark red'
                    ptext = rawtext[5:] + " (W)"
                elif (pcolor == 'black'):
                    dcolor = 'dark blue'
                    ptext = rawtext[5:] + " (B)"
                else:
                    continue
                brdx = leftsq + (x * incrsq)
                brdy = botsq - (y * incrsq)
                txtid = self.gcanvas.create_text(brdx, brdy, text=ptext,
                    tags="piecetag", font=30, fill=dcolor, anchor='c')
                def handler ( event, self=self, tkid=txtid,   \
                        dcolor=dcolor, ptext=ptext):  # Python curry
                    return self.startmove(event, tkid, dcolor, ptext)
                self.gcanvas.tag_bind(txtid, '<ButtonRelease-1>', handler)
                locatorx = brdx - int(0.45 * absincrsq)
                locatory = brdy + int(0.35 * absincrsq)
                locatortext = "(" + str(x) + "," + str(y) + ")"
                # self.gcanvas.create_text(locatorx, locatory,    
                    # text=locatortext, tags="loctag",font=6,fill='black',
                    # anchor='w')

    def fetchreach(self, reachstr):
        self.isreachdisplay = True
        self.reachstr = reachstr
        q.put(self.updatereach)
        return ""

    def updatereach(self):
        # print "DEBUG INSIDE UPDATEREACH" + str(self.isreachdisplay) + " :: " \
            # + str(self.reachstr)
        iswhite = (self.color == 'white')
        if (iswhite):
            leftsq = MAXPIXEL / 16
            botsq = MAXPIXEL * 15 / 16
            incrsq = MAXPIXEL / 8
            absincrsq = MAXPIXEL / 8
        else:
            leftsq = MAXPIXEL * 15 / 16
            botsq = MAXPIXEL / 16
            incrsq = -(MAXPIXEL / 8)
            absincrsq = MAXPIXEL / 8
        self.gcanvas.delete('reachtag')
        if (self.isreachdisplay and self.reachstr):
            # For each arraow, there are 8 possible directions:
            # UP, UPRT, RT, DNRT, DN, DNLT, LT, UPLT
            # Each state holds a list of two coordinate two-tuples in that
            # order, giving the arrow start and end location relative to
            # the center of the square. This is in element 2 of each state.
            halfsq = absincrsq / 2.0
            quarsq = absincrsq / 4.0
            egthsq = absincrsq / 8.0
            sxthsq = absincrsq / 16.0
            statemachine = {    \
                'isupport' :    \
                    ['black', LAST, [   \
                        [   \
                            [-sxthsq, -halfsq+sxthsq],  \
                            [-sxthsq, halfsq-sxthsq]    \
                        ],  \
                        [   \
                            [halfsq-quarsq, -halfsq+sxthsq],    \
                            [-halfsq+quarsq, halfsq-sxthsq] \
                        ],  \
                        [   \
                            [halfsq-sxthsq, -sxthsq],   \
                            [-halfsq+sxthsq, -sxthsq]   \
                        ],  \
                        [   \
                            [halfsq-quarsq, halfsq-sxthsq], \
                            [-halfsq+quarsq, -halfsq+sxthsq]    \
                        ],  \
                        [   \
                            [-sxthsq, halfsq-sxthsq],    \
                            [-sxthsq, -halfsq+sxthsq]  \
                        ],  \
                        [   \
                            [-halfsq+quarsq, halfsq-sxthsq], \
                            [halfsq-quarsq, -halfsq+sxthsq]    \
                        ],  \
                        [   \
                            [-halfsq+sxthsq, -sxthsq],  \
                            [halfsq-sxthsq, -sxthsq]    \
                        ],  \
                        [   \
                            [-halfsq+quarsq, -halfsq+sxthsq],   \
                            [halfsq-quarsq, halfsq-sxthsq]  \
                        ]   \
                    ], 'iattack'],  \
                'iattack' : \
                    ['red', LAST, [ \
                        [   \
                            [sxthsq, -halfsq+sxthsq],   \
                            [sxthsq, halfsq-sxthsq] \
                        ],  \
                        [   \
                            [halfsq-egthsq -halfsq+quarsq], \
                            [-halfsq+egthsq, halfsq-quarsq] \
                        ],  \
                        [   \
                            [halfsq-egthsq, sxthsq],    \
                            [-halfsq+egthsq, sxthsq]    \
                        ],  \
                        [   \
                            [halfsq-egthsq, halfsq-quarsq], \
                            [-halfsq+egthsq, -halfsq+quarsq]    \
                        ],  \
                        [   \
                            [sxthsq, halfsq-egthsq],    \
                            [sxthsq, -halfsq+egthsq]    \
                        ],  \
                        [   \
                            [-halfsq+egthsq, halfsq-quarsq],    \
                            [halfsq-egthsq -halfsq+quarsq]  \
                        ],  \
                        [   \
                            [-halfsq+egthsq, sxthsq],   \
                            [halfsq-egthsq, sxthsq] \
                        ],  \
                        [   \
                            [-halfsq+egthsq, -halfsq+quarsq],   \
                            [halfsq-egthsq, halfsq-quarsq]  \
                        ]   \
                    ], 'supportme'],    \
                'supportme' :   \
                    ['green', LAST, [   \
                        [   \
                            [-quarsq, -halfsq+sxthsq],  \
                            [-quarsq, halfsq-sxthsq]    \
                        ],  \
                        [   \
                            [halfsq-quarsq, -halfsq+sxthsq],    \
                            [-halfsq+quarsq, halfsq-sxthsq] \
                        ],  \
                        [   \
                            [halfsq-sxthsq, -sxthsq],   \
                            [-halfsq+sxthsq, -sxthsq]   \
                        ],  \
                        [   \
                            [halfsq-quarsq, halfsq-sxthsq], \
                            [-halfsq+quarsq, -halfsq+sxthsq]    \
                        ],  \
                        [   \
                            [-sxthsq, halfsq-sxthsq],   \
                            [-sxthsq, -halfsq+sxthsq]   \
                        ],  \
                        [   \
                            [-halfsq+quarsq, halfsq-sxthsq],    \
                            [halfsq-quarsq, -halfsq+sxthsq] \
                        ],  \
                        [   \
                            [-halfsq+sxthsq, -sxthsq],  \
                            [halfsq-sxthsq, -sxthsq]    \
                        ],  \
                        [   \
                            [-halfsq+quarsq, -halfsq+sxthsq],   \
                            [halfsq-quarsq, halfsq-sxthsq]  \
                        ]   \
                    ], 'attackme'], \
                'attackme' :    \
                    ['yellow', LAST, [  \
                        [   \
                            [egthsq, -halfsq+sxthsq],   \
                            [egthsq, halfsq-sxthsq] \
                        ],  \
                        [   \
                            [halfsq-quarsq -halfsq+quarsq], \
                            [-halfsq+quarsq, halfsq-quarsq] \
                        ],  \
                        [   \
                            [halfsq-egthsq, egthsq],    \
                            [-halfsq+egthsq, egthsq]    \
                        ],  \
                        [   \
                            [halfsq-quarsq, halfsq-quarsq], \
                            [-halfsq+quarsq, -halfsq+quarsq]    \
                        ],  \
                        [   \
                            [egthsq, halfsq-sxthsq],    \
                            [egthsq, -halfsq+sxthsq]    \
                        ],  \
                        [   \
                            [-halfsq+quarsq, halfsq-quarsq],    \
                            [halfsq-quarsq -halfsq+quarsq]  \
                        ],  \
                        [   \
                            [-halfsq+egthsq, egthsq],   \
                            [halfsq-egthsq, egthsq] \
                        ],  \
                        [   \
                            [-halfsq+quarsq, -halfsq+quarsq],   \
                            [halfsq-quarsq, halfsq-quarsq]  \
                        ]   \
                    ], 'isupport']  \
                }
            row = 0
            col = 0
            dlix = 0
            dlist = self.reachstr.split(',')
            relate = 'isupport'
            endlist = len(dlist)
            while (dlix < endlist):
                token = dlist[dlix]
                if (token == ''):
                    dlix = dlix + 1
                    continue
                if (token == '!'):
                    if (relate == 'attackme'):
                        col = col + 1
                        if (col == 8):
                            col = 0
                            row = row + 1
                            if (row == 8):
                                break
                    relate = statemachine[relate][3]
                    dlix = dlix + 1
                    continue
                try:
                    # print "DEBUG ARROW (" + str(dlist[dlix]) + "," \
                        # + str(dlist[dlix+1]) + ") " + relate    \
                        # + " (" + str(dlist[dlix+2]) + ","   \
                        # + str(dlist[dlix+3]) + ")"
                    fromx = leftsq + (int(dlist[dlix]) * incrsq)
                    fromy = botsq - (int(dlist[dlix+1]) * incrsq)
                    tox = leftsq + (int(dlist[dlix+2]) * incrsq)
                    toy = botsq - (int(dlist[dlix+3]) * incrsq)
                    if (fromy > toy):
                        if (fromx == tox):              # UP
                            compass = 0
                        elif (fromx < tox):          # UPRT
                            compass = 1
                        else:                           # UPLT
                            compass = 7
                    elif (fromy < toy):
                        if (fromx == tox):              # DN
                            compass = 4
                        elif (fromx < tox):          # DNRT
                            compass = 3
                        else:                           # DNLT
                            compass = 5
                    else:
                        if (fromx < tox):               # RT
                            compass = 2
                        else:                           # LT
                            compass = 6
                    fromx = fromx + statemachine[relate][2][compass][0][0]
                    fromy = fromx + statemachine[relate][2][compass][0][1]
                    tox = tox + statemachine[relate][2][compass][1][0]
                    toy = toy + statemachine[relate][2][compass][1][1]
                    self.gcanvas.create_line(fromx, fromy, tox, toy,    \
                        tags='reachtag', fill=statemachine[relate][0],   \
                        arrow=statemachine[relate][1])
                except ValueError, estr:
                    print "DEBUG reach format bug: " + str(estr)
                    raise ValueError, estr
                dlix = dlix + 4

    def startmove(self, event, tkid, dcolor, ptext):
        if (not self.ismove):
            (brdx, brdy) = self.canvas2board(event.x, event.y)
            rawtext = self.board[(brdx, brdy)]
            rawcolor = rawtext[0:5]
            if (rawcolor != self.color and not self.isdebug):
                showerror("Illegal Move","You cannot move a " \
                    + rawcolor + " piece while playing " + self.color + ".")
                return
            self.ismove = True
            self.gcanvas.itemconfig(tkid, fill='green')
            self.inmoverecord = (brdx, brdy, tkid, dcolor)
            def handler(event, self=self, oldx=brdx, oldy=brdy, \
                    tkid=tkid, dcolor=dcolor):
                return self.endmove(event, oldx, oldy, tkid, dcolor)
            self.gcanvas.tag_bind('square', '<ButtonRelease-1>', handler)
        elif (self.inmoverecord):
            # This piece is end destination for another's move.
            self.endmove(event, self.inmoverecord[0], self.inmoverecord[1],
                self.inmoverecord[2], self.inmoverecord[3])

    def endmove(self, event, oldx, oldy, tkid, dcolor):
        global ipcnxn
        if (self.ismove):
            (newx, newy) = self.canvas2board(event.x, event.y)
            self.gcanvas.tag_bind('square', '<ButtonRelease-1>')
            self.ismove = False
            self.inmoverecord = None
            if (newx == oldx and newy == oldy):
                self.gcanvas.itemconfig(tkid, fill=dcolor)
            else:
                errstr = None
                try:
                    errstr = ipcnxn.move(oldx,oldy,newx,newy)
                except Exception:
                    pass # ignore illegal move
                if (errstr):
                    self.gcanvas.itemconfig(tkid, fill=dcolor)
                    showerror("Illegal Move",errstr)
                else:
                    if (self.oldfrom):
                        self.gcanvas.itemconfig(self.rectangle[self.oldfrom],
                            fill=self.sqcolor[(self.oldfrom[0]  \
                                + self.oldfrom[1]) & 1])
                    if (self.oldto):
                        self.gcanvas.itemconfig(self.rectangle[self.oldto],
                            fill=self.sqcolor[(self.oldto[0]  \
                                + self.oldto[1]) & 1])
                    if (self.color == 'white'):
                        ocx = oldx
                        ocy = 7 - oldy
                        ncx = newx
                        ncy = 7 - newy
                    else:
                        ocx = 7 - oldx
                        ocy = oldy
                        ncx = 7 -newx
                        ncy = newy
                    self.gcanvas.itemconfig(self.rectangle[(ocx,ocy)],
                        fill=hilitecolor[(ocx + ocy) & 1])
                    self.gcanvas.itemconfig(self.rectangle[(ncx,ncy)],
                        fill=hilitecolor[(ncx + ncy) & 1])
                    self.oldfrom = (ocx, ocy)
                    self.oldto = (ncx, ncy)

    def togglereach(self):
        self.isreachdisplay = not self.isreachdisplay
        try:
            ipcnxn.displayreach(self.isreachdisplay)
        except Exception:
            pass # ignore illegal move
        if (not self.isreachdisplay):
            self.updatedisplay()

    def canvas2board(self,tkx,tky):
        quantum = int(MAXPIXEL / 8)
        slotx = tkx / quantum
        sloty = tky / quantum
        if (self.color == 'white'):
            sloty = 7 - sloty
        else:
            slotx = 7 - slotx
        return((slotx, sloty))

    def otherside(self):
        global rootwindow
        if (self.oldfrom):
            self.gcanvas.itemconfig(self.rectangle[self.oldfrom],
                fill=self.sqcolor[(self.oldfrom[0]  \
                    + self.oldfrom[1]) & 1])
            self.oldfrom = ((7 - self.oldfrom[0]), (7 - self.oldfrom[1]))
            self.gcanvas.itemconfig(self.rectangle[self.oldfrom],
                fill=hilitecolor[(self.oldfrom[0]  \
                    + self.oldfrom[1]) & 1])
        if (self.oldto):
            self.gcanvas.itemconfig(self.rectangle[self.oldto],
                fill=self.sqcolor[(self.oldto[0]  \
                    + self.oldto[1]) & 1])
            self.oldto = ((7 - self.oldto[0]), (7 - self.oldto[1]))
            self.gcanvas.itemconfig(self.rectangle[self.oldto],
                fill=hilitecolor[(self.oldto[0]  \
                    + self.oldto[1]) & 1])
        self.color = notside[self.color]
        rootwindow.title('Music for 32 Chess Pieces (' + self.color     \
            + ') by Acoustic Interloper')
        self.othersidebutton.config(                                    \
            text="Switch Sides to " + notside[self.color])
        self.updatedisplay()

    def newgame(self):
        global ipcnxn
        if (not askyesno("New Game", 'Do you really want a New Game?')):
            return
        if (self.oldfrom):
            self.gcanvas.itemconfig(self.rectangle[self.oldfrom],
                fill=self.sqcolor[(self.oldfrom[0]  \
                    + self.oldfrom[1]) & 1])
            self.oldfrom = None
        if (self.oldto):
            self.gcanvas.itemconfig(self.rectangle[self.oldto],
                fill=self.sqcolor[(self.oldto[0]  \
                    + self.oldto[1]) & 1])
            self.oldto = None
        try:
            success = ipcnxn.newgame()
        except Exception:
            pass # ignore illegal move

    def reconnect(self):
        global ipcnxn
        if (not askyesno("Reconnect", 'Do you really want to Reconnect?')):
            return
        try:
            self.cbacksrvr.server_close()
        except Exception:
            pass
        time.sleep(1)
        self.myipaddr = socket.gethostbyname(socket.gethostname())
        self.thread = Thread(target = self.runthread, name="XLMRPC")
        self.thread.setDaemon(1)
        self.thread.start()
        # ipcnxn =  client(srvrip, SERVERPORT)
        # ipcnxn.subscribe(self.myipaddr)

    def exit(self):
        if (not askyesno("Exit", 'Do you really want to Exit?')):
            return
        sys.exit(0)

rootwindow = None
def start(srvripaddr, color='white', debug=0):
    global q
    global rootwindow
    global mainframe
    global MAXPIXEL
    rootwindow = Tk()
    MAXPIXEL = min(rootwindow.maxsize()) - 100
    print "MAXPIXEL is " + str(MAXPIXEL)
    rootwindow.geometry('+0+0')
    startclient(srvripaddr, color, debug)
    rootwindow.deiconify()
    rootwindow.lift()
    pollq()
    rootwindow.mainloop()

def pollq():
    global q
    global rootwindow
    try:
        cback = q.get(False)
        cback()
    except Queue.Empty:
        pass
    rootwindow.after(200, pollq)
