# chessboard.py

# THE CODE AND DOCUMENTATION IN THIS DIRECTORY AND BELOW ARE OPEN
# SOURCE ACCORDING TO THE TERMS OF THE FOLLOWING LICENSE. PLEASE READ:
# -----------------------------------------------------------------------------
# ESST (Embedded System Software Tools) License
# -----------------------------------------------------------------------------
# 
# SOFTWARE LICENSE
# 
# This software is provided subject to the following terms and conditions,
# which you should read carefully before using the software. Using this
# software indicates your acceptance of these terms and conditions. 
# If you do not agree with these terms and conditions, do not use the software.
# 
# Copyright (c) 2008 Dale E. Parson, Ph.D. (a.k.a. Acoustic Interloper)
# All rights reserved.
# 
# Redistribution and use in source or binary forms, with or without
# modifications, are permitted provided that the following conditions are met:
# 
# * Redistributions of source code must retain the above copyright notice,
# this list of conditions and the following Disclaimer in comments in the code
# as well as in the documentation and/or other materials provided with the
# distribution.
# * Redistributions in binary form must reproduce the above copyright notice,
# this list of conditions and the following Disclaimer in the documentation
# and/or other materials provided with the distribution.
# * Neither the name of Dale E. Parson, nor the names of the contributors
# may be used to endorse or promote products derived from this software without
# specific prior written permission.
# 
# Disclaimer
# 
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
# INCLUDING, BUT NOT LIMITED TO, INFRINGEMENT AND THE IMPLIED WARRANTIES
# OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
# ANY USE, MODIFICATION OR DISTRIBUTION OF THIS SOFTWARE IS SOLELY AT THE
# USER'S OWN RISK. IN NO EVENT SHALL Dale E. Parson OR CONTRIBUTORS BE
# LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
# CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
# SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
# INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, INCLUDING,
# BUT NOT LIMITED TO, CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
# OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
# ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
# -----------------------------------------------------------------------------


from Tkinter import *
from tkMessageBox import showerror, showwarning, askyesno
from math import *
import socket
import xmlrpclib
import sys
import time
import types
from threading import *
import SocketServer
import struct
from binascii import a2b_hex, b2a_hex
import Queue
from chess.ChessException import ChessException

SERVERPORT = 4000
CLIENTPORT = 4001
MAXPIXEL = 800
graphcanvas = False
ipcnxn = -1
mainframe = None
gblcolor = 'white'
notside = {}
notside['white'] = 'black'
notside['black'] = 'white'
hilitecolor = {0 : 'pink', 1 : 'light blue'}    # highlight last move
q = Queue.Queue(0)

def startclient(ip, color, debug):
    global ipcnxn
    global mainframe
    if (ipcnxn != -1):
        print "board already started"
        raise ChessException, "board already started"
    mainframe = Mainframe(color, ip, debug)

def client(ip, port):
    url = "http://" + ip + ":" + str(port)
    prox = xmlrpclib.ServerProxy(url)
    return prox

class Mainframe(object):
    def __init__(self, color, srvrip, debug):
        global ipcnxn
        self.isdebug = debug
        self.disablecheckwarning = False
        self.board = {}
        self.rectangle = {}
        self.ismove = False
        self.isreachdisplay = False
        self.reachstr = ""
        self.inmoverecord = None
        self.oldfrom = None
        self.oldto = None
        self.sqcolor = {}
        self.sqcolor[1] = 'light gray'
        self.sqcolor[0] = 'white'
        for x in range(0,8):
            for y in range(0,8):
                self.board[(x, y)] = "EMPTY"
                self.rectangle[(x, y)] = None
        self.gcanvas = None
        self.othersidebutton = None
        self.newgamebutton = None
        self.exbutton = None
        self.statewindow = None
        self.textview = None
        self.textentry = None
        self.textcontents = ""
        # self.reconnbutton = None
        self.pieceImage = {}
        dir = "./avatars/"
        self.sustainx = None
        self.sustaint = None
        self.sustainp = None
        self.lookahead = None
        self.boredom = None
        self.tempodelay = None
        self.tempolfogain = None
        self.amplgain = None
        self.sustainsupport = None
        self.sustainattack = None
        self.sustainsupportme = None
        self.sustainattackme = None
        self.sustainxvar = IntVar()
        self.sustainxvar.set(0)
        self.sustaintvar = IntVar()
        self.sustaintvar.set(5)
        self.sustainpvar = IntVar()
        self.sustainpvar.set(0)
        self.lookaheadvar = IntVar()
        self.lookaheadvar.set(6)
        self.boredomvar = IntVar()
        self.boredomvar.set(15)
        self.tempodelayvar = IntVar()
        self.tempodelayvar.set(0)
        self.amplgainvar = IntVar()
        self.amplgainvar.set(10)
        self.tempolfogainvar = IntVar()
        self.tempolfogainvar.set(10)
        self.supportvar = IntVar()
        self.supportvar.set(0)
        self.attackvar = IntVar()
        self.attackvar.set(1)
        self.supportmevar = IntVar()
        self.supportmevar.set(0)
        self.attackmevar = IntVar()
        self.attackmevar.set(1)
        self.buildingcontrols = False
        for pn in ['Q', 'K', 'B', 'N', 'R', 'P']:
            for side in ['W','B']:
                key = pn + side
                img = None
                try:
                    img = PhotoImage(file=dir + key + ".gif")
                except Exception, gifstr:
                    img = None
                self.pieceImage[key] = img
                # print "DEBUG LOADED IMG " + str(img)
        if (color == 'black'):
            self.color = 'black'
        else:
            self.color = 'white'
        self.showcanvas()
        self.threadisrunning = False
        isok = False
        cv = Condition()
        cv.acquire()
        self.myipaddr = socket.gethostbyname(socket.gethostname())
        self.thread = Thread(target = self.runthread, name="XLMRPC",args=(cv,))
        self.thread.setDaemon(1)
        self.thread.start()
        while (not isok):
            isok = self.threadisrunning
            if (not isok):
                cv.wait()
        cv.release()
        ipcnxn =  client(srvrip, SERVERPORT)
        ipcnxn.subscribe(self.myipaddr)

    def runthread(self, cv):
        self.cbacksrvraddr = (self.myipaddr, CLIENTPORT)
        SocketServer.ThreadingUDPServer.allow_reuse_address = True
        self.cbacksrvr = SocketServer.ThreadingUDPServer(self.cbacksrvraddr,
            DatagramInterpreter)
        self.cbacksrvr.daemon_threads = True
        self.cbacksrvr.request_queue_size = 10
        cv.acquire()
        self.threadisrunning = True
        cv.notifyAll()
        cv.release()
        while (1):
            try:
                self.cbacksrvr.serve_forever()
            except Exception, estr:
                print "UDP server error in service thread: " + str(estr)
            print "UDP server service thread exits!"

    def showcanvas(self):
        global graphcanvas
        makecanvas = False
        if (not graphcanvas):
                makecanvas = True
        else:
            try:
                graphcanvas.create_line(-2,-2,-1,-1,width=1)
            except Exception:
                # This runs if the user has killed the former canvas.
                makecanvas = True
        if (makecanvas):
            self.bframe = Frame()
            self.othersidebutton = Button(self.bframe,
                text="Switch Sides to " + notside[self.color],
                    command=self.otherside)
            self.newgamebutton = Button(self.bframe, text="New Game",
                command=self.newgame)
            self.exbutton = Button(self.bframe, text="Exit GUI",
                command=self.exit)
            # self.reconnbutton = Button(self.bframe,
                # text="Reconnect with Server",
                # command=self.reconnect)
            reachbutton = Button(self.bframe, text="Toggle Graph Trace",
                command=self.togglereach)
            # killbutton = Button(self.bframe, text="Shut down chess server",
                # command=self.killgame)
            self.gcanvas = Canvas(width=MAXPIXEL,               \
                height=MAXPIXEL,bg='white')
            rectside = MAXPIXEL / 8
            for row in range(0,8):
                for col in range(0,8):
                    colix = (row + col) & 1
                    self.rectangle[(col,row)]              \
                        = self.gcanvas.create_rectangle(col * rectside,   \
                        row * rectside, (col+1) * rectside,         \
                        (row+1) * rectside, fill = self.sqcolor[colix],  \
                        outline='black', width=2, tags='square')
            self.othersidebutton.pack(side=LEFT)
            self.newgamebutton.pack(side=LEFT)
            self.exbutton.pack(side=LEFT)
            reachbutton.pack(side=LEFT)
            # killbutton.pack(side=LEFT)
            # self.reconnbutton.pack(side=LEFT)
            self.gcanvas.pack(side=TOP, expand=YES, fill=BOTH)
            self.bframe.pack(side=BOTTOM)
            self.makemusicdisplay()
        graphcanvas = self.gcanvas
        rootwindow.title('Music for 32 Chess Pieces (' + self.color     \
            + ') by Acoustic Interloper')
        return self.gcanvas

    def makemusicdisplay(self):
        self.buildingcontrols = True
        self.statewindow = Toplevel()
        self.statewindow.title('Music for 32 Chess Pieces, Musical State')
        self.statewindow.geometry('+0+0')
        frame = Frame(self.statewindow)
        sbar = Scrollbar(frame)
        self.textview = Text(frame, relief=SUNKEN, state=NORMAL, height=10)
        sbar.config(command=self.textview.yview)
        self.textview.config(yscrollcommand=sbar.set)
        sbar.pack(side=RIGHT, fill=Y)
        self.textview.pack(side=LEFT,expand=YES,fill=BOTH)
        subframe = Frame(self.statewindow)
        botframe = Frame(self.statewindow)
        basement = Frame(self.statewindow)
        label = Label(subframe, text="Enter assignment below")
        self.textentry = Entry(botframe)
        self.textentry.bind('<Return>', self.setMusicGenState)
        copypaste = Button(subframe, text="Copy selection to entry line",
            command=self.CopyPaste)
        clearentry = Button(subframe, text="Clear entry line",
            command=self.ClearEntry)
        label.pack(side=LEFT)
        clearentry.pack(side=RIGHT)
        copypaste.pack(side=RIGHT)
        self.textentry.pack(side=BOTTOM,expand=YES,fill=X)
        frame.pack(side=TOP,expand=YES,fill=BOTH)
        self.sustainx = Scale(basement,
            label="Sustain Duration (sustainmultiplier)",
            command=self.setSustainDuration, from_=0, to=50,
            resolution=1, tickinterval=5, showvalue=YES,
            variable=self.sustainxvar, orient='horizontal')
        self.sustaint = Scale(basement,
            label="Sustain Threshold (lower threshold sustains more notes)",
            command=self.setSustainThreshold, from_=1, to=5,
            resolution=1, tickinterval=1, showvalue=YES,
            variable=self.sustaintvar, orient='horizontal')
        checkframe = Frame(basement)
        self.sustainp = Checkbutton(checkframe,
            text="Sustain Across Moves", command=self.setSustainPersist,
            variable=self.sustainpvar)
        self.sustainsupport = Checkbutton(checkframe,
            text="Sustain Support", command=self.setSustainMode,
            variable=self.supportvar)
        self.sustainattack = Checkbutton(checkframe,
            text="Sustain Attack", command=self.setSustainMode,
            variable=self.attackvar)
        self.sustainsupportme = Checkbutton(checkframe,
            text="Sustain Supported", command=self.setSustainMode,
            variable=self.supportmevar)
        self.sustainattackme = Checkbutton(checkframe,
            text="Sustain Attacked", command=self.setSustainMode,
            variable=self.attackmevar)
        self.lookahead = Scale(basement, label="Phrase Length (lookaheadlimit)",
            command=self.setLookAhead, from_=1, to=10,
            resolution=1, tickinterval=2, showvalue=YES,
            variable=self.lookaheadvar, orient='horizontal')
        self.boredom = Scale(basement, label="Seconds until Boredom sets in",
            command=self.setBored, from_=1, to=50,
            resolution=1, tickinterval=5, showvalue=YES,
            variable=self.boredomvar, orient='horizontal')
        self.tempodelay = Scale(basement, label="Tempo Delay * 10",
            command=self.setTempoDelay, from_=0, to=20,
            resolution=1, tickinterval=2, showvalue=YES,
            variable=self.tempodelayvar, orient='horizontal')
        self.tempolfogain = Scale(basement, label="Tempo LFO Gain * 10",
            command=self.setTempoLfoGain, from_=0, to=20,
            resolution=1, tickinterval=2, showvalue=YES,
            variable=self.tempolfogainvar, orient='horizontal')
        self.amplgain = Scale(basement, label="Amplitude Gain * 10",
            command=self.setAmplGain, from_=0, to=20,
            resolution=1, tickinterval=2, showvalue=YES,
            variable=self.amplgainvar, orient='horizontal')
        self.sustainx.pack(side=TOP, expand=YES, fill=X)
        self.sustaint.pack(side=TOP, expand=YES, fill=X)
        self.sustainp.pack(side=LEFT)
        self.sustainsupport.pack(side=LEFT)
        self.sustainattack.pack(side=LEFT)
        self.sustainsupportme.pack(side=LEFT)
        self.sustainattackme.pack(side=LEFT)
        checkframe.pack(side=TOP, expand=YES, fill=X)
        self.lookahead.pack(side=TOP, expand=YES, fill=X)
        self.boredom.pack(side=TOP, expand=YES, fill=X)
        self.tempodelay.pack(side=TOP, expand=YES, fill=X)
        self.tempolfogain.pack(side=TOP, expand=YES, fill=X)
        self.amplgain.pack(side=TOP, expand=YES, fill=X)
        basement.pack(side=BOTTOM, expand=YES,fill=X)
        subframe.pack(side=BOTTOM, expand=YES,fill=X)
        botframe.pack(side=BOTTOM,expand=YES,fill=X)
        self.buildingcontrols = False

    def CopyPaste(self):
        try:
            text = self.textview.get(SEL_FIRST, SEL_LAST).strip()
        except TclError:
            # Nothing selected
            return
        self.statewindow.clipboard_clear()
        self.statewindow.clipboard_append(text)
        self.textentry.delete(0, END)
        self.textentry.insert(0, text)

    def ClearEntry(self):
        self.textentry.delete(0, END)

    def setMusicGenState(self, event):
        if (self.buildingcontrols):
            return
        text = self.textentry.get().strip()
        # self.textentry.delete(0, END)
        if (text):
            try:
                result = ipcnxn.setMusicGenState(text)
                if (type(result) == types.StringType and result):
                    showerror("Assignment Error", result)
            except Exception, estr:
                showerror('Assignment Exception', str(estr))

    def setSustainDuration(self, value):
        if (self.buildingcontrols):
            return
        text = "sustainmultiplier = " + str(self.sustainxvar.get())
        # print "DEBUG SENDING: " + text
        try:
            result = ipcnxn.setMusicGenState(text)
            if (type(result) == types.StringType and result):
                showerror("Assignment Error", result)
        except Exception, estr:
            showerror('Sustain Duration Assignment Exception', str(estr))

    def setSustainThreshold(self, value):
        if (self.buildingcontrols):
            return
        text = "sustainthreshold = " + str(self.sustaintvar.get())
        # print "DEBUG SENDING: " + text
        try:
            result = ipcnxn.setMusicGenState(text)
            if (type(result) == types.StringType and result):
                showerror("Assignment Error", result)
        except Exception, estr:
            showerror('Sustain Threshold Assignment Exception', str(estr))

    def setSustainPersist(self):
        if (self.buildingcontrols):
            return
        text = "sustainacrossmove = " + str(self.sustainpvar.get())
        # print "DEBUG SENDING: " + text
        try:
            result = ipcnxn.setMusicGenState(text)
            if (type(result) == types.StringType and result):
                showerror("Assignment Error", result)
        except Exception, estr:
            showerror('Sustain Across Moves Assignment Exception', str(estr))

    def setSustainMode(self):
        if (self.buildingcontrols):
            return
        value = []
        if (self.supportvar.get()):
            value.append(0)
        if (self.attackvar.get()):
            value.append(1)
        if (self.supportmevar.get()):
            value.append(2)
        if (self.attackmevar.get()):
            value.append(3)
        text = "sustainrelationships = " + repr(value)
        # print "DEBUG SENDING: " + text
        try:
            result = ipcnxn.setMusicGenState(text)
            if (type(result) == types.StringType and result):
                showerror("Assignment Error", result)
        except Exception, estr:
            showerror('Sustain Across Moves Assignment Exception', str(estr))

    def setLookAhead(self, value):
        if (self.buildingcontrols):
            return
        text = "lookaheadlimit = " + str(self.lookaheadvar.get())
        # print "DEBUG SENDING: " + text
        try:
            result = ipcnxn.setMusicGenState(text)
            if (type(result) == types.StringType and result):
                showerror("Lookahead Limit Assignment Error ", result)
        except Exception, estr:
            showerror('Assignment Exception', str(estr))

    def setBored(self, value):
        if (self.buildingcontrols):
            return
        text = "delay2alterseq = " + str(self.boredomvar.get())
        # print "DEBUG SENDING: " + text
        try:
            result = ipcnxn.setMusicGenState(text)
            if (type(result) == types.StringType and result):
                showerror("Assignment Error", result)
        except Exception, estr:
            showerror('Boredom Delay Assignment Exception', str(estr))

    def setTempoDelay(self, value):
        if (self.buildingcontrols):
            return
        text = "tempodelay = " + str(self.tempodelayvar.get()/10.0)
        try:
            result = ipcnxn.setMusicGenState(text)
            if (type(result) == types.StringType and result):
                showerror("Assignment Error", result)
        except Exception, estr:
            showerror('Tempo Delay Assignment Exception', str(estr))

    def setTempoLfoGain(self, value):
        if (self.buildingcontrols):
            return
        text = "tempolfogain = " + str(self.tempolfogainvar.get()/10.0)
        try:
            result = ipcnxn.setMusicGenState(text)
            if (type(result) == types.StringType and result):
                showerror("Assignment Error", result)
        except Exception, estr:
            showerror('LFO Gain Assignment Exception', str(estr))

    def setAmplGain(self, value):
        if (self.buildingcontrols):
            return
        text = "amplgain = " + str(self.amplgainvar.get()/10.0)
        try:
            result = ipcnxn.setMusicGenState(text)
            if (type(result) == types.StringType and result):
                showerror("Assignment Error", result)
        except Exception, estr:
            showerror('Amplitude Gain Assignment Exception', str(estr))

    def updatetextdisplay(self, retry=0):
        try:
            self.buildingcontrols = True
            self.textview.config(state=NORMAL)
            self.textview.delete('1.0', END)
            self.textview.insert('1.0', self.textcontents)
            self.textview.mark_set(INSERT, '1.0')
            self.textview.config(state=NORMAL)
            for rawline in self.textcontents.split("\n"):
                line = rawline.strip()
                assign = line.split('=')
                if (len(assign) == 2 and assign[1].strip()):
                    if (assign[0].startswith('sustainmultipler')):
                        val = int(assign[1].strip())
                        self.sustainxvar.set(val)
                    elif (assign[0].startswith('sustainacross')):
                        val = int(assign[1].strip())
                        self.sustainpvar.set(val)
                    elif (assign[0].startswith('sustainthres')):
                        val = int(assign[1].strip())
                        self.sustaintvar.set(val)
                    elif (assign[0].startswith('lookahead')):
                        val = int(assign[1].strip())
                        self.lookaheadvar.set(val)
                    elif (assign[0].startswith('delay2alterseq')):
                        val = int(float(assign[1].strip()))
                        self.boredomvar.set(val)
                    elif (assign[0].startswith('tempodelay')):
                        val = int(float(assign[1].strip()) * 10.0)
                        self.tempodelayvar.set(val)
                    elif (assign[0].startswith('tempolfogain')):
                        val = int(float(assign[1].strip()) * 10.0)
                        self.tempolfogainvar.set(val)
                    elif (assign[0].startswith('amplgain')):
                        val = int(float(assign[1].strip()) * 10.0)
                        self.amplgainvar.set(val)
                    elif (assign[0].startswith('sustainrelationships')):
                        val = list(eval(assign[1].strip()))
                        # print "DEBUG CHKS: " + str(val)
                        if 0 in val:
                            self.supportvar.set(1)
                        else:
                            self.supportvar.set(0)
                        if 1 in val:
                            self.attackvar.set(1)
                        else:
                            self.attackvar.set(0)
                        if 2 in val:
                            self.supportmevar.set(1)
                        else:
                            self.supportmevar.set(0)
                        if 3 in val:
                            self.attackmevar.set(1)
                        else:
                            self.attackmevar.set(0)
                            
        except TclError, tclstr:
            # The display may have been closed.
            if (not retry):
                try:
                    self.makemusicdisplay()
                    self.updatetextdisplay(retry=1)
                except TclError, tclstr2:
                    raise TclError, str(tclstr2)
                else:
                    raise TclError, str(tclstr)
        except Exception, estr:
            print "ERROR ON MUSIC STATE UPDATE: " + str(estr)
        self.buildingcontrols = False

    def helpfetchboard(self, boardstring, oldx, oldy, newx, newy, panicstr):
        global q
        boardlist = boardstring.split(",")
        if (len(boardlist) != 64):
            print "Invalid board string: " + boardstring
            raise ChessException, "Invalid board string: " + boardstring
        x = 0
        y = 0
        for piece in boardlist:
            self.board[(x, y)] = piece
            x = x + 1
            if (x > 7):
                x = 0
                y = y + 1
        if (self.oldfrom):
            self.gcanvas.itemconfig(self.rectangle[self.oldfrom],
                fill=self.sqcolor[(self.oldfrom[0]  \
                    + self.oldfrom[1]) & 1])
        if (self.oldto):
            self.gcanvas.itemconfig(self.rectangle[self.oldto],
                fill=self.sqcolor[(self.oldto[0]  \
                    + self.oldto[1]) & 1])
        if (self.color == 'white'):
            ocx = oldx
            ocy = 7 - oldy
            ncx = newx
            ncy = 7 - newy
        else:
            ocx = 7 - oldx
            ocy = oldy
            ncx = 7 -newx
            ncy = newy
        if (oldx > -1 and oldy > -1):
            self.gcanvas.itemconfig(self.rectangle[(ocx,ocy)],
                fill=hilitecolor[(ocx + ocy) & 1])
            self.oldfrom = (ocx, ocy)
        if (newx > -1 and newy > -1):
            self.gcanvas.itemconfig(self.rectangle[(ncx,ncy)],
                fill=hilitecolor[(ncx + ncy) & 1])
            self.oldto = (ncx, ncy)
        # print "DEBUG putting updatedisplay"
        self.updatedisplay()
        if (panicstr and not self.disablecheckwarning):
            result = askyesno('CHECK!', panicstr    \
                    + "\nDo you want to disable this pop-up warning?")
            if (result):
                self.disablecheckwarning = True
        return ""

    def updatedisplay(self):
        iswhite = (self.color == 'white')
        self.gcanvas.delete('piecetag')
        self.gcanvas.delete('loctag')
        self.gcanvas.delete('reachtag')
        if (iswhite):
            leftsq = MAXPIXEL / 16
            botsq = MAXPIXEL * 15 / 16
            incrsq = MAXPIXEL / 8
            absincrsq = MAXPIXEL / 8
        else:
            leftsq = MAXPIXEL * 15 / 16
            botsq = MAXPIXEL / 16
            incrsq = -(MAXPIXEL / 8)
            absincrsq = MAXPIXEL / 8
        for x in range(0,8):
            for y in range(0,8):
                rawtext = self.board[(x, y)]
                pcolor = rawtext[0:5]
                if (pcolor == 'white'):
                    dcolor = 'dark red'
                    ptext = rawtext[5:] + " (W)"
                    avatarkey = rawtext[5] + 'W'
                elif (pcolor == 'black'):
                    dcolor = 'dark blue'
                    ptext = rawtext[5:] + " (B)"
                    avatarkey = rawtext[5] + 'B'
                else:
                    continue
                brdx = leftsq + (x * incrsq)
                brdy = botsq - (y * incrsq)
                iconid = ""
                if (self.pieceImage[avatarkey]):
                    brdy = brdy - absincrsq / 7
                    iconid = self.gcanvas.create_image(brdx, brdy,
                        image=self.pieceImage[avatarkey], anchor='c',
                        tags="piecetag")
                    brdy = brdy + absincrsq / 2
                txtid = self.gcanvas.create_text(brdx, brdy, text=ptext,
                    tags="piecetag", font=30, fill=dcolor, anchor='c')
                def handler ( event, self=self, tkid=txtid,   \
                        dcolor=dcolor, ptext=ptext):  # Python curry
                    return self.startmove(event, tkid, dcolor, ptext)
                self.gcanvas.tag_bind(txtid, '<ButtonRelease-1>', handler)
                if (iconid):
                    self.gcanvas.tag_bind(iconid, '<ButtonRelease-1>',handler)
                locatorx = brdx - int(0.45 * absincrsq)
                locatory = brdy + int(0.35 * absincrsq)
                locatortext = "(" + str(x) + "," + str(y) + ")"
                # self.gcanvas.create_text(locatorx, locatory,    
                    # text=locatortext, tags="loctag",font=6,fill='black',
                    # anchor='w')

    def updatereach(self):
        # print "DEBUG INSIDE UPDATEREACH" + str(self.isreachdisplay) + " :: " \
            # + str(self.reachstr)
        iswhite = (self.color == 'white')
        if (iswhite):
            leftsq = MAXPIXEL / 16
            botsq = MAXPIXEL * 15 / 16
            incrsq = MAXPIXEL / 8
            absincrsq = MAXPIXEL / 8
        else:
            leftsq = MAXPIXEL * 15 / 16
            botsq = MAXPIXEL / 16
            incrsq = -(MAXPIXEL / 8)
            absincrsq = MAXPIXEL / 8
        self.gcanvas.delete('reachtag')
        if (self.isreachdisplay and self.reachstr):
            statemachine = {
                'isupport' :
                    ('black', LAST, 0.30, 'iattack'),
                'iattack' :
                    ('red', LAST, 0.25, 'supportme'),
                'supportme' :
                    ('green', LAST, 0.20, 'attackme'),
                'attackme' :
                    ('yellow', LAST, 0.15, 'isupport')}
            row = 0
            col = 0
            dlix = 0
            dlist = self.reachstr.split(',')
            relate = 'isupport'
            endlist = len(dlist)
            while (dlix < endlist):
                token = dlist[dlix]
                if (token == ''):
                    dlix = dlix + 1
                    continue
                if (token == '!'):
                    if (relate == 'attackme'):
                        col = col + 1
                        if (col == 8):
                            col = 0
                            row = row + 1
                            if (row == 8):
                                break
                    relate = statemachine[relate][3]
                    dlix = dlix + 1
                    continue
                try:
                    # print "DEBUG ARROW (" + str(dlist[dlix]) + "," \
                        # + str(dlist[dlix+1]) + ") " + relate    \
                        # + " (" + str(dlist[dlix+2]) + ","   \
                        # + str(dlist[dlix+3]) + ")"
                    fromx = leftsq + (int(dlist[dlix]) * incrsq)    \
                        + statemachine[relate][2] * incrsq
                    fromy = botsq - (int(dlist[dlix+1]) * incrsq)   \
                        + statemachine[relate][2] * incrsq
                    tox = leftsq + (int(dlist[dlix+2]) * incrsq)    \
                        + statemachine[relate][2] * incrsq
                    toy = botsq - (int(dlist[dlix+3]) * incrsq)     \
                        + statemachine[relate][2] * incrsq
                    self.gcanvas.create_line(fromx, fromy, tox, toy,    \
                        tags='reachtag', fill=statemachine[relate][0],   \
                        arrow=statemachine[relate][1])
                except ValueError, estr:
                    print "DEBUG reach format bug: " + str(estr)
                    raise ValueError, str(estr)
                dlix = dlix + 4

    def startmove(self, event, tkid, dcolor, ptext):
        if (not self.ismove):
            (brdx, brdy) = self.canvas2board(event.x, event.y)
            rawtext = self.board[(brdx, brdy)]
            rawcolor = rawtext[0:5]
            if (rawcolor != self.color and not self.isdebug):
                showerror("Illegal Move","You cannot move a " \
                    + rawcolor + " piece while playing " + self.color + ".")
                return
            self.ismove = True
            self.gcanvas.itemconfig(tkid, fill='green')
            self.inmoverecord = (brdx, brdy, tkid, dcolor)
            def handler(event, self=self, oldx=brdx, oldy=brdy, \
                    tkid=tkid, dcolor=dcolor):
                return self.endmove(event, oldx, oldy, tkid, dcolor)
            self.gcanvas.tag_bind('square', '<ButtonRelease-1>', handler)
        elif (self.inmoverecord):
            # This piece is end destination for another's move.
            return self.endmove(event, self.inmoverecord[0],    
                self.inmoverecord[1], self.inmoverecord[2],
                    self.inmoverecord[3])

    def endmove(self, event, oldx, oldy, tkid, dcolor):
        global ipcnxn
        if (self.ismove):
            (newx, newy) = self.canvas2board(event.x, event.y)
            self.gcanvas.tag_bind('square', '<ButtonRelease-1>')
            self.ismove = False
            self.inmoverecord = None
            if (newx == oldx and newy == oldy):
                self.gcanvas.itemconfig(tkid, fill=dcolor)
            else:
                errstr = None
                try:
                    errstr = ipcnxn.move(oldx,oldy,newx,newy)
                except Exception, estr:
                    print "DEBUG error from remote move: " + str(estr)
                if (errstr):
                    self.gcanvas.itemconfig(tkid, fill=dcolor)
                    showerror("Illegal Move",errstr)
                else:
                    if (self.oldfrom):
                        self.gcanvas.itemconfig(self.rectangle[self.oldfrom],
                            fill=self.sqcolor[(self.oldfrom[0]  \
                                + self.oldfrom[1]) & 1])
                    if (self.oldto):
                        self.gcanvas.itemconfig(self.rectangle[self.oldto],
                            fill=self.sqcolor[(self.oldto[0]  \
                                + self.oldto[1]) & 1])
                    if (self.color == 'white'):
                        ocx = oldx
                        ocy = 7 - oldy
                        ncx = newx
                        ncy = 7 - newy
                    else:
                        ocx = 7 - oldx
                        ocy = oldy
                        ncx = 7 -newx
                        ncy = newy
                    self.gcanvas.itemconfig(self.rectangle[(ocx,ocy)],
                        fill=hilitecolor[(ocx + ocy) & 1])
                    self.gcanvas.itemconfig(self.rectangle[(ncx,ncy)],
                        fill=hilitecolor[(ncx + ncy) & 1])
                    self.oldfrom = (ocx, ocy)
                    self.oldto = (ncx, ncy)

    def killgame(self):
        if (askyesno("Kill Server?",    \
                'Do you really want to stop the game server?')):
            try:
                ipcnxn.shutdowngame()
                time.sleep(1)
            except Exception:
                pass
            sys.exit(0)

    def togglereach(self):
        self.isreachdisplay = not self.isreachdisplay
        try:
            ipcnxn.displayreach(self.isreachdisplay)
        except Exception:
            pass # ignore illegal move
        if (not self.isreachdisplay):
            self.updatedisplay()

    def canvas2board(self,tkx,tky):
        quantum = int(MAXPIXEL / 8)
        slotx = tkx / quantum
        sloty = tky / quantum
        if (self.color == 'white'):
            sloty = 7 - sloty
        else:
            slotx = 7 - slotx
        return((slotx, sloty))

    def otherside(self):
        global rootwindow
        if (self.oldfrom):
            self.gcanvas.itemconfig(self.rectangle[self.oldfrom],
                fill=self.sqcolor[(self.oldfrom[0]  \
                    + self.oldfrom[1]) & 1])
            self.oldfrom = ((7 - self.oldfrom[0]), (7 - self.oldfrom[1]))
            self.gcanvas.itemconfig(self.rectangle[self.oldfrom],
                fill=hilitecolor[(self.oldfrom[0]  \
                    + self.oldfrom[1]) & 1])
        if (self.oldto):
            self.gcanvas.itemconfig(self.rectangle[self.oldto],
                fill=self.sqcolor[(self.oldto[0]  \
                    + self.oldto[1]) & 1])
            self.oldto = ((7 - self.oldto[0]), (7 - self.oldto[1]))
            self.gcanvas.itemconfig(self.rectangle[self.oldto],
                fill=hilitecolor[(self.oldto[0]  \
                    + self.oldto[1]) & 1])
        self.color = notside[self.color]
        rootwindow.title('Music for 32 Chess Pieces (' + self.color     \
            + ') by Acoustic Interloper')
        self.othersidebutton.config(                                    \
            text="Switch Sides to " + notside[self.color])
        self.updatedisplay()

    def newgame(self):
        global ipcnxn
        if (not askyesno("New Game", 'Do you really want a New Game?')):
            return
        if (self.oldfrom):
            self.gcanvas.itemconfig(self.rectangle[self.oldfrom],
                fill=self.sqcolor[(self.oldfrom[0]  \
                    + self.oldfrom[1]) & 1])
            self.oldfrom = None
        if (self.oldto):
            self.gcanvas.itemconfig(self.rectangle[self.oldto],
                fill=self.sqcolor[(self.oldto[0]  \
                    + self.oldto[1]) & 1])
            self.oldto = None
        try:
            success = ipcnxn.newgame()
        except Exception:
            pass # ignore illegal move

    def reconnect(self):
        global ipcnxn
        if (not askyesno("Reconnect", 'Do you really want to Reconnect?')):
            return
        try:
            self.cbacksrvr.server_close()
        except Exception:
            pass
        time.sleep(1)
        self.myipaddr = socket.gethostbyname(socket.gethostname())
        self.thread = Thread(target = self.runthread, name="XLMRPC")
        self.thread.setDaemon(1)
        self.thread.start()
        # ipcnxn =  client(srvrip, SERVERPORT)
        # ipcnxn.subscribe(self.myipaddr)

    def exit(self):
        if (not askyesno("Exit", 'Do you really want to Exit?')):
            return
        sys.exit(0)

    def fetchmusicmap(self, textmap):
        global q
        # print "DEBUG fetchmusic " + textmap
        self.textcontents = textmap.strip()
        # print "DEBUG putting updatetextdisplay"
        q.put(self.updatetextdisplay)
        return ""

    def fetchreach(self, reachstr):
        self.isreachdisplay = True
        self.reachstr = reachstr
        # print "DEBUG putting updatereach"
        q.put(self.updatereach)
        return ""

    def fetchboard(self, boardstring, oldx, oldy, newx, newy, panicstr):
        """CALLBACK function from board server"""
        def tmp(self=self, boardstring=boardstring, oldx=oldx, oldy=oldy,
                newx=newx, newy=newy, panicstr=panicstr):
            self.helpfetchboard(boardstring, oldx, oldy, newx, newy, panicstr)
        q.put(tmp)
        return ""

class DatagramInterpreter(SocketServer.BaseRequestHandler):
    def handle(self):
        global mainframe
        try:
            print "DEBUG RAW UDP: ", str(self.request), "\n", b2a_hex(self.request[0])
            datatuple = struct.unpack('>iiii128s1024s128s', self.request[0])
            print "DEBUG incoming UDP data = " + str(datatuple)
            if (datatuple[4] == 'fetchmusicmap'):
                mainframe.fetchmusicmap(datatuple[5])
            elif (datatuple[4] == 'fetchreach'):
                mainframe.fetchreach(datatuple[5])
            elif (datatuple[4] == 'fetchboard'):
                mainframe.fetchboard(datatuple[5], datatuple[0], datatuple[1],
                    datatuple[2], datatuple[3], datauple[6])
            else:
                raise ChessException, "Invalid UDP datagram: " + str(datatuple)
        except Exception, estr:
            print "UDP RECV ERROR: " + str(estr)

rootwindow = None
def start(srvripaddr, color='white', debug=0):
    global q
    global rootwindow
    global mainframe
    global MAXPIXEL
    rootwindow = Tk()
    MAXPIXEL = min(rootwindow.maxsize()) - 100
    print "MAXPIXEL is " + str(MAXPIXEL)
    rootwindow.geometry('+0+0')
    startclient(srvripaddr, color, debug)
    rootwindow.deiconify()
    rootwindow.lift()
    pollq(200)
    rootwindow.mainloop()

def pollq(delay=200):
    global q
    global rootwindow
    # print "DEBUG polling"
    try:
        cback = q.get(False)
        # print "DEBUG MAIN THREAD POLLED " + str(cback)
        cback()
    except Queue.Empty:
        pass
    rootwindow.after(delay, pollq)
