/*
   FIR Synthesizer

   yerpa58 (2008)

   Version 0.1 Two strings, two control knobs.

   Version 0.2 (2009) Add counter/generator, use API_POT[7] to control parameters of counter/generator.
   BUFFER1[] and BUFFER[2] are in application.c

   Version 0.3 (2009) Changed buffer preload to full scale values. Added "reverse" switch control of preload.

*/

//
// global variables
//

// "API" Potentiometer 0..7 values:
// int8 API_POT[8];

int8  FIR_out       = 0x7f;
int8 data;
static int16  speed1;
static int16  speed2;
static int16  delay1;
static int16  delay2;
static int16  wavcntr1;
static int16  wavcntr2;
static int16  seq1;
static int16  seq2;
static int8   prescale;
static int8   rescale;
static int8   seed;
static int16  buff_len_1;
static int16  buff_len_2;

void DSP_FIR_Init (void)
{
   int16 i;
   int8 noise;
   noise = 0x1d;
   for (i=0; i<512; i++)
   {
     noise <<=1;
     if (noise & 0x80) noise ^= 0xe1;
     if (noise & 0x01) BUFFER1[i]=0xff;
     else BUFFER1[i]=0;
   }

   FIR_out= 0x7f;

}


void DSP_FIR2_Init (void)
{
   int16 i;
   int8 noise;
   noise = 0x1d;
   for (i=0; i<512; i++)
   {
     noise <<=1;
     if (noise & 0x80) noise ^= 0xc5;
     BUFFER2[i]=noise;
   }

   FIR_out= 0x7f;
}


int8 Random (void)
{
   if (seed==0) seed = 0x1d;
   seed <<=1;
   if (seed & 0x80) seed ^= 0xe1;
   if (seed & 0x01) return(0xff);
   return(0);
}


// This subroutine plays two strings...

int8 DSP_FIR_1 (int1 reverse)
{
   static int16 index1a  = 0;
   static int16 index1b  = 0xff;
   static int16 index2a  = 0;
   static int16 index2b  = 0x3f;
   static int16 acc1     = 0x7f;
   static int16 acc2     = 0x7f;

   //static int16  buff_len_1;
   static int16 old_len_1;
   static int16 tmp16;
   static int16 old_len_2;
   static int16 FIR_out;
//   static int8  vscale;
   static int8  oldv;
   static int8  gain8;
   static int8  hi8;
   static int8  spread;
   static int8  oldspread;

//   vscale=API_POT[7];
//   vscale >>= 2;

   spread = API_POT[3];
   spread >>= 2;
   if (spread == oldspread) spread = 0;
   if (spread != oldspread) oldspread = spread;

   // First FIR string initial pluck...

   buff_len_1 = API_POT[4]>>2;
   if (buff_len_1 != old_len_1)
   {
      if (reverse) DSP_FIR_Init();
      old_len_1 = buff_len_1;
      index1a = 0;
   }

   // Second FIR string initial pluck...

   buff_len_2 = (API_POT[5] & 0xFC)<<1;
   if (buff_len_2 != old_len_2)
   {
      if (reverse) DSP_FIR2_Init();
      old_len_2 = buff_len_2;
      index2a = 0;
   }

   // First FIR string play...

   index1b = index1a + buff_len_1;
   index1b += spread;
   if (index1b > buff_len_1)
   {
      index1b=index1b-buff_len_1;
      index1b=index1b-1;
   }
   acc1 = BUFFER1[index1a] + BUFFER1[index1b];

//   if (reverse)  acc1 = BUFFER1[index1a] + BUFFER1[index1b];
//   if (!reverse)
//   {
//      hi8=Random();
//      if (hi8 & 0x01) acc1 = BUFFER1[index1a] + BUFFER1[index1b];
//      if (!(hi8 & 0x01)) acc1 = BUFFER1[index1a] - BUFFER1[index1b];
//   }

   acc1 >>=1;
   acc1 &= 0xFF;
   BUFFER1[index1b] = acc1;

//   if (!reverse)
//   {
//      gain8=API_POT[3];
//      tmp16 = _mul(gain8, acc1);  // Apply amplitude envelope
//      hi8 = tmp16>>6 ;
//      BUFFER1[index1a] = hi8;     // to feedback gain.
//   }

   index1a++;
   if (index1a > buff_len_1)
   {
     index1a=index1a-buff_len_1;
     index1a=index1a-1;
   }

   // Second FIR string play...

   index2b = index2a + buff_len_2;
   if (index2b > buff_len_2)
   {
      index2b=index2b-buff_len_2;
      index2b=index2b-1;
   }

   acc2 = BUFFER2[index2a] + BUFFER2[index2b];

//   if (reverse)  acc2 = BUFFER2[index2a] + BUFFER2[index2b];
//   if (!reverse)
//   {
//       hi8=Random();
//       if (hi8 & 0x01) acc2 = BUFFER2[index2a] + BUFFER2[index2b];
//       if (!(hi8 & 0x01)) acc2 = BUFFER2[index2a] - BUFFER2[index2b];
//   }

   acc2 >>=1;
   acc2 &= 0xFF;
   BUFFER2[index2b] = acc2;

//   if (!reverse)
//   {
//      gain8=API_POT[3];
//      tmp16 = _mul(gain8, acc2);   // Apply amplitude envelope
//      hi8 = tmp16>>6;
//      BUFFER2[index2a] = hi8;      // to feedback gain.
//   }

   index2a++;
   if (index2a > buff_len_2)
   {
     index2a=index2a-buff_len_2;
     index2a=index2a-1;
   }

   FIR_out = acc1+acc2;

   // Run string counter/sequencer if knob 7 turned up and moved...

//if (vscale > 4)
//{
//  wavcntr1 += API_POT[6];
//  seq2 = API_POT[7];
//  seq2 >>= 6;
//  wavcntr2=wavcntr1;
//  if (seq2==0) wavcntr2 >>=1;
//  if (seq2==1) wavcntr2 >>=2;
//  if (seq2==2) wavcntr2 <<=1;
//  if (seq2==2) wavcntr2 <<=2;
//
//     seq1 = wavcntr1;
//
//     seq2 = wavcntr2;
//
//     prescale++;
//
//     rescale = API_POT[1];
//     rescale >>= 2;
//
//     if (prescale >= rescale)
//     {
//       prescale=0;
//       if (speed1 !=0) speed1--;
//       else if (delay1 != 0) delay1--;
//       if (speed2 !=0) speed2--;
//       else if (delay2 != 0) delay2--;
//     }
//
//     if ((speed1==0)||(oldv!=vscale)||(delay1==0))
//     {
//       if (reverse) DSP_FIR_Init();
//       oldv=vscale;
//       speed1=seq1;
//       speed1 &= 0x3ff;
//       if (speed1 < 300) speed1 ^= 0xffff;
//       speed1 &= 0x3ff;
//       delay1 = speed1;
//       buff_len_1=seq1;
//       if (buff_len_1 < 64) buff_len_1 ^=0xffff;
//       buff_len_1 &= 0x1ff;
//     }
//     if ((speed2==0)||(oldv!=vscale)||(delay2==0))
//     {
//       oldv=vscale;
//       if (reverse) DSP_FIR2_Init();
//       speed2=seq2;
//       speed2 &= 0x3ff;
//       if (speed2 < 300) speed2 ^= 0xffff;
//       speed2 &= 0x3ff;
//       delay2 = speed2;
//       buff_len_2=seq2;
//       if (buff_len_2 < 100) buff_len_2 ^= 0xffff;
//       buff_len_2 &= 0x1ff;
//     }
//   }
   return FIR_out;
}
