/*
   Simple Sequencer / FM-Synthesizer

   Version 0.4

   Eric Boger (2008)

   ------

   I added/changed/commented out a couple of lines to change the operation of the EnvAcnt and EnvBcnt volume
   and modulation envelopes.

   yerpa58 (2009)

*/

//
// global variables
//

// "API" Potentiometer 0..7 values:
// int8 API_POT[8];

// Param1 = edit step
// Param2 = step value
// Param3 = DCA envelope decay
// Param4 = FM envelope decay
// Param5 = OSC-B pitch
// Param6 = OSC-A offset


int8 SEQ_out     = 0x7f;
int8 SEQ_step    = 0;
int1 SEQ_trigger = FALSE;
int8 SEQ_val[16];
int8 SEQ_clockdiv = 0x7f;



void DSP_SEQ_Init (void)
{
   int8 i;

   SEQ_out     = 0x7f;
   SEQ_step    = 0;
   SEQ_trigger = FALSE;
   SEQ_clockdiv = 0x7f;

   for (i=0;i<16;i++)
   {
      SEQ_val[i] = 0xff;
   }
   SEQ_val[0] = 0x7f;
}


int8 DSP_SEQ_Alg_1 (int1 reverse)
{
   static int8  oscA     = 0;
   static int8  oscArate = 1;
   static int8  oscB     = 0;
   static int8  oscBrate = 1;
   static int8  envA     = 0xff;
   static int16  envAcnt  = 1;
   static int8  envB     = 0xff;
   static int8  envBcnt  = 1;

   int16 temp;

   // sequence value 0 = mute step
   if (SEQ_val[SEQ_step] == 0xff) return 0x7f;

   // oscillator A
   oscArate--;
   if (oscArate == 0)
   {
      oscArate  = SEQ_val[SEQ_step] >> 1;
      oscArate += (~API_POT[_POT_PARAM6]) >> 1;
      if (oscArate == 0) oscArate = 1;

      oscA = ~oscA;
   }

   // oscillator B
   oscBrate--;
   if (oscBrate == 0)
   {
      oscBrate  = SEQ_val[SEQ_step] >> 1;
      oscBrate += ~API_POT[_POT_PARAM5];

      if (API_POT[_POT_PARAM4] != 0)
      {
         if (oscBrate > envB) oscBrate -= envB;
      }

      if (oscBrate == 0) oscBrate=1;

      oscB = ~oscB;
   }

   // volume envelope (VCA)
   envAcnt--;
   if (envAcnt == 0)
   {
      envAcnt  = API_POT[_POT_PARAM3] >> 1;
      envAcnt += 32;
      if (envA > 4) envA = envA - 4;
      if (envA <= 4) envA = 0;
      //envAcnt = 1;
   }

   // modulation envelope
   envBcnt--;
   if (envBcnt == 0)
   {
      envBcnt = API_POT[_POT_PARAM4]>>1;
      if (envB >= 1) envB = envB - 1;
      //envBcnt = 1;
   }

   // next sequence step triggered -> retrigger envelope A & B
   if (SEQ_trigger)
   {
      envA = 0xff;
      envB = 0xff;
      SEQ_trigger = FALSE;
   }

   // FM modulation OSC_A * OSC_B
   temp = _mul(oscA,oscB);
   SEQ_out = temp >> 8;

   // Volume modulation (VCA)
   temp = _mul(SEQ_out,envA);
   SEQ_out = temp >> 8;

   return SEQ_out;
}


void DSP_SEQ_Do (int1 reverse)
{
   static int8 stepold  = 0xff;
   static int1 lock = TRUE;

   int8 step;
   int8 val;

//   int8 i;
//   static int8 valold = 0;

   // update sequence
   step =  API_POT[_POT_PARAM1] >> 5;
   val  = ~API_POT[_POT_PARAM2];
   if (step != stepold)
   {
      LED = LEDCHAR[step+1] & 0x7f;  // show step number with dp
   }
   SEQ_val[step] = val;


   /*
   // debug
   if ((val != valold) || (step != stepold))
   {
      printf("S:%x P:%x  ",step,val);
      for (i=0;i<8;i++) printf(" %x",SEQ_val[i]);
      printf("\n\r");
   }
   valold = val;
   */

   stepold = step;

   // sequencer timer
   SEQ_clockdiv--;
   if (SEQ_clockdiv != 0) return;
   SEQ_clockdiv = 0x7f;

   // next step
   if (reverse)
   {
      SEQ_step--;
      if (SEQ_step > 7) SEQ_step = 7;
   }
   else
   {
      SEQ_step++;
      if (SEQ_step > 7) SEQ_step = 0;
   }

   SEQ_trigger = TRUE;

}
