/*
   Sine Wave Synthesizer

   yerpa58 (2009)

   Version 0.1 One wave plus another delayed wave. two control knobs.

   DELAY_BUFF[] is in application.c

*/

//
// global variables
//

   int8  SINE_out       = 0x7f;

// "API" Potentiometer 0..7 values:
// int8 API_POT[8];


const int16 SCALE1[32] =
{
   311,   841,   363,  893,
   415,   944,   466,  996,
   518,  1048,   570,  1100,
   622,  1152,   674,  1204,
   726,  1255,   777,  1307,
   829,  1359,   881,  1411,
   933,  1463,   985,  1515,
  1036,  1566,  1088,  1618
};


const int16 SCALE2[32] =
{
   415,   944,   466,  996,
   518,  1048,   570,  1100,
  1036,  1566,  1088,  1618,
   622,  1152,   674,  1204,
   726,  1255,   777,  1307,
   829,  1359,   881,  1411,
   311,   841,   363,  893,
   933,  1463,   985,  1515
};


const int16 SCALE3[32] =
{
   1153,   1312,   1515,   1787
   2132,   1594,   2099,   1731
   2415,   2237,   2163,   2198
   2350,   2625,   3030,   3573
   3303,   3189,   4198,   3462
   3871,   4475,   4326,   4396
   4700,   5249,   6060,   6187
   6607,   6377,   7437,   6924
};


const int16 SCALE4[32] =
{
   2132,   1594,   2099,   1731
   1153,   1312,   1515,   1787
   2415,   2237,   2163,   2198
   2350,   2625,   3030,   3573
   3871,   4475,   4326,   4396
   3303,   3189,   4198,   3462
   6607,   6377,   7437,   6924
   4700,   5249,   6060,   6187
};

const int16 SCALE5[32] =
{
   3189,   4198,  3462,  3871
   4475,   4326,  4396,  4700
   5249,   6060,  6187,  6607
   6377,   7437,  6924,  7741
   7989,   8651,  8793,  9399
   10498, 11159, 11413, 12253
   12754, 13913, 13848, 15482
   15978, 17303, 17585, 18798
};

const int16 SCALE6[32] =
{
   4475,   4326,  4396,  4700
   3189,   4198,  3462,  3871
   6377,   7437,  6924,  7741
   5249,   6060,  6187,  6607
   10498, 11159, 11413, 12253
   7989,   8651,  8793,  9399
   15978, 17303, 17585, 18798
   12754, 13913, 13848, 15482
};

const int16 SCALE7[32] =
{
   1153,    1515,   1787,   1594
   1731,    2237,   2163,   2350
   3030,    3573,   3189,   3462
   3871,    4475,   4326,   4700
   6060,    6187,   6377,   6924
   7741,    7989,   8651,   9399
   11159,  11413,  12754,  13848
   15482,  15978,  17303,  18798
};

const int16 SCALE8[32] =
{
   1731,    2237,   2163,   2350
   1153,    1515,   1787,   1594
   3871,    4475,   4326,   4700
   3030,    3573,   3189,   3462
   7741,    7989,   8651,   9399
   6060,    6187,   6377,   6924
   11159,  11413,  12754,  13848
   15482,  15978,  17303,  18798
};


const int8 SINE_TABLE[1024] =
{
    127, 128, 129, 129
	130, 131, 132, 132, 133, 134, 135, 136, 136, 137,
	138, 139, 139, 140, 141, 142, 143, 143, 144, 145,
	146, 146, 147, 148, 149, 149, 150, 151, 152, 153,
	153, 154, 155, 156, 156, 157, 158, 159, 159, 160,
	161, 162, 162, 163, 164, 165, 165, 166, 167, 168,
	168, 169, 170, 171, 171, 172, 173, 173, 174, 175,
	176, 176, 177, 178, 178, 179, 180, 181, 181, 182,
	183, 183, 184, 185, 185, 186, 187, 188, 188, 189,
	190, 190, 191, 192, 192, 193, 194, 194, 195, 196,
	196, 197, 198, 198, 199, 199, 200, 201, 201, 202,
	203, 203, 204, 205, 205, 206, 206, 207, 208, 208,
	209, 209, 210, 211, 211, 212, 212, 213, 213, 214,
	215, 215, 216, 216, 217, 217, 218, 218, 219, 220,
	220, 221, 221, 222, 222, 223, 223, 224, 224, 225,
	225, 226, 226, 227, 227, 228, 228, 229, 229, 229,
	230, 230, 231, 231, 232, 232, 233, 233, 233, 234,
	234, 235, 235, 236, 236, 236, 237, 237, 238, 238,
	238, 239, 239, 239, 240, 240, 240, 241, 241, 241,
	242, 242, 242, 243, 243, 243, 244, 244, 244, 245,
	245, 245, 245, 246, 246, 246, 247, 247, 247, 247,
	248, 248, 248, 248, 249, 249, 249, 249, 249, 250,
	250, 250, 250, 250, 251, 251, 251, 251, 251, 251,
	252, 252, 252, 252, 252, 252, 252, 253, 253, 253,
	253, 253, 253, 253, 253, 253, 253, 253, 254, 254,
	254, 254, 254, 254, 254, 254, 254, 254, 254, 254,
	254, 254, 254, 254, 254, 254, 254, 254, 254, 254,
	254, 254, 254, 254, 254, 254, 254, 253, 253, 253,
	253, 253, 253, 253, 253, 253, 253, 253, 252, 252,
	252, 252, 252, 252, 252, 251, 251, 251, 251, 251,
	251, 250, 250, 250, 250, 250, 249, 249, 249, 249,
	249, 248, 248, 248, 248, 247, 247, 247, 247, 246,
	246, 246, 245, 245, 245, 245, 244, 244, 244, 243,
	243, 243, 242, 242, 242, 241, 241, 241, 240, 240,
	240, 239, 239, 239, 238, 238, 238, 237, 237, 236,
	236, 236, 235, 235, 234, 234, 233, 233, 233, 232,
	232, 231, 231, 230, 230, 229, 229, 229, 228, 228,
	227, 227, 226, 226, 225, 225, 224, 224, 223, 223,
	222, 222, 221, 221, 220, 220, 219, 218, 218, 217,
	217, 216, 216, 215, 215, 214, 213, 213, 212, 212,
	211, 211, 210, 209, 209, 208, 208, 207, 206, 206,
	205, 205, 204, 203, 203, 202, 201, 201, 200, 199,
	199, 198, 198, 197, 196, 196, 195, 194, 194, 193,
	192, 192, 191, 190, 190, 189, 188, 188, 187, 186,
	185, 185, 184, 183, 183, 182, 181, 181, 180, 179,
	178, 178, 177, 176, 176, 175, 174, 173, 173, 172,
	171, 171, 170, 169, 168, 168, 167, 166, 165, 165,
	164, 163, 162, 162, 161, 160, 159, 159, 158, 157,
	156, 156, 155, 154, 153, 153, 152, 151, 150, 149,
	149, 148, 147, 146, 146, 145, 144, 143, 143, 142,
	141, 140, 139, 139, 138, 137, 136, 136, 135, 134,
	133, 132, 132, 131, 130, 129, 129, 128, 127, 126,
	125, 125, 124, 123, 122, 122, 121, 120, 119, 118,
	118, 117, 116, 115, 115, 114, 113, 112, 111, 111,
	110, 109, 108, 108, 107, 106, 105, 105, 104, 103,
	102, 101, 101, 100,  99,  98,  98,  97,  96,  95,
	 95,  94,  93,  92,  92,  91,  90,  89,  89,  88,
	 87,  86,  86,  85,  84,  83,  83,  82,  81,  81,
	 80,  79,  78, 	78,  77,  76,  76,  75,  74,  73,
	 73,  72,  71, 	71,  70,  69,  69,  68,  67,  66,
	 66,  65,  64, 	64,  63,  62,  62,  61,  60,  60,
	 59,  58,  58, 	57,  56,  56,  55,  55,  54,  53,
	 53,  52,  51, 	51,  50,  49,  49,  48,  48,  47,
	 46,  46,  45, 	45,  44,  43,  43,  42,  42,  41,
	 41,  40,  39, 	39,  38,  38,  37,  37,  36,  36,
	 35,  34,  34, 	33,  33,  32,  32,  31,  31,  30,
	 30,  29,  29, 	28,  28,  27,  27,  26,  26,  25,
	 25,  25,  24, 	24,  23,  23,  22,  22,  21,  21,
	 21,  20,  20, 	19,  19,  18,  18,  18,  17,  17,
	 16,  16,  16, 	15,  15,  15,  14,  14,  14,  13,
	 13,  13,  12, 	12,  12,  11,  11,  11,  10,  10,
	 10,   9,   9,   9,   9,   8,   8,   8,   7,   7,
	  7,   7,   6,   6,   6,   6,   5,   5,   5,   5,
	  5,   4,   4,   4,   4,   4,   3,   3,   3,   3,
	  3,   3,   2,   2,   2,   2,   2,   2,   2,   1,
	  1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
	  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	  0,   0,   0,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	  0,   0,   0, 	 0,   0,   1,   1,   1,   1,   1,
	  1,   1,   1, 	 1,   1,   1,   2,   2,   2,   2,
	  2,   2,   2, 	 3,   3,   3,   3,   3,   3,   4,
	  4,   4,   4, 	 4,   5,   5,   5,   5,   5,   6,
	  6,   6,   6, 	 7,   7,   7,   7,   8,   8,   8,
	  9,   9,   9, 	 9,  10,  10,  10,  11,  11,  11,
	 12,  12,  12, 	13,  13,  13,  14,  14,  14,  15,
	 15,  15,  16, 	16,  16,  17,  17,  18,  18,  18,
	 19,  19,  20, 	20,  21,  21,  21,  22,  22,  23,
	 23,  24,  24, 	25,  25,  25,  26,  26,  27,  27,
	 28,  28,  29, 	29,  30,  30,  31,  31,  32,  32,
	 33,  33,  34, 	34,  35,  36,  36,  37,  37,  38,
	 38,  39,  39, 	40,  41,  41,  42,  42,  43,  43,
	 44,  45,  45, 	46,  46,  47,  48,  48,  49,  49,
	 50,  51,  51, 	52,  53,  53,  54,  55,  55,  56,
	 56,  57,  58, 	58,  59,  60,  60,  61,  62,  62,
	 63,  64,  64, 	65,  66,  66,  67,  68,  69,  69,
	 70,  71,  71, 	72,  73,  73,  74,  75,  76,  76,
	 77,  78,  78, 	79,  80,  81,  81,  82,  83,  83,
	 84,  85,  86, 	86,  87,  88,  89,  89,  90,  91,
	 92,  92,  93, 	94,  95,  95,  96,  97,  98,  98,
	 99, 100, 101, 101, 102, 103, 104, 105, 105, 106,
	107, 108, 108, 109, 110, 111, 111, 112, 113, 114,
	115, 115, 116, 117, 118, 118, 119, 120, 121, 122,
	122, 123, 124, 125, 125, 126
};

const int8 TRIANGLE_TABLE[1024] =
{
    127,  127,  128,  128,  129,  129,  130,  130,  131,  131
	132,  132,  133,  133,  134,  134,  135,  135,  136,  136
	137,  137,  138,  138,  139,  139,  140,  140,  141,  141
	142,  142,  143,  143,  144,  144,  145,  145,  146,  146
	147,  147,  148,  148,  149,  149,  150,  150,  151,  151
	152,  152,  153,  153,  154,  154,  155,  155,  156,  156
	157,  157,  158,  158,  159,  159,  160,  160,  161,  161
	162,  162,  163,  163,  164,  164,  165,  165,  166,  166
	167,  167,  168,  168,  169,  169,  170,  170,  171,  171
	172,  172,  173,  173,  174,  174,  175,  175,  176,  176
	177,  177,  178,  178,  179,  179,  180,  180,  181,  181
	182,  182,  183,  183,  184,  184,  185,  185,  186,  186
	187,  187,  188,  188,  189,  189,  190,  190,  191,  191
	192,  192,  193,  193,  194,  194,  195,  195,  196,  196
	197,  197,  198,  198,  199,  199,  200,  200,  201,  201
	202,  202,  203,  203,  204,  204,  205,  205,  206,  206
	207,  207,  208,  208,  209,  209,  210,  210,  211,  211
	212,  212,  213,  213,  214,  214,  215,  215,  216,  216
	217,  217,  218,  218,  219,  219,  220,  220,  221,  221
	222,  222,  223,  223,  224,  224,  225,  225,  226,  226
	227,  227,  228,  228,  229,  229,  230,  230,  231,  231
	232,  232,  233,  233,  234,  234,  235,  235,  236,  236
	237,  237,  238,  238,  239,  239,  240,  240,  241,  241
	242,  242,  243,  243,  244,  244,  245,  245,  246,  246
	247,  247,  248,  248,  249,  249,  250,  250,  251,  251
	252,  252,  253,  253,  254,  254,  255,  255,  255,  254
	254,  253,  253,  252,  252,  251,  251,  250,  250,  249
	249,  248,  248,  247,  247,  246,  246,  245,  245,  244
	244,  243,  243,  242,  242,  241,  241,  240,  240,  239
	239,  238,  238,  237,  237,  236,  236,  235,  235,  234
	234,  233,  233,  232,  232,  231,  231,  230,  230,  229
	229,  228,  228,  227,  227,  226,  226,  225,  225,  224
	224,  223,  223,  222,  222,  221,  221,  220,  220,  219
	219,  218,  218,  217,  217,  216,  216,  215,  215,  214
	214,  213,  213,  212,  212,  211,  211,  210,  210,  209
	209,  208,  208,  207,  207,  206,  206,  205,  205,  204
	204,  203,  203,  202,  202,  201,  201,  200,  200,  199
	199,  198,  198,  197,  197,  196,  196,  195,  195,  194
	194,  193,  193,  192,  192,  191,  191,  190,  190,  189
	189,  188,  188,  187,  187,  186,  186,  185,  185,  184
	184,  183,  183,  182,  182,  181,  181,  180,  180,  179
	179,  178,  178,  177,  177,  176,  176,  175,  175,  174
	174,  173,  173,  172,  172,  171,  171,  170,  170,  169
	169,  168,  168,  167,  167,  166,  166,  165,  165,  164
	164,  163,  163,  162,  162,  161,  161,  160,  160,  159
	159,  158,  158,  157,  157,  156,  156,  155,  155,  154
	154,  153,  153,  152,  152,  151,  151,  150,  150,  149
	149,  148,  148,  147,  147,  146,  146,  145,  145,  144
	144,  143,  143,  142,  142,  141,  141,  140,  140,  139
	139,  138,  138,  137,  137,  136,  136,  135,  135,  134
	134,  133,  133,  132,  132,  131,  131,  130,  130,  129
	129,  128,  128,  127,  127,  126,  126,  125,  125,  124
	124,  123,  123,  122,  122,  121,  121,  120,  120,  119
	119,  118,  118,  117,  117,  116,  116,  115,  115,  114
	114,  113,  113,  112,  112,  111,  111,  110,  110,  109
	109,  108,  108,  107,  107,  106,  106,  105,  105,  104
	104,  103,  103,  102,  102,  101,  101,  100,  100,   99
	99,    98,   98,   97,   97,   96,   96,   95,   95,   94
	94,    93,   93,   92,   92,   91,   91,   90,   90,   89
	89,    88,   88,   87,   87,   86,   86,   85,   85,   84
	84,    83,   83,   82,   82,   81,   81,   80,   80,   79
	79,    78,   78,   77,   77,   76,   76,   75,   75,   74
	74,    73,   73,   72,   72,   71,   71,   70,   70,   69
	69,    68,   68,   67,   67,   66,   66,   65,   65,   64
	64,    63,   63,   62,   62,   61,   61,   60,   60,   59
	59,    58,   58,   57,   57,   56,   56,   55,   55,   54
	54,    53,   53,   52,   52,   51,   51,   50,   50,   49
	49,    48,   48,   47,   47,   46,   46,   45,   45,   44
	44,    43,   43,   42,   42,   41,   41,   40,   40,   39
	39,    38,   38,   37,   37,   36,   36,   35,   35,   34
	34,    33,   33,   32,   32,   31,   31,   30,   30,   29
	29,    28,   28,   27,   27,   26,   26,   25,   25,   24
	24,    23,   23,   22,   22,   21,   21,   20,   20,   19
	19,    18,   18,   17,   17,   16,   16,   15,   15,   14
	14,    13,   13,   12,   12,   11,   11,   10,   10,    9
	9,      8,    8,    7,    7,    6,    6,    5,    5,    4
	4,      3,    3,    2,    2,    1,    1,    0,    0,    0
	1,      1,    2,    2,    3,    3,    4,    4,    5,    5
	6,      6,    7,    7,    8,    8,    9,    9,   10,   10
	11,    11,   12,   12,   13,   13,   14,   14,   15,   15
	16,    16,   17,   17,   18,   18,   19,   19,   20,   20
	21,    21,   22,   22,   23,   23,   24,   24,   25,   25
	26,    26,   27,   27,   28,   28,   29,   29,   30,   30
	31,    31,   32,   32,   33,   33,   34,   34,   35,   35
	36,    36,   37,   37,   38,   38,   39,   39,   40,   40
	41,    41,   42,   42,   43,   43,   44,   44,   45,   45
	46,    46,   47,   47,   48,   48,   49,   49,   50,   50
	51,    51,   52,   52,   53,   53,   54,   54,   55,   55
	56,    56,   57,   57,   58,   58,   59,   59,   60,   60
	61,    61,   62,   62,   63,   63,   64,   64,   65,   65
	66,    66,   67,   67,   68,   68,   69,   69,   70,   70
	71,    71,   72,   72,   73,   73,   74,   74,   75,   75
	76,    76,   77,   77,   78,   78,   79,   79,   80,   80
	81,    81,   82,   82,   83,   83,   84,   84,   85,   85
	86,    86,   87,   87,   88,   88,   89,   89,   90,   90
	91,    91,   92,   92,   93,   93,   94,   94,   95,   95
	96,    96,   97,   97,   98,   98,   99,   99,  100,  100
	101,  101,  102,  102,  103,  103,  104,  104,  105,  105
	106,  106,  107,  107,  108,  108,  109,  109,  110,  110
	111,  111,  112,  112,  113,  113,  114,  114,  115,  115
	116,  116,  117,  117,  118,  118,  119,  119,  120,  120
	121,  121,  122,  122,  123,  123,  124,  124,  125,  125
	126,  126,  127,  127
};


void DSP_SINE_Init (void)
{
   SINE_out       = 0x7f;
}


int8 DSP_SINE (int1 reverse)
{
   static int8 note_ptr1;
   static int8 note_ptr2;
   static int8 old_ptr1;
   static int8 old_ptr2;
   static int8 envelope1;
   static int8 envelope2;
   static int8 gesture;
   static int8 tmp8;
   static int8 tmpnp1;
   static int8 tmpnp2;

   static int16 sin_index1;
   static int16 sin_index2;
   static int16 sin_increment1;
   static int16 sin_increment2;
   static int16 delay_ptr1;
   static int16 delay_ptr2;
   static int16 shift_mask;
   static int16 sin_sum;
   static int16 tmp_index;
   static int16 tmp_sum;

   gesture++;

   if (gesture==0)
   {
      tmpnp1 = API_POT[2];   // Used to pick a SCALE table for osc 1.
      tmpnp1 >>= 5;
      tmpnp2 = API_POT[3];   // Used to pick a SCALE table for osc 2.
      tmpnp2 >>= 5;
      shift_mask = 0x3ff;
      tmp8 = ~API_POT[1];
      tmp8 >>= 4;
      shift_mask >>= tmp8;
      delay_ptr2++;
      delay_ptr1 = delay_ptr2 + 1;
      delay_ptr1 &= shift_mask;
      delay_ptr2 &= shift_mask;
      note_ptr1 = API_POT[7]>>3;
      DELAY_BUFF[delay_ptr2] = note_ptr1;  //Record current note from osc 1.
      note_ptr2 = DELAY_BUFF[delay_ptr1];  //Get delayed note for osc 2.
      if ((envelope1 != 0)&&(reverse==FALSE)) envelope1--;
      if ((envelope2 != 0)&&(reverse==FALSE)) envelope2--;
      if ((envelope1 != 0xff)&&(reverse==TRUE)) envelope1++;
      if ((envelope2 != 0xff)&&(reverse==TRUE)) envelope2++;
   }

   // First waveform (sine)...

   if (tmpnp1==0) sin_increment1=SCALE1[note_ptr1];
   if (tmpnp1==1) sin_increment1=SCALE2[note_ptr1];
   if (tmpnp1==2) sin_increment1=SCALE3[note_ptr1];
   if (tmpnp1==3) sin_increment1=SCALE4[note_ptr1];
   if (tmpnp1==4) sin_increment1=SCALE5[note_ptr1];
   if (tmpnp1==5) sin_increment1=SCALE6[note_ptr1];
   if (tmpnp1==6) sin_increment1=SCALE7[note_ptr1];
   if (tmpnp1==7) sin_increment1=SCALE8[note_ptr1];

   sin_index1 += sin_increment1;
   tmp_index = sin_index1 >>6;
   tmp8 = SINE_TABLE[tmp_index];
   if (note_ptr1 != old_ptr1)
   {
      old_ptr1 = note_ptr1;
      if (reverse==FALSE) envelope1 = 0xff;
      if (reverse==TRUE) envelope1 = 0;
   }
   tmp_sum = _mul(tmp8, envelope1);   // Apply amplitude envelope 1...
   tmp8 = make8(tmp_sum, 1);
   sin_sum = tmp8;

   // Second waveform (triangle)...

   if (tmpnp2==0) sin_increment2=SCALE1[note_ptr2];
   if (tmpnp2==1) sin_increment2=SCALE2[note_ptr2];
   if (tmpnp2==2) sin_increment2=SCALE3[note_ptr2];
   if (tmpnp2==3) sin_increment2=SCALE4[note_ptr2];
   if (tmpnp2==4) sin_increment2=SCALE5[note_ptr2];
   if (tmpnp2==5) sin_increment2=SCALE6[note_ptr2];
   if (tmpnp2==6) sin_increment2=SCALE7[note_ptr2];
   if (tmpnp2==7) sin_increment2=SCALE8[note_ptr2];

   sin_index2 += sin_increment2;
   tmp_index = sin_index2 >>6;
   tmp8 = TRIANGLE_TABLE[tmp_index];
   if (note_ptr2 != old_ptr2)
   {
      old_ptr2 = note_ptr2;
      envelope2 = 0xff;
   }
   tmp_sum = _mul(tmp8, envelope2);   // Apply amplitude envelope 2...
   tmp8 = make8(tmp_sum, 1);
   sin_sum += tmp8;
   sin_sum >>=1;

   SINE_out = sin_sum & 0xff;
   return SINE_out;
}
