unit FrmMain;

//  ////////////////////////////////////////////////////////////////////////////
//
//  Copyright (C) 2004 Jan Punter
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
//  ////////////////////////////////////////////////////////////////////////////
//
//    lupd : 2004-04-04
//
//  ////////////////////////////////////////////////////////////////////////////


interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, Buttons, Globals, datadefs;

type
  TFormMain = class(TForm)
    BitBtnLoadpatch: TBitBtn;
    OpenDialog: TOpenDialog;
    SaveDialog: TSaveDialog;
    BitBtnSaveMIDI: TBitBtn;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    LabelVersionString: TLabel;
    LabelTypeString: TLabel;
    LabelVersionInt: TLabel;
    LabelInfoString: TLabel;
    BitBtnLoadMIDI: TBitBtn;
    BitBtnSavePatch: TBitBtn;
    Label2: TLabel;
    LabelPatchName: TLabel;
    procedure BitBtnLoadpatchClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure BitBtnSaveMIDIClick(Sender: TObject);
    procedure FormKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure BitBtnLoadMIDIClick(Sender: TObject);
    procedure BitBtnSavePatchClick(Sender: TObject);
  private
    FPatchData : TPatchData;
  Private
    Procedure   ShowFileInfo;
    Procedure   LoadPatchFile( Const aFileName: String);
    Procedure   SaveMidiFile( Const aFileName: String);
    Procedure   LoadMIDIFile( Const aFileName: String);
    Procedure   SavePatchFile( Const aFileName: String);
    // Procedure   TestChecksum;
  end;

var
  FormMain: TFormMain;

implementation

{$R *.dfm}


// User area

    Procedure   TFormMain.ShowFileInfo;
    Begin
      With FPatchData Do
      Begin
        LabelPatchName    .Caption := fileName;
        LabelVersionString.Caption := VersionString;
        LabelTypeString   .Caption := TypeString;
        LabelVersionInt   .Caption := IntToStr( VersionInt);
        LabelInfoString   .Caption := InfoString;
      End;
    End;

    Procedure   TFormMain.LoadPatchFile( Const aFileName: String);
    Begin
      FPatchData.LoadPatch( aFileName);
      ShowFileInfo;
    End;

    Procedure   TFormMain.SaveMidiFile( Const aFileName: String);
    Begin
      FPatchData.SaveMidi( aFileName);
    End;

    Procedure   TFormMain.LoadMIDIFile( Const aFileName: String);
    Begin
      FPatchData.LoadMIDI( aFileName);
      ShowFileInfo;
    End;

    Procedure   TFormMain.SavePatchFile( Const aFileName: String);
    Begin
      FPatchData.SavePatch( aFileName);
      ShowFileInfo;
    End;

    
    (*
    Procedure   TFormMain.TestChecksum;

      Function CalcCheck( Const S : String): Integer;
      Var
        p : Integer;
        V : String;
      Begin
        Result := 0;
        p      := 0;
        V      := '';
        While p < Length( S) Do
        Begin
          Inc( p);
          Case S[ p] Of
            ' ' : Begin
                Inc( Result, StrToInt( '$' + V));
                V := '';
              End;
            '0' .. '9',
            'a' .. 'f',
            'A' .. 'F' :
              V := V + S[ p];
          End;
        End;
        If V <> ''
        Then Inc( Result, StrToInt( '$' + V));
      End;

    Var
      aFile : TextFile;
      S     : String;
      CS    : Integer;
    begin
      AssignFile( aFile, ApplicationPath + 'data.txt');
      Reset( aFile);
      Try
        CS := 0;
        While Not Eof( aFile) Do
        Begin
          ReadLn( aFile, S);
          CS := CS + CalcCheck( S);
        End;
      Finally
        CloseFile( aFile);
      End;
      LabelCheckSum.Caption := Format( '%.2x', [ CS And $7f]);
    End;
    *)

// Delphi area


procedure TFormMain.BitBtnLoadpatchClick(Sender: TObject);
begin
  With OpenDialog Do
  Begin
    Filter := 'patches and performances (*.pch2 *.prf2)|*.pch2;*.prf2';
    Title := 'Open a G2 patch or performance';
    If Execute
    Then Begin
      LoadPatchFile( FileName);
    End;
  End;
end;

procedure TFormMain.FormCreate(Sender: TObject);
begin
  FPatchData := TPatchData.Create;
end;

procedure TFormMain.FormDestroy(Sender: TObject);
begin
  FreeAndNil( FPatchData);
end;

procedure TFormMain.BitBtnSaveMIDIClick(Sender: TObject);
begin
  With SaveDialog Do
  Begin
    Filter := 'bin files (*.bin)|*.bin';
    Title  := 'Save G2 MIDI file';
    If Execute
    Then Begin
      SaveMidiFile( FileName);
    End;
  End;
end;

procedure TFormMain.FormKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  If Shift = [ ssAlt]
  Then Begin
    Case Char( Key) Of
      'X' : Close;
    End;
  End;
end;

procedure TFormMain.BitBtnLoadMIDIClick(Sender: TObject);
begin
  With OpenDialog Do
  Begin
    Filter := 'bin files (*.bin)|*.bin';
    Title  := 'Open G2 MIDI file';
    If Execute
    Then Begin
      LoadMidiFile( FileName);
    End;
  End;
end;

procedure TFormMain.BitBtnSavePatchClick(Sender: TObject);
Var
  FName : String;
begin
  With SaveDialog Do
  Begin
    With FPatchData Do
    Begin
      DefaultExt := FileExtension;
      FName      := FileName;
      Case PatchDataType Of
        pdtPatch       : Begin
            Filter := 'patches (*.pch2)|*.pch2';
            Title  := 'Save a G2 patch';
          End;
        pdtPerformance : Begin
            Filter := 'performances (*.prf2)|*.prf2';
            Title  := 'Save a G2 performance';
          End;
        Else
          Raise Exception.Create( 'Invalid patch data, can''t save it.');
      End;
    End;
    FileName := FName + DefaultExt;
    If Execute
    Then Begin
      SavePatchFile( FileName);
    End;
  End;
end;

end.
