`timescale 1ns / 1ps
//////////////////////////////////////////////////////////////////////////////////
// Company: 
// Engineer: Scott Gravenhorst  
// 
// Create Date:    13:27:55 03/03/2009 
// Design Name:    expogen
// Module Name:    expogen 
// Project Name: 
// Target Devices: 
// Tool versions: 
// Description: Exponential curve generator
//
// Dependencies: 
//
// Revision: 
// Revision 0.01 - File Created
// Additional Comments:
//    This design is a modified single pole IIR filter performing as follows:
//    It is triggered by using the init line with ena to initialize the IIR Z1 memory with
//    an input value, all other cycles are then completed with the a zero at the input.
//    This allows the computation to take place with only one multiplier since the a0 
//    value is always zero for all but the first computation.  The first computation
//    simply forces the initialization input value to the output.
//
//////////////////////////////////////////////////////////////////////////////////
module expogen( clk, init, ena, sel, DEL, I, O );

input clk;
input [31:0] init;
input ena;
input [4:0] sel;                      // 32 generators
input signed [17:0] DEL;              // Delay - the higher this is, the longer the time constant
input signed [17:0] I;
output signed [17:0] O;

wire clk;                             // system clock
wire [31:0] init;                     // initialize signal, ena high with init high causes initialization
wire ena;                             // enables one computation
wire [4:0] sel;                       // selects one exponential curve generator
wire signed [17:0] DEL;               // Bandwidth
wire signed [17:0] I;                 // initialization  value;  Magnitude determines output level
wire signed [17:0] O;                 // curve output for selected generator

reg signed [34:0] Z1ram [31:0];       // RAM for Z1 element

assign O = Z1ram[sel][34:17];         // output is always selected Z1 RAM location.

wire signed [31:0] DELsext;
wire signed [31:0] sum;
wire signed [66:0] P;

assign DELsext = {{14{DEL[17]}},DEL};          // sign extend DEL
assign sum = (DELsext << 3) + 32'sh7FF00000;   // force the delay into the upper range
assign P = Z1ram[sel] * sum ;

wire [34:0] Z1ram_new_data;

assign Z1ram_new_data = ( init[sel] ) ? {I,18'h00000} : (P >>> 31) ;

// if init is high at ena, push I into Z1, otherwise push computation into Z1
always @ ( posedge clk ) 
  begin
  if ( ena ) Z1ram[sel] <= Z1ram_new_data;
  end

endmodule
