/*
   PICsynth * API/HAL Layer *

   Version 0.4

   Eric Boger (2008)
*/


/*

   Added OSCTUNE vibrato. yerpa58 12 JUL 2009
   Added RUNSTEP & EDITLOCK. yerpa58 12 JUN 2010

*/

int8  API_AUDIOOUT = 0x7f;
int8  API_POT[8];

static int8  toggle_lo;
static int8  toggle_hi;
static int8  softime;
static int8  sample;
       int1  VIBRATON = FALSE;
       int1  RUNSTEP;
       int1  EDITLOCK;
static int8  vibrat;
static int8  vibrat2;
static int8  vtime;
static int8  vspeed;
static int16 regptr;

        void API_Init (void);
#inline void API_Task (void);

extern  void load_buf1(int8);
extern  int8 unload_buf1(void);

void API_Init(void)
{

   //            76543210
   set_tris_a (0b11111111);
   set_tris_b (0b00111111);
   set_tris_c (0b10100000);
   set_tris_d (0b00000000);
   set_tris_e (0b11111111);

   // ADC
   setup_adc_ports(AN0_TO_AN7 | VSS_VDD);
   setup_adc(ADC_CLOCK_DIV_32); // div_64
   set_adc_channel(0);
   read_adc(ADC_START_ONLY);

   // PWM
   setup_ccp1   (CCP_PWM);
   setup_timer_2(T2_DIV_BY_1, 255, 1);
   set_pwm1_duty (0x7f);

}


#inline
void API_Task(void)
{
   static int8 channel=0;
          int8 *regptr;

   // audio output
   set_pwm1_duty(API_AUDIOOUT);

   // read ADC
   if (!bit_test(*ADCON0,1)) // ADC finished?
   {
      bit_set(*ADCON0,1);
      API_POT[channel]=read_adc(ADC_READ_ONLY);

      channel++;
      if (channel>7) channel=0;
      set_adc_channel(channel);

      read_adc(ADC_START_ONLY);
   }

      // select vibrato?
      if (input(_PIN_GATE)) VIBRATON = FALSE;
      else VIBRATON = TRUE;
      vspeed = API_POT[7];
      vspeed &= 0xfc;

      // Read RUN/STEP switch...

      if (input(_PIN_RUN_STEP)) RUNSTEP = FALSE;
      else RUNSTEP = TRUE;

      // Read EDIT/LOCK switch...

      if (input(_PIN_EDIT_LOCK)) EDITLOCK = TRUE;
      else EDITLOCK = FALSE;

   // Vibrato
       vtime++;
       if ((vtime == vspeed)&&(VIBRATON==TRUE))
       {
         vtime=0;
         regptr = 0xf9b;
         vibrat2 = *regptr;
         vibrat2 &= 0xc0;
         vibrat++;
         vibrat &= 0x3f;
         vibrat2 |= vibrat;
         *regptr = vibrat2;
       }
}

