/*
   One dimensional Cellular Automata Synthesizer
                  
   Version 0.4  
               
   Eric Boger (2008)                      
*/           

//                                                    
// global variables  
// 

// "API" Potentiometer 0..7 values
// int8 API_POT[8];

// Param1 = 
// Param2 = 
// Param3 = 
// Param4 = 
// Param5 = 
// Param6 = 


#define CA_MAXCELLS 34

int8  CA_out       = 0;
int8  CA_tonecnt   = 1;
int8  CA_tonerate  = 0;       
int8  CA_CELL[CA_MAXCELLS+1][2];
         
         
void DSP_CA_Init(void)                          
{                   
   int8 i;
   
   for (i=0; i<CA_MAXCELLS; i++)
   {                
      CA_CELL[i][0] = 0;
      CA_CELL[i][1] = 0;
      restart_wdt();
   }
   CA_CELL[17][0] = 1;
}                                  
   
                                            
void DSP_CA_Do (void)
{                     
   static int16 caclock=1;
   static int1  swapnewold = FALSE;

   int8 rule;
   int8 iterations;
   int8 cell_hi, cell_lo;

   int8 c;
   int8 i;
   int8 state;
   int8 old, new;
      
   caclock--;
   if (caclock!=0) return; 
   
   caclock=(~API_POT[_POT_PARAM1])>>1;
   caclock=caclock<<8;
   caclock=caclock+0xff;
  
   // do cellular automata   
   
   rule       = API_POT[_POT_PARAM2];             // rule       0..255
   cell_hi    = 18 + (API_POT[_POT_PARAM3]>>4);   // cell width 1..32
   cell_lo    = 16 - (API_POT[_POT_PARAM3]>>4);   // cell width 1..32
   iterations = API_POT[_POT_PARAM4]>>4;          // iterations 1..16
   iterations++;
   
   for(i=0;i<iterations;i++)
   {          
      if (swapnewold) { old = 1; new = 0; swapnewold = FALSE; }
      else            { old = 0; new = 1; swapnewold = TRUE;  }
      
      for(c=0;c<34;c++)
      {
         if ((c > cell_lo) && (c < cell_hi))
         {           
            state = 0;
            if (CA_CELL[c-1][old] != 0) state += 1;
            if (CA_CELL[c]  [old] != 0) state += 2;
            if (CA_CELL[c+1][old] != 0) state += 4;
      
            if (bit_test(rule,state))
            {
               state = CA_CELL[c][old];
               state++;
               state = state %16;
               state++;
               CA_tonerate = _mul(CA_tonerate,state);
               CA_CELL[c][new] = state;
            }
            else
            {
               CA_CELL[c][new] = 0;
            }   
         }
         else
         {
            CA_CELL[c][new] = 0;
         }
      }
      
      CA_tonerate++;
   
   }
 
}

 
int8 DSP_CA_Alg_1 (void)
{           
   // generate tone
   CA_tonecnt--;
   if (CA_tonecnt == 0)
   {                                              
      CA_tonecnt = CA_tonerate;               
      CA_out = ~CA_out;
   }

   return CA_out;
}
    
    

                        
                    
