/*
   Simple Sequencer / FM-Synthesizer

   Version 0.4

   Eric Boger (2008)

   ------

   I added/changed/commented out a couple of lines to change the operation of the EnvAcnt and EnvBcnt volume
   and modulation envelopes.

   yerpa58 (2009)

   ------

   13 June 2010:

   Added toggle switch functions RUN/STEP and EDIT/LOCK.  Made arrays for all the paramenters so that each note
   can have it's own set of parameters.  Expanded from 8 to 16 steps. Added save to EEPROM when going from EDIT
   to LOCK.

   The way I do two-value flags is like this: value=0 means 1st word is true, such as RUNSTEP = RUN.
   If value = 1, then the 2nd word is true, ie. RUNSTEP = STEP.

*/

//
// global variables
//

// "API" Potentiometer 0..7 values:
// int8 API_POT[8];

// RUN/STEP = STEP:

// Pot 0 = synth mode
// Pot 1 = speed
// Pot 2 (Param1) = step number
// Pot 3 (Param2) = OSC-A base
// Pot 4 (Param3) = DCA envelope decay
// Pot 5 (Param4) = FM envelope decay
// Pot 6 (Param5) = OSC-B pitch
// Pot 7 (Param6) = OSC-A offset


   int8  SEQ_out     = 0x7f;
   int8  SEQ_step    = 0;
   int1  SEQ_trigger = FALSE;
   int8  SEQ_clockdiv = 0x7f;

   int8   Xval[16];
   int8   XoscA[16];
   int8   XoscArate[16];
   int8   XoscB[16];
   int8   XoscBrate[16];
   int8   XenvAcnt[16];
   int8   XenvBcnt[16];

   int16  EnvMaster;

   int1   editflag;
   int1   vibflag;

   static int8  oscA     = 0;
   static int8  oscArate = 1;
   static int8  oscB     = 0;
   static int8  oscBrate = 1;
   static int8  envA     = 0xff;
   static int16  envAcnt  = 1;
   static int8  envB     = 0xff;
   static int8  envBcnt  = 1;

void DSP_SEQ_Init (void)
{
   int8 i;
   int8 k;
   int8 tmp;

   SEQ_out     = 0x7f;
   SEQ_step    = 0;
   SEQ_trigger = FALSE;
   SEQ_clockdiv = 0x7f;
   editflag = FALSE;
   vibflag = FALSE;
   EnvMaster = 0xffff;

   k = 0;
   for (i=0;i<16;i++)
   {
      tmp = read_eeprom(k++);
      Xval[i] = tmp;

      tmp = read_eeprom(k++);
      XoscA[i] = tmp;

      tmp = read_eeprom(k++);
      XoscArate[i] = tmp;

      tmp = read_eeprom(k++);
      XoscB[i] = tmp;

      tmp = read_eeprom(k++);
      XoscBrate[i] = tmp;

      tmp = read_eeprom(k++);
      XenvAcnt[i] = tmp;

      tmp = read_eeprom(k++);
      XenvBcnt[i] = tmp;
   }
}


// This subroutine saves the sequencer data in eeprom...

void seq_save(void)
{
   int8 i;
   int8 k;
   int8 tmp;

   k=0;
   for (i=0; i<16; i++)
   {
      tmp=Xval[i];
      write_eeprom( k++, tmp );

      tmp=XoscA[i];
      write_eeprom( k++, tmp );

      tmp=XoscArate[i];
      write_eeprom( k++, tmp );

      tmp=XoscB[i];
      write_eeprom( k++, tmp );

      tmp=XoscBrate[i];
      write_eeprom( k++, tmp );

      tmp=XenvAcnt[i];
      write_eeprom( k++, tmp );

      tmp=XenvBcnt[i];
      write_eeprom( k++, tmp );
   }
}


// This subroutine is called when the sequencer is in the "RUN" mode...

int8 DSP_SEQ_Alg_1 (int1 reverse)
{
//   static int8  oscA     = 0;
//   static int8  oscArate = 1;
//   static int8  oscB     = 0;
//   static int8  oscBrate = 1;
//   static int8  envA     = 0xff;
//   static int16  envAcnt  = 1;
//   static int8  envB     = 0xff;
//   static int8  envBcnt  = 1;

   int16 temp;
   int8  tmp8;

   // sequence value 0 = mute step
   if (Xval[SEQ_step] == 0xff) return 0x7f;

   // oscillator A
   oscArate--;
   if (oscArate == 0)
   {
      if (!EDITLOCK)
      {
        tmp8 = (~API_POT[_POT_PARAM6]) >> 1;
        XoscArate[SEQ_step] = tmp8;
      }
      oscArate  = Xval[SEQ_step] >> 1;
      oscArate += XoscArate[SEQ_step];

      if (oscArate == 0) oscArate = 1;
      oscA = ~oscA;
   }

   // oscillator B
   oscBrate--;
   if (oscBrate == 0)
   {
      if (!EDITLOCK)
      {
        tmp8 = ~API_POT[_POT_PARAM5];
        XoscBrate[SEQ_step] = tmp8;
      }
      oscBrate  = Xval[SEQ_step] >> 1;
      oscBrate += XoscBrate[SEQ_step];

      //if (API_POT[_POT_PARAM4] != 0)
      if (XenvBcnt[SEQ_step] != 0);
      {
         if (oscBrate > envB) oscBrate -= envB;
      }

      if (oscBrate == 0) oscBrate=1;
      oscB = ~oscB;
   }

   // volume envelope (VCA)
   if (EnvMaster) EnvMaster--;
   if (!EnvMaster) envAcnt--;
   if (envAcnt == 0)
   {
      if (!EDITLOCK)
      {
        EnvMaster = 0;
        tmp8  = API_POT[_POT_PARAM3] >> 1;
        XenvAcnt[SEQ_step] = tmp8;
      }
      envAcnt  = XenvAcnt[SEQ_step];
      envAcnt += 32;
      if (envA > 4) envA -= 4;
      if (envA <= 4) envA = 0;
   }

   // modulation envelope
   envBcnt--;
   if (envBcnt == 0)
   {
      if (!EDITLOCK)
      {
        tmp8 = API_POT[_POT_PARAM4]>>1;
        XenvBcnt[SEQ_step] = tmp8;
      }
      envBcnt  = XenvBcnt[SEQ_step];
      if (envB >= 1) envB -= 1;
   }

   // next sequence step triggered -> retrigger envelope A & B
   if (SEQ_trigger)
   {
      envA = 0xff;
      envB = 0xff;
      SEQ_trigger = FALSE;
   }

   // FM modulation OSC_A * OSC_B
   temp = _mul(oscA,oscB);
   SEQ_out = temp >> 8;

   // Volume modulation (VCA)
   temp = _mul(SEQ_out,envA);
   SEQ_out = temp >> 8;

   return SEQ_out;
}


void DSP_SEQ_Do (int1 reverse)
{
   static int8 stepold  = 0xff;

   int8 val;

   // sequencer timer
   SEQ_clockdiv--;
   if (SEQ_clockdiv == 0)
   {
      SEQ_clockdiv = 0x7f;
      SEQ_trigger = TRUE;
   }

   // update sequence

   if (RUNSTEP) SEQ_step = API_POT[_POT_PARAM1] >> 4;

   if ((!RUNSTEP)&&(SEQ_trigger))
   {
     if (reverse)
     {
        SEQ_step--;
        if (SEQ_step > 15) SEQ_step = 15;
     }
     if (!reverse)
     {
        SEQ_step++;
        if (SEQ_step > 15) SEQ_step = 0;

     }

     if (VIBRATON != vibflag)  // If vibrato switch changed, force max envelopes for a short burst.
     {
       vibflag = VIBRATON;
       //reset_cpu();
       EnvMaster = 0xffff;     // This gives that power-up effect.
     }
   }

   if (!EDITLOCK)
   {
     val = ~API_POT[_POT_PARAM2];
     Xval[SEQ_step] = val;
     editflag = TRUE;
   }

   if (EDITLOCK)
   {
     if (editflag) seq_save();
     editflag = FALSE;
   }

   if (SEQ_step != stepold)
   {
      if (RUNSTEP) LED = LEDCHAR[SEQ_step] & 0x7f;      // show step number with dp when stepping.
      else LED = LEDCHAR[SEQ_step];                     // show step number without dp when running.
   }
   stepold = SEQ_step;

}

