/*********************************************************************************** 
 * Application Entry Point
 *
 *
 ***********************************************************************************/

#include "main.h" // Template Framework

// DSP
#include "Synth_Fraktal.h"
#include "Synth_MarsRadio.h"
#include "Synth_CA.h"
#include "Synth_SP0256.h"


int APP_STATE = 0;

enum APP_STATES {
	STATE_INIT = 0,
	STATE_MENU_MAIN,
	STATE_FRAKTALSYNTH,
	STATE_MARSRADIO,
	STATE_CA,
	STATE_SP0256,
};


GUI_Button  CFRAKTALSYNTH;
GUI_Button  CMARSRADIO;
GUI_Button  CCA;
GUI_Button  CSP0256;



/**********************************************************************************
 * Main Menu
 **********************************************************************************/
void APP_Menu_Main_Show (void) {
	screenClear(SCREEN_TOP);
	screenClear(SCREEN_BOTTOM);
	
	SetScreen(SCREEN_TOP);
		
	iprintf("\x1b[10;9HNOIZE TOYZ V0.1");
	iprintf("\x1b[12;8HEric Boger [2009]");

	SetScreen(SCREEN_BOTTOM);

	iprintf("\x1b[2;10HFraktal Synth");
	GUI_CreateButton(&CFRAKTALSYNTH, 10, (2<<3)-5, 235, 16, BLUE);

	iprintf("\x1b[5;12HMarsRadio");
	GUI_CreateButton(&CMARSRADIO, 	 10, (5<<3)-5, 235, 16, BLUE);

	iprintf("\x1b[8;8HCellular Automata");
	GUI_CreateButton(&CCA, 			 10, (8<<3)-5, 235, 16, BLUE);

	iprintf("\x1b[11;13HSP 0256");
	GUI_CreateButton(&CSP0256, 		 10, (11<<3)-5, 235, 16, BLUE);

/*
	iprintf("\x1b[14;13H");
	GUI_CreateButton(&C , 10, (14<<3)-5, 235, 16, BLUE);

	iprintf("\x1b[17;11H");
	GUI_CreateButton(&C , 10, (17<<3)-5, 235, 16, BLUE);

	iprintf("\x1b[20;14H");
	GUI_CreateButton(&C , 10, (20<<3)-5, 235, 16, BLUE);

 */
 
	APP_STATE = STATE_MENU_MAIN;		
}


bool APP_isStylusPressed (void) {
	while ((TOUCH.px!=0) && (TOUCH.py!=0)) {
 		touchRead(&TOUCH);  // update touch parameters
		swiWaitForVBlank(); // wait until next frame 
	}
	return false;
}


void APP_Menu_Main_Task (void) {
	static int randomseed = 0;
	srand(randomseed++);

	if (GUI_CheckButton(&CFRAKTALSYNTH)) { 
		if (APP_isStylusPressed()) return;
		GUI_SetButton(&CFRAKTALSYNTH,false);
		if (!FraktalSynth_Init()) return; 
		APP_STATE = STATE_FRAKTALSYNTH;
		return;
	}
	if (GUI_CheckButton(&CMARSRADIO)) { 
		if (APP_isStylusPressed()) return;
		GUI_SetButton(&CMARSRADIO,false);
		if (!MarsRadio_Init()) return; 
		APP_STATE = STATE_MARSRADIO;
		return;
	}
	if (GUI_CheckButton(&CCA)) {
		if (APP_isStylusPressed()) return;
 		GUI_SetButton(&CCA,false);
		if (!CA_Init()) return; 
		APP_STATE = STATE_CA;
		return;
	}
	if (GUI_CheckButton(&CSP0256)) { 
		if (APP_isStylusPressed()) return;
		GUI_SetButton(&CSP0256,false);
		if (!SP0256_Init()) return; 
		APP_STATE = STATE_SP0256;
		return;
	}
	/*
	if (GUI_CheckButton(&C)) { 
		if (APP_isStylusPressed()) return;
		GUI_SetButton(&C,false);
		//if (!_Init()) return; 
		APP_STATE = STATE_;
		return;
	}
	if (GUI_CheckButton(&C)) { 
		if (APP_isStylusPressed()) return;
		GUI_SetButton(&C,false);
		//if (!_Init()) return; 
		APP_STATE = STATE_;
		return;
	}
	*/
	
}


/**********************************************************************************
 * Init Audio Stream
 **********************************************************************************/
void APP_InitAudioStream (void) {
	mm_ds_system mm_sys;
	mm_sys.mod_count 		= 0;
	mm_sys.samp_count		= 0;
	mm_sys.mem_bank			= 0;
	mm_sys.fifo_channel		= FIFO_MAXMOD;
	mmInit( &mm_sys );

	mm_stream mmstream;
	mmstream.sampling_rate	= AUDIO_STREAM_SAMPLERATE;	// sampling rate (Hz)
	mmstream.buffer_length	= AUDIO_STREAM_BUFFERSIZE;	// buffer length (samples)
	mmstream.callback		= Event_Stream_Request;		// set callback function
	mmstream.format			= MM_STREAM_8BIT_MONO;		// format 8/16-bit mono/stereo 
	mmstream.timer			= MM_TIMER0;				// use hardware timer 0
	mmstream.manual			= 0;					    // use manual filling (0=auto)
	mmStreamOpen( &mmstream );	
}



/**********************************************************************************
 * Init Application
 **********************************************************************************/
void APP_Init (void) {
	
	screenClear(SCREEN_TOP);
	screenClear(SCREEN_BOTTOM);
	
	SetScreen(SCREEN_TOP);
		
	// top screen text

	SetScreen(SCREEN_BOTTOM);
	
	// bottom screen text

	DSP_Init();

	APP_InitAudioStream();

	APP_Menu_Main_Show();

}


/**********************************************************************************
 * Application Task
 **********************************************************************************/
void APP_Task (void) {
	bool runtask = true;
	
	if (keysDown() == KEY_SELECT) {
		runtask = false; // go back to main menu, close running task
	}

	switch (APP_STATE)
	{
		case STATE_MENU_MAIN:		APP_Menu_Main_Task(); 		break;
		case STATE_FRAKTALSYNTH: 	FraktalSynth_Task(runtask);	break;
		case STATE_MARSRADIO:		MarsRadio_Task(runtask);	break;
		case STATE_CA:				CA_Task(runtask);			break;
		case STATE_SP0256:			SP0256_Task(runtask);		break;
		
		default: runtask = false; // something went wrong, undefined state -> main menu 
	}

	if (!runtask) APP_Menu_Main_Show();

}



/***********************************************************************************
 * Event_Stream_Request
 *
 * Audio stream data request handler.
 ***********************************************************************************/
void Event_Stream_Request (mm_word length, mm_addr dest, mm_stream_formats format) {	
	s8 *target = (s8*)dest;
	s8 sample;
	
	for( ; length; length-- )
	{
		// Call DSP
		switch (APP_STATE) {
			case STATE_FRAKTALSYNTH: 	sample = DSP_FraktalSynth();	break;
			case STATE_MARSRADIO:		sample = DSP_MarsRadio();		break;
			case STATE_CA:				sample = DSP_CA();				break;
			case STATE_SP0256:			sample = DSP_SP0256();			break;
			default:					sample = 0; 					break;
		}
		
		// Output sample 
		*target++ = sample;
		//*target++ = sample; // stereo mode
	}
	
}

