#include "main.h"



int	Filter_MUL = 0;


//
// Bit manipulations
//

bool parity32 (u32 data) {
	data ^= data >> 16;
	data ^= data >> 8;
	data ^= data >> 4;
	data &= 0xf;
	return (0x6996 >> data) & 1;
}

bool parity8 (u8 data) {
	data ^= data >> 4;
	data &= 0xf;
	return (0x96 >> data) & 1;
}


u32 binary2gray32 (u32 data) {
	return (data >> 1) ^ data;
}

u32 gray2binary32 (u32 data) {
	u32 temp;
	temp = data ^ (data >> 16);
	temp ^= (temp >> 8);
	temp ^= (temp >> 4);
	temp ^= (temp >> 2);
	temp ^= (temp >> 1);
	return temp;
}

u8  binary2gray8 (u8 data) {
	return (data >> 1) ^ data;
}

u8  gray2binary8 (u8 data) {
	u32 temp;
	temp = data ^ (data >> 4);
	temp ^= (temp >> 2);
	temp ^= (temp >> 1);
	return temp;
}


u32 rotate_right32 (u32 data, u32 bits) {
	u32 carry;
	while (bits-- != 0) {
		carry = data << 31; data >>= 1; data += carry;
	}
	return data;
}

u32 rotate_left32 (u32 data, u32 bits) {
	u32 carry;
	while (bits-- != 0) {
		carry = data >> 31; data <<= 1; data += carry;
	}
	return data;
}

u8  rotate_right8 (u8 data, u32 bits) {
	u8 carry;
	while (bits-- != 0) {
		carry = data << 7; data >>= 1; data += carry;
	}
	return data;
}

u8  rotate_left8 (u8 data, u32 bits) {
	u8 carry;
	while (bits-- != 0) {
		carry = data >> 7; data <<= 1; data += carry;
	}
	return data;
}


//
// Float calculation 
//
int quickfloat_ConvertFromInt (int i) {
    return (i<<16);
}

int quickfloat_ConvertFromFloat (float f) {
    return (int)(f*(1<<16));
}

int quickfloat_Multiply (int a, int b) {
    return (a>>8)*(b>>8);
}

int quickfloat_ConvertToInt (int i) {
    return (i>>16);
}



// Init DSP
void DSP_Init (void) {
		
	Filter_MUL = quickfloat_ConvertFromFloat(21.5332031f)/AUDIO_STREAM_SAMPLERATE; // Filter_12dB 

}


// Delay FX 
s8 DSP_Delay (s8 *delaybuffer, s8 input, int time, int feedback) {
	static int DELAYBUFFERCNT = 0;
	s8  output;
	s32 temp;

	// read operation
	output = delaybuffer[DELAYBUFFERCNT];  	
	// feedback
	temp = (output * feedback) >> 8;
	temp = (temp + input) >> 1;
	input = temp; 
	// write operation
	delaybuffer[DELAYBUFFERCNT++] = input;  
	// wrap ptr 
	if (DELAYBUFFERCNT >= time) DELAYBUFFERCNT -= time;   
	
	return output;
}



// 2nd Order Resonant MultiMode Filter 
// CutOff = 0..2048  Q = 0..0xEF
s8 DSP_Filter (s8 input, int cutoff, int q, int type) {
	static int lp=0, bp=0, hp=0; 	
	s32 output;
	
	// calc cutoff parameter
	cutoff *= Filter_MUL;
	
	// calc resonance (Q) parameter
	q = quickfloat_ConvertFromFloat(1.2f) - quickfloat_ConvertFromFloat(0.04f) * (q >> 3);
    q >>= 8;
	
	// calculate filter 
	hp =  quickfloat_ConvertFromInt(input << 4) - (bp>>8) * q - lp; 
	bp += quickfloat_Multiply(cutoff, hp); 
	lp += quickfloat_Multiply(cutoff, bp);
	
	// select filter output
	switch (type)
	{
		case FILTER_LP: output = quickfloat_ConvertToInt(lp) >> 5; // LowPass
				break;
		case FILTER_BP: output = quickfloat_ConvertToInt(bp) >> 5; // BandPass
				break;
		case FILTER_HP: output = quickfloat_ConvertToInt(hp) >> 5; // HighPass
				break;
		default: output = quickfloat_ConvertToInt(lp) >> 5; // LowPass
	}
	
	// overload protection / limiter
	if (output>  127) output =  127;
	if (output< -127) output = -127;
	
	return output; 
}


