/*********************************************************************************** 
 * Cellular Automata Synth V0.1
 *
 *
 ***********************************************************************************/

#include "main.h" // Template Framework
#include "Synth_CA.h"

int PARAM_CA_RULE = 30;


u32 CA_Do (u32 rule, u32 r, u32 seed) {
	static u32 genold = 0;
	static u32 seedlast = 0;
	u32 mask = (1 << (r+r+1)) - 1; // (2^x)-1 
	u32 index;
	u32 gennew = 0;
	u32 i;

	// inject new seed if seed has changed
	if (seedlast != seed) {
		genold = seed;
		seedlast = seed;
		return genold;
	}
	
	genold = rotate_left32(genold, r);
	for (i=0; i<32; i++) {
		index = genold & mask;
		gennew += (rule >> index) & 1;
		gennew <<= 1;
		genold = rotate_right32(genold, 1);
	}
	genold = rotate_left32(genold, r+1);

	genold = gennew;
	return gennew;
}



/**********************************************************************************
 * CA Init
 **********************************************************************************/
bool CA_Init (void) {
	static bool init = false;

	int x,y;
	u32 catemp;

	screenClear(SCREEN_TOP);
	screenClear(SCREEN_BOTTOM);
	
	SetScreen(SCREEN_TOP);
		
	iprintf("\x1b[1;6HCellular Automata V0.1");

	SetScreen(SCREEN_BOTTOM);

	CA_Do(0,0,0); // reinit CA
	for (y=0; y<190; y++)
	{
		catemp = CA_Do(PARAM_CA_RULE,1,1<<16);
		for (x=0; x<32; x++) {
			if ((catemp&1) == 1) setpixel(112+x,y,WHITE);
			else	             setpixel(112+x,y,BLACK);
			catemp >>= 1;
		}

	}


	// Default Values
	// if (init) return true; // don't set default values (already set)
	init = true;

	return true;
}


/**********************************************************************************
 * Close Task, free allocated memory
 **********************************************************************************/
void CA_Close (void) {
    
}


/**********************************************************************************
 * CA Task
 **********************************************************************************/
void CA_Task (bool runtask) {
	
	if (!runtask) { // close synth and free resources
		CA_Close();
		return;
	} 

	//
	// DEBUG Info
	//
	SetScreen(SCREEN_TOP);

	//iprintf("\x1b[22;20HTX=%2d  TY=%2d", TOUCH.px>>3, TOUCH.py>>3);
	//iprintf("\x1b[23;20HX=%3d  Y=%3d", TOUCH.px, TOUCH.py);
}


/***********************************************************************************
 * DSP Algorithm
 ***********************************************************************************/
s8 DSP_CA (void) {
	static int tmr = 1;
	static s8  sample = 0;
	
	if (tmr--!=0) return sample;
	tmr = 10;
	
	sample = (CA_Do(PARAM_CA_RULE,1,1<<16)>>8);
		
	return sample;
}