/*********************************************************************************** 
 * Fraktal Synth V0.1
 *
 *
 ***********************************************************************************/

#include "main.h" // Template Framework
#include "Synth_Fraktal.h"


int PARAM_FS_ALG = 0;
int PARAM_FS_PITCH;
int PARAM_FS_1;
int PARAM_FS_2;
int PARAM_FS_CODING = 0;

int PARAM_FS_CUTOFF;
int PARAM_FS_Q;
int PARAM_FS_TYPE = 0;

int PARAM_FS_TIME;
int PARAM_FS_FEEDBACK;
int PARAM_FS_DRYWET;

s8  DELAYBUFFER[0x10000];


GUI_Bitfield CFS_P1;
GUI_Bitfield CFS_P2;	
GUI_Slider   CFS_Pitch;

GUI_Slider   CFS_Cutoff;
GUI_Slider   CFS_Q;
GUI_Button   CFS_LP;
GUI_Button   CFS_HP;
GUI_Button   CFS_BP;

GUI_Slider   CFS_Time;
GUI_Slider   CFS_Feedback;
GUI_Slider   CFS_DryWet;

GUI_Button   CFS_ALG1;
GUI_Button   CFS_ALG2;
GUI_Button   CFS_ALG3;
GUI_Button   CFS_ALG4;

GUI_Button   CFS_RND;
GUI_Button   CFS_SWP;
GUI_Button   CFS_CODING;



void FraktalSynth_GUI_FilterButtons_Set (int filtertype) {
	GUI_SetButton(&CFS_LP,false);
	GUI_SetButton(&CFS_BP,false);
	GUI_SetButton(&CFS_HP,false);
	switch (filtertype)
	{
		case FILTER_LP: GUI_SetButton(&CFS_LP,true); break;
		case FILTER_BP: GUI_SetButton(&CFS_BP,true); break;
		case FILTER_HP: GUI_SetButton(&CFS_HP,true); break;
		default: GUI_SetButton(&CFS_LP,true); break;
	}
}

int FraktalSynth_GUI_FilterButtons_Check (void) {
	bool old;
	static int newfilter;
	old = GUI_GetButton(&CFS_LP);
	if (GUI_CheckButton(&CFS_LP) != old) { newfilter = FILTER_LP; FraktalSynth_GUI_FilterButtons_Set(newfilter); } 
	old = GUI_GetButton(&CFS_BP);
	if (GUI_CheckButton(&CFS_BP) != old) { newfilter = FILTER_BP; FraktalSynth_GUI_FilterButtons_Set(newfilter); }
	old = GUI_GetButton(&CFS_HP);
	if (GUI_CheckButton(&CFS_HP) != old) { newfilter = FILTER_HP; FraktalSynth_GUI_FilterButtons_Set(newfilter); }
	return newfilter;
}


void FraktalSynth_GUI_AlgButtons_Set (int Alg) {
	GUI_SetButton(&CFS_ALG1,false);
	GUI_SetButton(&CFS_ALG2,false);
	GUI_SetButton(&CFS_ALG3,false);
	GUI_SetButton(&CFS_ALG4,false);
	switch (Alg)
	{
		case 0:  GUI_SetButton(&CFS_ALG1,true); break;
		case 1:  GUI_SetButton(&CFS_ALG2,true); break;
		case 2:  GUI_SetButton(&CFS_ALG3,true); break;
		case 3:  GUI_SetButton(&CFS_ALG4,true); break;
		default: GUI_SetButton(&CFS_ALG1,true); break;
	}
}

int FraktalSynth_GUI_AlgButtons_Check (void) {
	bool old;
	static int newalg;
	old = GUI_GetButton(&CFS_ALG1);
	if (GUI_CheckButton(&CFS_ALG1) != old) { newalg = 0; FraktalSynth_GUI_AlgButtons_Set(newalg); } 
	old = GUI_GetButton(&CFS_ALG2);
	if (GUI_CheckButton(&CFS_ALG2) != old) { newalg = 1; FraktalSynth_GUI_AlgButtons_Set(newalg); }
	old = GUI_GetButton(&CFS_ALG3);
	if (GUI_CheckButton(&CFS_ALG3) != old) { newalg = 2; FraktalSynth_GUI_AlgButtons_Set(newalg); }
	old = GUI_GetButton(&CFS_ALG4);
	if (GUI_CheckButton(&CFS_ALG4) != old) { newalg = 3; FraktalSynth_GUI_AlgButtons_Set(newalg); }
	return newalg;
}


void FraktalSynth_GUI_ParamRND (void) {
	PARAM_FS_1 = rand() % 255;
	PARAM_FS_2 = rand() % 255;
	GUI_SetBitfield(&CFS_P1,PARAM_FS_1);
	GUI_SetBitfield(&CFS_P2,PARAM_FS_2);
}

void FraktalSynth_GUI_ParamSWP (void) {
	int temp;
	temp = PARAM_FS_1;
	PARAM_FS_1 = PARAM_FS_2;
	PARAM_FS_2 = temp;
	GUI_SetBitfield(&CFS_P1,PARAM_FS_1);
	GUI_SetBitfield(&CFS_P2,PARAM_FS_2);
}


/**********************************************************************************
 * FraktalSynth Init
 **********************************************************************************/
bool FraktalSynth_Init (void) {
	static bool init = false;

	screenClear(SCREEN_TOP);
	screenClear(SCREEN_BOTTOM);
	
	SetScreen(SCREEN_TOP);
		
	iprintf("\x1b[1;7HFraktal Synth V0.1");

	SetScreen(SCREEN_BOTTOM);
	
	// Setup Synth GUI
	iprintf("\x1b[0;1HFraktal Synth:");
	iprintf("\x1b[6;18HPitch");
	GUI_CreateBitfield(&CFS_P1,8,13,16,12,BLUE); 
	GUI_CreateBitfield(&CFS_P2,8,29,16,12,BLUE);
	GUI_CreateSliderBarH(&CFS_Pitch,8,45,128,12,BLUE);
		
	// Setup Filter GUI
	iprintf("\x1b[8;1HFilter:");
	iprintf("\x1b[10;18HCutOff");
	iprintf("\x1b[12;18HQ");
	iprintf("\x1b[8;9HLP BP HP");
	GUI_CreateSliderBarH(&CFS_Cutoff,8,77,128,12,BLUE);
	GUI_CreateSliderBarH(&CFS_Q,     8,93,128,12,BLUE);
	GUI_CreateButton(&CFS_LP, (9<<3)-4,  62, 21, 10, BLUE);
	GUI_CreateButton(&CFS_BP, (12<<3)-4, 62, 21, 10, BLUE);
	GUI_CreateButton(&CFS_HP, (15<<3)-4, 62, 21, 10, BLUE);
   
	// Setup Delay GUI
	iprintf("\x1b[14;1HDelay FX:");
	iprintf("\x1b[16;18HTime");
	iprintf("\x1b[18;18HFeedBack");
	iprintf("\x1b[20;18HDry/Wet");
	GUI_CreateSliderBarH(&CFS_Time    ,8,125,128,12,BLUE);
	GUI_CreateSliderBarH(&CFS_Feedback,8,141,128,12,BLUE);
	GUI_CreateSliderBarH(&CFS_DryWet  ,8,157,128,12,BLUE);

	// Setup Algorithm Selection Buttons
	iprintf("\x1b[23;1HALG 1");
	iprintf("\x1b[23;9HALG 2");
	iprintf("\x1b[23;17HALG 3");
	iprintf("\x1b[23;25HALG 4");
	GUI_CreateButton(&CFS_ALG1, 0,     180, (8<<3)-2, 10, BLUE);
	GUI_CreateButton(&CFS_ALG2, 8<<3,  180, (8<<3)-2, 10, BLUE);
	GUI_CreateButton(&CFS_ALG3, 16<<3, 180, (8<<3)-2, 10, BLUE);
	GUI_CreateButton(&CFS_ALG4, 24<<3, 180, (8<<3)-2, 10, BLUE);

	// Parameter Mod Buttons
	iprintf("\x1b[2;19HRND");
	GUI_CreateButton(&CFS_RND, 18<<3, 13, (5<<3)-2, 12, BLUE);
	iprintf("\x1b[4;19HSWP");
	GUI_CreateButton(&CFS_SWP, 18<<3, 29, (5<<3)-2, 12, BLUE);
	iprintf("\x1b[2;25HGRY");
	GUI_CreateButton(&CFS_CODING, 24<<3, 13, (5<<3)-2, 12, BLUE);

		
	// Default Values
	FraktalSynth_GUI_FilterButtons_Set(FILTER_LP);
	FraktalSynth_GUI_AlgButtons_Set(PARAM_FS_ALG);
	GUI_SetBitfield(&CFS_P1,0x1E);
	GUI_SetBitfield(&CFS_P2,0x12);
	GUI_SetSliderBarH(&CFS_Pitch,10<<3);
	GUI_SetSliderBarH(&CFS_Cutoff, 127);

	init = true;

	return true;
}


/**********************************************************************************
 * FraktalSynth Close Task, free allocated memory
 **********************************************************************************/
void FraktalSynth_Close (void) {
    
}


/**********************************************************************************
 * FraktalSynth Task
 **********************************************************************************/
void FraktalSynth_Task (bool runtask) {
	
	if (!runtask) { // close synth and free resources
		FraktalSynth_Close();
		return;
	} 
	
	SetScreen(SCREEN_BOTTOM);
	
	//
	// Check Fraktal Synth Parameter 
	//
	PARAM_FS_1 = GUI_CheckBitfield(&CFS_P1);
	PARAM_FS_2 = GUI_CheckBitfield(&CFS_P2);
	
	if (keysDown() == KEY_DOWN) {
		PARAM_FS_PITCH++;
		PARAM_FS_PITCH &= 0x0F;
		GUI_SetSliderBarH(&CFS_Pitch, PARAM_FS_PITCH << 3);
	}
	if (keysDown() == KEY_UP) {
		PARAM_FS_PITCH--;
		PARAM_FS_PITCH &= 0x0F;
		GUI_SetSliderBarH(&CFS_Pitch, PARAM_FS_PITCH << 3);
	}
	PARAM_FS_PITCH = GUI_CheckSliderBarH(&CFS_Pitch) >> 3;
	
	//
	// Check LowPass Filter Parameter
	//
	PARAM_FS_CUTOFF = GUI_CheckSliderBarH(&CFS_Cutoff) << 1; 		
	PARAM_FS_Q      = GUI_CheckSliderBarH(&CFS_Q) << 1;
	PARAM_FS_CUTOFF <<= 2;                    // CutOff 0..2048
	if (PARAM_FS_Q > 0xEF) PARAM_FS_Q = 0xEF; // Q      0..0xEF 
	PARAM_FS_TYPE = FraktalSynth_GUI_FilterButtons_Check();
	
	//
	// Check Delay FX Parameter
	// 
	PARAM_FS_TIME     = (GUI_CheckSliderBarH(&CFS_Time) << 9) + 256;
	PARAM_FS_FEEDBACK = (GUI_CheckSliderBarH(&CFS_Feedback) << 1) +1;
	PARAM_FS_DRYWET   = GUI_CheckSliderBarH(&CFS_DryWet) << 1;
	
	//
	// Check Algorithm selection buttons
	//
	PARAM_FS_ALG = FraktalSynth_GUI_AlgButtons_Check();

	//
	// Algorithm Mod/Alter Buttons 
	//
	if (GUI_CheckButton(&CFS_RND)) {
		FraktalSynth_GUI_ParamRND();
		GUI_SetButton(&CFS_RND,false);
	}
	if (GUI_CheckButton(&CFS_SWP)) {
		FraktalSynth_GUI_ParamSWP();
		GUI_SetButton(&CFS_SWP,false);		
	}
	PARAM_FS_CODING = GUI_CheckButton(&CFS_CODING);

	//
	// DEBUG Info
	//
	SetScreen(SCREEN_TOP);

	iprintf("\x1b[6;8HAlgorithm = 0x%02X", PARAM_FS_ALG+1);				
	iprintf("\x1b[7;8HPitch     = 0x%02X", PARAM_FS_PITCH);				
	iprintf("\x1b[8;8HParam 1   = 0x%02X", PARAM_FS_1);
	iprintf("\x1b[9;8HParam 2   = 0x%02X", PARAM_FS_2);
	
	iprintf("\x1b[11;8HCutOff    = 0x%04X", PARAM_FS_CUTOFF);
	iprintf("\x1b[12;8HQ         = 0x%02X", PARAM_FS_Q);
	
	iprintf("\x1b[14;8HDLY Time  = 0x%04X", PARAM_FS_TIME);
	iprintf("\x1b[15;8HDLY FdBk  = 0x%02X", PARAM_FS_FEEDBACK);
	iprintf("\x1b[16;8HDLY D/W   = 0x%02X", PARAM_FS_DRYWET);

	//iprintf("\x1b[22;20HTX=%2d  TY=%2d", TOUCH.px>>3, TOUCH.py>>3);
	//iprintf("\x1b[23;20HX=%3d  Y=%3d", TOUCH.px, TOUCH.py);
}


/***********************************************************************************
 * DSP Algorithm
 ***********************************************************************************/
s8 DSP_FraktalSynth (void) {
	static u32 counter;
	static int ratecnt = 1;

	u32 cnt;

	s8  sample = 0;
	s8  delaysample = 0;
	s32 temp;
	
	// convert counter binary coding 
	switch (PARAM_FS_CODING) {
		case 0:  cnt = counter; 				break; // binary code
		case 1:  cnt = binary2gray32(counter); 	break; // gray code
		default: cnt = counter; // binary code
				 PARAM_FS_CODING = 0;
	}
	
	// calc synth sample
	switch (PARAM_FS_ALG)
	{
		case 0:
			sample = ((cnt>>8) & PARAM_FS_1) * (cnt&0xff) * PARAM_FS_2; 	// OK
			break;
		case 1:
			sample = ((cnt>>8) & PARAM_FS_1) * ((cnt&0xff) ^ PARAM_FS_2);	// OK		
			break;
		case 2:
			sample = ((cnt>>8) * PARAM_FS_1) * ((cnt&0xff) * PARAM_FS_2);	// OK / TODO!		
			break;
		case 3:
			sample = ((cnt>>8) & PARAM_FS_1) ^ ((cnt&0xff) ^ PARAM_FS_2);   // TODO!
			break;
		default:
			sample = 0;
			PARAM_FS_ALG = 0;
	}

	// pitch workaround, todo (fractional sample calculation)
	if (ratecnt-- == 0)
	{
		ratecnt = PARAM_FS_PITCH;
		counter++;
	}
	
	// calc 12dB LowPass filter
	sample = DSP_Filter (sample, PARAM_FS_CUTOFF, PARAM_FS_Q, PARAM_FS_TYPE);
	
	// calc delay fx sample
	delaysample = DSP_Delay (DELAYBUFFER, sample, PARAM_FS_TIME, PARAM_FS_FEEDBACK);
	
	// output mixer
	temp = (sample * (254-PARAM_FS_DRYWET)) >> 8;
	sample = temp;
	temp = (delaysample * (PARAM_FS_DRYWET)) >> 8;
	delaysample = temp;
	temp = (sample + delaysample);// >> 1; // mix dry/wet
	sample = temp;
	
	return sample;
}

