/*********************************************************************************** 
 * SP0256 Speech Synth V0.1
 *
 *
 ***********************************************************************************/

#include "main.h" // Template Framework
#include "Synth_SP0256.h"
#include "Synth_SP0256_Allophones.h" // Allophones Sample Data


u8  REG_SP[2];

int PARAM_SP_ALLOPHONE;
int PARAM_SP_PITCH;

GUI_PadXY CSP_PAD;


void SP0256_RegToParam (void) {
	PARAM_SP_ALLOPHONE = REG_SP[0];
	PARAM_SP_PITCH     = REG_SP[1];
}

void SP0256_ParamToReg (void) {
	REG_SP[0] = PARAM_SP_ALLOPHONE;
	REG_SP[1] = PARAM_SP_PITCH;
}


void SP0256_CheckGUI (void) {
	GUI_CheckPadXY(&CSP_PAD);
	PARAM_SP_PITCH = GUI_GetPadY(&CSP_PAD)>>4;
	PARAM_SP_ALLOPHONE = GUI_GetPadX(&CSP_PAD);
	if (PARAM_SP_ALLOPHONE > 0x3A) PARAM_SP_ALLOPHONE = 0x3A;
	if (PARAM_SP_PITCH == 0) PARAM_SP_PITCH = 1;

}


void SP0256_SetGUI (void) {
	
}

/**********************************************************************************
 * SP0256 Init
 **********************************************************************************/
bool SP0256_Init (void) {
	static bool init = false;

	screenClear(SCREEN_TOP);
	screenClear(SCREEN_BOTTOM);
	
	SetScreen(SCREEN_TOP);
		
	iprintf("\x1b[1;11HSP0256 V0.1");

	SetScreen(SCREEN_BOTTOM);

	GUI_CreatePadXY(&CSP_PAD,0,0,0x3A,128,BLUE);

	// Default Values
	// if (init) return true; // don't set default values (already set)
	init = true;

	return true;
}


/**********************************************************************************
 * SP0256 Close Task, free allocated memory
 **********************************************************************************/
void SP0256_Close (void) {
    
}


/**********************************************************************************
 * SP0256 Task
 **********************************************************************************/
void SP0256_Task (bool runtask) {
	
	if (!runtask) { // close synth and free resources
		SP0256_Close();
		return;
	} 

	SetScreen(SCREEN_BOTTOM);

	SP0256_CheckGUI();

	//
	// DEBUG Info
	//
	SetScreen(SCREEN_TOP);

	//iprintf("\x1b[22;20HTX=%2d  TY=%2d", TOUCH.px>>3, TOUCH.py>>3);
	//iprintf("\x1b[23;20HX=%3d  Y=%3d", TOUCH.px, TOUCH.py);
}


/***********************************************************************************
 * DSP Algorithm
 ***********************************************************************************/
s8 DSP_SP0256 (void) {
	static int sampleadr = 0;
	static s8  sample = 0;
	static int tmr = 1;
	u8 allophone;
	
	if ((TOUCH.px ==0) && (TOUCH.py ==0)) return 0;
	
	if (tmr-- != 0) return sample-0x80; // sample data is unsigned !
	tmr = PARAM_SP_PITCH;
	
	if (sample == 0) {
		allophone = PARAM_SP_ALLOPHONE+5; //(rand() % 0x3A) + 5;
		sampleadr = SP0256_ALLOPHONE_ADRESS[allophone];
	}
	
	sample = SP0256_ALLOPHONE_DATA[sampleadr++]; 


	return sample-0x80;// sample data is unsigned !
}