/*********************************************************************************** 
 * temp Synth V0.1
 *
 *
 ***********************************************************************************/

#include "main.h" // Template Framework
//#include "Synth_xxx.h"




/**********************************************************************************
 *  Init
 **********************************************************************************/
bool _Init (void) {
	static bool init = false;

	screenClear(SCREEN_TOP);
	screenClear(SCREEN_BOTTOM);
	
	SetScreen(SCREEN_TOP);
		
	iprintf("\x1b[1;7H V0.1");

	SetScreen(SCREEN_BOTTOM);


	// Default Values
	// if (init) return true; // don't set default values (already set)
	init = true;

	return true;
}


/**********************************************************************************
 * Close Task, free allocated memory
 **********************************************************************************/
void _Close (void) {
    
}


/**********************************************************************************
 *  Task
 **********************************************************************************/
void _Task (bool runtask) {
	
	if (!runtask) { // close synth and free resources
		_Close();
		return;
	} 


	//
	// DEBUG Info
	//
	SetScreen(SCREEN_TOP);

	iprintf("\x1b[22;20HTX=%2d  TY=%2d", TOUCH.px>>3, TOUCH.py>>3);
	iprintf("\x1b[23;20HX=%3d  Y=%3d", TOUCH.px, TOUCH.py);
}


/***********************************************************************************
 * DSP Algorithm
 ***********************************************************************************/
s8 DSP_ (void) {
	s8  sample = 0;

	return sample;
}