/*********************************************************************************** 
 * Graphic API Headerfile
 *
 * Toolchain: 
 * - DevKitPro Release 24 
 * - libnds 1.3.1
 ***********************************************************************************/

touchPosition TOUCH;

PrintConsole ConsoleTop;
PrintConsole ConsoleBottom;

u16 *RAM_BitmapTop;
u16 *RAM_BitmapBottom;

bool SCREEN;
#define SCREEN_TOP     false
#define SCREEN_BOTTOM  true

// colors
#define BLACK 	RGB15(0 , 0 , 0 )
#define WHITE 	RGB15(31, 31, 31)
#define GRAY 	RGB15(15, 15, 15)
#define RED 	RGB15(31, 0 , 0 )
#define GREEN 	RGB15(0 , 31, 0 )
#define BLUE 	RGB15(0 , 0 , 31)
#define YELLOW  RGB15(31, 31, 0 )


typedef struct { // GUI_Button
	int x;
	int y;
	int w;
	int h;
	bool value;
	bool lock;
	int color;
}GUI_Button;

typedef struct { // GUI_Slider
	int x;
	int y;
	int w;
	int h;
	int value;
	int color;
}GUI_Slider;

typedef struct { // GUI_PadXY
	int x;
	int y;
	int w;
	int h;
	int valueX;
	int valueY;
	int color;
}GUI_PadXY;

typedef struct { // GUI_Bitfield
	int x;
	int y;
	int w;
	int h;
	int value;
	bool lock;
	int color;
}GUI_Bitfield;



void GFX_Init(void);

void SetScreen (bool screen);
void backgroundClear (void);
void screenClear(bool screen);

void setpixel (int x, int y, int color);
void line (int x1, int y1, int x2, int y2, int color);
void lineh (int x, int y, int x2, int color);
void linev (int x, int y, int y2, int color);
void rect (int x1, int y1, int x2, int y2, int color);
void rectfill (int x1, int y1, int x2, int y2, int color, int colorfill);
void circle (int xCenter, int yCenter, int radius, int color);

void GUI_DrawButton (GUI_Button *buttondata);
void GUI_CreateButton (GUI_Button *buttondata, int x, int y, int w, int h, int color);
void GUI_SetButton (GUI_Button *buttondata, bool newvalue);
bool GUI_CheckButton (GUI_Button *buttondata);
bool GUI_GetButton (GUI_Button *buttondata);

void GUI_DrawSliderH (GUI_Slider *sliderdata);
void GUI_CreateSliderH (GUI_Slider *sliderdata, int x, int y, int w, int h, int color);
void GUI_SetSliderH (GUI_Slider *sliderdata, bool newvalue);
int  GUI_CheckSliderH (GUI_Slider *sliderdata);
int  GUI_GetSliderH (GUI_Slider *sliderdata);

void GUI_DrawSliderV (GUI_Slider *sliderdata);
void GUI_CreateSliderV (GUI_Slider *sliderdata, int x, int y, int w, int h, int color);
void GUI_SetSliderV (GUI_Slider *sliderdata, bool newvalue);
int  GUI_CheckSliderV (GUI_Slider *sliderdata);
int  GUI_GetSliderV (GUI_Slider *sliderdata);

void GUI_DrawSliderBarH (GUI_Slider *sliderdata);
void GUI_CreateSliderBarH (GUI_Slider *sliderdata, int x, int y, int w, int h, int color);
void GUI_SetSliderBarH (GUI_Slider *sliderdata, bool newvalue);
int  GUI_CheckSliderBarH (GUI_Slider *sliderdata);
int  GUI_GetSliderBarH (GUI_Slider *sliderdata);

void GUI_DrawSliderBarV (GUI_Slider *sliderdata);
void GUI_CreateSliderBarV (GUI_Slider *sliderdata, int x, int y, int w, int h, int color);
void GUI_SetSliderBarV (GUI_Slider *sliderdata, bool newvalue);
int  GUI_CheckSliderBarV (GUI_Slider *sliderdata);
int  GUI_GetSliderBarV (GUI_Slider *sliderdata);

void GUI_DrawPadXY (GUI_PadXY *padxydata);
void GUI_CreatePadXY (GUI_PadXY *padxydata, int x, int y, int w, int h, int color);
void GUI_SetPadXY (GUI_PadXY *padxydata, int newvalueX, int newvalueY);
void GUI_CheckPadXY (GUI_PadXY *padxydata);
int  GUI_GetPadX (GUI_PadXY *padxydata);
int  GUI_GetPadY (GUI_PadXY *padxydata);

void GUI_DrawBitfield (GUI_Bitfield *bitfielddata);
void GUI_CreateBitfield (GUI_Bitfield *bitfielddata, int x, int y, int w, int h, int color);
void GUI_SetBitfield (GUI_Bitfield *bitfielddata, bool newvalue);
int  GUI_CheckBitfield (GUI_Bitfield *bitfielddata);
int  GUI_GetBitfield (GUI_Bitfield *bitfielddata);



 

