// By Scott R. Gravenhorst (file generated by PitchWheel_ROM_2_semi_gen.c)
// Pitch Wheel ROM
//
// This ROM is addressed by the top 4 bits of the pitch wheel output.  The ROM
// output values are interpolated by the rest of the address to give a final output.
// The interpolator output then provides a value that is multplied by the phase
// increment value to give a final phase increment value to apply to the accumulator.

// HAND MODIFIED FROM 17 bits to 16 bits signed forced positive

module PW_ROM (ad, out_lo, out_hi);    // ad is the LUT address input

// original I/O :
//  input  [3:0]  ad;
//  output [16:0] out_lo;
//  output [16:0] out_hi;
//  wire   [3:0]  ad;
//  wire   [16:0] out_lo;
//  wire   [16:0] out_hi;

  input  [3:0]  ad;
  output [15:0] out_lo;
  output [15:0] out_hi;
  wire   [3:0]  ad;
  wire   [15:0] out_lo;
  wire   [15:0] out_hi;

  assign out_lo[15] = 0;       // force sign bits low
  assign out_hi[15] = 0;       // force sign bits low

// LOW ROM

//  LUT4 #(.INIT(16'b1110110000100111)) pwROMlo00 ( .O(out_lo[0]), .I0(ad[0]), .I1(ad[1]), .I2(ad[2]), .I3(ad[3]) );
//  LUT4 #(.INIT(16'b0000101000110000)) pwROMlo01 ( .O(out_lo[1]), .I0(ad[0]), .I1(ad[1]), .I2(ad[2]), .I3(ad[3]) );
  LUT4 #(.INIT(16'b1100000001011100)) pwROMlo02 ( .O(out_lo[0]), .I0(ad[0]), .I1(ad[1]), .I2(ad[2]), .I3(ad[3]) );
  LUT4 #(.INIT(16'b0010111010001000)) pwROMlo03 ( .O(out_lo[1]), .I0(ad[0]), .I1(ad[1]), .I2(ad[2]), .I3(ad[3]) );
  LUT4 #(.INIT(16'b0100111001010000)) pwROMlo04 ( .O(out_lo[2]), .I0(ad[0]), .I1(ad[1]), .I2(ad[2]), .I3(ad[3]) );
  LUT4 #(.INIT(16'b0010010010011111)) pwROMlo05 ( .O(out_lo[3]), .I0(ad[0]), .I1(ad[1]), .I2(ad[2]), .I3(ad[3]) );
  LUT4 #(.INIT(16'b1110001001001010)) pwROMlo06 ( .O(out_lo[4]), .I0(ad[0]), .I1(ad[1]), .I2(ad[2]), .I3(ad[3]) );
  LUT4 #(.INIT(16'b0001111000111001)) pwROMlo07 ( .O(out_lo[5]), .I0(ad[0]), .I1(ad[1]), .I2(ad[2]), .I3(ad[3]) );
  LUT4 #(.INIT(16'b1111111000000111)) pwROMlo08 ( .O(out_lo[6]), .I0(ad[0]), .I1(ad[1]), .I2(ad[2]), .I3(ad[3]) );
  LUT4 #(.INIT(16'b0101010010101010)) pwROMlo09 ( .O(out_lo[7]), .I0(ad[0]), .I1(ad[1]), .I2(ad[2]), .I3(ad[3]) );
  LUT4 #(.INIT(16'b1001100011001100)) pwROMlo0A ( .O(out_lo[8]), .I0(ad[0]), .I1(ad[1]), .I2(ad[2]), .I3(ad[3]) );
  LUT4 #(.INIT(16'b1110000011110000)) pwROMlo0B ( .O(out_lo[9]), .I0(ad[0]), .I1(ad[1]), .I2(ad[2]), .I3(ad[3]) );
  LUT4 #(.INIT(16'b0000000011111111)) pwROMlo0C ( .O(out_lo[10]), .I0(ad[0]), .I1(ad[1]), .I2(ad[2]), .I3(ad[3]) );
  LUT4 #(.INIT(16'b0000000011111111)) pwROMlo0D ( .O(out_lo[11]), .I0(ad[0]), .I1(ad[1]), .I2(ad[2]), .I3(ad[3]) );
  LUT4 #(.INIT(16'b0000000011111111)) pwROMlo0E ( .O(out_lo[12]), .I0(ad[0]), .I1(ad[1]), .I2(ad[2]), .I3(ad[3]) );
  LUT4 #(.INIT(16'b0000000011111111)) pwROMlo0F ( .O(out_lo[13]), .I0(ad[0]), .I1(ad[1]), .I2(ad[2]), .I3(ad[3]) );
  LUT4 #(.INIT(16'b1111111100000000)) pwROMlo10 ( .O(out_lo[14]), .I0(ad[0]), .I1(ad[1]), .I2(ad[2]), .I3(ad[3]) );

//  HIGH ROM

//  LUT4 #(.INIT(16'b0111011000010011)) pwROMhi00 ( .O(out_hi[0]), .I0(ad[0]), .I1(ad[1]), .I2(ad[2]), .I3(ad[3]) );
//  LUT4 #(.INIT(16'b0000010100011000)) pwROMhi01 ( .O(out_hi[1]), .I0(ad[0]), .I1(ad[1]), .I2(ad[2]), .I3(ad[3]) );
  LUT4 #(.INIT(16'b0110000000101110)) pwROMhi02 ( .O(out_hi[0]), .I0(ad[0]), .I1(ad[1]), .I2(ad[2]), .I3(ad[3]) );
  LUT4 #(.INIT(16'b1001011101000100)) pwROMhi03 ( .O(out_hi[1]), .I0(ad[0]), .I1(ad[1]), .I2(ad[2]), .I3(ad[3]) );
  LUT4 #(.INIT(16'b1010011100101000)) pwROMhi04 ( .O(out_hi[2]), .I0(ad[0]), .I1(ad[1]), .I2(ad[2]), .I3(ad[3]) );
  LUT4 #(.INIT(16'b1001001001001111)) pwROMhi05 ( .O(out_hi[3]), .I0(ad[0]), .I1(ad[1]), .I2(ad[2]), .I3(ad[3]) );
  LUT4 #(.INIT(16'b0111000100100101)) pwROMhi06 ( .O(out_hi[4]), .I0(ad[0]), .I1(ad[1]), .I2(ad[2]), .I3(ad[3]) );
  LUT4 #(.INIT(16'b0000111100011100)) pwROMhi07 ( .O(out_hi[5]), .I0(ad[0]), .I1(ad[1]), .I2(ad[2]), .I3(ad[3]) );
  LUT4 #(.INIT(16'b1111111100000011)) pwROMhi08 ( .O(out_hi[6]), .I0(ad[0]), .I1(ad[1]), .I2(ad[2]), .I3(ad[3]) );
  LUT4 #(.INIT(16'b1010101001010101)) pwROMhi09 ( .O(out_hi[7]), .I0(ad[0]), .I1(ad[1]), .I2(ad[2]), .I3(ad[3]) );
  LUT4 #(.INIT(16'b1100110001100110)) pwROMhi0A ( .O(out_hi[8]), .I0(ad[0]), .I1(ad[1]), .I2(ad[2]), .I3(ad[3]) );
  LUT4 #(.INIT(16'b1111000001111000)) pwROMhi0B ( .O(out_hi[9]), .I0(ad[0]), .I1(ad[1]), .I2(ad[2]), .I3(ad[3]) );
  LUT4 #(.INIT(16'b0000000001111111)) pwROMhi0C ( .O(out_hi[10]), .I0(ad[0]), .I1(ad[1]), .I2(ad[2]), .I3(ad[3]) );
  LUT4 #(.INIT(16'b0000000001111111)) pwROMhi0D ( .O(out_hi[11]), .I0(ad[0]), .I1(ad[1]), .I2(ad[2]), .I3(ad[3]) );
  LUT4 #(.INIT(16'b0000000001111111)) pwROMhi0E ( .O(out_hi[12]), .I0(ad[0]), .I1(ad[1]), .I2(ad[2]), .I3(ad[3]) );
  LUT4 #(.INIT(16'b0000000001111111)) pwROMhi0F ( .O(out_hi[13]), .I0(ad[0]), .I1(ad[1]), .I2(ad[2]), .I3(ad[3]) );
  LUT4 #(.INIT(16'b1111111110000000)) pwROMhi10 ( .O(out_hi[14]), .I0(ad[0]), .I1(ad[1]), .I2(ad[2]), .I3(ad[3]) );

endmodule
