// Engineer Scott Gravenhorst
// email: music.maker@gte.net
module sine_tab ( CLK, A, O );
  input         CLK;
  input  [9:0]  A;
  output [17:0] O;

  wire          CLK;
  wire   [9:0]  A;
  wire   [17:0] O;
  wire   [15:0] DOA;
  wire   [1:0]  DOPA;
  
  assign O = {DOPA,DOA};

// Sine/Cosine Lookup Table init data for DDS
// Auto-generated by mk_sc_lut_param.c
// Single port block RAM as ROM used because of Address range.
// Clocks are not used.

  RAMB16_S18_S18 sin (
                 .DOA ( DOA ),
                 .DOB (),
                 .DOPA ( DOPA ),
                 .DOPB (),
                 .ADDRA ( A ),
                 .ADDRB ( 10'h000 ),
                 .CLKA ( CLK ),
                 .CLKB ( 1'b0 ),
                 .DIA ( 16'h0000 ),
                 .DIB ( 16'h0000 ),
                 .DIPA ( 2'b00 ),
                 .DIPB ( 2'b00 ),
                 .ENA ( 1'b1 ),
                 .ENB ( 1'b0 ),
                 .SSRA ( 1'b0 ),
                 .SSRB ( 1'b0 ),
                 .WEA ( 1'b0 ),
                 .WEB ( 1'b0 )
                 );
					  
defparam sin.INIT_00 = 256'h0C2C0B630A9A09D10908083F077606AD05E4051B0452038902C001F7012E0065;
defparam sin.INIT_01 = 256'h18BB17F217291660159814CF1406133D127411AB10E210190F500E870DBE0CF5;
defparam sin.INIT_02 = 256'h2546247D23B522EC2224215B20921FCA1F011E381D701CA71BDE1B151A4D1984;
defparam sin.INIT_03 = 256'h31CB3103303B2F732EAA2DE22D1A2C522B892AC129F929302868279F26D7260E;
defparam sin.INIT_04 = 256'h3E493D813CBA3BF23B2A3A62399B38D3380B3743367B35B334EB3423335B3293;
defparam sin.INIT_05 = 256'h4ABD49F6492F486847A146DA4612454B448443BD42F5422E4167409F3FD83F10;
defparam sin.INIT_06 = 256'h5725565F559954D2540C5346527F51B950F2502C4F654E9F4DD84D114C4A4B84;
defparam sin.INIT_07 = 256'h638062BB61F66130606B5FA55EE05E1A5D545C8F5BC95B035A3D597758B157EB;
defparam sin.INIT_08 = 256'h6FCC6F076E436D7F6CBA6BF66B316A6D69A868E3681E6759669565CF650A6445;
defparam sin.INIT_09 = 256'h7C067B437A8079BD78F97836777276AF75EB7528746473A072DC721871547090;
defparam sin.INIT_0A = 256'h882D876C86AA85E88525846383A182DF821C815A80977FD57F127E4F7D8C7CC9;
defparam sin.INIT_0B = 256'h9440937F92BF91FE913D907C8FBB8EFA8E398D788CB78BF58B348A7289B188EF;
defparam sin.INIT_0C = 256'hA03B9F7C9EBD9DFE9D3F9C7F9BC09B009A40998198C198019741968195C09500;
defparam sin.INIT_0D = 256'hAC1EAB60AAA3A9E5A928A86AA7ACA6EEA630A571A4B3A3F5A336A278A1B9A0FA;
defparam sin.INIT_0E = 256'hB7E6B72AB66EB5B3B4F7B43AB37EB2C2B205B149B08CAFCFAF12AE55AD98ACDB;
defparam sin.INIT_0F = 256'hC392C2D8C21EC164C0AABFEFBF35BE7ABDC0BD05BC4ABB8FBAD4BA18B95DB8A2;
defparam sin.INIT_10 = 256'hCF1FCE68CDAFCCF7CC3FCB87CACECA15C95DC8A4C7EBC731C678C5BFC505C44C;
defparam sin.INIT_11 = 256'hDA8DD9D7D921D86BD7B5D6FED648D591D4DAD423D36CD2B5D1FED147D08FCFD7;
defparam sin.INIT_12 = 256'hE5D9E525E472E3BEE309E255E1A1E0ECE038DF83DECEDE19DD63DCAEDBF9DB43;
defparam sin.INIT_13 = 256'hF102F050EF9FEEEDEE3BED89ECD7EC24EB72EABFEA0DE95AE8A7E7F4E740E68D;
defparam sin.INIT_14 = 256'hFC05FB56FAA7F9F7F948F898F7E8F738F688F5D8F527F477F3C6F315F264F1B3;
defparam sin.INIT_15 = 256'h06E20635058804DB042E038102D40226017800CB001DFF6EFEC0FE12FD63FCB4;
defparam sin.INIT_16 = 256'h119610EC10410F970EED0E420D970CEC0C410B960AEA0A3E099308E7083A078E;
defparam sin.INIT_17 = 256'h1C201B781AD11A29198118D91831178916E01637158E14E5143C139312E91240;
defparam sin.INIT_18 = 256'h267E25D92534248F23EA234522A021FA215420AE20081F621EBB1E151D6E1CC7;
defparam sin.INIT_19 = 256'h30AE300C2F6B2EC92E262D842CE12C3F2B9C2AF82A5529B2290E286A27C62722;
defparam sin.INIT_1A = 256'h3AB03A11397238D33834379436F5365535B53515347433D43333329231F13150;
defparam sin.INIT_1B = 256'h448143E5434942AD4211417540D8403B3F9E3F013E643DC63D293C8B3BED3B4E;
defparam sin.INIT_1C = 256'h4E204D874CEF4C564BBD4B244A8A49F1495748BD4822478846ED465345B7451C;
defparam sin.INIT_1D = 256'h578B56F6566155CB5535549F5409537352DC524551AE511750804FE84F504EB8;
defparam sin.INIT_1E = 256'h60C260305F9E5F0C5E795DE75D545CC15C2D5B9A5B065A7259DE594A58B55820;
defparam sin.INIT_1F = 256'h69C2693468A56816678766F8666865D9654964B9642863986307627661E56154;
defparam sin.INIT_20 = 256'h728A7200717470E9705E6FD26F466EBA6E2D6DA16D146C876BF96B6C6ADE6A50;
defparam sin.INIT_21 = 256'h7B1A7A927A0B798378FB787377EB776276D9765075C7753D74B4742A739F7315;
defparam sin.INIT_22 = 256'h836E82EB826781E3815F80DA80567FD17F4B7EC67E407DBA7D347CAE7C277BA1;
defparam sin.INIT_23 = 256'h8B878B088A888A07898789068885880487828701867F85FD857A84F8847583F2;
defparam sin.INIT_24 = 256'h936392E8926B91EF917290F590788FFB8F7D8EFF8E818E038D848D058C868C07;
defparam sin.INIT_25 = 256'h9B019A899A119998992098A7982D97B4973A96C0964695CC955194D6945B93DF;
defparam sin.INIT_26 = 256'hA260A1ECA177A103A08EA0199FA49F2E9EB99E429DCC9D569CDF9C689BF19B79;
defparam sin.INIT_27 = 256'hA97EA90EA89DA82DA7BCA74BA6DAA669A5F7A585A513A4A0A42DA3BAA347A2D4;
defparam sin.INIT_28 = 256'hB05AAFEEAF82AF16AEA9AE3CADCFAD62ACF4AC86AC18ABAAAB3BAACCAA5DA9ED;
defparam sin.INIT_29 = 256'hB6F4B68CB624B5BCB554B4EBB482B419B3AFB345B2DBB271B207B19CB131B0C6;
defparam sin.INIT_2A = 256'hBD4ABCE6BC83BC1FBBBABB56BAF1BA8CBA27B9C2B95CB8F6B890B829B7C2B75B;
defparam sin.INIT_2B = 256'hC35BC2FCC29DC23DC1DDC17DC11DC0BCC05BBFFABF98BF36BED4BE72BE10BDAD;
defparam sin.INIT_2C = 256'hC927C8CCC871C816C7BAC75EC702C6A6C649C5EDC58FC532C4D4C476C418C3BA;
defparam sin.INIT_2D = 256'hCEACCE56CDFFCDA8CD51CCFACCA2CC4ACBF2CB9ACB41CAE8CA8FCA35C9DBC981;
defparam sin.INIT_2E = 256'hD3EAD398D346D2F3D2A1D24ED1FBD1A7D154D100D0ABD057D002CFADCF57CF02;
defparam sin.INIT_2F = 256'hD8DFD892D845D7F7D7A9D75AD70CD6BDD66ED61ED5CED57ED52ED4DDD48CD43B;
defparam sin.INIT_30 = 256'hDD8CDD43DCFADCB1DC68DC1EDBD4DB8ADB3FDAF4DAA9DA5DDA11D9C5D979D92C;
defparam sin.INIT_31 = 256'hE1EFE1ABE167E122E0DDE098E053E00DDFC7DF81DF3ADEF3DEACDE64DE1DDDD4;
defparam sin.INIT_32 = 256'hE608E5C9E589E549E509E4C8E487E446E405E3C3E381E33FE2FCE2BAE276E233;
defparam sin.INIT_33 = 256'hE9D6E99BE960E925E8E9E8AEE872E835E7F8E7BBE77EE740E703E6C4E686E647;
defparam sin.INIT_34 = 256'hED58ED22ECECECB6EC7FEC48EC10EBD9EBA1EB68EB30EAF7EABEEA84EA4AEA10;
defparam sin.INIT_35 = 256'hF08FF05DF02CEFFAEFC8EF96EF63EF30EEFDEEC9EE96EE61EE2DEDF8EDC3ED8E;
defparam sin.INIT_36 = 256'hF378F34CF31FF2F2F2C5F297F26AF23BF20DF1DEF1AFF180F150F120F0F0F0BF;
defparam sin.INIT_37 = 256'hF615F5EDF5C6F59DF575F54CF523F4FAF4D0F4A6F47CF451F427F3FBF3D0F3A4;
defparam sin.INIT_38 = 256'hF864F841F81EF7FBF7D8F7B4F78FF76BF746F721F6FCF6D6F6B0F68AF663F63C;
defparam sin.INIT_39 = 256'hFA66FA48FA2AFA0BF9EDF9CDF9AEF98FF96FF94EF92EF90DF8ECF8CAF8A9F886;
defparam sin.INIT_3A = 256'hFC19FC00FBE7FBCDFBB3FB99FB7FFB64FB49FB2EFB12FAF6FADAFABDFAA0FA83;
defparam sin.INIT_3B = 256'hFD7EFD6AFD56FD41FD2CFD17FD01FCEBFCD5FCBFFCA8FC91FC7AFC62FC4AFC32;
defparam sin.INIT_3C = 256'hFE94FE85FE76FE66FE56FE46FE35FE24FE13FE01FDF0FDDDFDCBFDB8FDA5FD92;
defparam sin.INIT_3D = 256'hFF5CFF52FF47FF3DFF32FF26FF1AFF0EFF02FEF5FEE9FEDBFECEFEC0FEB2FEA3;
defparam sin.INIT_3E = 256'hFFD5FFD0FFCAFFC4FFBEFFB8FFB1FFAAFFA2FF9BFF93FF8AFF82FF79FF70FF66;
defparam sin.INIT_3F = 256'hFFFFFFFFFFFEFFFDFFFCFFFAFFF8FFF6FFF4FFF1FFEEFFEBFFE7FFE3FFDFFFDA;
defparam sin.INITP_00 = 256'h0000000000000000000000000000000000000000000000000000000000000000;
defparam sin.INITP_01 = 256'h0000000000000000000000000000000000000000000000000000000000000000;
defparam sin.INITP_02 = 256'h5555555555555555555554000000000000000000000000000000000000000000;
defparam sin.INITP_03 = 256'h5555555555555555555555555555555555555555555555555555555555555555;
defparam sin.INITP_04 = 256'h5555555555555555555555555555555555555555555555555555555555555555;
defparam sin.INITP_05 = 256'h5555555555555555555555555555555555555555555555555555555555555555;
defparam sin.INITP_06 = 256'h5555555555555555555555555555555555555555555555555555555555555555;
defparam sin.INITP_07 = 256'h5555555555555555555555555555555555555555555555555555555555555555;

endmodule
