/*
Must link with

C:\Program Files (x86)\Microsoft SDKs\Windows\v7.0A\Lib\WS2_32.Lib (or somewhere like that)
SDK\lib\win32\release_dll\sixense.lib
SDK\lib\win32\release_dll\sixense_utils.lib
libglfw.a
libopengl32.a
*/
#include<GL\glfw.h>
#include<SDK\include\sixense.h>
#define OSCPKT_OSTREAM_OUTPUT
#include<SDK\oscpkt\oscpkt.hh>
#include<SDK\oscpkt\udp.hh>
using namespace oscpkt;
main(){
	sixenseInit();
	sixenseSetActiveBase(0);
	sixenseControllerData dat;
	UdpSocket sok;
	sok.connectTo("localhost",7022);
	for(glfwInit();;glfwSetTime(glfwGetTime()-.004)){
		for(;glfwGetTime()<.004;);
		sixenseGetNewestData(0,&dat);
		PacketWriter pkt;
		pkt.startBundle();
		Message lpx("/l/p/x"),
			lpy("/l/p/y"),
			lpz("/l/p/z"),
			ljx("/l/j/x"),
			ljy("/l/j/y"),
			ltt("/l/t/t"),
			lb1("/l/b/1"),
			lb2("/l/b/2"),
			lb3("/l/b/3"),
			lb4("/l/b/4"),
			lbs("/l/b/s"),
			lbb("/l/b/b"),
			lbj("/l/b/j"),
			lrx("/l/r/x"),
			lry("/l/r/y"),
			lrz("/l/r/z"),
			lrq("/l/r/q"),
			l00("/l/0/0"),
			l01("/l/0/1"),
			l02("/l/0/2"),
			l10("/l/1/0"),
			l11("/l/1/1"),
			l12("/l/1/2"),
			l20("/l/2/0"),
			l21("/l/2/1"),
			l22("/l/2/2");
		pkt.addMessage(lpx.pushFloat(dat.pos[0]))
			.addMessage(lpy.pushFloat(dat.pos[1]))
			.addMessage(lpz.pushFloat(dat.pos[2]))
			.addMessage(ljx.pushInt32(int(dat.joystick_x)))
			.addMessage(ljy.pushInt32(int(dat.joystick_y)))
			.addMessage(ltt.pushInt32(int(dat.trigger)))
			.addMessage(lb1.pushInt32(dat.buttons&SIXENSE_BUTTON_1?1:0))
			.addMessage(lb2.pushInt32(dat.buttons&SIXENSE_BUTTON_2?1:0))
			.addMessage(lb3.pushInt32(dat.buttons&SIXENSE_BUTTON_3?1:0))
			.addMessage(lb4.pushInt32(dat.buttons&SIXENSE_BUTTON_4?1:0))
			.addMessage(lbs.pushInt32(dat.buttons&SIXENSE_BUTTON_START?1:0))
			.addMessage(lbb.pushInt32(dat.buttons&SIXENSE_BUTTON_BUMPER?1:0))
			.addMessage(lbj.pushInt32(dat.buttons&SIXENSE_BUTTON_JOYSTICK?1:0))
			.addMessage(lrx.pushFloat(dat.rot_quat[0]))
			.addMessage(lry.pushFloat(dat.rot_quat[1]))
			.addMessage(lrz.pushFloat(dat.rot_quat[2]))
			.addMessage(lrq.pushFloat(dat.rot_quat[3]))
			.addMessage(l00.pushFloat(dat.rot_mat[0][0]))
			.addMessage(l01.pushFloat(dat.rot_mat[0][1]))
			.addMessage(l02.pushFloat(dat.rot_mat[0][2]))
			.addMessage(l10.pushFloat(dat.rot_mat[1][0]))
			.addMessage(l11.pushFloat(dat.rot_mat[1][1]))
			.addMessage(l12.pushFloat(dat.rot_mat[1][2]))
			.addMessage(l20.pushFloat(dat.rot_mat[2][0]))
			.addMessage(l21.pushFloat(dat.rot_mat[2][1]))
			.addMessage(l22.pushFloat(dat.rot_mat[2][2]));
		sok.sendPacket(pkt.packetData(),pkt.packetSize());}}
