unit FrmStore;

{

  (C) COPYRIGHT 1999 .. 2014 Blue Hell / Jan Punter

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License version 2 as
  published by the Free Software Foundation;

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

  For all listed email addresses :

    _dot. to be substituted by a dot      '.'
    2@t2  to be substituted by an at sign '@'


  Blue Hell is a trade mark owned by

    Jan Punter
    Oogstplein 6
    7545 HP Enschede
    the Netherlands
    http://www.iaf.nl/Users/BlueHell/
    http://bluehell.electro-music.com/
    j_dot.punter2@t2iaf_dot.nl

  All rights attributed to Blue Hell are owned by Jan Punter.
}

interface

uses

  WinApi.Windows, WinApi.Messages, System.SysUtils, System.Classes, Vcl.Graphics, Vcl.Controls, Vcl.Forms, Vcl.Dialogs,
  Vcl.ExtCtrls, Vcl.StdCtrls, Vcl.ComCtrls, Vcl.Buttons, Vcl.Imaging.jpeg, Vcl.ImgList, Vcl.Samples.Spin,
  Vcl.Imaging.pngimage,

  knobs2013;

type

  TOnDesignerLog = procedure( aSender: TObject; const aMsg: string) of object;

  TFormStore = class(TForm)
    savedstuff_pagecontrol: TPageControl;
    lfo_tabsheet: TTabSheet;
    savedstuff_tabsheet: TTabSheet;
    savedstuff_memo: TMemo;
    inout_tabsheet: TTabSheet;
    mixer_tabsheet: TTabSheet;
    sigcond_tabsheet: TTabSheet;
    osc_tabsheet: TTabSheet;
    logic_tabsheet: TTabSheet;
    delay_tabseet: TTabSheet;
    switch_tabsheet: TTabSheet;
    envelope_tabsheet: TTabSheet;
    filter_tabsheet: TTabSheet;
    util_tabsheet: TTabSheet;
    sequencer_tabsheet: TTabSheet;
    ImageAudioIn: TImage;
    ImageAudioOut: TImage;
    ImageXFade: TImage;
    ImagePan: TImage;
    ImageConstant: TImage;
    ImageInverter: TImage;
    ImageAdder: TImage;
    ImageMultiplier: TImage;
    ImageAmplifier: TImage;
    ImageScaler: TImage;
    ImageQuantizer: TImage;
    ImageSineLfo: TImage;
    ImageTriLfo: TImage;
    ImageSawLfo: TImage;
    ImageSquareLfo: TImage;
    ImageNoiseLfo: TImage;
    ImageSineLfoTrig: TImage;
    ImageTriLfoTrig: TImage;
    ImageSawLfoTrig: TImage;
    ImageSquareLfoTrig: TImage;
    ImageNoiseLfoTrig: TImage;
    ImageSine: TImage;
    ImageTri: TImage;
    ImageSaw: TImage;
    ImageSquare: TImage;
    ImageNoise: TImage;
    ImageSineTrig: TImage;
    ImageTriTrig: TImage;
    ImageSawTrig: TImage;
    ImageSquareTrig: TImage;
    ImageNoiseTrig: TImage;
    ImageAnd: TImage;
    ImageNand: TImage;
    ImageOr: TImage;
    ImageNor: TImage;
    ImageXor: TImage;
    ImageXnor: TImage;
    ImageDivider: TImage;
    ImageDelay: TImage;
    ImageSampleAndHold: TImage;
    ImageTrackAndHold: TImage;
    ImageSwitch2to1: TImage;
    ImageEnvAR: TImage;
    ImageEnvARRetrig: TImage;
    ImageAverage: TImage;
    ImageSVF: TImage;
    ImagePanel1: TImage;
    ImagePanel2: TImage;
    ImagePanel3: TImage;
    ImagePanel4: TImage;
    ImagePanel5: TImage;
    ImageDisplay: TImage;
    ImageSequencer: TImage;
    ImageTextSequencer: TImage;
    ImageSeqStep: TImage;
    ImageSeqClockStep: TImage;
    ImageDelayShort: TImage;
    ImageNot: TImage;
    ImageNotes: TImage;
    ImageEnvAHD: TImage;
    ImageEnvADSR: TImage;
    audioin: TKnobsModule;
    audioin_out1: TKnobsOutput;
    audioin_out2: TKnobsOutput;
    audioin_editlabel: TKnobsEditLabel;
    audioout: TKnobsModule;
    audioout_in2: TKnobsInput;
    audioout_in1: TKnobsInput;
    audioout_editlabel: TKnobsEditLabel;
    xfade: TKnobsModule;
    xfade_out: TKnobsOutput;
    xfade_in1: TKnobsInput;
    xfade_in2: TKnobsInput;
    xfade_control: TKnobsInput;
    xfade_editlabel: TKnobsEditLabel;
    pan: TKnobsModule;
    pan_out2: TKnobsOutput;
    pan_out1: TKnobsOutput;
    pan_in: TKnobsInput;
    pan_control: TKnobsInput;
    pan_editlabel: TKnobsEditLabel;
    constant: TKnobsModule;
    constant_out: TKnobsOutput;
    constant_editlabel: TKnobsEditLabel;
    constant_value: TKnobsSmallKnob;
    constant_display_value: TKnobsDisplay;
    inverter: TKnobsModule;
    inverter_image: TImage;
    inverter_out4: TKnobsOutput;
    inverter_out3: TKnobsOutput;
    inverter_out2: TKnobsOutput;
    inverter_out1: TKnobsOutput;
    inverter_in4: TKnobsInput;
    inverter_in3: TKnobsInput;
    inverter_in2: TKnobsInput;
    inverter_in1: TKnobsInput;
    inverter_editlabel: TKnobsEditLabel;
    inverter_inputcount: TKnobsNoKnob;
    adder: TKnobsModule;
    adder_image: TImage;
    adder_out: TKnobsOutput;
    adder_in4: TKnobsInput;
    adder_in3: TKnobsInput;
    adder_in2: TKnobsInput;
    adder_in1: TKnobsInput;
    adder_editlabel: TKnobsEditLabel;
    adder_inputcount: TKnobsNoKnob;
    multiplier: TKnobsModule;
    multiplier_image: TImage;
    multiplier_out: TKnobsOutput;
    multiplier_in4: TKnobsInput;
    multiplier_in3: TKnobsInput;
    multiplier_in2: TKnobsInput;
    multiplier_in1: TKnobsInput;
    multiplier_editlabel: TKnobsEditLabel;
    multiplier_inputcount: TKnobsNoKnob;
    amplifier: TKnobsModule;
    amplifier_out4: TKnobsOutput;
    amplifier_out3: TKnobsOutput;
    amplifier_out2: TKnobsOutput;
    amplifier_out1: TKnobsOutput;
    amplifier_in4: TKnobsInput;
    amplifier_in3: TKnobsInput;
    amplifier_in2: TKnobsInput;
    amplifier_in1: TKnobsInput;
    amplifier_editlabel: TKnobsEditLabel;
    amplifier_gain: TKnobsSmallKnob;
    amplifier_display_gain: TKnobsDisplay;
    amplifier_inputcount: TKnobsNoKnob;
    scaler: TKnobsModule;
    scaler_out4: TKnobsOutput;
    scaler_out3: TKnobsOutput;
    scaler_out2: TKnobsOutput;
    scaler_out1: TKnobsOutput;
    scaler_in4: TKnobsInput;
    scaler_in3: TKnobsInput;
    scaler_in2: TKnobsInput;
    scaler_in1: TKnobsInput;
    scaler_editlabel: TKnobsEditLabel;
    scaler_offset: TKnobsSmallKnob;
    scaler_gain: TKnobsSmallKnob;
    scaler_display_gain: TKnobsDisplay;
    scaler_display_offset: TKnobsDisplay;
    scaler_inputcount: TKnobsNoKnob;
    quantize: TKnobsModule;
    quantizer_out: TKnobsOutput;
    quantizer_in: TKnobsInput;
    quantizer_editlabel: TKnobsEditLabel;
    quantizer_qsteps: TKnobsSmallKnob;
    quantizer_display_qsteps: TKnobsDisplay;
    sinelfo: TKnobsModule;
    sinelfo_image: TImage;
    sinelfo_symbol_res: TImage;
    sinelfo_out: TKnobsOutput;
    sinelfo_fm: TKnobsInput;
    sinelfo_phase: TKnobsInput;
    sinelfo_res: TKnobsInput;
    sinelfo_editlabel: TKnobsEditLabel;
    sinelfo_indicator_out: TKnobsIndicator;
    sinelfo_indicator_res: TKnobsIndicator;
    sinelfo_frequency: TKnobsSmallKnob;
    sinelfo_display_frequency: TKnobsDisplay;
    trilfo: TKnobsModule;
    trilfo_image: TImage;
    trilfo_symbol_res: TImage;
    trilfo_out: TKnobsOutput;
    trilfo_fm: TKnobsInput;
    trilfo_phase: TKnobsInput;
    trilfo_res: TKnobsInput;
    trilfo_editlabel: TKnobsEditLabel;
    trilfo_indicator_out: TKnobsIndicator;
    trilfo_indicator_res: TKnobsIndicator;
    trilfo_frequency: TKnobsSmallKnob;
    trilfo_display_frequency: TKnobsDisplay;
    sawlfo: TKnobsModule;
    sawlfo_image: TImage;
    sawlfo_symbol_res: TImage;
    sawlfo_out: TKnobsOutput;
    sawlfo_fm: TKnobsInput;
    sawlfo_phase: TKnobsInput;
    sawlfo_res: TKnobsInput;
    sawlfo_editlabel: TKnobsEditLabel;
    sawlfo_indicator_out: TKnobsIndicator;
    sawlfo_indicator_res: TKnobsIndicator;
    sawlfo_frequency: TKnobsSmallKnob;
    sawlfo_display_frequency: TKnobsDisplay;
    squarelfo: TKnobsModule;
    squarelfo_image: TImage;
    squarelfo_symbol_res: TImage;
    squarelfo_out: TKnobsOutput;
    squarelfo_fm: TKnobsInput;
    squarelfo_phase: TKnobsInput;
    squarelfo_pwm: TKnobsInput;
    squarelfo_res: TKnobsInput;
    squarelfo_editlabel: TKnobsEditLabel;
    squarelfo_indicator_out: TKnobsIndicator;
    squarelfo_indicator_res: TKnobsIndicator;
    squarelfo_frequency: TKnobsSmallKnob;
    squarelfo_display_frequency: TKnobsDisplay;
    noiselfo: TKnobsModule;
    noiselfo_image: TImage;
    noiselfo_out: TKnobsOutput;
    noiselfo_editlabel: TKnobsEditLabel;
    noiselfo_indicator_out: TKnobsIndicator;
    noiselfo_color: TKnobsSmallKnob;
    noiselfo_display_color: TKnobsDisplay;
    sinelfotrig: TKnobsModule;
    sinelfotrig_image: TImage;
    sinelfotrig_symbol_trig: TImage;
    sinelfotrig_out: TKnobsOutput;
    sinelfotrig_fm: TKnobsInput;
    sinelfotrig_trig: TKnobsInput;
    sinelfotrig_editlabel: TKnobsEditLabel;
    sinelfotrig_indicator_out: TKnobsIndicator;
    sinelfotrig_indicator_trig: TKnobsIndicator;
    sinelfotrig_frequency: TKnobsSmallKnob;
    sinelfotrig_display_frequency: TKnobsDisplay;
    sinelfotrig_display_count: TKnobsDisplay;
    sinelfotrig_count: TKnobsNoKnob;
    trilfotrig: TKnobsModule;
    trilfotrig_image: TImage;
    trilfotrig_symbol_trig: TImage;
    trilfotrig_out: TKnobsOutput;
    trilfotrig_fm: TKnobsInput;
    trilfotrig_trig: TKnobsInput;
    trilfotrig_editlabel: TKnobsEditLabel;
    trilfotrig_indicator_out: TKnobsIndicator;
    trilfotrig_indicator_trig: TKnobsIndicator;
    trilfotrig_frequency: TKnobsSmallKnob;
    trilfotrig_display_frequency: TKnobsDisplay;
    trifotrig_display_count: TKnobsDisplay;
    trilfotrig_count: TKnobsNoKnob;
    sawlfotrig: TKnobsModule;
    sawlfotrig_image: TImage;
    sawlfotrig_symbol_trig: TImage;
    sawlfotrig_out: TKnobsOutput;
    sawlfotrig_fm: TKnobsInput;
    sawlfotrig_trig: TKnobsInput;
    sawlfotrig_editlabel: TKnobsEditLabel;
    sawlfotrig_indicator_out: TKnobsIndicator;
    sawlfotrig_indicator_trig: TKnobsIndicator;
    sawlfotrig_frequency: TKnobsSmallKnob;
    sawlfotrig_display_frequency: TKnobsDisplay;
    sawlfotrig_display_count: TKnobsDisplay;
    sawlfotrig_count: TKnobsNoKnob;
    squarelfotrig: TKnobsModule;
    squarelfotrig_symbol_trig: TImage;
    squarelfotrig_image: TImage;
    squarelfotrig_out: TKnobsOutput;
    squarelfotrig_fm: TKnobsInput;
    squarelfotrig_trig: TKnobsInput;
    squarelfotrig_pwm: TKnobsInput;
    squarelfotrig_editlabel: TKnobsEditLabel;
    squarelfotrig_indicator_out: TKnobsIndicator;
    squarelfotrig_indicator_trig: TKnobsIndicator;
    squarelfotrig_frequency: TKnobsSmallKnob;
    squarelfotrig_display_frequency: TKnobsDisplay;
    squarelfotrig_display_count: TKnobsDisplay;
    squarelfotrig_count: TKnobsNoKnob;
    noiselfotrig: TKnobsModule;
    noiselfotrig_image: TImage;
    noiselfotrig_symbol_trig: TImage;
    noiselfotrig_out: TKnobsOutput;
    noiselfotrig_trig: TKnobsInput;
    noiselfotrig_editlabel: TKnobsEditLabel;
    noiselfotrig_indicator_out: TKnobsIndicator;
    noiselfotrig_indicator_trig: TKnobsIndicator;
    noiselfotrig_color: TKnobsSmallKnob;
    noiselfotrig_display_color: TKnobsDisplay;
    sine: TKnobsModule;
    sine_image: TImage;
    sine_symbol_res: TImage;
    sine_out: TKnobsOutput;
    sine_outcos: TKnobsOutput;
    sine_fm: TKnobsInput;
    sine_phase: TKnobsInput;
    sine_res: TKnobsInput;
    sine_editlabel: TKnobsEditLabel;
    sine_indicator_res: TKnobsIndicator;
    sine_frequency: TKnobsSmallKnob;
    sine_display_frequency: TKnobsDisplay;
    tri: TKnobsModule;
    tri_image: TImage;
    tri_symbol_res: TImage;
    tri_out: TKnobsOutput;
    tri_fm: TKnobsInput;
    tri_phase: TKnobsInput;
    tri_res: TKnobsInput;
    tri_editlabel: TKnobsEditLabel;
    tri_indicator_res: TKnobsIndicator;
    tri_frequency: TKnobsSmallKnob;
    tri_display_frequency: TKnobsDisplay;
    saw: TKnobsModule;
    saw_image: TImage;
    saw_symbol_res: TImage;
    saw_out: TKnobsOutput;
    saw_fm: TKnobsInput;
    saw_phase: TKnobsInput;
    saw_res: TKnobsInput;
    saw_editlabel: TKnobsEditLabel;
    saw_indicator_res: TKnobsIndicator;
    saw_frequency: TKnobsSmallKnob;
    saw_display_frequency: TKnobsDisplay;
    square: TKnobsModule;
    square_image: TImage;
    square_symbol_res: TImage;
    square_out: TKnobsOutput;
    square_fm: TKnobsInput;
    square_phase: TKnobsInput;
    square_pwm: TKnobsInput;
    square_res: TKnobsInput;
    square_editlabel: TKnobsEditLabel;
    square_indicator_res: TKnobsIndicator;
    square_frequency: TKnobsSmallKnob;
    square_display_frequency: TKnobsDisplay;
    noise: TKnobsModule;
    noise_image: TImage;
    noise_out: TKnobsOutput;
    noise_editlabel: TKnobsEditLabel;
    noise_color: TKnobsSmallKnob;
    noise_display_color: TKnobsDisplay;
    sinetrig: TKnobsModule;
    sinetrig_image: TImage;
    sinetrig_symbol_trig: TImage;
    sinetrig_out: TKnobsOutput;
    sinetrig_fm: TKnobsInput;
    sinetrig_trig: TKnobsInput;
    sinetrig_editlabel: TKnobsEditLabel;
    sinetrig_indicator_trig: TKnobsIndicator;
    sinetrig_frequency: TKnobsSmallKnob;
    sinetrig_display_frequency: TKnobsDisplay;
    sinetrig_display_count: TKnobsDisplay;
    sinetrig_count: TKnobsNoKnob;
    tritrig: TKnobsModule;
    tritrig_image: TImage;
    tritrig_symbol_trig: TImage;
    tritrig_out: TKnobsOutput;
    tritrig_fm: TKnobsInput;
    tritrig_trig: TKnobsInput;
    tritrig_editlabel: TKnobsEditLabel;
    tritrig_indicator_trig: TKnobsIndicator;
    tritrig_frequency: TKnobsSmallKnob;
    tritrig_display_frequency: TKnobsDisplay;
    tritrig_display_count: TKnobsDisplay;
    tritrig_count: TKnobsNoKnob;
    sawtrig: TKnobsModule;
    sawtrig_image: TImage;
    sawtrig_symbol_trig: TImage;
    sawtrig_out: TKnobsOutput;
    sawtrig_fm: TKnobsInput;
    sawtrig_trig: TKnobsInput;
    sawtrig_editlabel: TKnobsEditLabel;
    sawtrig_indicator_trig: TKnobsIndicator;
    sawtrig_frequency: TKnobsSmallKnob;
    sawtrig_display_frequency: TKnobsDisplay;
    sawtrig_display_count: TKnobsDisplay;
    sawtrig_count: TKnobsNoKnob;
    squaretrig: TKnobsModule;
    squaretrig_symbol_trig: TImage;
    squaretrig_image: TImage;
    squaretrig_out: TKnobsOutput;
    squaretrig_fm: TKnobsInput;
    squaretrig_trig: TKnobsInput;
    squaretrig_pwm: TKnobsInput;
    squaretrig_editlabel: TKnobsEditLabel;
    squaretrig_indicator_trig: TKnobsIndicator;
    squaretrig_frequency: TKnobsSmallKnob;
    squaretrig_display_frequency: TKnobsDisplay;
    squaretrig_display_count: TKnobsDisplay;
    squaretrig_count: TKnobsNoKnob;
    noisetrig: TKnobsModule;
    noisetrig_image: TImage;
    noisetrig_symbol_trig: TImage;
    noisetrig_out: TKnobsOutput;
    noisetrig_trig: TKnobsInput;
    noisetrig_editlabel: TKnobsEditLabel;
    noisetrig_indicator_trig: TKnobsIndicator;
    noisetrig_color: TKnobsSmallKnob;
    noisetrig_display_color: TKnobsDisplay;
    logicand: TKnobsModule;
    logicand_image: TImage;
    logicand_out: TKnobsOutput;
    logicand_in4: TKnobsInput;
    logicand_in3: TKnobsInput;
    logicand_in2: TKnobsInput;
    logicand_in1: TKnobsInput;
    logicand_editlabel: TKnobsEditLabel;
    logicand_indicator_out: TKnobsIndicator;
    logicand_inputcount: TKnobsNoKnob;
    logicnand: TKnobsModule;
    logicnand_image: TImage;
    logicnand_out: TKnobsOutput;
    logicnand_in4: TKnobsInput;
    logicnand_in3: TKnobsInput;
    logicnand_in2: TKnobsInput;
    logicnand_in1: TKnobsInput;
    logicnand_editlabel: TKnobsEditLabel;
    logicnand_indicator_out: TKnobsIndicator;
    logicnand_inputcount: TKnobsNoKnob;
    logicor: TKnobsModule;
    logicor_image: TImage;
    logicor_out: TKnobsOutput;
    logicor_in4: TKnobsInput;
    logicor_in3: TKnobsInput;
    logicor_in2: TKnobsInput;
    logicor_in1: TKnobsInput;
    logicor_editlabel: TKnobsEditLabel;
    logicor_indicator_out: TKnobsIndicator;
    logicor_inputcount: TKnobsNoKnob;
    logicnor: TKnobsModule;
    logicnor_image: TImage;
    logicnor_out: TKnobsOutput;
    logicnor_in4: TKnobsInput;
    logicnor_in3: TKnobsInput;
    logicnor_in2: TKnobsInput;
    logicnor_in1: TKnobsInput;
    logicnor_editlabel: TKnobsEditLabel;
    logicnor_indicator_out: TKnobsIndicator;
    logicnor_inputcount: TKnobsNoKnob;
    logicxor: TKnobsModule;
    logicxor_image: TImage;
    logicxor_out: TKnobsOutput;
    logicxor_in4: TKnobsInput;
    logicxor_in3: TKnobsInput;
    logicxor_in2: TKnobsInput;
    logicxor_in1: TKnobsInput;
    logicxor_editlabel: TKnobsEditLabel;
    logicxor_indicator_out: TKnobsIndicator;
    logicxor_inputcount: TKnobsNoKnob;
    logicxnor: TKnobsModule;
    logicxnor_image: TImage;
    logicxnor_out: TKnobsOutput;
    logicxnor_in4: TKnobsInput;
    logicxnor_in3: TKnobsInput;
    logicxnor_in2: TKnobsInput;
    logicxnor_in1: TKnobsInput;
    logicxnor_editlabel: TKnobsEditLabel;
    logicxnor_indicator_out: TKnobsIndicator;
    logicxnor_inputcount: TKnobsNoKnob;
    divider: TKnobsModule;
    divider_image: TImage;
    divider_symbol_trig: TImage;
    divider_out: TKnobsOutput;
    divider_trig: TKnobsInput;
    divider_editlabel: TKnobsEditLabel;
    divider_indicator_out: TKnobsIndicator;
    divider_count: TKnobsSmallKnob;
    divider_display_count: TKnobsDisplay;
    logicnot: TKnobsModule;
    logicnot_image: TImage;
    logicnot_out1: TKnobsOutput;
    logicnot_out3: TKnobsOutput;
    logicnot_out4: TKnobsOutput;
    logicnot_out2: TKnobsOutput;
    logicnot_in4: TKnobsInput;
    logicnot_in3: TKnobsInput;
    logicnot_in2: TKnobsInput;
    logicnot_in1: TKnobsInput;
    logicnot_editlabel: TKnobsEditLabel;
    logicnot_indicator_out1: TKnobsIndicator;
    logicnot_indicator_out3: TKnobsIndicator;
    logicnot_indicator_out4: TKnobsIndicator;
    logicnot_indicator_out2: TKnobsIndicator;
    logicnot_inputcount: TKnobsNoKnob;
    delay: TKnobsModule;
    delay_out: TKnobsOutput;
    delay_outfixed: TKnobsOutput;
    delay_in: TKnobsInput;
    delay_delay: TKnobsInput;
    delay_editlabel: TKnobsEditLabel;
    delay_length: TKnobsSmallKnob;
    delay_display_length: TKnobsDisplay;
    delayshort: TKnobsModule;
    delayshort_out: TKnobsOutput;
    delayshort_outfixed: TKnobsOutput;
    delayshort_delay: TKnobsInput;
    delayshort_editlabel: TKnobsEditLabel;
    delayshort_in: TKnobsInput;
    delayshort_display_length: TKnobsDisplay;
    sampleandhold: TKnobsModule;
    sampleandhold_symbol_trig: TImage;
    sampleandhold_out: TKnobsOutput;
    sampleandhold_in: TKnobsInput;
    sampleandhold_trig: TKnobsInput;
    sampleandhold_editlabel: TKnobsEditLabel;
    sampleandhold_indicator_trig: TKnobsIndicator;
    trackandhold: TKnobsModule;
    trackandhold_symbol_trig: TImage;
    trackandhold_out: TKnobsOutput;
    trackandhold_in: TKnobsInput;
    trackandhold_trig: TKnobsInput;
    trackandhold_editlabel: TKnobsEditLabel;
    trackandhold_indicator_trig: TKnobsIndicator;
    switch2to1: TKnobsModule;
    switch2to1_out: TKnobsOutput;
    switch2to1_control: TKnobsInput;
    switch2to1_in1: TKnobsInput;
    switch2to1_in2: TKnobsInput;
    switch2to1_editlabel: TKnobsEditLabel;
    switch2to1_indicator_control: TKnobsIndicator;
    envar: TKnobsModule;
    envar_symbol_connect: TImage;
    envar_out: TKnobsOutput;
    envar_sigout: TKnobsOutput;
    envar_trig: TKnobsInput;
    envar_gain: TKnobsInput;
    envar_sigin: TKnobsInput;
    envar_editlabel: TKnobsEditLabel;
    envar_indicator_trig: TKnobsIndicator;
    envar_attack: TKnobsSmallKnob;
    envar_release: TKnobsSmallKnob;
    envar_display_attack: TKnobsDisplay;
    envar_display_release: TKnobsDisplay;
    envarretrig: TKnobsModule;
    envarretrig_symbol_trig: TImage;
    envarretrig_out: TKnobsOutput;
    envarretrig_sigout: TKnobsOutput;
    envarretrig_trig: TKnobsInput;
    envarretrig_gain: TKnobsInput;
    envarretrig_sigin: TKnobsInput;
    envarretrig_editlabel: TKnobsEditLabel;
    envarretrig_indicator_trig: TKnobsIndicator;
    envarretrig_attack: TKnobsSmallKnob;
    envarretrig_release: TKnobsSmallKnob;
    envarretrig_display_attack: TKnobsDisplay;
    envarretrig_display_release: TKnobsDisplay;
    envahd: TKnobsModule;
    envahd_symbol_connect: TImage;
    envahd_out: TKnobsOutput;
    envahd_sigout: TKnobsOutput;
    envahd_trig: TKnobsInput;
    envahd_gain: TKnobsInput;
    envahd_sigin: TKnobsInput;
    envahd_editlabel: TKnobsEditLabel;
    envahd_indicator_trig: TKnobsIndicator;
    envahd_attack: TKnobsSmallKnob;
    envahd_decay: TKnobsSmallKnob;
    envahd_hold: TKnobsSmallKnob;
    envahd_display_attack: TKnobsDisplay;
    envahd_display_decay: TKnobsDisplay;
    envahd_display_hold: TKnobsDisplay;
    envadsr: TKnobsModule;
    envadsr_symbol_connect: TImage;
    envadsr_out: TKnobsOutput;
    envadsr_sigout: TKnobsOutput;
    envadsr_trig: TKnobsInput;
    envadsr_gain: TKnobsInput;
    envadsr_sigin: TKnobsInput;
    envadsr_editlabel: TKnobsEditLabel;
    envadsr_indicator_trig: TKnobsIndicator;
    envadsr_attack: TKnobsSmallKnob;
    envadsr_release: TKnobsSmallKnob;
    envadsr_decay: TKnobsSmallKnob;
    envadsr_sustain: TKnobsSmallKnob;
    envadsr_display_attack: TKnobsDisplay;
    envadsr_display_release: TKnobsDisplay;
    envadsr_display_decay: TKnobsDisplay;
    envadsr_display_sustain: TKnobsDisplay;
    avg: TKnobsModule;
    avg_image: TImage;
    avg_lp: TKnobsOutput;
    avg_hp: TKnobsOutput;
    avg_in: TKnobsInput;
    avg_editlabel: TKnobsEditLabel;
    avg_alpha: TKnobsSmallKnob;
    svf: TKnobsModule;
    svf_lp: TKnobsOutput;
    svf_bp: TKnobsOutput;
    svf_hp: TKnobsOutput;
    svf_br: TKnobsOutput;
    svf_in: TKnobsInput;
    svf_fm: TKnobsInput;
    svf_editlabel: TKnobsEditLabel;
    svf_distortion: TKnobsSmallKnob;
    svf_display_frequency: TKnobsDisplay;
    svf_display_q: TKnobsDisplay;
    panel1: TKnobsModule;
    panel2: TKnobsModule;
    panel2_editlabel: TKnobsEditLabel;
    panel3: TKnobsModule;
    panel3_editlabel: TKnobsEditLabel;
    panel4: TKnobsModule;
    panel4_editlabel: TKnobsEditLabel;
    panel5: TKnobsModule;
    panel5_editlabel: TKnobsEditLabel;
    display: TKnobsModule;
    display_in2: TKnobsInput;
    display_in1: TKnobsInput;
    display_editlabel: TKnobsEditLabel;
    notes: TKnobsModule;
    notes_editlabel: TKnobsEditLabel;
    notes_display: TKnobsDisplay;
    sequencer: TKnobsModule;
    sequencer_symbol_trig: TImage;
    sequencer_out: TKnobsOutput;
    sequencer_dir: TKnobsInput;
    sequencer_trig: TKnobsInput;
    sequencer_reset: TKnobsInput;
    sequencer_editlabel: TKnobsEditLabel;
    sequencer_indicator_step1: TKnobsIndicator;
    sequencer_indicator_step2: TKnobsIndicator;
    sequencer_indicator_step3: TKnobsIndicator;
    sequencer_indicator_step4: TKnobsIndicator;
    sequencer_indicator_step5: TKnobsIndicator;
    sequencer_indicator_step6: TKnobsIndicator;
    sequencer_indicator_step7: TKnobsIndicator;
    sequencer_indicator_step8: TKnobsIndicator;
    sequencer_indicator_step9: TKnobsIndicator;
    sequencer_indicator_step10: TKnobsIndicator;
    sequencer_indicator_step11: TKnobsIndicator;
    sequencer_indicator_trig: TKnobsIndicator;
    sequencer_indicator_dir: TKnobsIndicator;
    sequencer_indicator_reset: TKnobsIndicator;
    sequencer_display_steps: TKnobsDisplay;
    sequencer_display_step1: TKnobsDisplay;
    sequencer_display_step2: TKnobsDisplay;
    sequencer_display_step3: TKnobsDisplay;
    sequencer_display_step4: TKnobsDisplay;
    sequencer_display_step5: TKnobsDisplay;
    sequencer_display_step6: TKnobsDisplay;
    sequencer_display_step7: TKnobsDisplay;
    sequencer_display_step8: TKnobsDisplay;
    sequencer_display_step9: TKnobsDisplay;
    sequencer_display_step10: TKnobsDisplay;
    sequencer_display_step11: TKnobsDisplay;
    sequencer_steps: TKnobsNoKnob;
    sequencer_step1: TKnobsNoKnob;
    sequencer_step2: TKnobsNoKnob;
    sequencer_step3: TKnobsNoKnob;
    sequencer_step4: TKnobsNoKnob;
    sequencer_step5: TKnobsNoKnob;
    sequencer_step6: TKnobsNoKnob;
    sequencer_step7: TKnobsNoKnob;
    sequencer_step8: TKnobsNoKnob;
    sequencer_step9: TKnobsNoKnob;
    sequencer_step10: TKnobsNoKnob;
    sequencer_step11: TKnobsNoKnob;
    textsequencer: TKnobsModule;
    textsequencer_symbol_trig: TImage;
    textsequencer_label_slash: TLabel;
    textsequencer_out: TKnobsOutput;
    textsequencer_dir: TKnobsInput;
    textsequencer_trig: TKnobsInput;
    textsequencer_reset: TKnobsInput;
    textsequencer_editlabel: TKnobsEditLabel;
    textsequencer_indicator_trig: TKnobsIndicator;
    textsequencer_indicator_dir: TKnobsIndicator;
    textsequencer_indicator_reset: TKnobsIndicator;
    textsequencer_values: TKnobsDisplay;
    seqstep: TKnobsModule;
    seqstep_symbol_trigfwd: TImage;
    seqstep_symbol_sigflow: TImage;
    seqstep_symbol_trigbwd: TImage;
    seqstep_out: TKnobsOutput;
    seqstep_trigoutfwd: TKnobsOutput;
    seqstep_trigoutbwd: TKnobsOutput;
    seqstep_dir: TKnobsInput;
    seqstep_triginfwd: TKnobsInput;
    seqstep_reset: TKnobsInput;
    seqstep_chain: TKnobsInput;
    seqstep_triginbwd: TKnobsInput;
    seqstep_editlabel: TKnobsEditLabel;
    seqstep_indicator_trigbwd: TKnobsIndicator;
    seqstep_indicator_dir: TKnobsIndicator;
    seqstep_indicator_reset: TKnobsIndicator;
    seqstep_indicator_active: TKnobsIndicator;
    seqstep_indicator_trigfwd: TKnobsIndicator;
    seqstep_note: TKnobsSmallKnob;
    seqstep_time: TKnobsSmallKnob;
    seqstep_display_note: TKnobsDisplay;
    seqstep_display_time: TKnobsDisplay;
    seqclockstep: TKnobsModule;
    seqclockstep_symbol_clockedge: TImage;
    seqclockstep_symbol_trigfwd: TImage;
    seqclockstep_symbol_sigflow: TImage;
    seqclockstep_symbol_trigbwd: TImage;
    seqclockstep_out: TKnobsOutput;
    seqclockstep_trigoutfwd: TKnobsOutput;
    seqclockstep_trigoutbwd: TKnobsOutput;
    seqclockstep_dir: TKnobsInput;
    seqclockstep_triginfwd: TKnobsInput;
    seqclockstep_reset: TKnobsInput;
    seqclockstep_chain: TKnobsInput;
    seqclockstep_triginbwd: TKnobsInput;
    seqclockstep_clock: TKnobsInput;
    seqclockstep_editlabel: TKnobsEditLabel;
    seqclockstep_indicator_trigbwd: TKnobsIndicator;
    seqclockstep_indicator_dir: TKnobsIndicator;
    seqclockstep_indicator_reset: TKnobsIndicator;
    seqclockstep_indicator_active: TKnobsIndicator;
    seqclockstep_indicator_trigfwd: TKnobsIndicator;
    seqclockstep_indicator_clock: TKnobsIndicator;
    seqclockstep_note: TKnobsSmallKnob;
    seqclockstep_counts: TKnobsSmallKnob;
    seqclockstep_display_note: TKnobsDisplay;
    seqclockstep_display_counts: TKnobsDisplay;
    envahd_viewer: TKnobsDataViewer;
    envadsr_viewer: TKnobsDataViewer;
    svf_frequency: TKnobsKnob;
    svf_q: TKnobsKnob;
    display_level1: TKnobsIndicatorBar;
    display_level2: TKnobsIndicatorBar;
    audioin_textlabel_r_out: TKnobsTextLabel;
    audioin_textlabel_l_out: TKnobsTextLabel;
    audioout_textlabel_r_in: TKnobsTextLabel;
    audioout_textlabel_l_in: TKnobsTextLabel;
    xfade_textlabel_control: TKnobsTextLabel;
    xfade_textlabel_in1: TKnobsTextLabel;
    xfade_textlabel_in2: TKnobsTextLabel;
    xfade_textlabel_out: TKnobsTextLabel;
    pan_textlabel_control: TKnobsTextLabel;
    pan_textlabel_in: TKnobsTextLabel;
    pan_textlabel_out2: TKnobsTextLabel;
    pan_textlabel_out1: TKnobsTextLabel;
    scaler_textlabel_gain: TKnobsTextLabel;
    scaler_textlabel_offset: TKnobsTextLabel;
    quantizer_textlabel_in: TKnobsTextLabel;
    quantizer_textlabel_qsteps: TKnobsTextLabel;
    sinelfo_textlabel_fm: TKnobsTextLabel;
    sinelfo_textlabel_phase: TKnobsTextLabel;
    sinelfo_textlabel_res: TKnobsTextLabel;
    trilfo_textlabel_fm: TKnobsTextLabel;
    trilfo_textlabel_phase: TKnobsTextLabel;
    trilfo_textlabel_res: TKnobsTextLabel;
    sawlfo_textlabel_fm: TKnobsTextLabel;
    sawlfo_textlabel_phase: TKnobsTextLabel;
    sawlfo_textlabel_res: TKnobsTextLabel;
    squarelfo_textlabel_fm: TKnobsTextLabel;
    squarelfo_textlabel_phase: TKnobsTextLabel;
    squarelfo_textlabel_pwm: TKnobsTextLabel;
    squarelfo_textlabel_res: TKnobsTextLabel;
    noiselfo_textlabel_color: TKnobsTextLabel;
    sinelfotrig_textlabel_fm: TKnobsTextLabel;
    sinelfotrig_textlabel_trig: TKnobsTextLabel;
    trilfotrig_textlabel_fm: TKnobsTextLabel;
    trilfotrig_textlabel_trig: TKnobsTextLabel;
    sawlfotrig_textlabel_fm: TKnobsTextLabel;
    sawlfotrig_textlabel_trig: TKnobsTextLabel;
    squarelfotrig_textlabel_fm: TKnobsTextLabel;
    squarelfotrig_textlabel_trig: TKnobsTextLabel;
    aquarelftrig_textlabel_trig: TKnobsTextLabel;
    noiselfotrig_textlabel_trig: TKnobsTextLabel;
    noiselfotrix_textlabel_color: TKnobsTextLabel;
    sine_textlabel_fm: TKnobsTextLabel;
    sine_textlabel_phase: TKnobsTextLabel;
    sine_textlabel_res: TKnobsTextLabel;
    tri_textlabel_fm: TKnobsTextLabel;
    tri_textlabel_phase: TKnobsTextLabel;
    tri_textlabel_res: TKnobsTextLabel;
    saw_textlabel_fm: TKnobsTextLabel;
    saw_textlabel_phase: TKnobsTextLabel;
    saw_textlabel_res: TKnobsTextLabel;
    square_textlabel_fm: TKnobsTextLabel;
    square_textlabel_phase: TKnobsTextLabel;
    square_textlabel_pwm: TKnobsTextLabel;
    square_textlabel_res: TKnobsTextLabel;
    noise_textlabel_color: TKnobsTextLabel;
    sinetrig_textlabel_fm: TKnobsTextLabel;
    sinetrig_textlabel_trig: TKnobsTextLabel;
    tritrig_textlabel_fm: TKnobsTextLabel;
    tritrig_textlabel_trig: TKnobsTextLabel;
    sawtrig_textlabel_fm: TKnobsTextLabel;
    sawtrig_textlabel_trig: TKnobsTextLabel;
    squaretrig_textlabel_fm: TKnobsTextLabel;
    squaretrig_textlabel_trig: TKnobsTextLabel;
    squaretrig_textlabel_pwm: TKnobsTextLabel;
    noisetrig_textlabel_trig: TKnobsTextLabel;
    noisetrig_textlabel_color: TKnobsTextLabel;
    divider_textlabel_trig: TKnobsTextLabel;
    delay_textlabel_in: TKnobsTextLabel;
    delay_textlabel_delay: TKnobsTextLabel;
    delay_textlabel_maxdelay: TKnobsTextLabel;
    delay_textlabel_fixed: TKnobsTextLabel;
    delayshort_textlabel_in: TKnobsTextLabel;
    delayshort_textlabel_delay: TKnobsTextLabel;
    delayshort_textlabel_maxdelay: TKnobsTextLabel;
    delayshort_textlabel_fixed: TKnobsTextLabel;
    sampleandhold_label_in: TKnobsTextLabel;
    sampleandhold_label_trig: TKnobsTextLabel;
    trackandhold_label_in: TKnobsTextLabel;
    trackandhold_label_trig: TKnobsTextLabel;
    switch2to1_textlabel_control: TKnobsTextLabel;
    switch2to1_textlabel_in1: TKnobsTextLabel;
    switch2to1_textlabel_in2: TKnobsTextLabel;
    envar_textlabel_trig: TKnobsTextLabel;
    envar_textlabel_gain: TKnobsTextLabel;
    envar_textlabel_attack: TKnobsTextLabel;
    envar_textlabel_release: TKnobsTextLabel;
    envarretrig_textlabel_trig: TKnobsTextLabel;
    envarretrig_textlabel_gain: TKnobsTextLabel;
    envarretrig_textlabel_release: TKnobsTextLabel;
    envarretrig_textlabel_attack: TKnobsTextLabel;
    envahd_textlabel_gain: TKnobsTextLabel;
    envahd_textlabel_decay: TKnobsTextLabel;
    envahd_textlabel_attack: TKnobsTextLabel;
    envahd_textlabel_hold: TKnobsTextLabel;
    envadsr_textlabel_gain: TKnobsTextLabel;
    envadsr_textlabel_release: TKnobsTextLabel;
    envadsr_textlabel_attack: TKnobsTextLabel;
    envadsr_textlabel_decay: TKnobsTextLabel;
    envadsr_textlabel_sustain: TKnobsTextLabel;
    avg_textlabel_in: TKnobsTextLabel;
    avg_textlabel_out: TKnobsTextLabel;
    avg_textlabel_invout: TKnobsTextLabel;
    svf_textlabel_in: TKnobsTextLabel;
    svf_textlabel_frequency_in: TKnobsTextLabel;
    svf_textlabel_frequency: TKnobsTextLabel;
    svf_textlabel_q: TKnobsTextLabel;
    svf_textlabel_lp: TKnobsTextLabel;
    svf_textlabel_bp: TKnobsTextLabel;
    svf_textlabel_hp: TKnobsTextLabel;
    svf_textlabel_br: TKnobsTextLabel;
    svf_textlabel_distortion: TKnobsTextLabel;
    display_textlabel_db: TKnobsTextLabel;
    sequencer_textlabel_steps: TKnobsTextLabel;
    sequencer_textlabel_trig: TKnobsTextLabel;
    sequencer_textlabel_dir: TKnobsTextLabel;
    sequencer_textlabel_step1: TKnobsTextLabel;
    sequencer_textlabel_step2: TKnobsTextLabel;
    sequencer_textlabel_step3: TKnobsTextLabel;
    sequencer_textlabel_step4: TKnobsTextLabel;
    sequencer_textlabel_step5: TKnobsTextLabel;
    sequencer_textlabel_step6: TKnobsTextLabel;
    sequencer_textlabel_step7: TKnobsTextLabel;
    sequencer_textlabel_step8: TKnobsTextLabel;
    sequencer_textlabel_step9: TKnobsTextLabel;
    sequencer_textlabel_step10: TKnobsTextLabel;
    sequencer_textlabel_step11: TKnobsTextLabel;
    sequencer_textlabel_reset: TKnobsTextLabel;
    textsequencer_textlabel_trig: TKnobsTextLabel;
    textsequencer_textlabel_dir: TKnobsTextLabel;
    textsequencer_textlabel_reset: TKnobsTextLabel;
    seqstep_textlabel_trig: TKnobsTextLabel;
    seqstep_textlabel_dir: TKnobsTextLabel;
    seqstep_textlabel_res: TKnobsTextLabel;
    seqstep_textlabel_note: TKnobsTextLabel;
    seqstep_textlabel_duration: TKnobsTextLabel;
    seqclockstep_textlabel_trig: TKnobsTextLabel;
    seqclockstep_textlabel_dir: TKnobsTextLabel;
    seqclockstep_textlabel_reset: TKnobsTextLabel;
    seqclockstep_textlabel_note: TKnobsTextLabel;
    seqclockstep_textlabel_count: TKnobsTextLabel;
    seqclockstep_textlabel_clock: TKnobsTextLabel;
    textsequencer_indicator_step: TKnobsIndicatorText;
    textsequencer_indicator_steps: TKnobsIndicatorText;
    seqclockstep_indicator_count: TKnobsIndicatorText;
    randomwalklfo: TKnobsModule;
    randomwalklfo_outx: TKnobsOutput;
    randomwalklfo_editlabel: TKnobsEditLabel;
    randomwalklfo_indicator_outx: TKnobsIndicator;
    randomwalklfo_textlabel_distance: TKnobsTextLabel;
    randomwalklfo_distance: TKnobsSmallKnob;
    randomwalklfo_display_distance: TKnobsDisplay;
    randomwalklfo_fm: TKnobsInput;
    randomwalklfo_textlabel_fm: TKnobsTextLabel;
    randomwalklfo_frequency: TKnobsSmallKnob;
    randomwalklfo_display_frequency: TKnobsDisplay;
    randomwalklfo_textlabel_frequency: TKnobsTextLabel;
    ImageRandomWalkLfo: TImage;
    randomwalklfo_outy: TKnobsOutput;
    randomwalklfo_indicator_outy: TKnobsIndicator;
    randomwalklfo_outz: TKnobsOutput;
    randomwalklfo_indicator_outz: TKnobsIndicator;
    randomwalklfo_textlabel_x: TKnobsTextLabel;
    randomwalklfo_textlabel_y: TKnobsTextLabel;
    randomwalklfo_textlabel_z: TKnobsTextLabel;
    randomwalklfo_image: TImage;
    amplifier_image: TImage;
    scaler_mode: TKnobsSelector;
    envahd_ashape: TKnobsSelector;
    envahd_dshape: TKnobsSelector;
    envadsr_rshape: TKnobsSelector;
    envadsr_ashape: TKnobsSelector;
    envadsr_dshape: TKnobsSelector;
    envahd_mode: TKnobsSelector;
    envadsr_mode: TKnobsSelector;
    textsequencer_mode: TKnobsSelector;
    sinelfo_mute: TKnobsSelector;
    trilfo_mute: TKnobsSelector;
    sawlfo_mute: TKnobsSelector;
    squarelfo_mute: TKnobsSelector;
    noiselfo_mute: TKnobsSelector;
    sinelfotrig_mute: TKnobsSelector;
    trilfotrig_mute: TKnobsSelector;
    sawlfotrig_mute: TKnobsSelector;
    squarelfotrig_mute: TKnobsSelector;
    noiselfotrig_mute: TKnobsSelector;
    sine_mute: TKnobsSelector;
    tri_mute: TKnobsSelector;
    saw_mute: TKnobsSelector;
    square_mute: TKnobsSelector;
    noise_mute: TKnobsSelector;
    sinetrig_mute: TKnobsSelector;
    tritrig_mute: TKnobsSelector;
    sawtrig_mute: TKnobsSelector;
    squaretrig_mute: TKnobsSelector;
    noisetrig_mute: TKnobsSelector;
    envar_mute: TKnobsSelector;
    envarretrig_mute: TKnobsSelector;
    envahd_mute: TKnobsSelector;
    envadsr_mute: TKnobsSelector;
    randomwalklfo_mute: TKnobsSelector;
    quantizer_mute: TKnobsSelector;
    scaler_mute: TKnobsSelector;
    adder_mute: TKnobsSelector;
    multiplier_mute: TKnobsSelector;
    constant_mute: TKnobsSelector;
    amplifier_mute: TKnobsSelector;
    waveplayer: TKnobsModule;
    waveplayer_out: TKnobsOutput;
    waveplayer_speed: TKnobsInput;
    waveplayer_editlabel: TKnobsEditLabel;
    waveplayer_textlabel_speed: TKnobsTextLabel;
    waveplayer_textlabel_duration: TKnobsTextLabel;
    waveplayer_display_duration: TKnobsDisplay;
    ImageWavePlayer: TImage;
    envarretrig_symbol_connect: TImage;
    separator_lfo1: TKnobsModule;
    separator_lfo2: TKnobsModule;
    separator_osc1: TKnobsModule;
    separator_logic1: TKnobsModule;
    separator_util1: TKnobsModule;
    separator_util2: TKnobsModule;
    display_knobsbox_left: TKnobsBox;
    display_knobsbox_right: TKnobsBox;
    waveplayer_textlabel_position: TKnobsTextLabel;
    waveplayer_position: TKnobsInput;
    waveplayer_symbol_res: TImage;
    waveplayer_res: TKnobsInput;
    waveplayer_indicator_res: TKnobsIndicator;
    waveplayer_textlabel_res: TKnobsTextLabel;
    envahd_speed: TKnobsSelector;
    envadsr_speed: TKnobsSelector;
    delay_textlabel_info_1: TKnobsTextLabel;
    MemoAudioIn: TMemo;
    MemoAudioOut: TMemo;
    MemoSine: TMemo;
    MemoTri: TMemo;
    MemoSaw: TMemo;
    MemoSquare: TMemo;
    MemoNoise: TMemo;
    MemoSineTrig: TMemo;
    MemoTriTrig: TMemo;
    MemoSawTrig: TMemo;
    MemoSquareTrig: TMemo;
    MemoNoiseTrig: TMemo;
    MemoSineLfo: TMemo;
    MemoTriLfo: TMemo;
    MemoSawLfo: TMemo;
    MemoSquareLfo: TMemo;
    MemoNoiseLfo: TMemo;
    MemoRandomWalkLfo: TMemo;
    MemoSineLfoTrig: TMemo;
    MemoTriLfoTrig: TMemo;
    MemoSawLfoTrig: TMemo;
    MemoSquareLfoTrig: TMemo;
    MemoNoiseLfoTrig: TMemo;
    MemoEnvAR: TMemo;
    MemoEnvARRetrig: TMemo;
    MemoEnvAHD: TMemo;
    MemoEnvADSR: TMemo;
    MemoAverage: TMemo;
    MemoSVF: TMemo;
    MemoSampleAndHold: TMemo;
    MemoTrackAndHold: TMemo;
    MemoSwitch2to1: TMemo;
    MemoXFade: TMemo;
    MemoPan: TMemo;
    MemoConstant: TMemo;
    MemoInverter: TMemo;
    MemoAdder: TMemo;
    MemoMultiplier: TMemo;
    MemoAmplifier: TMemo;
    MemoScaler: TMemo;
    MemoQuantizer: TMemo;
    MemoNot: TMemo;
    MemoAnd: TMemo;
    MemoNand: TMemo;
    MemoOr: TMemo;
    MemoNor: TMemo;
    MemoXor: TMemo;
    MemoXNor: TMemo;
    MemoDivider: TMemo;
    MemoSequencer: TMemo;
    MemoTextSequencer: TMemo;
    MemoSeqStep: TMemo;
    MemoSeqClockStep: TMemo;
    MemoDelay: TMemo;
    MemoDelayShort: TMemo;
    MemoWavePlayer: TMemo;
    MemoPanel1: TMemo;
    MemoPanel2: TMemo;
    MemoPanel3: TMemo;
    MemoPanel4: TMemo;
    MemoPanel5: TMemo;
    MemoDisplay: TMemo;
    MemoNotes: TMemo;
    sinelin: TKnobsModule;
    sinelin_editlabel: TKnobsEditLabel;
    sinelin_image: TImage;
    sinelin_symbol_res: TImage;
    sinelin_out: TKnobsOutput;
    sinelin_outcos: TKnobsOutput;
    sinelin_fmlin: TKnobsInput;
    sinelin_phase: TKnobsInput;
    sinelin_res: TKnobsInput;
    sinelin_indicator_res: TKnobsIndicator;
    sinelin_textlabel_fm: TKnobsTextLabel;
    sinelin_textlabel_pm: TKnobsTextLabel;
    sinelin_textlabel_res: TKnobsTextLabel;
    sinelin_freqlin: TKnobsSmallKnob;
    sinelin_display_frequency: TKnobsDisplay;
    sinelin_mute: TKnobsSelector;
    separator_osc2: TKnobsModule;
    ImageSineLin: TImage;
    MemoSineLin: TMemo;
    separator_lfo3: TKnobsModule;
    trilin: TKnobsModule;
    trilin_editlabel: TKnobsEditLabel;
    trilin_image: TImage;
    trilin_symbol_res: TImage;
    trilin_out: TKnobsOutput;
    trilin_fmlin: TKnobsInput;
    trilin_phase: TKnobsInput;
    trilin_res: TKnobsInput;
    trilin_indicator_res: TKnobsIndicator;
    trilin_textlabel_fm: TKnobsTextLabel;
    trilin_textlabel_pm: TKnobsTextLabel;
    trilin_textlabel_res: TKnobsTextLabel;
    trilin_freqlin: TKnobsSmallKnob;
    trilin_display_frequency: TKnobsDisplay;
    trilin_mute: TKnobsSelector;
    sawlin: TKnobsModule;
    sawlin_editlabel: TKnobsEditLabel;
    sawlin_image: TImage;
    sawlin_symbol_res: TImage;
    sawlin_out: TKnobsOutput;
    sawlin_fmlin: TKnobsInput;
    sawlin_phase: TKnobsInput;
    sawlin_res: TKnobsInput;
    sawlin_indicator_res: TKnobsIndicator;
    sawlin_textlabel_fm: TKnobsTextLabel;
    sawlin_textlabel_pm: TKnobsTextLabel;
    sawlin_textlabel_res: TKnobsTextLabel;
    sawlin_freqlin: TKnobsSmallKnob;
    sawlin_display_frequency: TKnobsDisplay;
    sawlin_mute: TKnobsSelector;
    squarelin: TKnobsModule;
    squarelin_editlabel: TKnobsEditLabel;
    squarelin_image: TImage;
    squarelin_symbol_res: TImage;
    squarelin_out: TKnobsOutput;
    squarelin_fmlin: TKnobsInput;
    squarelin_phase: TKnobsInput;
    squarelin_pwm: TKnobsInput;
    squarelin_res: TKnobsInput;
    squarelin_indicator_res: TKnobsIndicator;
    squarelin_textlabel_fm: TKnobsTextLabel;
    squarelin_textlabel_pm: TKnobsTextLabel;
    squarelin_textlabel_pwm: TKnobsTextLabel;
    squarelin_textlabel_res: TKnobsTextLabel;
    squarelin_freqlin: TKnobsSmallKnob;
    squarelin_display_frequency: TKnobsDisplay;
    squarelin_mute: TKnobsSelector;
    ImageTriLin: TImage;
    ImageSawLin: TImage;
    ImageSquareLin: TImage;
    MemoTriLin: TMemo;
    MemoSawLin: TMemo;
    MemoSquareLin: TMemo;
    sinelfolin: TKnobsModule;
    sinelfolin_editlabel: TKnobsEditLabel;
    sinelfolin_image: TImage;
    sinelfolin_symbol_res: TImage;
    sinelfolin_out: TKnobsOutput;
    sinelfolin_fmlin: TKnobsInput;
    sinelfolin_phase: TKnobsInput;
    sinelfolin_res: TKnobsInput;
    sinelfolin_indicator_out: TKnobsIndicator;
    sinelfolin_indicator_res: TKnobsIndicator;
    sinelfolin_textlabel_fm: TKnobsTextLabel;
    sinelfolin_textlabel_pm: TKnobsTextLabel;
    sinelfolin_textlabel_res: TKnobsTextLabel;
    sinelfolin_freqlin: TKnobsSmallKnob;
    sinelfolin_display_frequency: TKnobsDisplay;
    sinelfolin_mute: TKnobsSelector;
    trilfolin: TKnobsModule;
    trilfolin_editlabel: TKnobsEditLabel;
    trilfolin_image: TImage;
    trilfolin_symbol_res: TImage;
    trilfolin_out: TKnobsOutput;
    trilfolin_fmlin: TKnobsInput;
    trilfolin_phase: TKnobsInput;
    trilfolin_res: TKnobsInput;
    trilfolin_indicator_out: TKnobsIndicator;
    trilfolin_indicator_res: TKnobsIndicator;
    trilfolin_textlabel_fm: TKnobsTextLabel;
    trilfolin_textlabel_pm: TKnobsTextLabel;
    trilfolin_textlabel_res: TKnobsTextLabel;
    trilfolin_freqlin: TKnobsSmallKnob;
    trilfolin_display_frequency: TKnobsDisplay;
    trilfolin_mute: TKnobsSelector;
    sawlfolin: TKnobsModule;
    sawlfolin_editlabel: TKnobsEditLabel;
    sawlfolin_image: TImage;
    sawlfolin_symbol_res: TImage;
    sawlfolin_out: TKnobsOutput;
    sawlfolin_fmlin: TKnobsInput;
    sawlfolin_phase: TKnobsInput;
    sawlfolin_res: TKnobsInput;
    sawlfolin_indicator_out: TKnobsIndicator;
    sawlfolin_indicator_res: TKnobsIndicator;
    sawlfolin_textlabel_fm: TKnobsTextLabel;
    sawlfolin_textlabel_pm: TKnobsTextLabel;
    sawlfolin_textlabel_res: TKnobsTextLabel;
    sawlfolin_freqlin: TKnobsSmallKnob;
    sawlfolin_display_frequency: TKnobsDisplay;
    sawlfolin_mute: TKnobsSelector;
    squarelfolin: TKnobsModule;
    squarelfolin_editlabel: TKnobsEditLabel;
    squarelfolin_image: TImage;
    squarelfolin_symbol_res: TImage;
    squarelfolin_out: TKnobsOutput;
    squarelfolin_fmlin: TKnobsInput;
    squarelfolin_phase: TKnobsInput;
    squarelfolin_pwm: TKnobsInput;
    squarelfolin_res: TKnobsInput;
    squarelfolin_indicator_out: TKnobsIndicator;
    squarelfolin_indicator_res: TKnobsIndicator;
    squarelfolin_textlabel_fm: TKnobsTextLabel;
    squarelfolin_textlabel_pm: TKnobsTextLabel;
    squarelfolin_textlabel_pwm: TKnobsTextLabel;
    squarelfolin_textlabel_res: TKnobsTextLabel;
    squarelfolin_freqlin: TKnobsSmallKnob;
    squarelfolin_display_frequency: TKnobsDisplay;
    squarelfolin_mute: TKnobsSelector;
    ImageSineLfoLin: TImage;
    ImageTriLfoLin: TImage;
    ImageSawLfoLin: TImage;
    ImageSquareLfoLin: TImage;
    MemoSineLfoLin: TMemo;
    MemoTriLfoLin: TMemo;
    MemoSawLfoLin: TMemo;
    MemoSquareLfoLin: TMemo;
    sinelin_textlabel_hz: TKnobsTextLabel;
    trilin_textlabel_hz: TKnobsTextLabel;
    sawlin_textlabel_hz: TKnobsTextLabel;
    squarelin_textlabel_hz: TKnobsTextLabel;
    sinelfolin_textlabel_hz: TKnobsTextLabel;
    trilfolin_textlabel_hz: TKnobsTextLabel;
    sawlfolin_textlabel_hz: TKnobsTextLabel;
    squarelfolin_textlabel_hz: TKnobsTextLabel;
    ratio: TKnobsModule;
    ratio_out4: TKnobsOutput;
    ratio_out3: TKnobsOutput;
    ratio_out2: TKnobsOutput;
    ratio_out1: TKnobsOutput;
    ratio_in4: TKnobsInput;
    ratio_in3: TKnobsInput;
    ratio_in2: TKnobsInput;
    ratio_in1: TKnobsInput;
    ratio_editlabel: TKnobsEditLabel;
    ratio_textlabel_multiplier: TKnobsTextLabel;
    ratio_textlabel_divider: TKnobsTextLabel;
    ratio_divider: TKnobsSmallKnob;
    ratio_multiplier: TKnobsSmallKnob;
    ratio_display_multiplier: TKnobsDisplay;
    ratio_display_divider: TKnobsDisplay;
    ratio_inputcount: TKnobsNoKnob;
    ratio_mute: TKnobsSelector;
    MemoRatio: TMemo;
    ImageRatio: TImage;
    dflipflop: TKnobsModule;
    dflipflop_editlabel: TKnobsEditLabel;
    dflipflop_image: TImage;
    dflipflop_q: TKnobsOutput;
    dflipflop_d: TKnobsInput;
    dflipflop_clk: TKnobsInput;
    dflipflop_indicator_q: TKnobsIndicator;
    dflipflop_notq: TKnobsOutput;
    dflipflop_indicator_notq: TKnobsIndicator;
    MemoDFlipFlop: TMemo;
    ImageDFlipFlop: TImage;
    rsflipflop: TKnobsModule;
    rsflipflop_editlabel: TKnobsEditLabel;
    rsflipflop_image: TImage;
    rsflipflop_q: TKnobsOutput;
    rsflipflop_s: TKnobsInput;
    rsflipflop_r: TKnobsInput;
    rsflipflop_indicator_q: TKnobsIndicator;
    rsflipflop_notq: TKnobsOutput;
    rsflipflop_indicator_notq: TKnobsIndicator;
    ImageRSFlipFlop: TImage;
    MemoRSFlipFlop: TMemo;
    rotator: TKnobsModule;
    rotator_editlabel: TKnobsEditLabel;
    rotator_out1: TKnobsOutput;
    rotator_out2: TKnobsOutput;
    rotator_angle: TKnobsInput;
    rotator_in1: TKnobsInput;
    rotator_in2: TKnobsInput;
    ImageRotator: TImage;
    MemoRotator: TMemo;
    rotator_textlabel_angle: TKnobsTextLabel;
    rotator_textlabel_ins: TKnobsTextLabel;
    rotator_textlabel_outs: TKnobsTextLabel;
    sinelfotrig_ready: TKnobsOutput;
    sinelfotrig_indicator_ready: TKnobsIndicator;
    trilfotrig_ready: TKnobsOutput;
    trilfotrig_indicator_ready: TKnobsIndicator;
    sawlfotrig_ready: TKnobsOutput;
    sawlfotrig_indicator_ready: TKnobsIndicator;
    squarelfotrig_ready: TKnobsOutput;
    squarelfotrig_indicator_ready: TKnobsIndicator;
    sinelfotrig_textlabel_ready: TKnobsTextLabel;
    trilfotrig_textlabel_ready: TKnobsTextLabel;
    sawlfotrig_textlabel_ready: TKnobsTextLabel;
    squarelfotrig_textlabel_ready: TKnobsTextLabel;
    sinelfo_sync: TKnobsOutput;
    sinelfo_textlabel_sync: TKnobsTextLabel;
    trilfo_sync: TKnobsOutput;
    trilfo_textlabel_sync: TKnobsTextLabel;
    sawlfo_sync: TKnobsOutput;
    sawlfo_textlabel_sync: TKnobsTextLabel;
    squarelfo_sync: TKnobsOutput;
    squarelfo_textlabel_sync: TKnobsTextLabel;
    sinelfolin_sync: TKnobsOutput;
    sinelfolin_textlabel_sync: TKnobsTextLabel;
    trilfolin_sync: TKnobsOutput;
    trilfolin_textlabel_sync: TKnobsTextLabel;
    sawlfolin_sync: TKnobsOutput;
    sawlfolin_textlabel_sync: TKnobsTextLabel;
    squarelfolin_sync: TKnobsOutput;
    squarelfolin_textlabel_sync: TKnobsTextLabel;
    waveplayer_fileselector_filename: TKnobsFileSelector;
    waveplayer_outr: TKnobsOutput;
    waveplayer_mode: TKnobsSelector;
    waveplayer_textlabel_l: TKnobsTextLabel;
    waveplayer_textlabel_r: TKnobsTextLabel;
    xfade_position: TKnobsSmallKnob;
    pan_position: TKnobsSmallKnob;
    scaler_textlabel_lock: TKnobsTextLabel;
    sequencer_trig1: TKnobsOutput;
    sequencer_trig2: TKnobsOutput;
    sequencer_trig3: TKnobsOutput;
    sequencer_trig4: TKnobsOutput;
    sequencer_trig5: TKnobsOutput;
    sequencer_trig6: TKnobsOutput;
    sequencer_trig7: TKnobsOutput;
    sequencer_trig8: TKnobsOutput;
    sequencer_trig9: TKnobsOutput;
    sequencer_trig10: TKnobsOutput;
    sequencer_trig11: TKnobsOutput;
    sequencer_chain: TKnobsInput;
    mixm4to1: TKnobsModule;
    mixm4to1_editlabel: TKnobsEditLabel;
    mixm4to1_out: TKnobsOutput;
    mixm4to1_in3: TKnobsInput;
    mixm4to1_level3: TKnobsSmallKnob;
    mixm4to1_in4: TKnobsInput;
    mixm4to1_level4: TKnobsSmallKnob;
    mixm4to1_in2: TKnobsInput;
    mixm4to1_level2: TKnobsSmallKnob;
    mixm4to1_in: TKnobsInput;
    mixm4to1_in1: TKnobsInput;
    mixm4to1_level1: TKnobsSmallKnob;
    mixs2to1: TKnobsModule;
    mixs2to1_editlabel: TKnobsEditLabel;
    mixs2to1_outr: TKnobsOutput;
    mixs2to1_inr1: TKnobsInput;
    mixs2to1_inr2: TKnobsInput;
    mixs2to1_inr: TKnobsInput;
    mixs2to1_level1: TKnobsSmallKnob;
    mixs2to1_level2: TKnobsSmallKnob;
    mixs2to1_inl: TKnobsInput;
    mixs2to1_outl: TKnobsOutput;
    mixs2to1_inl2: TKnobsInput;
    mixs2to1_inl1: TKnobsInput;
    mixm4to1_mute: TKnobsSelector;
    mixs2to1_mute: TKnobsSelector;
    ImageMixM4to1: TImage;
    ImageMixS2to1: TImage;
    MemoMixM4to1: TMemo;
    MemoMixS2to1: TMemo;
    display_mode: TKnobsSelector;
    rectifier: TKnobsModule;
    rectifier_editlabel: TKnobsEditLabel;
    rectifier_outinv: TKnobsOutput;
    rectifier_out: TKnobsOutput;
    rectifier_in: TKnobsInput;
    rectifier_textlabel_inv: TKnobsTextLabel;
    rectifier_mode: TKnobsSelector;
    ImageRectifier: TImage;
    MemoRectifier: TMemo;
    rectifier_image: TImage;
    minmax: TKnobsModule;
    minmax_editlabel: TKnobsEditLabel;
    minmax_min: TKnobsOutput;
    minmax_max: TKnobsOutput;
    minmax_in1: TKnobsInput;
    minmax_in2: TKnobsInput;
    minmax_textlabel_1in2: TKnobsTextLabel;
    minmax_textlabel_minmax: TKnobsTextLabel;
    ImageMinMax: TImage;
    minmax_image: TImage;
    MemoMinMax: TMemo;
    intdif: TKnobsModule;
    intdif_editlabel: TKnobsEditLabel;
    intdif_int: TKnobsOutput;
    intdif_dif: TKnobsOutput;
    intdif_in: TKnobsInput;
    intdif_textlabel_int: TKnobsTextLabel;
    intdif_textlabel_dif: TKnobsTextLabel;
    ImageIntDif: TImage;
    MemoIntDif: TMemo;
    intdif_image: TImage;
    midi_tabsheet: TTabSheet;
    midinotein: TKnobsModule;
    midinotein_editlabel: TKnobsEditLabel;
    midinotein_indicator_gate: TKnobsIndicator;
    midinotein_gate: TKnobsOutput;
    midinotein_note: TKnobsOutput;
    midinotein_velon: TKnobsOutput;
    midinotein_veloff: TKnobsOutput;
    midinotein_textlabel_gate: TKnobsTextLabel;
    midinotein_textlabel_velocity: TKnobsTextLabel;
    midinotein_textlabel_veloff: TKnobsTextLabel;
    midinotein_textlabel_velon: TKnobsTextLabel;
    midinotein_textlabel_note: TKnobsTextLabel;
    midinotein_ch: TKnobsNoKnob;
    midinotein_display_ch: TKnobsDisplay;
    midinotein_textlabel_ch: TKnobsTextLabel;
    MemoMidiNoteIn: TMemo;
    ImageMidiNoteIn: TImage;
    midiccin: TKnobsModule;
    midiccin_editlabel: TKnobsEditLabel;
    midiccin_indicator_gate: TKnobsIndicator;
    midiccin_gate: TKnobsOutput;
    midiccin_value: TKnobsOutput;
    midiccin_textlabel_gate: TKnobsTextLabel;
    midiccin_textlabel_value: TKnobsTextLabel;
    midiccin_textlabel_cc: TKnobsTextLabel;
    midiccin_textlabel_ch: TKnobsTextLabel;
    midiccin_ch: TKnobsNoKnob;
    midiccin_display_ch: TKnobsDisplay;
    ImageMidiCCIn: TImage;
    MemoMidiCCIn: TMemo;
    midiccin_display_cc: TKnobsDisplay;
    midiccin_cc: TKnobsNoKnob;
    midinoteout: TKnobsModule;
    midinoteout_editlabel: TKnobsEditLabel;
    midinoteout_indicator_gate: TKnobsIndicator;
    midinoteout_textlabel_gate: TKnobsTextLabel;
    midinoteout_textlabel_velocity: TKnobsTextLabel;
    midinoteout_textlabel_veloff: TKnobsTextLabel;
    midinoteout_textlabel_velon: TKnobsTextLabel;
    midinoteout_textlabel_note: TKnobsTextLabel;
    midinoteout_textlabel_ch: TKnobsTextLabel;
    midinoteout_ch: TKnobsNoKnob;
    midinoteout_display_ch: TKnobsDisplay;
    ImageMidiNoteOut: TImage;
    MemoMidiNoteOut: TMemo;
    midinoteout_velon: TKnobsInput;
    midinoteout_note: TKnobsInput;
    midinoteout_veloff: TKnobsInput;
    midinoteout_gate: TKnobsInput;
    midiccout: TKnobsModule;
    midiccout_editlabel: TKnobsEditLabel;
    midiccout_indicator_gate: TKnobsIndicator;
    midiccout_textlabel_gate: TKnobsTextLabel;
    midiccout_textlabel_value: TKnobsTextLabel;
    midiccout_textlabel_cc: TKnobsTextLabel;
    midiccout_textlabel_ch: TKnobsTextLabel;
    midiccout_ch: TKnobsNoKnob;
    midiccout_display_ch: TKnobsDisplay;
    midiccout_display_cc: TKnobsDisplay;
    midiccout_cc: TKnobsNoKnob;
    ImageMidiCCOut: TImage;
    MemoMidiCCOut: TMemo;
    separator_midi: TKnobsModule;
    midiccout_value: TKnobsInput;
    midiccout_gate: TKnobsInput;
    envahd_symbol_trig: TImage;
    envadsr_symbol_trig: TImage;
    envadsr_textlabel_env: TKnobsTextLabel;
    envahd_textlabel_env: TKnobsTextLabel;
    waveplayer_display_mono: TKnobsDisplay;
    mixm6to6: TKnobsModule;
    mixm6to6_editlabel: TKnobsEditLabel;
    mixm6to6_outchrow1: TKnobsOutput;
    mixm6to6_levelr1c5: TKnobsSmallKnob;
    mixm6to6_levelr1c6: TKnobsSmallKnob;
    mixm6to6_levelr1c4: TKnobsSmallKnob;
    mixm6to6_levelr1c3: TKnobsSmallKnob;
    mixm6to6_levelr1c2: TKnobsSmallKnob;
    mixm6to6_levelr1c1: TKnobsSmallKnob;
    mixm6to6_in1: TKnobsInput;
    mixm6to6_mute1: TKnobsSelector;
    mixm6to6_levelr2c5: TKnobsSmallKnob;
    mixm6to6_levelr2c6: TKnobsSmallKnob;
    mixm6to6_levelr2c4: TKnobsSmallKnob;
    mixm6to6_levelr2c3: TKnobsSmallKnob;
    mixm6to6_levelr2c2: TKnobsSmallKnob;
    mixm6to6_levelr2c1: TKnobsSmallKnob;
    mixm6to6_in2: TKnobsInput;
    mixm6to6_mute2: TKnobsSelector;
    mixm6to6_levelr3c5: TKnobsSmallKnob;
    mixm6to6_levelr3c6: TKnobsSmallKnob;
    mixm6to6_levelr3c4: TKnobsSmallKnob;
    mixm6to6_levelr3c3: TKnobsSmallKnob;
    mixm6to6_levelr3c2: TKnobsSmallKnob;
    mixm6to6_levelr3c1: TKnobsSmallKnob;
    mixm6to6_in3: TKnobsInput;
    mixm6to6_mute3: TKnobsSelector;
    mixm6to6_levelr4c5: TKnobsSmallKnob;
    mixm6to6_levelr4c6: TKnobsSmallKnob;
    mixm6to6_levelr4c4: TKnobsSmallKnob;
    mixm6to6_levelr4c3: TKnobsSmallKnob;
    mixm6to6_levelr4c2: TKnobsSmallKnob;
    mixm6to6_levelr4c1: TKnobsSmallKnob;
    mixm6to6_in4: TKnobsInput;
    mixm6to6_mute4: TKnobsSelector;
    mixm6to6_levelr5c5: TKnobsSmallKnob;
    mixm6to6_levelr5c6: TKnobsSmallKnob;
    mixm6to6_levelr5c4: TKnobsSmallKnob;
    mixm6to6_levelr5c3: TKnobsSmallKnob;
    mixm6to6_levelr5c2: TKnobsSmallKnob;
    mixm6to6_levelr5c1: TKnobsSmallKnob;
    mixm6to6_in5: TKnobsInput;
    mixm6to6_mute5: TKnobsSelector;
    mixm6to6_levelr6c5: TKnobsSmallKnob;
    mixm6to6_levelr6c6: TKnobsSmallKnob;
    mixm6to6_levelr6c4: TKnobsSmallKnob;
    mixm6to6_levelr6c3: TKnobsSmallKnob;
    mixm6to6_levelr6c2: TKnobsSmallKnob;
    mixm6to6_levelr6c1: TKnobsSmallKnob;
    mixm6to6_in6: TKnobsInput;
    mixm6to6_mute6: TKnobsSelector;
    mixm6to6_outchrow2: TKnobsOutput;
    mixm6to6_outchrow3: TKnobsOutput;
    mixm6to6_outchrow4: TKnobsOutput;
    mixm6to6_outchrow5: TKnobsOutput;
    mixm6to6_outchrow6: TKnobsOutput;
    mixm6to6_out1: TKnobsOutput;
    mixm6to6_out2: TKnobsOutput;
    mixm6to6_out3: TKnobsOutput;
    mixm6to6_out4: TKnobsOutput;
    mixm6to6_out5: TKnobsOutput;
    mixm6to6_out6: TKnobsOutput;
    mixm6to6_inchcol1: TKnobsInput;
    mixm6to6_inchcol2: TKnobsInput;
    mixm6to6_inchcol3: TKnobsInput;
    mixm6to6_inchcol4: TKnobsInput;
    mixm6to6_inchcol5: TKnobsInput;
    mixm6to6_inchcol6: TKnobsInput;
    mixm6to6_textlabel_out: TKnobsTextLabel;
    mixm6to6_textlabel_in: TKnobsTextLabel;
    mixm6to6_textlabel_chains: TKnobsTextLabel;
    mixm6to6_box_inchains: TKnobsBox;
    mixm6to6_inr1c1: TKnobsInput;
    mixm6to6_inr1c2: TKnobsInput;
    mixm6to6_inr1c3: TKnobsInput;
    mixm6to6_inr1c4: TKnobsInput;
    mixm6to6_inr1c5: TKnobsInput;
    mixm6to6_inr1c6: TKnobsInput;
    mixm6to6_inr2c1: TKnobsInput;
    mixm6to6_inr2c2: TKnobsInput;
    mixm6to6_inr2c3: TKnobsInput;
    mixm6to6_inr2c4: TKnobsInput;
    mixm6to6_inr2c5: TKnobsInput;
    mixm6to6_inr2c6: TKnobsInput;
    mixm6to6_inr3c1: TKnobsInput;
    mixm6to6_inr3c2: TKnobsInput;
    mixm6to6_inr3c3: TKnobsInput;
    mixm6to6_inr3c4: TKnobsInput;
    mixm6to6_inr3c5: TKnobsInput;
    mixm6to6_inr3c6: TKnobsInput;
    mixm6to6_inr4c1: TKnobsInput;
    mixm6to6_inr4c2: TKnobsInput;
    mixm6to6_inr4c3: TKnobsInput;
    mixm6to6_inr4c4: TKnobsInput;
    mixm6to6_inr4c5: TKnobsInput;
    mixm6to6_inr4c6: TKnobsInput;
    mixm6to6_inr5c1: TKnobsInput;
    mixm6to6_inr5c2: TKnobsInput;
    mixm6to6_inr5c3: TKnobsInput;
    mixm6to6_inr5c4: TKnobsInput;
    mixm6to6_inr5c5: TKnobsInput;
    mixm6to6_inr5c6: TKnobsInput;
    mixm6to6_inr6c1: TKnobsInput;
    mixm6to6_inr6c2: TKnobsInput;
    mixm6to6_inr6c3: TKnobsInput;
    mixm6to6_inr6c4: TKnobsInput;
    mixm6to6_inr6c5: TKnobsInput;
    mixm6to6_inr6c6: TKnobsInput;
    KnobsBox1: TKnobsBox;
    KnobsBox2: TKnobsBox;
    KnobsBox3: TKnobsBox;
    MemoMixM6to6: TMemo;
    ImageMixM6to6: TImage;
    SeparatorOscHP: TKnobsModule;
    HrastOsc: TKnobsModule;
    HrastOscLabel: TKnobsEditLabel;
    HrastOscImage2: TImage;
    HrastOsc_Output: TKnobsOutput;
    HrastOsc_FMInput: TKnobsInput;
    HrastOsc_PMInput: TKnobsInput;
    HrastOsc_SyncInput: TKnobsInput;
    HrastOscIndicator_SyncInput: TKnobsIndicator;
    HrastOscLabelFM: TKnobsTextLabel;
    HrastOscLabelPM: TKnobsTextLabel;
    HrastOscLabelSync: TKnobsTextLabel;
    HrastOsc_Freq: TKnobsSmallKnob;
    HrastOscDisplayFreq: TKnobsDisplay;
    HrastOsc_Mute: TKnobsSelector;
    ImageHrastOsc: TImage;
    MemoHrastOsc: TMemo;
    HrastOscLabelPWM: TKnobsTextLabel;
    HrastOsc_PWMInput: TKnobsInput;
    HrastOsc_Shape: TKnobsSmallKnob;
    HrastOsc_Morph: TKnobsSmallKnob;
    HrastOsc_Bandlimit: TKnobsSmallKnob;
    HrastOsc_Level: TKnobsSmallKnob;
    HrastOsc_PW: TKnobsSmallKnob;
    HrastOsc_Vintage: TKnobsSelector;
    HrastOsc_PWM: TKnobsSmallKnob;
    HrastOsc_PM: TKnobsSmallKnob;
    HrastOsc_FM: TKnobsSmallKnob;
    HrastOscLabelMorph: TKnobsTextLabel;
    HrastOscLabelPW: TKnobsTextLabel;
    HrastOscLabelShape: TKnobsTextLabel;
    HrastOscLabelBandlimit: TKnobsTextLabel;
    HrastOscLabelLevel: TKnobsTextLabel;
    HrastOscLabelFreq: TKnobsTextLabel;
    HrastOsc_Image: TImage;
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
  private
    FModules       : TKnobsModuleList;
    FOnDesignerLog : TOnDesignerLog;
  private
    procedure   DoModuleListLog( aSender: TObject; const aMsg: string);
    procedure   DoModuleLog    ( aSender: TObject; const aMsg: string);
    procedure   RegisterModules;
    procedure   Log( const aMsg: string);
    procedure   LogFmt( const aFmt: string; const anArgs: array of const);
  public
    function    CreateModule(
      aWirePanel  : TKnobsWirePanel;
      aModuleType : TKnobsModuleType;
      MustDrag    : Boolean
    ): TKnobsCustomModule;

    procedure   PopulateSelector( aModuleSelector: TKnobsModuleSelector);
    procedure   ShowModule     ( const aModule: TKnobsCustomModule);
    function    CreateModuleBitmap( const aModuleType: TKnobsModuleType): TBitmap;
    function    ReadModuleComment ( const aModuleType: TKnobsModuleType): string;
    procedure   MakeImage      ( const aFolder: string; const aModule: TKnobsCustomModule);
    procedure   MakeImages     ( const aFolder: string);
    function    FindBitmap     ( const aModuleTitle: string): TBitmap;
    function    FindDocu       ( const aModuleTitle: string): TStrings;
    function    DocumentModule ( const aModule: TKnobsCustomModule; const anImagesFolder: string; anIndex: Integer): string;
    function    MakeDocIndex   : string;
    function    MakeDocHeader  ( const aVersion: string): string;
    function    MakeDocFooter  : string;
    function    DoDocument     ( const aFolder, anImagesFolder, aVersion: string): string;
    procedure   Document       ( const aFolder, anImagesFolder, aVersion: string);
  public
    property    Modules       : TKnobsModuleList read FModules;
    property    OnDesignerLog : TOnDesignerLog   read FOnDesignerLog write FOnDesignerLog;
  end;


var

  FormStore: TFormStore;


implementation


{$R *.DFM}


// User area


//  private


    // -------------------------------------------------------------------------

    procedure   TFormStore.DoModuleListLog( aSender: TObject; const aMsg: string);
    begin
      LogFmt( 'ModuleList (%s)', [ aMsg]);
    end;

    procedure   TFormStore.DoModuleLog( aSender: TObject; const aMsg: string);
    begin
      LogFmt( 'Module (%s)', [ aMsg]);
    end;

    procedure   TFormStore.RegisterModules;
    var
      i : Integer;
    begin
      FModules := TKnobsModuleList.Create;

      FModules.OnLog := DoModuleListLog;

      for i := 0 to ComponentCount - 1
      do begin
        if ( Components[ i] is TKnobsCustomModule)
        then begin
          TKnobsCustomModule( Components[ i]).OnLog := DoModuleLog;
          FModules.Add( Components[ i]);
        end;
      end;

      FModules.RegisterComponents( True);
    end;

    procedure   TFormStore.Log( const aMsg: string);
    begin
      if Assigned( FOnDesignerLog)
      then FOnDesignerLog( Self, Format( 'designer (%s)', [ aMsg]));
    end;

    procedure   TFormStore.LogFmt( const aFmt: string; const anArgs: array of const);
    begin
      Log( Format( aFmt, anArgs));
    end;


//  public


    function    TFormStore.CreateModule(
      aWirePanel  : TKnobsWirePanel;
      aModuleType : TKnobsModuleType;
      MustDrag    : Boolean
    ): TKnobsCustomModule;
    begin
      Result := FModules.CreateModule( aWirePanel, aModuleType, MustDrag);
      if Assigned( Result) and Assigned( aWirePanel)
      then Result.ControlMode := aWirePanel.ControlMode;
    end;


    procedure   TFormStore.PopulateSelector( aModuleSelector: TKnobsModuleSelector);
    begin
      FModules.PopulateSelector( aModuleSelector);
    end;

    procedure   TFormStore.ShowModule( const aModule: TKnobsCustomModule);
    var
      aTabSheet: TTabSheet;
    begin
      aTabSheet := aModule.Parent as TTabSheet;
      savedstuff_pagecontrol.ActivePage := aTabSheet;
    end;

    function    TFormStore.CreateModuleBitmap( const aModuleType: TKnobsModuleType): TBitmap;
    var
      i : Integer;
    begin
      Result := nil;
      if Assigned( FModules)
      then begin
        for i := 0 to FModules.Count - 1
        do begin
          if FModules[ i].ModuleType = aModuleType
          then begin
            Result := FModules[ i].AsBitmap;
            Break;
          end;
        end;
      end;
    end;

    function    TFormStore.ReadModuleComment( const aModuleType: TKnobsModuleType): string;
    var
      i : Integer;
    begin
      Result := '';
      if Assigned( FModules)
      then begin
        for i := 0 to FModules.Count - 1
        do begin
          if FModules[ i].ModuleType = aModuleType
          then begin
            Result := FModules[ i].Comment;
            if Result = ''
            then Result := FModules[ i].Title;
            Break;
          end;
        end;
      end;
    end;

    procedure   TFormStore.MakeImage( const aFolder: string; const aModule: TKnobsCustomModule);
    var
      aBitmap   : TBitmap;
      aFileName : string;
      aJPeg     : TJPEGImage;
    begin
      if Assigned( aModule)
      then begin
        aFileName := aFolder + '\TMod' + aModule.Title + '.jpg';
        aBitmap := aModule.AsBitmap;
        try
          aJpeg := TJPEGImage.Create;
          try
            aJpeg.CompressionQuality  := 90;
            aJpeg.ProgressiveEncoding := True;
            aJpeg.Assign( aBitmap);
            aJpeg.Compress;
            aJpeg.SaveToFile( aFileName);
          finally
            FreeAndNil( aJpeg);
          end;
        finally
          aBitmap.Free;
        end;
      end;
    end;

    procedure   TFormStore.MakeImages( const aFolder: string);
    var
      i : Integer;
    begin
      for i := 0 to FModules.Count - 1
      do begin
        ShowModule( FModules[ i]);
        MakeImage( aFolder, FModules[ i]);
      end;
    end;

    function    TFormStore.FindBitmap( const aModuleTitle: string): TBitmap;
    var
      i      : Integer;
      anImage: TImage;
    begin
      Result := nil;
      for i := 0 to ComponentCount - 1
      do begin
        if Components[ i] is TImage
        then begin
          anImage := TImage( Components[ i]);
          if SameText( anImage.Name, Format( 'Image%s', [ aModuleTitle]))
          then Result := anImage.Picture.Bitmap;
        end;
      end;
    end;


    function    TFormStore.FindDocu( const aModuleTitle: string): TStrings;
    var
      i     : Integer;
      aMemo : TMemo;
    begin
      Result := nil;
      for i := 0 to ComponentCount - 1
      do begin
        if Components[ i] is TMemo
        then begin
          aMemo := TMemo( Components[ i]);
          if SameText( aMemo.Name, Format( 'Memo%s', [ aModuleTitle]))
          then Result := aMemo.Lines;
        end;
      end;
    end;

    function    TFormStore.DocumentModule( const aModule: TKnobsCustomModule; const anImagesFolder: string; anIndex: Integer): string;
    var
      aDocu : TStrings;
      i     : Integer;
      First : Boolean;
      aType : Integer;
    begin
      Result := '';
      if Assigned( aModule)
      then begin
        aDocu := FindDocu( aModule.Title);
        if Assigned( aDocu)
        then begin
          First := True;
          for i := 0 to aDocu.Count - 1
          do begin
            if aDocu[ i] <> ''
            then begin
              if First
              then begin
                First  := False;
                aType  := aModule.ModuleType;
                Result := Result + '<a href=''#index''>index</a>';
                Result := Result + Format( '<h2><a id=''%d'' name=''%d''>%d %s</a></h2>'^M, [ aType, aType, anIndex, aDocu[ i]]);
                Result := Result + Format( '<h3>Page: %s</h3>'^M                          , [ aModule.PageName                ]);
                Result := Result + Format( '<img src=''./images/TMod%s.jpg''>'^M          , [ aModule.Title                   ]);
                Result := Result + Format( '<p>Type: %d'^M                                , [ aType                           ]);
              end
              else Result := Result + Format( '%s'^M  , [ aDocu[ i]]);
            end
            else begin
              if not First
              then Result := Result + ^M + '<p>';
            end;
          end;
          Result := Result + ^M + '<hr>'^M;
        end;
      end;
    end;

    function    TFormStore.MakeDocIndex: string;
    const
      Header    = '<tr><th>#</th><th>Page</th><th>Module type</th><th>Looks</th></tr>'^M;
      Separator = '<tr><th colspan=''4''><hr></th></tr>'^M;
    var
      i         : Integer;
      aPage     : string;
      anOldPage : string;
      aModule   : string;
      aType     : Integer;
    begin
      anOldPage := '';
      Result    := '';
      Result    := Result + '<table>'^M'<tbody>'^M;
      Result    := Result + Header;
      for i := 0 to FModules.Count - 1
      do begin
        with Modules[ i]
        do begin
          aType   := ModuleType;
          if aType >= 0
          then begin
            aPage     := PageName;
            aModule   := Title;
            if not SameText( anOldPage, aPage)
            then Result := Result + Separator;
            Result    := Result + Format( '<tr><td>%d</td><td>%s</td><td><a href=''#%d''>%s</a></td><td><a href=''#%d''><img src=''./images/TMod%s.jpg''></a></td></tr>', [ i + 1, aPage, aType, aModule, aType, aModule]);
            anOldPage := aPage;
          end;
        end;
      end;
      Result := Result + '</tbody>'^M'</table>'^M;
    end;

    function    TFormStore.MakeDocHeader( const aVersion: string): string;
    begin
      Result := '';
      Result := Result + '<!doctype html>'^M'<html>'^M'<head>'^M'<title>WREN module documentation</title>'^M'</head>'^M;
      Result := Result + '<h1><a name=''index'' id=''index''>WREN module documentation</a></h1>'^M;
      Result := Result + Format( '<h3>Version : %s</h3>'^M, [ aVersion]);
      Result := Result + '<p> COPYRIGHT 1999 - 2014 Blue Hell</p>';
      Result := Result + '<p>Look <a href=''http://bluehell.electro-music.com/modules/''>here</a> for more information.</p>'^M;
      Result := Result + MakeDocIndex;
      Result := Result + '<hr>';
    end;

    function    TFormStore.MakeDocFooter: string;
    begin
      Result := '';
      Result := Result + '<p> COPYRIGHT 1999 - 2014 Blue Hell</p>';
      Result := Result + '<p>Look <a href=''http://bluehell.electro-music.com/modules/''>here</a> for more information.</p>'^M;
      Result := Result + '<p>~~ fin ~~</p>';
      Result := Result + '</body>'^M'</html>';
    end;

    function    TFormStore.DoDocument( const aFolder, anImagesFolder, aVersion: string): string; // overload;
    var
      i : Integer;
    begin
      Result := MakeDocHeader( aVersion);
      for i := 0 to FModules.Count - 1
      do begin
        ShowModule( FModules[ i]);
        MakeImage( aFolder + anImagesFolder, FModules[ i]);
        Result := Result + DocumentModule( FModules[ i], anImagesFolder, i + 1);
      end;
      Result := Result + MakeDocFooter;
    end;

    procedure   TFormStore.Document( const aFolder, anImagesFolder, aVersion: string); // overload;
    var
      aFileName : string;
      aFile     : TextFile;
      Data      : string;
    begin
      Data := '';
      aFileName := aFolder + '\modules.html';
      AssignFile( aFile, aFileName);
      try
        Rewrite( aFile);
        Write( aFile, DoDocument( aFolder, anImagesFolder, aVersion));
      finally
        CloseFile( aFile);
      end;
    end;


// Delphi area



procedure TFormStore.FormCreate(Sender: TObject);
begin
  FModules := nil;
  RegisterModules;
end;


procedure TFormStore.FormDestroy(Sender: TObject);
begin
  FModules.RegisterComponents( False);
  if Assigned( FModules)
  then FModules.Free;
end;

end.
