/*
 * Decompiled with CFR 0.152.
 */
package oscP5;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Vector;
import netP5.AbstractTcpClient;
import netP5.Logger;
import netP5.NetAddress;
import netP5.NetAddressList;
import netP5.NetInfo;
import netP5.TcpClient;
import netP5.TcpPacket;
import netP5.TcpPacketListener;
import netP5.TcpServer;
import netP5.UdpPacketListener;
import oscP5.OscBundle;
import oscP5.OscEventListener;
import oscP5.OscIn;
import oscP5.OscMessage;
import oscP5.OscNetManager;
import oscP5.OscPacket;
import oscP5.OscPlug;
import oscP5.OscProperties;
import processing.core.PApplet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OscP5
implements UdpPacketListener,
TcpPacketListener {
    protected HashMap<String, ArrayList<OscPlug>> _myOscPlugMap = new HashMap();
    protected NetInfo _myNetInfo;
    private OscNetManager _myOscNetManager;
    protected static final int NONE = 0;
    public static final boolean ON = true;
    public static final boolean OFF = false;
    public static final int UDP = 0;
    public static final int MULTICAST = 1;
    public static final int TCP = 2;
    protected final Object parent;
    private OscProperties _myOscProperties;
    private Class<?> _myParentClass;
    private Method _myEventMethod;
    private Class<?> _myEventClass = OscMessage.class;
    private boolean isEventMethod;
    private boolean isBroadcast = false;
    private NetAddress _myBroadcastAddress;
    private boolean isOscIn = false;
    public static final String VERSION = "0.9.6";

    public OscP5(Object object, OscProperties oscProperties) {
        this.welcome();
        this.parent = object;
        if (this.parent instanceof PApplet) {
            ((PApplet)this.parent).registerDispose((Object)this);
        }
        this._myOscProperties = oscProperties;
        this._myOscNetManager = new OscNetManager();
        this._myOscNetManager.start(this._myOscProperties);
        if (this._myOscProperties.networkProtocol() == 2) {
            this._myOscNetManager.addTcpListener(this);
        } else {
            this._myOscNetManager.addUdpListener(this);
        }
        this.isEventMethod = this.checkEventMethod();
        if (this._myOscProperties.networkProtocol() == 1) {
            Logger.printInfo("OscP5", "is joining a multicast group @ " + this._myOscProperties.remoteAddress().address() + ":" + this._myOscProperties.remoteAddress().port());
        } else {
            Logger.printInfo("OscP5", "is running. you (" + this.ip() + ") are listening @ port " + this._myOscProperties.remoteAddress().port());
        }
    }

    public OscP5(Object object, String string, int n, int n2) {
        this.welcome();
        this.parent = object;
        this._myOscProperties = new OscProperties();
        if (this.parent instanceof PApplet) {
            ((PApplet)this.parent).registerDispose((Object)this);
        }
        switch (n2) {
            case 1: {
                this._myOscProperties.setNetworkProtocol(1);
                this._myOscProperties.setRemoteAddress(string, n);
                this._myOscProperties.setListeningPort(n);
                this._myOscNetManager = new OscNetManager();
                this._myOscNetManager.start(this._myOscProperties);
                this._myOscNetManager.addUdpListener(this);
                Logger.printInfo("OscP5", "is joining a multicast group @ " + this._myOscProperties.remoteAddress().address() + ":" + this._myOscProperties.remoteAddress().port());
                break;
            }
            case 0: {
                this._myOscProperties.setRemoteAddress(string, n);
                this.initUDP(n);
                break;
            }
            case 2: {
                this._myOscProperties.setNetworkProtocol(2);
                this._myOscProperties.setRemoteAddress(string, n);
                this._myOscNetManager = new OscNetManager();
                this._myOscNetManager.start(this._myOscProperties);
                this._myOscNetManager.addTcpListener(this);
            }
        }
        this.isEventMethod = this.checkEventMethod();
    }

    public OscP5(Object object, int n, int n2) {
        this.welcome();
        this.parent = object;
        if (this.parent instanceof PApplet) {
            ((PApplet)this.parent).registerDispose((Object)this);
        }
        this._myOscProperties = new OscProperties();
        switch (n2) {
            case 0: {
                this.initUDP(n);
                break;
            }
            case 2: {
                this._myOscProperties.setNetworkProtocol(2);
                this._myOscProperties.setListeningPort(n);
                this._myOscNetManager = new OscNetManager();
                this._myOscNetManager.start(this._myOscProperties);
                this._myOscNetManager.addTcpListener(this);
                break;
            }
            case 1: {
                Logger.printWarning("OscP5", "please specify a multicast address. use OscP5(Object theObject, String theMulticastAddress, int thePort, int theMode)");
            }
        }
        this.isEventMethod = this.checkEventMethod();
    }

    public OscP5(Object object, int n) {
        this.welcome();
        this.parent = object;
        if (this.parent instanceof PApplet) {
            ((PApplet)this.parent).registerDispose((Object)this);
        }
        this.initUDP(n);
        this.isEventMethod = this.checkEventMethod();
    }

    private void welcome() {
        System.out.println("OscP5 0.9.6 infos, comments, questions at http://www.sojamo.de/oscP5\n\n");
    }

    private void initUDP(int n) {
        this._myOscProperties = new OscProperties();
        this._myOscProperties.setListeningPort(n);
        this._myOscNetManager = new OscNetManager();
        this._myOscNetManager.start(this._myOscProperties);
        this._myOscNetManager.addUdpListener(this);
        Logger.printInfo("OscP5", "is running. you (" + this.ip() + ") are listening @ port " + n);
    }

    private boolean checkEventMethod() {
        Object object;
        this._myParentClass = this.parent.getClass();
        try {
            object = this._myParentClass.getDeclaredMethods();
            for (int i = 0; i < ((Method[])object).length; ++i) {
                Class<?>[] classArray;
                if (object[i].getName().indexOf(this._myOscProperties.eventMethod()) == -1 || (classArray = object[i].getParameterTypes()).length != 1) continue;
                this._myEventClass = classArray[0];
                this.isOscIn = this._myEventClass.toString().indexOf("OscIn") != -1;
                break;
            }
        }
        catch (Throwable throwable) {
            System.err.println(throwable);
        }
        object = this._myOscProperties.eventMethod();
        if (object != null) {
            try {
                Class[] classArray = new Class[]{this._myEventClass};
                this._myEventMethod = this._myParentClass.getDeclaredMethod((String)object, classArray);
                this._myEventMethod.setAccessible(true);
                return true;
            }
            catch (SecurityException securityException) {
                Logger.printWarning("OscP5.plug", "### security issues in OscP5.checkEventMethod(). (this occures when running in applet mode)");
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        return this._myEventMethod != null;
    }

    public String version() {
        return VERSION;
    }

    public void dispose() {
        this.stop();
    }

    public void addListener(OscEventListener oscEventListener) {
        this._myOscProperties.listeners().add(oscEventListener);
    }

    public void removeListener(OscEventListener oscEventListener) {
        this._myOscProperties.listeners().remove(oscEventListener);
    }

    public Vector<OscEventListener> listeners() {
        return this._myOscProperties.listeners();
    }

    public void plug(Object object, String string, String string2, String string3) {
        OscPlug oscPlug = new OscPlug();
        oscPlug.plug(object, string, string2, string3);
        if (this._myOscPlugMap.containsKey(string2)) {
            this._myOscPlugMap.get(string2).add(oscPlug);
        } else {
            ArrayList<OscPlug> arrayList = new ArrayList<OscPlug>();
            arrayList.add(oscPlug);
            this._myOscPlugMap.put(string2, arrayList);
        }
    }

    public void plug(Object object, String string, String string2) {
        Class<?> clazz = object.getClass();
        Method[] methodArray = clazz.getDeclaredMethods();
        Class<?>[] classArray = null;
        for (int i = 0; i < methodArray.length; ++i) {
            String string3 = "";
            try {
                methodArray[i].setAccessible(true);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (!methodArray[i].getName().equals(string)) continue;
            classArray = methodArray[i].getParameterTypes();
            OscPlug oscPlug = new OscPlug();
            for (int j = 0; j < classArray.length; ++j) {
                string3 = string3 + oscPlug.checkType(classArray[j].getName());
            }
            oscPlug.plug(object, string, string2, string3);
            if (this._myOscPlugMap.containsKey(string2)) {
                this._myOscPlugMap.get(string2).add(oscPlug);
                continue;
            }
            ArrayList<OscPlug> arrayList = new ArrayList<OscPlug>();
            arrayList.add(oscPlug);
            this._myOscPlugMap.put(string2, arrayList);
        }
    }

    private void handleSystemMessage(OscMessage oscMessage) {
        if (oscMessage.addrPattern().startsWith("/sys/ping")) {
            this.send("/sys/pong", new Object[0], this._myBroadcastAddress);
        } else if (oscMessage.addrPattern().startsWith("/sys/register") && oscMessage.tcpConnection() != null && oscMessage.checkTypetag("s")) {
            oscMessage.tcpConnection().setName(oscMessage.get(0).stringValue());
        }
    }

    private void callMethod(OscMessage oscMessage) {
        OscPlug oscPlug;
        int n;
        if (oscMessage.addrPattern().startsWith("/sys/")) {
            this.handleSystemMessage(oscMessage);
        }
        for (int i = this.listeners().size() - 1; i >= 0; --i) {
            this.listeners().get(i).oscEvent(oscMessage);
        }
        if (oscMessage.isArray && this._myOscPlugMap.containsKey(oscMessage.addrPattern())) {
            ArrayList<OscPlug> arrayList = this._myOscPlugMap.get(oscMessage.addrPattern());
            for (n = 0; n < arrayList.size(); ++n) {
                oscPlug = arrayList.get(n);
                if (!oscPlug.isArray || !oscPlug.checkMethod(oscMessage, true)) continue;
                this.invoke(oscPlug.getObject(), oscPlug.getMethod(), oscMessage.argsAsArray());
            }
        }
        if (this._myOscPlugMap.containsKey(oscMessage.addrPattern())) {
            ArrayList<OscPlug> arrayList = this._myOscPlugMap.get(oscMessage.addrPattern());
            for (n = 0; n < arrayList.size(); ++n) {
                oscPlug = arrayList.get(n);
                if (oscPlug.isArray || !oscPlug.checkMethod(oscMessage, false)) continue;
                oscMessage.isPlugged = true;
                this.invoke(oscPlug.getObject(), oscPlug.getMethod(), oscMessage.arguments());
            }
        }
        Logger.printDebug("OscP5.callMethod ", "" + this.isEventMethod);
        if (this.isEventMethod) {
            try {
                if (this.isOscIn) {
                    this.invoke(this.parent, this._myEventMethod, new Object[]{new OscIn(oscMessage)});
                    Logger.printDebug("OscP5.callMethod ", "invoking OscIn " + this.isEventMethod);
                } else {
                    this.invoke(this.parent, this._myEventMethod, new Object[]{oscMessage});
                    Logger.printDebug("OscP5.callMethod ", "invoking OscMessage " + this.isEventMethod);
                }
            }
            catch (ClassCastException classCastException) {
                Logger.printError("OscHandler.callMethod", " ClassCastException." + classCastException);
            }
        }
    }

    private void invoke(Object object, Method method, Object[] objectArray) {
        try {
            method.invoke(object, objectArray);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace();
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        catch (InvocationTargetException invocationTargetException) {
            Logger.printError("OscP5", "ERROR. an error occured while forwarding an OscMessage\n to a method in your program. please check your code for any \npossible errors that might occur in the method where incoming\n OscMessages are parsed e.g. check for casting errors, possible\n nullpointers, array overflows ... .\nmethod in charge : " + method.getName() + "  " + invocationTargetException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(DatagramPacket datagramPacket, int n) {
        OscP5 oscP5 = this;
        synchronized (oscP5) {
            OscPacket oscPacket = OscPacket.parse(datagramPacket);
            if (oscPacket.isValid()) {
                if (oscPacket.type() == 1) {
                    for (int i = 0; i < ((OscBundle)oscPacket).size(); ++i) {
                        this.callMethod(((OscBundle)oscPacket).getMessage(i));
                    }
                } else {
                    this.callMethod((OscMessage)oscPacket);
                }
            }
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(TcpPacket tcpPacket, int n) {
        OscP5 oscP5 = this;
        synchronized (oscP5) {
            OscPacket oscPacket = OscPacket.parse(tcpPacket);
            if (oscPacket.isValid()) {
                if (oscPacket.type() == 1) {
                    for (int i = 0; i < ((OscBundle)oscPacket).size(); ++i) {
                        this.callMethod(((OscBundle)oscPacket).getMessage(i));
                    }
                } else {
                    this.callMethod((OscMessage)oscPacket);
                }
            }
            this.notifyAll();
        }
    }

    @Override
    public void remove(AbstractTcpClient abstractTcpClient) {
    }

    @Override
    public void status(int n) {
    }

    public OscProperties properties() {
        return this._myOscProperties;
    }

    public boolean isBroadcast() {
        return this.isBroadcast;
    }

    public String ip() {
        return NetInfo.getHostAddress();
    }

    public static void setLogStatus(int n, int n2) {
        Logger.set(n, n2);
    }

    public static void setLogStatus(int n) {
        for (int i = 0; i < 5; ++i) {
            Logger.set(i, n);
        }
    }

    public void setTimeToLive(int n) {
        this._myOscNetManager.setTimeToLive(n);
    }

    public void disconnect(NetAddress netAddress) {
        if (netAddress.isvalid() && netAddress.name.length() > 1) {
            String string = "/sys/disconnect/" + netAddress.name + "/" + netAddress.port();
            this.send(string, new Object[0], netAddress);
            this.isBroadcast = false;
            this._myBroadcastAddress = null;
        }
    }

    public void connect(NetAddress netAddress, String string, String[] stringArray) {
        if (netAddress.isvalid()) {
            this._myBroadcastAddress = netAddress;
            this._myBroadcastAddress.name = string;
            String string2 = "/sys/connect/" + string + "/" + this._myOscProperties.listeningPort();
            this.send(string2, (Object[])stringArray, this._myBroadcastAddress);
            this.isBroadcast = true;
        }
    }

    public NetInfo netInfo() {
        return this._myNetInfo;
    }

    public TcpServer tcpServer() {
        return this._myOscNetManager.tcpServer();
    }

    public TcpClient tcpClient() {
        return this._myOscNetManager.tcpClient();
    }

    public void send(OscPacket oscPacket, NetAddress netAddress) {
        this._myOscNetManager.send(oscPacket, netAddress);
    }

    public void send(OscPacket oscPacket) {
        this._myOscNetManager.send(oscPacket);
    }

    public void send(OscPacket oscPacket, NetAddressList netAddressList) {
        this._myOscNetManager.send(oscPacket, netAddressList);
    }

    public void send(String string, Object[] objectArray) {
        this._myOscNetManager.send(string, objectArray);
    }

    public void send(String string, Object[] objectArray, NetAddressList netAddressList) {
        this._myOscNetManager.send(string, objectArray, netAddressList);
    }

    public void send(String string, Object[] objectArray, NetAddress netAddress) {
        this._myOscNetManager.send(string, objectArray, netAddress);
    }

    public void send(String string, Object[] objectArray, String string2, int n) {
        this._myOscNetManager.send(string, objectArray, string2, n);
    }

    public void send(OscPacket oscPacket, TcpClient tcpClient) {
        tcpClient.send(oscPacket.getBytes());
    }

    public void send(String string, Object[] objectArray, TcpClient tcpClient) {
        this.send((OscPacket)new OscMessage(string, objectArray), tcpClient);
    }

    public void send(OscPacket oscPacket, String string, int n) {
        this._myOscNetManager.send(oscPacket, string, n);
    }

    public void stop() {
        Logger.printDebug("OscP5.stop", "starting to stop oscP5.");
        this._myOscNetManager.stop();
        Logger.printDebug("OscP5.stop", "stopping oscP5.");
    }

    public static void flush(OscMessage oscMessage, NetAddress netAddress) {
        OscP5.flush(oscMessage.getBytes(), netAddress);
    }

    public static void flush(String string, Object[] objectArray, NetAddress netAddress) {
        OscP5.flush(new OscMessage(string, objectArray).getBytes(), netAddress);
    }

    public static void flush(byte[] byArray, NetAddress netAddress) {
        try {
            DatagramSocket datagramSocket = new DatagramSocket();
            DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length, netAddress.inetaddress(), netAddress.port());
            datagramSocket.send(datagramPacket);
        }
        catch (SocketException socketException) {
            Logger.printError("OscP5.openSocket", "cant create socket " + socketException.getMessage());
        }
        catch (IOException iOException) {
            Logger.printError("OscP5.openSocket", "cant create multicastSocket " + iOException.getMessage());
        }
    }

    public static void flush(byte[] byArray, String string, int n) {
        OscP5.flush(byArray, new NetAddress(string, n));
    }

    public static void flush(OscMessage oscMessage, String string, int n) {
        OscP5.flush(oscMessage.getBytes(), new NetAddress(string, n));
    }

    public OscP5(Object object, String string, int n, int n2, String string2) {
        this.welcome();
        this.parent = object;
        if (this.parent instanceof PApplet) {
            ((PApplet)this.parent).registerDispose((Object)this);
        }
        this._myOscProperties = new OscProperties();
        this._myOscProperties.setRemoteAddress(string, n);
        this._myOscProperties.setListeningPort(n2);
        this._myOscProperties.setEventMethod(string2);
        this._myOscNetManager = new OscNetManager();
        this._myOscNetManager.start(this._myOscProperties);
        this._myOscNetManager.addUdpListener(this);
        this.isEventMethod = this.checkEventMethod();
    }

    public OscMessage newMsg(String string) {
        return new OscMessage(string);
    }

    public OscBundle newBundle() {
        return new OscBundle();
    }

    public void disconnectFromTEMP() {
    }

    public OscP5(Object object, String string, int n) {
        this(object, string, n, 1);
    }
}

