/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl;

import java.util.List;

public class GLRendererQuirks {
    public static final int NoDoubleBufferedPBuffer = 0;
    public static final int NoDoubleBufferedBitmap = 1;
    public static final int NoSetSwapInterval = 2;
    public static final int NoOffscreenBitmap = 3;
    public static final int NoSetSwapIntervalPostRetarget = 4;
    public static final int GLSLBuggyDiscard = 5;
    public static final int GLNonCompliant = 6;
    public static final int GLFlushBeforeRelease = 7;
    public static final int DontCloseX11Display = 8;
    public static final int NeedCurrCtx4ARBPixFmtQueries = 9;
    public static final int NeedCurrCtx4ARBCreateContext = 10;
    public static final int NoFullFBOSupport = 11;
    public static final int COUNT = 12;
    private static final String[] _names = new String[]{"NoDoubleBufferedPBuffer", "NoDoubleBufferedBitmap", "NoSetSwapInterval", "NoOffscreenBitmap", "NoSetSwapIntervalPostRetarget", "GLSLBuggyDiscard", "GLNonCompliant", "GLFlushBeforeRelease", "DontCloseX11Display", "NeedCurrCtx4ARBPixFmtQueries", "NeedCurrCtx4ARBCreateContext", "NoFullFBOSupport"};
    private final int _bitmask;

    public GLRendererQuirks(int[] nArray, int n, int n2) throws IllegalArgumentException {
        int n3 = 0;
        if (0 > n + n2 || n + n2 >= nArray.length) {
            throw new IllegalArgumentException("offset and len out of bounds: offset " + n + ", len " + n2 + ", array-len " + nArray.length);
        }
        for (int i = n; i < n + n2; ++i) {
            int n4 = nArray[i];
            GLRendererQuirks.validateQuirk(n4);
            n3 |= 1 << n4;
        }
        this._bitmask = n3;
    }

    public GLRendererQuirks(List<Integer> list) throws IllegalArgumentException {
        int n = 0;
        for (int i = 0; i < list.size(); ++i) {
            int n2 = list.get(i);
            GLRendererQuirks.validateQuirk(n2);
            n |= 1 << n2;
        }
        this._bitmask = n;
    }

    public final boolean exist(int n) throws IllegalArgumentException {
        GLRendererQuirks.validateQuirk(n);
        return 0 != (1 << n & this._bitmask);
    }

    public final StringBuilder toString(StringBuilder stringBuilder) {
        if (null == stringBuilder) {
            stringBuilder = new StringBuilder();
        }
        stringBuilder.append("[");
        boolean bl = true;
        for (int i = 0; i < 12; ++i) {
            int n = 1 << i;
            if (0 == (this._bitmask & n)) continue;
            if (!bl) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(GLRendererQuirks.toString(i));
            bl = false;
        }
        stringBuilder.append("]");
        return stringBuilder;
    }

    public final String toString() {
        return this.toString(null).toString();
    }

    public static void validateQuirk(int n) throws IllegalArgumentException {
        if (0 > n || n >= 12) {
            throw new IllegalArgumentException("Quirks must be in range [0..12[, but quirk: " + n);
        }
    }

    public static final String toString(int n) throws IllegalArgumentException {
        GLRendererQuirks.validateQuirk(n);
        return _names[n];
    }
}

