/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.util;

import com.jogamp.common.nio.Buffers;
import com.jogamp.opengl.util.GLBuffers;
import com.jogamp.opengl.util.GLPixelBuffer;
import com.jogamp.opengl.util.GLPixelStorageModes;
import com.jogamp.opengl.util.texture.Texture;
import com.jogamp.opengl.util.texture.TextureData;
import com.jogamp.opengl.util.texture.TextureIO;
import java.io.File;
import java.io.IOException;
import javax.media.opengl.GL;
import javax.media.opengl.GLDrawable;
import javax.media.opengl.GLException;

public class GLReadBufferUtil {
    protected final GLPixelBuffer.GLPixelBufferProvider pixelBufferProvider;
    protected final int componentCount;
    protected final int alignment;
    protected final Texture readTexture;
    protected final GLPixelStorageModes psm;
    protected GLPixelBuffer readPixelBuffer = null;
    protected TextureData readTextureData = null;

    public GLReadBufferUtil(boolean bl, boolean bl2) {
        this(GLPixelBuffer.defaultProvider, bl, bl2);
    }

    public GLReadBufferUtil(GLPixelBuffer.GLPixelBufferProvider gLPixelBufferProvider, boolean bl, boolean bl2) {
        this.pixelBufferProvider = gLPixelBufferProvider;
        this.componentCount = bl ? 4 : 3;
        this.alignment = bl ? 4 : 1;
        this.readTexture = bl2 ? new Texture(3553) : null;
        this.psm = new GLPixelStorageModes();
    }

    public GLPixelBuffer.GLPixelBufferProvider getPixelBufferProvider() {
        return this.pixelBufferProvider;
    }

    public boolean isValid() {
        return null != this.readTextureData && null != this.readPixelBuffer && this.readPixelBuffer.isValid();
    }

    public boolean hasAlpha() {
        return 4 == this.componentCount;
    }

    public GLPixelStorageModes getGLPixelStorageModes() {
        return this.psm;
    }

    public GLPixelBuffer getPixelBuffer() {
        return this.readPixelBuffer;
    }

    public void rewindPixelBuffer() {
        if (null != this.readPixelBuffer) {
            this.readPixelBuffer.rewind();
        }
    }

    public TextureData getTextureData() {
        return this.readTextureData;
    }

    public Texture getTexture() {
        return this.readTexture;
    }

    public void write(File file) {
        try {
            TextureIO.write(this.readTextureData, file);
            this.rewindPixelBuffer();
        }
        catch (IOException iOException) {
            throw new RuntimeException("can not write to file: " + file.getAbsolutePath(), iOException);
        }
    }

    public boolean readPixels(GL gL, boolean bl) {
        return this.readPixels(gL, 0, 0, null, null, bl);
    }

    public boolean readPixels(GL gL, int n, int n2, int[] nArray, int[] nArray2, boolean bl) {
        boolean bl2;
        int n3 = gL.glGetError();
        if (0 != n3) {
            System.err.println("Info: GLReadBufferUtil.readPixels: pre-exisiting GL error 0x" + Integer.toHexString(n3));
        }
        GLPixelBuffer.GLPixelAttributes gLPixelAttributes = this.pixelBufferProvider.getAttributes(gL, this.componentCount);
        int n4 = gL.isGL2GL3() && 3 == this.componentCount ? 6407 : (4 == this.componentCount ? 6408 : 6407);
        GLDrawable gLDrawable = gL.getContext().getGLReadDrawable();
        int n5 = null == nArray || gLDrawable.getWidth() < nArray[0] ? gLDrawable.getWidth() : nArray[0];
        int n6 = null == nArray2 || gLDrawable.getHeight() < nArray2[0] ? gLDrawable.getHeight() : nArray2[0];
        boolean bl3 = gLDrawable.isGLOriented() ? bl : !bl;
        int[] nArray3 = new int[1];
        int n7 = GLBuffers.sizeof(gL, nArray3, gLPixelAttributes.bytesPerPixel, n5, n6, 1, true);
        boolean bl4 = false;
        if (null == this.readPixelBuffer || this.readPixelBuffer.requiresNewBuffer(gL, n5, n6, n7)) {
            this.readPixelBuffer = this.pixelBufferProvider.allocate(gL, gLPixelAttributes, n5, n6, 1, true, n7);
            Buffers.rangeCheckBytes((Object)this.readPixelBuffer.buffer, (int)n7);
            try {
                this.readTextureData = new TextureData(gL.getGLProfile(), n4, n5, n6, 0, gLPixelAttributes, false, false, bl3, this.readPixelBuffer.buffer, null);
                bl4 = true;
            }
            catch (Exception exception) {
                this.readTextureData = null;
                this.readPixelBuffer = null;
                throw new RuntimeException("can not fetch offscreen texture", exception);
            }
        } else {
            this.readTextureData.setInternalFormat(n4);
            this.readTextureData.setWidth(n5);
            this.readTextureData.setHeight(n6);
            this.readTextureData.setPixelAttributes(gLPixelAttributes);
        }
        boolean bl5 = bl2 = null != this.readPixelBuffer && this.readPixelBuffer.isValid();
        if (bl2) {
            this.psm.setAlignment(gL, this.alignment, this.alignment);
            if (gL.isGL2GL3()) {
                gL.getGL2GL3().glPixelStorei(3330, this.readPixelBuffer.width);
            }
            this.readPixelBuffer.clear();
            try {
                gL.glReadPixels(n, n2, n5, n6, gLPixelAttributes.format, gLPixelAttributes.type, this.readPixelBuffer.buffer);
            }
            catch (GLException gLException) {
                bl2 = false;
                gLException.printStackTrace();
            }
            this.readPixelBuffer.position(n7);
            this.readPixelBuffer.flip();
            int n8 = gL.glGetError();
            if (0 != n8) {
                System.err.println("GLReadBufferUtil.readPixels: readPixels error 0x" + Integer.toHexString(n8) + " " + n5 + "x" + n6 + ", " + gLPixelAttributes + ", " + this.readPixelBuffer + ", sz " + n7);
                bl2 = false;
            }
            if (bl2 && null != this.readTexture) {
                if (bl4) {
                    this.readTexture.updateImage(gL, this.readTextureData);
                } else {
                    this.readTexture.updateSubImage(gL, this.readTextureData, 0, 0, 0, 0, 0, n5, n6);
                }
                this.readPixelBuffer.rewind();
            }
            this.psm.restore(gL);
        }
        return bl2;
    }

    public void dispose(GL gL) {
        if (null != this.readTexture) {
            this.readTexture.destroy(gL);
            this.readTextureData = null;
        }
        if (null != this.readPixelBuffer) {
            this.readPixelBuffer.dispose();
            this.readPixelBuffer = null;
        }
    }
}

