/*
 * Decompiled with CFR 0.152.
 */
package themidibus;

public class Note {
    static String[] pitchMap = new String[]{"C", "C#", "D", "D#", "E", "F", "F#", "G", "G#", "A", "A#", "B"};
    public int channel;
    public int pitch;
    public int velocity;
    public long ticks;
    public long timestamp;
    public String bus_name;

    public Note(int n, int n2, int n3) {
        this(n, n2, n3, 0, -1L, null);
    }

    public Note(int n, int n2, int n3, int n4) {
        this(n, n2, n3, n4, -1L, null);
    }

    public Note(int n, int n2, int n3, long l, String string) {
        this(n, n2, n3, 0, l, string);
    }

    public Note(int n, int n2, int n3, int n4, long l, String string) {
        this.channel = n;
        this.pitch = n2;
        this.velocity = n3;
        this.ticks = n4;
        this.timestamp = l;
        this.bus_name = string;
    }

    public void setChannel(int n) {
        this.channel = n;
    }

    public int channel() {
        return this.channel;
    }

    public void setPitch(int n) {
        this.pitch = n;
    }

    public int pitch() {
        return this.pitch;
    }

    public int relativePitch() {
        return this.pitch;
    }

    public int octave() {
        return this.pitch / 12;
    }

    public String name() {
        return pitchMap[this.pitch % 12];
    }

    public void setVelocity(int n) {
        this.velocity = n;
    }

    public int velocity() {
        return this.velocity;
    }

    public void setTicks(int n) {
        this.ticks = n;
    }

    public long ticks() {
        return this.ticks;
    }

    public String toString() {
        String string = "[" + this.name() + ", c:" + this.channel + ", p:" + this.pitch + ", v:" + this.velocity;
        if (this.ticks != 0L) {
            string = string + ", t:" + this.ticks;
        }
        if (this.timestamp != -1L) {
            string = string + ", ts:" + this.timestamp;
        }
        if (this.bus_name != null) {
            string = string + ", b:" + this.bus_name;
        }
        string = string + "]";
        return string;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Note note = (Note)object;
        if (note.channel != this.channel) {
            return false;
        }
        if (note.pitch != this.pitch) {
            return false;
        }
        if (note.velocity != this.velocity) {
            return false;
        }
        if (note.ticks != this.ticks) {
            return false;
        }
        if (note.timestamp != this.timestamp) {
            return false;
        }
        return note.bus_name == this.bus_name;
    }
}

