/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.common.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public class ArrayHashSet<E>
implements Cloneable,
Collection<E>,
List<E> {
    private final HashMap<E, E> map;
    private final ArrayList<E> data;

    public ArrayHashSet() {
        this.map = new HashMap();
        this.data = new ArrayList();
    }

    public ArrayHashSet(int n) {
        this.map = new HashMap(n);
        this.data = new ArrayList(n);
    }

    public ArrayHashSet(int n, float f) {
        this.map = new HashMap(n, f);
        this.data = new ArrayList(n);
    }

    public final Object clone() {
        ArrayList<E> arrayList = new ArrayList<E>(this.data);
        ArrayHashSet<E> arrayHashSet = new ArrayHashSet<E>();
        arrayHashSet.addAll(arrayList);
        return arrayHashSet;
    }

    public final ArrayList<E> getData() {
        return this.data;
    }

    public final HashMap<E, E> getMap() {
        return this.map;
    }

    public final String toString() {
        return this.data.toString();
    }

    @Override
    public final void clear() {
        this.data.clear();
        this.map.clear();
    }

    @Override
    public final boolean add(E e) {
        boolean bl = this.map.containsKey(e);
        if (!bl) {
            if (null != this.map.put(e, e)) {
                throw new InternalError("Already existing, but checked before: " + e);
            }
            if (!this.data.add(e)) {
                throw new InternalError("Couldn't add element: " + e);
            }
        }
        return !bl;
    }

    @Override
    public final boolean remove(Object object) {
        if (null != this.map.remove(object)) {
            if (!this.data.remove(object)) {
                throw new InternalError("Couldn't remove prev mapped element: " + object);
            }
            return true;
        }
        return false;
    }

    @Override
    public final boolean addAll(Collection<? extends E> collection) {
        boolean bl = false;
        for (E e : collection) {
            bl |= this.add(e);
        }
        return bl;
    }

    @Override
    public final boolean contains(Object object) {
        return this.map.containsKey(object);
    }

    @Override
    public final boolean containsAll(Collection<?> collection) {
        for (Object obj : collection) {
            if (this.contains(obj)) continue;
            return false;
        }
        return true;
    }

    @Override
    public final boolean removeAll(Collection<?> collection) {
        boolean bl = false;
        for (Object obj : collection) {
            bl |= this.remove(obj);
        }
        return bl;
    }

    @Override
    public final boolean retainAll(Collection<?> collection) {
        boolean bl = false;
        for (Object obj : collection) {
            if (collection.contains(obj)) continue;
            bl |= this.remove(obj);
        }
        return bl;
    }

    @Override
    public final boolean equals(Object object) {
        if (!(object instanceof ArrayHashSet)) {
            return false;
        }
        return this.data.equals(((ArrayHashSet)object).data);
    }

    @Override
    public final int hashCode() {
        return this.data.hashCode();
    }

    @Override
    public final boolean isEmpty() {
        return this.data.isEmpty();
    }

    @Override
    public final Iterator<E> iterator() {
        return this.data.iterator();
    }

    @Override
    public final int size() {
        return this.data.size();
    }

    @Override
    public final Object[] toArray() {
        return this.data.toArray();
    }

    @Override
    public final <T> T[] toArray(T[] TArray) {
        return this.data.toArray(TArray);
    }

    @Override
    public final E get(int n) {
        return this.data.get(n);
    }

    @Override
    public final int indexOf(Object object) {
        return this.data.indexOf(object);
    }

    @Override
    public final void add(int n, E e) {
        if (this.map.containsKey(e)) {
            throw new IllegalArgumentException("Element " + e + " is already contained");
        }
        if (null != this.map.put(e, e)) {
            throw new InternalError("Already existing, but checked before: " + e);
        }
        this.data.add(n, e);
    }

    @Override
    public final boolean addAll(int n, Collection<? extends E> collection) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public final E set(int n, E e) {
        E e2 = this.remove(n);
        if (null != e2) {
            this.add(n, e);
        }
        return e2;
    }

    @Override
    public final E remove(int n) {
        E e = this.get(n);
        if (null != e && this.remove(e)) {
            return e;
        }
        return null;
    }

    @Override
    public final int lastIndexOf(Object object) {
        return this.indexOf(object);
    }

    @Override
    public final ListIterator<E> listIterator() {
        return this.data.listIterator();
    }

    @Override
    public final ListIterator<E> listIterator(int n) {
        return this.data.listIterator(n);
    }

    @Override
    public final List<E> subList(int n, int n2) {
        return this.data.subList(n, n2);
    }

    public final ArrayList<E> toArrayList() {
        return new ArrayList<E>(this.data);
    }

    public final E get(Object object) {
        return this.map.get(object);
    }

    public final E getOrAdd(E e) {
        E e2 = this.get(e);
        if (null == e2) {
            if (!this.add(e)) {
                throw new InternalError("Key not mapped, but contained in list: " + e);
            }
            e2 = e;
        }
        return e2;
    }

    public final boolean containsSafe(Object object) {
        return this.data.contains(object);
    }
}

