/*
 * Decompiled with CFR 0.152.
 */
import controlP5.ControlEvent;
import controlP5.ControlP5;
import controlP5.ListBox;
import controlP5.Numberbox;
import java.util.ArrayList;
import oscP5.OscMessage;
import oscP5.OscP5;
import processing.core.PApplet;
import processing.core.PFont;
import processing.serial.Serial;
import themidibus.MidiBus;

public class USB_Octomod_P5
extends PApplet {
    ControlP5 controlP5;
    Serial teensy;
    OscP5 oscP5;
    ListBox l;
    ListBox midiList;
    Numberbox portBox;
    MidiBus midi;
    int channel;
    int inputData;
    int updateBits = 3;
    int dacChip;
    int spiWord;
    String binaryString;
    ArrayList<Byte> outputData = new ArrayList();
    byte[] outputBytes;
    int dataIndex = 0;
    int[] data;
    double previousUpdate = 0.0;
    double currentTime;
    String portName;
    boolean serialConnected = false;
    int newPort = 9999;
    boolean portNeedsUpdate = false;
    int[] channelData;
    boolean[] newData;
    Slider[] sliders;
    Slider sliderOne;
    Slider sliderTwo;
    Slider sliderThree;
    Slider sliderFour;
    Slider sliderFive;
    Slider sliderSix;
    Slider sliderSeven;
    Slider sliderEight;
    PFont font;

    public void setup() {
        this.size(710, 175);
        this.frameRate(16.0f);
        this.midi = new MidiBus((PApplet)this, 0, 0);
        this.controlP5 = new ControlP5((PApplet)this);
        this.l = this.controlP5.addListBox("serialPorts", 550, 65, 140, 140);
        this.l.setItemHeight(15);
        this.l.setBarHeight(15);
        this.l.captionLabel().toUpperCase(true);
        this.l.captionLabel().set("serial ports");
        this.l.captionLabel().style().marginTop = 3;
        this.l.valueLabel().style().marginTop = 3;
        int n = 0;
        while (n < Serial.list().length) {
            this.l.addItem(Serial.list()[n], n);
            ++n;
        }
        this.midiList = this.controlP5.addListBox("midiPorts", 15, 33, 140, 140);
        this.midiList.setItemHeight(15);
        this.midiList.setBarHeight(15);
        this.midiList.captionLabel().toUpperCase(true);
        this.midiList.captionLabel().set("MIDI inputs");
        this.midiList.captionLabel().style().marginTop = 3;
        this.midiList.valueLabel().style().marginTop = 3;
        n = 0;
        while (n < MidiBus.availableInputs().length) {
            this.midiList.addItem(MidiBus.availableInputs()[n], n);
            ++n;
        }
        this.portBox = this.controlP5.addNumberbox("port", 550, 15, 140, 15);
        this.portBox.setValue(9999.0f);
        this.portBox.setId(1);
        this.portBox.setColorLabel(this.color(0, 0, 0));
        this.portBox.setDecimalPrecision(0);
        this.oscP5 = new OscP5((Object)this, 9999);
        this.outputData = new ArrayList();
        this.outputBytes = new byte[1];
        this.channelData = new int[8];
        this.newData = new boolean[8];
        this.data = new int[8];
        this.font = this.loadFont("Monaco-9.vlw");
        this.textFont(this.font, 9.0f);
        this.fill(100.0f, 200.0f, 50.0f);
        this.stroke(100.0f, 200.0f, 50.0f);
        this.sliders = new Slider[8];
        this.sliders[0] = new Slider(270, 40, 275);
        this.sliders[1] = new Slider(270, 55, 275);
        this.sliders[2] = new Slider(270, 70, 275);
        this.sliders[3] = new Slider(270, 85, 275);
        this.sliders[4] = new Slider(270, 100, 275);
        this.sliders[5] = new Slider(270, 115, 275);
        this.sliders[6] = new Slider(270, 130, 275);
        this.sliders[7] = new Slider(270, 145, 275);
    }

    public void draw() {
        if (!this.mousePressed && this.portNeedsUpdate) {
            this.oscP5.dispose();
            this.oscP5 = new OscP5((Object)this, this.newPort);
            this.portNeedsUpdate = false;
        }
        this.background(250.0f, 250.0f, 255.0f);
        this.fill(0.0f, 0.0f, 0.0f, 100.0f);
        this.rect(10.0f, 10.0f, this.width - 20, this.height - 20);
        this.fill(250.0f, 255.0f, 255.0f, 200.0f);
        this.rect(160.0f, 15.0f, 385.0f, 144.0f);
        this.fill(0.0f, 0.0f, 0.0f);
        this.stroke(0.0f, 0.0f, 0.0f);
        this.text("SERIAL: " + this.portName + " OSC: LISTENING ON PORT: " + this.newPort + ".", 165.0f, 30.0f);
        this.text("/CHANNEL 1: " + this.channelData[0], 165.0f, 45.0f);
        this.text("/CHANNEL 2: " + this.channelData[1], 165.0f, 60.0f);
        this.text("/CHANNEL 3: " + this.channelData[2], 165.0f, 75.0f);
        this.text("/CHANNEL 4: " + this.channelData[3], 165.0f, 90.0f);
        this.text("/CHANNEL 5: " + this.channelData[4], 165.0f, 105.0f);
        this.text("/CHANNEL 6: " + this.channelData[5], 165.0f, 120.0f);
        this.text("/CHANNEL 7: " + this.channelData[6], 165.0f, 135.0f);
        this.text("/CHANNEL 8: " + this.channelData[7], 165.0f, 150.0f);
        int n = 0;
        while (n < 8) {
            this.sliders[n].update(this.channelData[n]);
            ++n;
        }
    }

    public void controllerChange(int n, int n2, int n3) {
        if (n2 >= 20 || n2 <= 27) {
            this.channelData[n2 - 20] = (int)USB_Octomod_P5.map((float)n3, (float)0.0f, (float)127.0f, (float)0.0f, (float)1023.0f);
            this.writeValue(n2 - 20, PApplet.parseInt((float)USB_Octomod_P5.map((float)n3, (float)0.0f, (float)127.0f, (float)0.0f, (float)1023.0f)));
        }
    }

    public void oscEvent(OscMessage oscMessage) {
        USB_Octomod_P5.println((Object)oscMessage);
        if (this.serialConnected && oscMessage.checkAddrPattern("/dac")) {
            int n = 0;
            while (n < 8) {
                this.data[n] = oscMessage.get(n).intValue();
                if (this.data[n] != this.channelData[n]) {
                    this.channelData[n] = this.data[n];
                    this.newData[n] = true;
                } else {
                    this.newData[n] = false;
                }
                ++n;
            }
            n = 0;
            while (n < 8) {
                USB_Octomod_P5.println((String)(String.valueOf(this.data[n]) + " " + this.channelData[n] + " " + this.newData[n]));
                if (this.newData[n]) {
                    USB_Octomod_P5.println((String)"new data sent over serial");
                    this.writeValue(n, this.channelData[n]);
                }
                ++n;
            }
        }
    }

    public void writeValue(int n, int n2) {
        this.dacChip = n > 3 ? 1 : 0;
        n <<= 14;
        this.updateBits = 12288;
        this.spiWord = (n |= this.updateBits) | (n2 <<= 2);
        this.binaryString = USB_Octomod_P5.binary((int)this.spiWord, (int)16);
        this.outputData.add(PApplet.parseByte((int)this.dacChip));
        this.outputData.add(PApplet.parseByte((int)USB_Octomod_P5.unbinary((String)this.binaryString.substring(0, 8))));
        this.outputData.add(PApplet.parseByte((int)USB_Octomod_P5.unbinary((String)this.binaryString.substring(8, 16))));
        this.currentTime = this.millis();
        if (this.outputData.size() >= 24 || this.currentTime - this.previousUpdate >= 10.0) {
            this.outputBytes = new byte[this.outputData.size()];
            int n3 = 0;
            while (n3 < this.outputData.size()) {
                this.outputBytes[n3] = this.outputData.get(n3);
                ++n3;
            }
            this.teensy.write(this.outputBytes);
            this.dataIndex = 0;
            this.outputData = new ArrayList();
            this.previousUpdate = this.currentTime;
        }
    }

    public void controlEvent(ControlEvent controlEvent) {
        if (controlEvent.isGroup()) {
            if (controlEvent.group().name() == "serialPorts") {
                this.teensy = new Serial((PApplet)this, Serial.list()[(int)controlEvent.group().value()], 115200);
                this.teensy.buffer(1);
                this.portName = Serial.list()[(int)controlEvent.group().value()];
                this.serialConnected = true;
                return;
            }
            if (controlEvent.group().name() == "midiPorts") {
                this.midi = new MidiBus((PApplet)this, MidiBus.availableInputs()[(int)controlEvent.group().value()], 1);
                USB_Octomod_P5.println((String)("MIDI port: " + MidiBus.availableInputs()[(int)controlEvent.group().value()] + " connected."));
                this.midi.clearOutputs();
                return;
            }
        }
        if (controlEvent.controller().id() == 1) {
            this.newPort = (int)controlEvent.controller().value();
            this.portNeedsUpdate = true;
        }
    }

    public static void main(String[] stringArray) {
        PApplet.main((String[])new String[]{"--bgcolor=#FFFFFF", "USB_Octomod_P5"});
    }

    class Slider {
        int x;
        int y;
        int value;
        int center;
        int w = 265;
        int h = 12;

        Slider() {
        }

        Slider(int n, int n2, int n3) {
            this.x = n;
            this.y = n2;
            this.value = n3;
        }

        public int getX() {
            return this.x;
        }

        public int getY() {
            return this.y;
        }

        public void setX(int n) {
            this.x = n;
        }

        public void setY(int n) {
            this.y = n;
        }

        public int getValue() {
            return this.value;
        }

        public void setValue(int n) {
            this.value = n;
        }

        public void update(int n) {
            this.setValue(n);
            this.drawLine();
            this.drawPuck();
        }

        public void drawLine() {
            USB_Octomod_P5.this.line(this.x, this.y, this.x + this.w, this.y);
        }

        public void drawPuck() {
            this.center = (int)USB_Octomod_P5.map((float)this.value, (float)0.0f, (float)1023.0f, (float)0.0f, (float)this.w);
            USB_Octomod_P5.this.ellipse(this.x + this.center, this.y, 6.0f, 6.0f);
        }
    }
}

