/*
 * Decompiled with CFR 0.152.
 */
package controlP5;

import controlP5.ControlEvent;
import controlP5.ControlP5;
import controlP5.ControlP5Constants;
import controlP5.Controller;
import controlP5.ControllerPlug;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Vector;

public class ControlBroadcaster {
    private Vector<ControllerPlug> _myControllerPlugList;
    private int _myControlEventType = -1;
    private ControllerPlug _myControlEventPlug = null;
    private ControlP5 _myControlP5;
    private String _myEventMethod = "controlEvent";

    protected ControlBroadcaster(ControlP5 controlP5) {
        this._myControlP5 = controlP5;
        this._myControllerPlugList = new Vector();
        this.plug("", this._myEventMethod);
    }

    public void plug(String string, String string2) {
        if (string2.equals(this._myEventMethod)) {
            this._myControlEventPlug = ControlBroadcaster.checkObject(ControlP5.papplet, this._myEventMethod, new Class[]{ControlEvent.class});
            if (this._myControlEventPlug != null) {
                this._myControlEventType = 0;
            }
            return;
        }
        Controller controller = this._myControlP5.controller(string);
        if (controller != null) {
            controller.setTarget(string2);
            controller.setTargetObject(ControlP5.papplet);
            ControllerPlug controllerPlug = ControlBroadcaster.checkObject(ControlP5.papplet, string2, ControlP5Constants.acceptClassList);
            if (controllerPlug != null) {
                if (controller.controllerPlug() == null) {
                    this._myControllerPlugList.add(controllerPlug);
                    controller.setControllerPlug(controllerPlug);
                } else {
                    controller.controllerPlug().set(controllerPlug.object(), controllerPlug.name(), controllerPlug.type(), controllerPlug.parameterType(), ControlP5Constants.acceptClassList);
                }
            }
        } else {
            System.out.println("### Controller " + string + " does not exist.");
        }
    }

    protected static ControllerPlug checkObject(Object object, String string, Class[] classArray) {
        int n;
        Class<?> clazz = object.getClass();
        Method[] methodArray = clazz.getDeclaredMethods();
        for (int i = 0; i < methodArray.length; ++i) {
            if (!methodArray[i].getName().equals(string)) continue;
            if (methodArray[i].getParameterTypes().length == 1) {
                for (n = 0; n < classArray.length; ++n) {
                    if (methodArray[i].getParameterTypes()[0] != classArray[n]) continue;
                    return new ControllerPlug(object, string, 0, n, classArray);
                }
                break;
            }
            if (methodArray[i].getParameterTypes().length != 0) break;
            return new ControllerPlug(object, string, 0, -1, classArray);
        }
        Field[] fieldArray = clazz.getDeclaredFields();
        for (n = 0; n < fieldArray.length; ++n) {
            if (!fieldArray[n].getName().equals(string)) continue;
            for (int i = 0; i < classArray.length; ++i) {
                if (fieldArray[n].getType() != classArray[i]) continue;
                return new ControllerPlug(object, string, 1, i, classArray);
            }
            break;
        }
        return null;
    }

    public void broadcast(ControlEvent controlEvent, int n) {
        if (!controlEvent.isTab() && !controlEvent.isGroup() && controlEvent.controller().controllerPlug() != null) {
            if (n == 3) {
                this.callTarget(controlEvent.controller().controllerPlug().name(), controlEvent.stringValue());
            } else if (n != 4) {
                this.callTarget(controlEvent.controller().controllerPlug().name(), controlEvent.value());
            }
        }
        if (this._myControlEventType == 0) {
            this.invokeMethod(this._myControlEventPlug.object(), this._myControlEventPlug.getMethod(), new Object[]{controlEvent});
        }
    }

    protected void callTarget(String string, float f) {
        for (int i = 0; i < this._myControllerPlugList.size(); ++i) {
            if (!this._myControllerPlugList.get(i).checkName(string)) continue;
            ControllerPlug controllerPlug = this._myControllerPlugList.get(i);
            if (controllerPlug.checkType(0)) {
                this.invokeMethod(controllerPlug.object(), controllerPlug.getMethod(), controllerPlug.getMethodParameter(f));
                continue;
            }
            if (!controllerPlug.checkType(1)) continue;
            this.invokeField(controllerPlug.object(), controllerPlug.getField(), controllerPlug.getFieldParameter(f));
        }
    }

    protected void callTarget(String string, String string2) {
        for (int i = 0; i < this._myControllerPlugList.size(); ++i) {
            if (!this._myControllerPlugList.get(i).checkName(string)) continue;
            ControllerPlug controllerPlug = this._myControllerPlugList.get(i);
            if (controllerPlug.checkType(0)) {
                this.invokeMethod(controllerPlug.object(), controllerPlug.getMethod(), new Object[]{string2});
                continue;
            }
            if (!controllerPlug.checkType(1)) continue;
            this.invokeField(controllerPlug.object(), controllerPlug.getField(), string2);
        }
    }

    private void invokeField(Object object, Field field, Object object2) {
        try {
            field.set(object, object2);
        }
        catch (IllegalAccessException illegalAccessException) {
            System.out.println("### WARNING @ ControlBroadcaster.invokeField " + illegalAccessException);
        }
    }

    private void invokeMethod(Object object, Method method, Object[] objectArray) {
        try {
            if (objectArray[0] == null) {
                method.invoke(object, new Object[0]);
            } else {
                method.invoke(object, objectArray);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            System.out.println("### ERROR @ ControlP5.invokeMethod " + method.toString() + "  " + method.getName() + " " + objectArray.length + " " + illegalArgumentException);
        }
        catch (IllegalAccessException illegalAccessException) {
            this.printMethodError(method, illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            this.printMethodError(method, invocationTargetException);
        }
        catch (NullPointerException nullPointerException) {
            this.printMethodError(method, nullPointerException);
        }
    }

    private void printMethodError(Method method, Exception exception) {
        System.out.println("ERROR. an error occured while forwarding a Controller value\n to a method in your program. please check your code for any \npossible errors that might occur in this method .\n e.g. check for casting errors, possible nullpointers, array overflows ... .\nmethod: " + method.getName() + "\n" + "exception:  " + exception);
    }
}

