/*
 * Decompiled with CFR 0.152.
 */
package controlP5;

import controlP5.CColor;
import controlP5.ControlGroup;
import controlP5.ControlP5;
import controlP5.ControlP5XMLElement;
import controlP5.ControlWindow;
import controlP5.Controller;
import controlP5.ControllerGroup;
import controlP5.ControllerInterface;
import controlP5.ControllerList;
import controlP5.Radio;
import controlP5.ScrollList;
import controlP5.Tab;
import java.awt.Component;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.text.StringCharacterIterator;
import java.util.Calendar;
import java.util.Hashtable;
import java.util.Vector;

public class ControlP5IOHandler {
    ControlP5 controlP5;
    String _myFilePath;
    String _myUrlPath;
    boolean isLock;

    public ControlP5IOHandler(ControlP5 controlP5) {
        this.controlP5 = controlP5;
    }

    public static Image loadImage(URL uRL) {
        return ControlP5IOHandler.loadImage((Component)ControlP5.papplet, uRL);
    }

    public static Image loadImage(Component component, URL uRL) {
        if (component == null) {
            component = ControlP5.papplet;
        }
        Image image = null;
        image = Toolkit.getDefaultToolkit().createImage(uRL);
        MediaTracker mediaTracker = new MediaTracker(component);
        mediaTracker.addImage(image, 0);
        try {
            mediaTracker.waitForAll();
        }
        catch (InterruptedException interruptedException) {
            System.out.println("### ERROR " + interruptedException);
        }
        catch (Exception exception) {
            System.out.println("### ERROR at loadImage " + exception);
        }
        return image;
    }

    public static String forURL(String string) {
        String string2 = null;
        try {
            string2 = URLEncoder.encode(string, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException("UTF-8 not supported", unsupportedEncodingException);
        }
        return string2;
    }

    public static String forHTMLTag(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        StringCharacterIterator stringCharacterIterator = new StringCharacterIterator(string);
        char c = stringCharacterIterator.current();
        while (c != '\uffff') {
            if (c == '<') {
                stringBuffer.append("&lt;");
            } else if (c == '>') {
                stringBuffer.append("&gt;");
            } else if (c == '\"') {
                stringBuffer.append("&quot;");
            } else if (c == '\'') {
                stringBuffer.append("&#039;");
            } else if (c == '\\') {
                stringBuffer.append("&#092;");
            } else if (c == '&') {
                stringBuffer.append("&amp;");
            } else {
                stringBuffer.append(c);
            }
            c = stringCharacterIterator.next();
        }
        return stringBuffer.toString();
    }

    String URLEncode(String string) {
        String string2 = new String();
        try {
            byte[] byArray = string.getBytes("UTF-8");
            for (int i = 0; i < byArray.length; ++i) {
                if (byArray[i] < 0) continue;
                string2 = byArray[i] == 32 ? string2 + '+' : string2 + (char)byArray[i];
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
        }
        return string2;
    }

    public static String replace(String string, String string2, String string3) {
        if (string.length() < 1) {
            return "";
        }
        for (int i = 0; i < string.length() && (i = string.indexOf(string2, i)) >= 0; i += string3.length()) {
            string = string.substring(0, i) + string3 + string.substring(i + string2.length(), string.length());
        }
        return string;
    }

    public static int parseHex(String string) {
        int n = string.length();
        switch (n) {
            case 8: {
                break;
            }
            case 6: {
                string = "ff" + string;
                break;
            }
            default: {
                string = "ff000000";
            }
        }
        int n2 = new Integer(Integer.parseInt(string.substring(0, 2), 16));
        int n3 = new Integer(Integer.parseInt(string.substring(2, 4), 16));
        int n4 = new Integer(Integer.parseInt(string.substring(4, 6), 16));
        int n5 = new Integer(Integer.parseInt(string.substring(6, 8), 16));
        return n2 << 24 | n3 << 16 | n4 << 8 | n5;
    }

    public static String intToString(int n) {
        int n2 = n >> 24 & 0xFF;
        int n3 = n >> 16 & 0xFF;
        int n4 = n >> 8 & 0xFF;
        int n5 = n >> 0 & 0xFF;
        String string = Integer.toHexString(n2).length() == 1 ? "0" + Integer.toHexString(n2) : Integer.toHexString(n2);
        String string2 = Integer.toHexString(n3).length() == 1 ? "0" + Integer.toHexString(n3) : Integer.toHexString(n3);
        String string3 = Integer.toHexString(n4).length() == 1 ? "0" + Integer.toHexString(n4) : Integer.toHexString(n4);
        String string4 = Integer.toHexString(n5).length() == 1 ? "0" + Integer.toHexString(n5) : Integer.toHexString(n5);
        return string + string2 + string3 + string4;
    }

    protected boolean save(ControlP5 controlP5, String string) {
        Object object;
        Object object2;
        Object object3;
        String string2 = "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\n";
        ControlP5XMLElement controlP5XMLElement = new ControlP5XMLElement(new Hashtable(), true, false);
        controlP5XMLElement.setName("controlP5");
        Calendar calendar = Calendar.getInstance();
        controlP5XMLElement.setAttribute("date", calendar.getTime().toString());
        controlP5XMLElement.setAttribute("filepath", controlP5.filePath());
        controlP5XMLElement.setAttribute("urlpath", controlP5.urlPath());
        controlP5XMLElement.setAttribute("lock", "" + ControlP5.isLock);
        controlP5XMLElement.setAttribute("colorBackground", ControlP5IOHandler.intToString(controlP5.color.colorBackground));
        controlP5XMLElement.setAttribute("colorForeground", ControlP5IOHandler.intToString(controlP5.color.colorForeground));
        controlP5XMLElement.setAttribute("colorActive", ControlP5IOHandler.intToString(controlP5.color.colorActive));
        controlP5XMLElement.setAttribute("colorLabel", ControlP5IOHandler.intToString(controlP5.color.colorLabel));
        controlP5XMLElement.setAttribute("colorValue", ControlP5IOHandler.intToString(controlP5.color.colorValue));
        CColor cColor = new CColor(this.controlP5.color);
        for (int i = 0; i < controlP5.controlWindows().size(); ++i) {
            object3 = (ControlWindow)controlP5.controlWindows().get(i);
            object2 = ((ControlWindow)object3).tabs();
            object = ((ControlWindow)object3).getAsXML();
            if (!cColor.equals(((ControlWindow)object3).color)) {
                cColor.set(((ControlWindow)object3).color);
                ((ControlP5XMLElement)object).setAttribute("colorBackground", ControlP5IOHandler.intToString(cColor.colorBackground));
                ((ControlP5XMLElement)object).setAttribute("colorForeground", ControlP5IOHandler.intToString(cColor.colorForeground));
                ((ControlP5XMLElement)object).setAttribute("colorActive", ControlP5IOHandler.intToString(cColor.colorActive));
                ((ControlP5XMLElement)object).setAttribute("colorLabel", ControlP5IOHandler.intToString(cColor.colorLabel));
                ((ControlP5XMLElement)object).setAttribute("colorValue", ControlP5IOHandler.intToString(cColor.colorValue));
            }
            for (int j = 0; j < ((ControllerList)object2).size(); ++j) {
                ControllerGroup controllerGroup = (ControllerGroup)((ControllerList)object2).get(j);
                ControlP5XMLElement controlP5XMLElement2 = controllerGroup.getAsXML();
                ControllerList controllerList = controllerGroup.controllers;
                if (!cColor.equals(controllerGroup.color)) {
                    cColor.set(controllerGroup.color);
                    controlP5XMLElement2.setAttribute("colorBackground", ControlP5IOHandler.intToString(cColor.colorBackground));
                    controlP5XMLElement2.setAttribute("colorForeground", ControlP5IOHandler.intToString(cColor.colorForeground));
                    controlP5XMLElement2.setAttribute("colorActive", ControlP5IOHandler.intToString(cColor.colorActive));
                    controlP5XMLElement2.setAttribute("colorLabel", ControlP5IOHandler.intToString(cColor.colorLabel));
                    controlP5XMLElement2.setAttribute("colorValue", ControlP5IOHandler.intToString(cColor.colorValue));
                }
                for (int k = 0; k < controllerList.size(); ++k) {
                    if (!controllerList.get(k).isXMLsavable()) continue;
                    ControlP5XMLElement controlP5XMLElement3 = controllerList.get(k).getAsXML();
                    if (!cColor.equals(controllerList.get(k).color())) {
                        cColor.set(controllerList.get(k).color());
                        controlP5XMLElement3.setAttribute("colorBackground", ControlP5IOHandler.intToString(cColor.colorBackground));
                        controlP5XMLElement3.setAttribute("colorForeground", ControlP5IOHandler.intToString(cColor.colorForeground));
                        controlP5XMLElement3.setAttribute("colorActive", ControlP5IOHandler.intToString(cColor.colorActive));
                        controlP5XMLElement3.setAttribute("colorLabel", ControlP5IOHandler.intToString(cColor.colorLabel));
                        controlP5XMLElement3.setAttribute("colorValue", ControlP5IOHandler.intToString(cColor.colorValue));
                    }
                    controlP5XMLElement2.addChild(controlP5XMLElement3);
                }
                ((ControlP5XMLElement)object).addChild(controlP5XMLElement2);
            }
            controlP5XMLElement.addChild((ControlP5XMLElement)object);
        }
        if (controlP5.urlPath().toLowerCase().startsWith("http://") || controlP5.urlPath().toLowerCase().startsWith("https://")) {
            try {
                URL uRL = new URL(controlP5.urlPath());
                object3 = uRL.openConnection();
                ((HttpURLConnection)object3).setRequestMethod("POST");
                ((URLConnection)object3).setDoInput(true);
                ((URLConnection)object3).setDoOutput(true);
                object2 = new OutputStreamWriter(((URLConnection)object3).getOutputStream());
                ((Writer)object2).write("controlP5=" + ControlP5IOHandler.forURL(string2 + ControlP5IOHandler.replace(controlP5XMLElement.toString(), ">", ">\n")));
                ((OutputStreamWriter)object2).flush();
                ((OutputStreamWriter)object2).close();
                object = new BufferedReader(new InputStreamReader(((URLConnection)object3).getInputStream()));
                while (((BufferedReader)object).ready()) {
                    System.out.println(((BufferedReader)object).readLine());
                }
                System.out.println("uploading xml to " + controlP5.urlPath() + " .");
            }
            catch (Exception exception) {
                System.out.println("### ERROR ###\n### Error while uploading xml to " + controlP5.urlPath() + " " + exception);
            }
        }
        try {
            if (!ControlP5.papplet.online) {
                if (string.length() > 1) {
                    if (!string.startsWith("data/") && string.indexOf(47) == -1 && string.indexOf(92) == -1) {
                        string = "data/" + string;
                    }
                    ControlP5.papplet.saveStrings(string, new String[]{string2, ControlP5IOHandler.replace(controlP5XMLElement.toString(), ">", ">\n")});
                    System.out.println("ControlP5 writing file " + string + " to disk.");
                } else {
                    System.out.println("### ERROR ###\n### Please specify a filepath in order to save settings to xml.");
                }
            }
        }
        catch (Exception exception) {
            System.out.println("### WARNING ###\n### did not write to file " + string + " because of exception " + exception);
        }
        return true;
    }

    protected boolean parse(String string) {
        try {
            int n;
            boolean bl = this.controlP5.isAutoInitialization;
            this.controlP5.isAutoInitialization = false;
            ControlP5XMLElement controlP5XMLElement = new ControlP5XMLElement();
            controlP5XMLElement.parseString(string);
            Vector vector = controlP5XMLElement.getChildren();
            this._myFilePath = controlP5XMLElement.getStringAttribute("filepath");
            this._myUrlPath = controlP5XMLElement.getStringAttribute("urlpath");
            this.isLock = controlP5XMLElement.getStringAttribute("lock").equals("true");
            CColor cColor = new CColor();
            cColor.colorBackground = ControlP5IOHandler.parseHex(controlP5XMLElement.getStringAttribute("colorBackground"));
            cColor.colorForeground = ControlP5IOHandler.parseHex(controlP5XMLElement.getStringAttribute("colorForeground"));
            cColor.colorActive = ControlP5IOHandler.parseHex(controlP5XMLElement.getStringAttribute("colorActive"));
            cColor.colorLabel = ControlP5IOHandler.parseHex(controlP5XMLElement.getStringAttribute("colorLabel"));
            cColor.colorValue = ControlP5IOHandler.parseHex(controlP5XMLElement.getStringAttribute("colorValue"));
            for (n = 0; n < vector.size(); ++n) {
                ControlP5XMLElement controlP5XMLElement2 = (ControlP5XMLElement)vector.get(n);
                ControlWindow controlWindow = null;
                if (controlP5XMLElement2.getStringAttribute("colorBackground") != null) {
                    cColor.colorBackground = ControlP5IOHandler.parseHex(controlP5XMLElement2.getStringAttribute("colorBackground"));
                    cColor.colorForeground = ControlP5IOHandler.parseHex(controlP5XMLElement2.getStringAttribute("colorForeground"));
                    cColor.colorActive = ControlP5IOHandler.parseHex(controlP5XMLElement2.getStringAttribute("colorActive"));
                    cColor.colorLabel = ControlP5IOHandler.parseHex(controlP5XMLElement2.getStringAttribute("colorLabel"));
                    cColor.colorValue = ControlP5IOHandler.parseHex(controlP5XMLElement2.getStringAttribute("colorValue"));
                }
                if (controlP5XMLElement2.getStringAttribute("class").startsWith("controlP5.PAppletWindow")) {
                    controlWindow = this.controlP5.addControlWindow(controlP5XMLElement2.getStringAttribute("name"), controlP5XMLElement2.getIntAttribute("x"), controlP5XMLElement2.getIntAttribute("y"), controlP5XMLElement2.getIntAttribute("width"), controlP5XMLElement2.getIntAttribute("height"));
                    controlWindow.setBackground(ControlP5IOHandler.parseHex(controlP5XMLElement2.getStringAttribute("background")));
                } else {
                    controlWindow = this.controlP5.controlWindow;
                    this.controlP5.controlWindow.init();
                    this.controlP5.controlWindowList.add(this.controlP5.controlWindow);
                    controlWindow.setBackground(ControlP5IOHandler.parseHex(controlP5XMLElement2.getStringAttribute("background")));
                }
                Vector vector2 = controlP5XMLElement2.getChildren();
                String string2 = "default";
                for (int i = 0; i < vector2.size(); ++i) {
                    ControlP5XMLElement controlP5XMLElement3 = (ControlP5XMLElement)vector2.get(i);
                    string2 = controlP5XMLElement3.getStringAttribute("name");
                    Tab tab = this.controlP5.tab(controlWindow, string2);
                    tab.setLabel(controlP5XMLElement3.getStringAttribute("label"));
                    cColor = this.checkColor(controlP5XMLElement3, cColor);
                    tab.color.set(cColor);
                    Vector vector3 = controlP5XMLElement3.getChildren();
                    ControlGroup controlGroup = null;
                    for (int j = 0; j < vector3.size(); ++j) {
                        ControlP5XMLElement controlP5XMLElement4 = (ControlP5XMLElement)vector3.get(j);
                        if (controlP5XMLElement4.getName().equals("controller")) {
                            this.parseController(controlP5XMLElement4, controlGroup, tab, controlWindow, cColor);
                            continue;
                        }
                        if (!controlP5XMLElement4.getName().equals("group")) continue;
                        this.parseGroup(controlP5XMLElement4, controlGroup, tab, controlWindow, cColor);
                    }
                }
            }
            if (bl) {
                for (n = 0; n < this.controlP5.getControllerList().length; ++n) {
                    this.controlP5.getControllerList()[n].update();
                }
            }
            this.controlP5.isAutoInitialization = bl;
            return true;
        }
        catch (Exception exception) {
            System.out.println("ERROR unable to parse file. make sure the file exists. " + exception);
            exception.printStackTrace();
            return false;
        }
    }

    private void parseGroup(ControlP5XMLElement controlP5XMLElement, ControlGroup controlGroup, Tab tab, ControlWindow controlWindow, CColor cColor) {
        ControlGroup controlGroup2 = this.controlP5.addGroup(controlP5XMLElement.getStringAttribute("name"), (int)controlP5XMLElement.getDoubleAttribute("x"), (int)controlP5XMLElement.getDoubleAttribute("y"), (int)controlP5XMLElement.getDoubleAttribute("width"));
        controlGroup2.setLabel(controlP5XMLElement.getStringAttribute("label"));
        controlGroup2.setId(controlP5XMLElement.getIntAttribute("id"));
        controlGroup2.moveTo(controlGroup, tab, controlWindow);
        controlGroup2.setVisible((int)controlP5XMLElement.getDoubleAttribute("visible") > 0);
        controlGroup2.setMoveable((int)controlP5XMLElement.getDoubleAttribute("moveable") > 0);
        controlGroup2.setOpen((int)controlP5XMLElement.getDoubleAttribute("open") > 0);
        controlGroup = controlGroup2;
        cColor = this.checkColor(controlP5XMLElement, cColor);
        controlGroup2.color.set(cColor);
        Vector vector = controlP5XMLElement.getChildren();
        for (int i = 0; i < vector.size(); ++i) {
            ControlP5XMLElement controlP5XMLElement2 = (ControlP5XMLElement)vector.get(i);
            if (controlP5XMLElement2.getName().equals("controller")) {
                this.parseController(controlP5XMLElement2, controlGroup, tab, controlWindow, cColor);
                continue;
            }
            if (!controlP5XMLElement2.getName().equals("group")) continue;
            this.parseGroup(controlP5XMLElement2, controlGroup, tab, controlWindow, cColor);
        }
    }

    private void parseController(ControlP5XMLElement controlP5XMLElement, ControlGroup controlGroup, Tab tab, ControlWindow controlWindow, CColor cColor) {
        ControllerInterface controllerInterface = null;
        if (controlP5XMLElement.getStringAttribute("type").equals("slider")) {
            controllerInterface = this.controlP5.addSlider(controlP5XMLElement.getStringAttribute("name"), (float)controlP5XMLElement.getDoubleAttribute("min"), (float)controlP5XMLElement.getDoubleAttribute("max"), (float)controlP5XMLElement.getDoubleAttribute("value"), (int)controlP5XMLElement.getDoubleAttribute("x"), (int)controlP5XMLElement.getDoubleAttribute("y"), controlP5XMLElement.getIntAttribute("width"), controlP5XMLElement.getIntAttribute("height"));
            int n = controlP5XMLElement.getIntAttribute("id");
            controllerInterface.setId(n);
        } else if (controlP5XMLElement.getStringAttribute("type").equals("knob")) {
            controllerInterface = this.controlP5.addKnob(controlP5XMLElement.getStringAttribute("name"), (float)controlP5XMLElement.getDoubleAttribute("min"), (float)controlP5XMLElement.getDoubleAttribute("max"), (float)controlP5XMLElement.getDoubleAttribute("value"), (int)controlP5XMLElement.getDoubleAttribute("x"), (int)controlP5XMLElement.getDoubleAttribute("y"), controlP5XMLElement.getIntAttribute("width"));
            int n = controlP5XMLElement.getIntAttribute("id");
            controllerInterface.setId(n);
        } else if (controlP5XMLElement.getStringAttribute("type").equals("bang")) {
            controllerInterface = this.controlP5.addBang(controlP5XMLElement.getStringAttribute("name"), (int)controlP5XMLElement.getDoubleAttribute("x"), (int)controlP5XMLElement.getDoubleAttribute("y"), (int)controlP5XMLElement.getDoubleAttribute("width"), (int)controlP5XMLElement.getDoubleAttribute("height"));
            int n = controlP5XMLElement.getIntAttribute("id");
            controllerInterface.setId(n);
        } else if (controlP5XMLElement.getStringAttribute("type").equals("textarea")) {
            controllerInterface = this.controlP5.addTextarea(controlP5XMLElement.getStringAttribute("name"), controlP5XMLElement.getContent(), (int)controlP5XMLElement.getDoubleAttribute("x"), (int)controlP5XMLElement.getDoubleAttribute("y"), (int)controlP5XMLElement.getDoubleAttribute("width"), (int)controlP5XMLElement.getDoubleAttribute("height"));
            int n = controlP5XMLElement.getIntAttribute("id");
            controllerInterface.setId(n);
        } else if (controlP5XMLElement.getStringAttribute("type").equals("textlabel")) {
            controllerInterface = this.controlP5.addTextlabel(controlP5XMLElement.getStringAttribute("name"), controlP5XMLElement.getContent(), (int)controlP5XMLElement.getDoubleAttribute("x"), (int)controlP5XMLElement.getDoubleAttribute("y"));
            int n = controlP5XMLElement.getIntAttribute("id");
            controllerInterface.setId(n);
        } else if (controlP5XMLElement.getStringAttribute("type").equals("radio")) {
            int n;
            Radio radio = this.controlP5.addRadio(controlP5XMLElement.getStringAttribute("name"), (int)controlP5XMLElement.getDoubleAttribute("x"), (int)controlP5XMLElement.getDoubleAttribute("y"));
            Vector vector = controlP5XMLElement.getChildren();
            for (n = 0; n < vector.size(); ++n) {
                ControlP5XMLElement controlP5XMLElement2 = (ControlP5XMLElement)vector.get(n);
                String string = controlP5XMLElement2.getStringAttribute("name");
                int n2 = (int)controlP5XMLElement2.getDoubleAttribute("value");
                Radio.RadioToggle radioToggle = radio.addItem(string, n2);
                radioToggle.setId(controlP5XMLElement.getIntAttribute("id"));
                if (controlP5XMLElement2.getIntAttribute("state") != 1) continue;
                radio.activate(radioToggle.name());
            }
            controllerInterface = radio;
            n = controlP5XMLElement.getIntAttribute("id");
            controllerInterface.setId(n);
        } else if (controlP5XMLElement.getStringAttribute("type").equals("scrolllist")) {
            int n;
            ScrollList scrollList = this.controlP5.addScrollList(controlP5XMLElement.getStringAttribute("name"), (int)controlP5XMLElement.getDoubleAttribute("x"), (int)controlP5XMLElement.getDoubleAttribute("y"), (int)controlP5XMLElement.getDoubleAttribute("width"), (int)controlP5XMLElement.getDoubleAttribute("height"));
            Vector vector = controlP5XMLElement.getChildren();
            for (n = 0; n < vector.size(); ++n) {
                ControlP5XMLElement controlP5XMLElement3 = (ControlP5XMLElement)vector.get(n);
                scrollList.addItem(controlP5XMLElement3.getStringAttribute("name"), (int)controlP5XMLElement3.getDoubleAttribute("value")).setId(controlP5XMLElement3.getIntAttribute("id"));
            }
            scrollList.setOpen((int)controlP5XMLElement.getDoubleAttribute("open") > 0);
            controllerInterface = scrollList;
            n = controlP5XMLElement.getIntAttribute("id");
            controllerInterface.setId(n);
        } else if (controlP5XMLElement.getStringAttribute("type").equals("toggle")) {
            controllerInterface = this.controlP5.addToggle(controlP5XMLElement.getStringAttribute("name"), (double)((float)controlP5XMLElement.getDoubleAttribute("value")) > 0.5, (int)controlP5XMLElement.getDoubleAttribute("x"), (int)controlP5XMLElement.getDoubleAttribute("y"), (int)controlP5XMLElement.getDoubleAttribute("width"), (int)controlP5XMLElement.getDoubleAttribute("height"));
            int n = controlP5XMLElement.getIntAttribute("id");
            controllerInterface.setId(n);
        } else if (controlP5XMLElement.getStringAttribute("type").equals("textfield")) {
            controllerInterface = this.controlP5.addTextfield(controlP5XMLElement.getStringAttribute("name"), (int)controlP5XMLElement.getDoubleAttribute("x"), (int)controlP5XMLElement.getDoubleAttribute("y"), controlP5XMLElement.getIntAttribute("width"), controlP5XMLElement.getIntAttribute("height"));
            int n = controlP5XMLElement.getIntAttribute("id");
            controllerInterface.setId(n);
        } else if (controlP5XMLElement.getStringAttribute("type").equals("numberbox")) {
            controllerInterface = this.controlP5.addNumberbox(controlP5XMLElement.getStringAttribute("name"), (float)controlP5XMLElement.getDoubleAttribute("value"), (int)controlP5XMLElement.getDoubleAttribute("x"), (int)controlP5XMLElement.getDoubleAttribute("y"), (int)controlP5XMLElement.getDoubleAttribute("width"), (int)controlP5XMLElement.getDoubleAttribute("height"));
            int n = controlP5XMLElement.getIntAttribute("id");
            controllerInterface.setId(n);
        } else if (controlP5XMLElement.getStringAttribute("type").equals("button")) {
            controllerInterface = this.controlP5.addButton(controlP5XMLElement.getStringAttribute("name"), (float)controlP5XMLElement.getDoubleAttribute("value"), (int)controlP5XMLElement.getDoubleAttribute("x"), (int)controlP5XMLElement.getDoubleAttribute("y"), (int)controlP5XMLElement.getDoubleAttribute("width"), (int)controlP5XMLElement.getDoubleAttribute("height"));
            int n = controlP5XMLElement.getIntAttribute("id");
            controllerInterface.setId(n);
        }
        if (controllerInterface != null) {
            controllerInterface.setLabel(controlP5XMLElement.getStringAttribute("label"));
            controllerInterface.setId(controlP5XMLElement.getIntAttribute("id"));
            controllerInterface.moveTo(controlGroup, tab, controlWindow);
            if ((int)controlP5XMLElement.getDoubleAttribute("visible") > 0) {
                controllerInterface.show();
            } else {
                controllerInterface.hide();
            }
            cColor = this.checkColor(controlP5XMLElement, cColor);
            if (controllerInterface instanceof Controller) {
                ((Controller)controllerInterface).color().set(cColor);
            } else if (controllerInterface instanceof ControlGroup) {
                // empty if block
            }
        }
    }

    private CColor checkColor(ControlP5XMLElement controlP5XMLElement, CColor cColor) {
        if (controlP5XMLElement.getStringAttribute("colorBackground") != null) {
            cColor.colorBackground = ControlP5IOHandler.parseHex(controlP5XMLElement.getStringAttribute("colorBackground"));
            cColor.colorForeground = ControlP5IOHandler.parseHex(controlP5XMLElement.getStringAttribute("colorForeground"));
            cColor.colorActive = ControlP5IOHandler.parseHex(controlP5XMLElement.getStringAttribute("colorActive"));
            cColor.colorLabel = ControlP5IOHandler.parseHex(controlP5XMLElement.getStringAttribute("colorLabel"));
            cColor.colorValue = ControlP5IOHandler.parseHex(controlP5XMLElement.getStringAttribute("colorValue"));
        }
        return cColor;
    }
}

