/*
 * Decompiled with CFR 0.152.
 */
package controlP5;

import controlP5.CColor;
import controlP5.CDrawable;
import controlP5.CVector3f;
import controlP5.ControlCanvas;
import controlP5.ControlFont;
import controlP5.ControlGroup;
import controlP5.ControlP5;
import controlP5.ControlP5XMLElement;
import controlP5.ControlWindow;
import controlP5.Controller;
import controlP5.ControllerInterface;
import controlP5.ControllerList;
import controlP5.Label;
import controlP5.Tab;
import java.awt.event.KeyEvent;
import java.util.Hashtable;
import java.util.Vector;
import processing.core.PApplet;

public abstract class ControllerGroup
implements ControllerInterface {
    protected CVector3f position;
    protected CVector3f positionBuffer;
    protected CVector3f absolutePosition;
    protected ControllerList controllers;
    protected ControlWindow _myControlWindow;
    protected ControlP5 controlP5;
    protected ControllerGroup _myParent;
    protected String _myName;
    protected int _myId = -1;
    protected CColor color = new CColor();
    protected boolean isMousePressed = false;
    protected boolean isInside = false;
    protected boolean isVisible = true;
    protected boolean isOpen = true;
    protected boolean isMoveable = true;
    protected Label _myLabel;
    protected Label _myValueLabel;
    protected int _myWidth = 99;
    protected int _myHeight = 9;
    protected boolean isXMLsavable = true;
    protected boolean isUpdate;
    protected Vector<ControlCanvas> _myControlCanvas;
    protected float _myValue;
    protected String _myStringValue;
    protected float[] _myArrayValue;
    protected boolean isBarToggle = true;

    public ControllerGroup(ControlP5 controlP5, ControllerGroup controllerGroup, String string, float f, float f2) {
        this.position = new CVector3f(f, f2, 0.0f);
        this.controlP5 = controlP5;
        this.color.set(controllerGroup == null ? this.controlP5.color : controllerGroup.color);
        this._myName = string;
        this.controllers = new ControllerList();
        this._myControlCanvas = new Vector();
        this._myLabel = new Label(this._myName, this.color.colorLabel);
        this.setParent(controllerGroup == null ? this : controllerGroup);
    }

    protected ControllerGroup(int n, int n2) {
        this.position = new CVector3f(n, n2, 0.0f);
        this.controllers = new ControllerList();
        this._myControlCanvas = new Vector();
    }

    public void init() {
    }

    void setParent(ControllerGroup controllerGroup) {
        if (this._myParent != null && this._myParent != this) {
            this._myParent.remove(this);
        }
        this._myParent = controllerGroup;
        if (this._myParent != this) {
            this._myParent.add(this);
        }
        this.absolutePosition = new CVector3f(this.position);
        this.absolutePosition.add(this._myParent.absolutePosition());
        this.positionBuffer = new CVector3f(this.position);
        this._myControlWindow = this._myParent.getWindow();
        for (int i = 0; i < this.controllers.size(); ++i) {
            if (this.controllers.get(i) instanceof Controller) {
                ((Controller)this.controllers.get((int)i))._myControlWindow = this._myControlWindow;
                continue;
            }
            ((ControllerGroup)this.controllers.get((int)i))._myControlWindow = this._myControlWindow;
        }
    }

    public void setGroup(ControllerGroup controllerGroup) {
        this.setParent(controllerGroup);
    }

    public void setGroup(String string) {
        this.setParent(this.controlP5.getGroup(string));
    }

    public void moveTo(ControlGroup controlGroup, Tab tab, ControlWindow controlWindow) {
        if (controlGroup != null) {
            this.setGroup(controlGroup);
            return;
        }
        if (controlWindow == null) {
            controlWindow = this.controlP5.controlWindow;
        }
        this.setTab(controlWindow, tab.name());
    }

    public void moveTo(ControlGroup controlGroup) {
        this.moveTo(controlGroup, null, null);
    }

    public void moveTo(Tab tab) {
        this.moveTo(null, tab, null);
    }

    public void moveTo(ControlWindow controlWindow) {
        this.moveTo(null, controlWindow.tab("default"), controlWindow);
    }

    public void moveTo(String string) {
        this.moveTo(null, this.controlP5.controlWindow.tab(string), this.controlP5.controlWindow);
    }

    public void moveTo(String string, ControlWindow controlWindow) {
        this.moveTo(null, controlWindow.tab(string), controlWindow);
    }

    public void moveTo(Tab tab, ControlWindow controlWindow) {
        this.moveTo(null, tab, controlWindow);
    }

    public void setTab(String string) {
        this.setParent(this.controlP5.getTab(string));
    }

    public void setTab(ControlWindow controlWindow, String string) {
        this.setParent(this.controlP5.getTab(controlWindow, string));
    }

    public void setTab(Tab tab) {
        this.setParent(tab);
    }

    public Tab getTab() {
        if (this instanceof Tab) {
            return (Tab)this;
        }
        if (this._myParent instanceof Tab) {
            return (Tab)this._myParent;
        }
        return this._myParent.getTab();
    }

    protected void updateFont(ControlFont controlFont) {
        this._myLabel.updateFont(controlFont);
        if (this._myValueLabel != null) {
            this._myValueLabel.updateFont(controlFont);
        }
        for (int i = 0; i < this.controllers.size(); ++i) {
            if (this.controllers.get(i) instanceof Controller) {
                ((Controller)this.controllers.get(i)).updateFont(controlFont);
                continue;
            }
            ((ControllerGroup)this.controllers.get(i)).updateFont(controlFont);
        }
    }

    public CVector3f position() {
        return this.position;
    }

    public CVector3f absolutePosition() {
        return this.absolutePosition;
    }

    public void setPosition(float f, float f2) {
        this.position.set((int)f, (int)f2);
        this.positionBuffer.set(this.position);
        this.updateAbsolutePosition();
    }

    public void updateAbsolutePosition() {
        this.absolutePosition.set(this.position);
        this.absolutePosition.add(this._myParent.absolutePosition());
        for (int i = 0; i < this.controllers.size(); ++i) {
            this.controllers.get(i).updateAbsolutePosition();
        }
    }

    public void continuousUpdateEvents() {
        for (int i = this.controllers.size() - 1; i >= 0; --i) {
            this.controllers.get(i).continuousUpdateEvents();
        }
    }

    public void update() {
        for (int i = this.controllers.size() - 1; i >= 0; --i) {
            if (!this.controllers.get(i).isUpdate()) continue;
            this.controllers.get(i).update();
        }
    }

    public void setUpdate(boolean bl) {
        this.isUpdate = bl;
        for (int i = 0; i < this.controllers.size(); ++i) {
            this.controllers.get(i).setUpdate(bl);
        }
    }

    public boolean isUpdate() {
        return this.isUpdate;
    }

    public void updateEvents() {
        if (this.isOpen) {
            for (int i = this.controllers.size() - 1; i >= 0; --i) {
                this.controllers.get(i).updateEvents();
            }
        }
        if (this.isVisible && this.isMousePressed == this._myControlWindow.mouselock) {
            if (this.isMousePressed && ControlP5.keyHandler.isAltDown && this.isMoveable) {
                this.positionBuffer.x += (float)(this._myControlWindow.mouseX - this._myControlWindow.pmouseX);
                this.positionBuffer.y += (float)(this._myControlWindow.mouseY - this._myControlWindow.pmouseY);
                if (ControlP5.keyHandler.isShiftDown) {
                    this.position.x = (int)this.positionBuffer.x / 10 * 10;
                    this.position.y = (int)this.positionBuffer.y / 10 * 10;
                } else {
                    this.position.set(this.positionBuffer);
                }
                this.updateAbsolutePosition();
            } else if (this.inside()) {
                if (!this.isInside) {
                    this.isInside = true;
                    this.onEnter();
                }
            } else if (this.isInside && !this.isMousePressed) {
                this.onLeave();
                this.isInside = false;
            }
        }
    }

    public void updateInternalEvents(PApplet pApplet) {
    }

    public void draw(PApplet pApplet) {
        if (this.isVisible) {
            pApplet.pushMatrix();
            pApplet.translate(this.position.x(), this.position.y());
            this.preDraw(pApplet);
            this.drawControllers(pApplet);
            this.postDraw(pApplet);
            pApplet.popMatrix();
        }
    }

    protected void drawControllers(PApplet pApplet) {
        if (this.isOpen) {
            int n;
            for (n = 0; n < this._myControlCanvas.size(); ++n) {
                if (this._myControlCanvas.get(n).mode() != 0) continue;
                this._myControlCanvas.get(n).draw(pApplet);
            }
            for (n = 0; n < this.controllers.size(); ++n) {
                if (!this.controllers.get(n).isVisible()) continue;
                this.controllers.get(n).updateInternalEvents(pApplet);
                this.controllers.get(n).draw(pApplet);
            }
            for (n = 0; n < this.controllers.sizeDrawable(); ++n) {
                this.controllers.getDrawable(n).draw(pApplet);
            }
            for (n = 0; n < this._myControlCanvas.size(); ++n) {
                if (this._myControlCanvas.get(n).mode() != 1) continue;
                this._myControlCanvas.get(n).draw(pApplet);
            }
        }
    }

    protected void preDraw(PApplet pApplet) {
    }

    protected void postDraw(PApplet pApplet) {
    }

    public void addCanvas(ControlCanvas controlCanvas) {
        this._myControlCanvas.add(controlCanvas);
    }

    public void removeCanvas(ControlCanvas controlCanvas) {
        this._myControlCanvas.remove(controlCanvas);
    }

    public void add(ControllerInterface controllerInterface) {
        this.controllers.add(controllerInterface);
    }

    public void remove(ControllerInterface controllerInterface) {
        this.controllers.remove(controllerInterface);
    }

    public void addDrawable(CDrawable cDrawable) {
        this.controllers.addDrawable(cDrawable);
    }

    public void remove(CDrawable cDrawable) {
        this.controllers.removeDrawable(cDrawable);
    }

    public void remove() {
        if (this._myParent != null) {
            this._myParent.remove(this);
        }
        if (this.controlP5 != null) {
            this.controlP5.remove(this);
        }
        for (int i = this.controllers.size() - 1; i >= 0; --i) {
            this.controllers.get(i).remove();
        }
        this.controllers.clear();
        this.controllers.clearDrawable();
        this.controllers = new ControllerList();
        if (this instanceof Tab) {
            this._myControlWindow.removeTab((Tab)this);
        }
    }

    public String name() {
        return this._myName;
    }

    public ControlWindow getWindow() {
        return this._myControlWindow;
    }

    public void keyEvent(KeyEvent keyEvent) {
        for (int i = 0; i < this.controllers.size(); ++i) {
            this.controllers.get(i).keyEvent(keyEvent);
        }
    }

    public boolean setMousePressed(boolean bl) {
        if (!this.isVisible) {
            return false;
        }
        for (int i = this.controllers.size() - 1; i >= 0; --i) {
            if (!this.controllers.get(i).setMousePressed(bl)) continue;
            return true;
        }
        if (bl) {
            if (this.isInside) {
                this.isMousePressed = true;
                this.mousePressed();
                return true;
            }
        } else if (this.isMousePressed) {
            this.isMousePressed = false;
            this.mouseReleased();
        }
        return false;
    }

    void mousePressed() {
    }

    void mouseReleased() {
    }

    void onEnter() {
    }

    void onLeave() {
    }

    public void setId(int n) {
        this._myId = n;
    }

    public int id() {
        return this._myId;
    }

    public void setColorActive(int n) {
        this.color.colorActive = n;
        for (int i = 0; i < this.controllers.size(); ++i) {
            this.controllers.get(i).setColorActive(n);
        }
    }

    public void setColorForeground(int n) {
        this.color.colorForeground = n;
        for (int i = 0; i < this.controllers.size(); ++i) {
            this.controllers.get(i).setColorForeground(n);
        }
    }

    public void setColorBackground(int n) {
        this.color.colorBackground = n;
        for (int i = 0; i < this.controllers.size(); ++i) {
            this.controllers.get(i).setColorBackground(n);
        }
    }

    public void setColorLabel(int n) {
        this.color.colorLabel = n;
        if (this._myLabel != null) {
            this._myLabel.set(this._myLabel.toString(), this.color.colorLabel);
        }
        for (int i = 0; i < this.controllers.size(); ++i) {
            this.controllers.get(i).setColorLabel(n);
        }
    }

    public void setColorValue(int n) {
        this.color.colorValue = n;
        if (this._myValueLabel != null) {
            this._myValueLabel.set(this._myValueLabel.toString(), this.color.colorValue);
        }
        for (int i = 0; i < this.controllers.size(); ++i) {
            this.controllers.get(i).setColorValue(n);
        }
    }

    public void setLabel(String string) {
        this._myLabel.setFixedSize(false);
        this._myLabel.set(string);
        this._myLabel.setFixedSize(true);
    }

    public boolean isVisible() {
        return this.isVisible;
    }

    public void setVisible(boolean bl) {
        this.isVisible = bl;
    }

    public void hide() {
        this.isVisible = false;
    }

    public void show() {
        this.isVisible = true;
    }

    public void setMoveable(boolean bl) {
        this.isMoveable = bl;
    }

    public boolean isMoveable() {
        return this.isMoveable;
    }

    public void setOpen(boolean bl) {
        this.isOpen = bl;
        if (this._myValueLabel != null) {
            this._myValueLabel.set(this.isOpen ? "-" : "+");
        }
    }

    public boolean isOpen() {
        return this.isOpen;
    }

    public void open() {
        this.setOpen(true);
    }

    public void close() {
        this.setOpen(false);
    }

    public CColor color() {
        return this.color;
    }

    public CColor getColor() {
        return this.color;
    }

    public float value() {
        return this._myValue;
    }

    public String stringValue() {
        return this._myStringValue;
    }

    public float[] arrayValue() {
        return this._myArrayValue;
    }

    public Controller controller(String string) {
        return this.controlP5.controller(string);
    }

    public Label captionLabel() {
        return this._myLabel;
    }

    public Label valueLabel() {
        return this._myValueLabel;
    }

    protected boolean inside() {
        return (float)this._myControlWindow.mouseX > this.position.x() + this._myParent.absolutePosition().x() && (float)this._myControlWindow.mouseX < this.position.x() + this._myParent.absolutePosition().x() + (float)this._myWidth && (float)this._myControlWindow.mouseY > this.position.y() + this._myParent.absolutePosition().y() - (float)this._myHeight && (float)this._myControlWindow.mouseY < this.position.y() + this._myParent.absolutePosition().y();
    }

    public boolean isXMLsavable() {
        return this.isXMLsavable;
    }

    public ControlP5XMLElement getAsXML() {
        ControlP5XMLElement controlP5XMLElement = new ControlP5XMLElement(new Hashtable(), true, false);
        controlP5XMLElement.setAttribute("name", this.name());
        controlP5XMLElement.setAttribute("label", this._myLabel.toString());
        controlP5XMLElement.setAttribute("id", new Integer(this.id()));
        controlP5XMLElement.setAttribute("x", new Float(this.position().x()));
        controlP5XMLElement.setAttribute("y", new Float(this.position().y()));
        controlP5XMLElement.setAttribute("open", new Float(this.isOpen ? 1.0f : 0.0f));
        controlP5XMLElement.setAttribute("visible", new Float(this.isVisible ? 1.0f : 0.0f));
        controlP5XMLElement.setAttribute("moveable", new Float(this.isMoveable ? 1.0f : 0.0f));
        this.addToXMLElement(controlP5XMLElement);
        return controlP5XMLElement;
    }
}

