/*
 * Decompiled with CFR 0.152.
 */
package controlP5;

import controlP5.ControlEvent;
import controlP5.ControlGroup;
import controlP5.ControlP5;
import controlP5.ControllerGroup;
import controlP5.Toggle;
import java.util.Vector;

public class RadioButton
extends ControlGroup {
    protected Vector _myRadioToggles;
    protected int rowSpacing = 2;
    protected int columnSpacing = 2;
    protected int itemsPerRow = -1;
    protected boolean isMultipleChoice;
    protected int itemHeight = 11;
    protected int itemWidth = 11;

    public RadioButton(ControlP5 controlP5, ControllerGroup controllerGroup, String string, int n, int n2) {
        super(controlP5, controllerGroup, string, n, n2, 100, 9);
        this.isBarVisible = false;
        this.isBarToggle = false;
        this._myRadioToggles = new Vector();
        this.setItemsPerRow(1);
    }

    public Toggle addItem(String string, float f) {
        Toggle toggle = this.controlP5.addToggle(string, 0.0f, 0.0f, this.itemWidth, this.itemHeight);
        toggle.captionLabel().style().marginLeft = toggle.width + 4;
        toggle.captionLabel().style().marginTop = -toggle.height - 2;
        return this.addItem(toggle, f);
    }

    public Toggle addItem(Toggle toggle, float f) {
        toggle.setGroup(this);
        toggle.isMoveable = false;
        toggle.setInternalValue(f);
        toggle.isBroadcast = false;
        this._myRadioToggles.add(toggle);
        this.updateLayout();
        this.color().copyTo(toggle);
        toggle.addListener(this);
        this.updateValues(false);
        return toggle;
    }

    public void removeItem(String string) {
        int n = this._myRadioToggles.size();
        for (int i = 0; i < n; ++i) {
            if (!((Toggle)this._myRadioToggles.get(i)).name().equals(string)) continue;
            ((Toggle)this._myRadioToggles.get(i)).removeListener(this);
            this._myRadioToggles.remove(i);
        }
        this.updateValues(false);
    }

    public void setItemHeight(int n) {
        this.itemHeight = n;
    }

    public void setItemWidth(int n) {
        this.itemWidth = n;
    }

    public Toggle getItem(int n) {
        return (Toggle)this._myRadioToggles.get(n);
    }

    public boolean getState(int n) {
        if (n < this._myRadioToggles.size() && n >= 0) {
            return ((Toggle)this._myRadioToggles.get(n)).getState();
        }
        return false;
    }

    public boolean getState(String string) {
        int n = this._myRadioToggles.size();
        for (int i = 0; i < n; ++i) {
            Toggle toggle = (Toggle)this._myRadioToggles.get(i);
            if (!string.equals(toggle.name())) continue;
            return toggle.getState();
        }
        return false;
    }

    public void updateLayout() {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = this._myRadioToggles.size();
        for (int i = 0; i < n4; ++i) {
            Toggle toggle = (Toggle)this._myRadioToggles.get(i);
            toggle.position().y = n3;
            toggle.position().x = n2;
            n2 += toggle.width + this.columnSpacing;
            if (++n == this.itemsPerRow) {
                n = 0;
                this._myWidth = n2;
                n3 += toggle.height + this.rowSpacing;
                n2 = 0;
                continue;
            }
            this._myWidth = n2;
        }
    }

    public void setItemsPerRow(int n) {
        this.itemsPerRow = n;
        this.updateLayout();
    }

    public void setSpacingColumn(int n) {
        this.columnSpacing = n;
        this.updateLayout();
    }

    public void setSpacingRow(int n) {
        this.rowSpacing = n;
        this.updateLayout();
    }

    public void deactivateAll() {
        int n = this._myRadioToggles.size();
        for (int i = 0; i < n; ++i) {
            ((Toggle)this._myRadioToggles.get(i)).deactivate();
        }
        this._myValue = -1.0f;
        this.updateValues(true);
    }

    public void activate(int n) {
        int n2 = this._myRadioToggles.size();
        if (n < n2) {
            for (int i = 0; i < n2; ++i) {
                ((Toggle)this._myRadioToggles.get(i)).deactivate();
            }
            ((Toggle)this._myRadioToggles.get(n)).activate();
            this._myValue = ((Toggle)this._myRadioToggles.get(n)).value();
            this.updateValues(true);
        }
    }

    public void deactivate(int n) {
        if (n < this._myRadioToggles.size()) {
            Toggle toggle = (Toggle)this._myRadioToggles.get(n);
            if (toggle.isActive) {
                toggle.deactivate();
                this._myValue = -1.0f;
                this.updateValues(true);
            }
        }
    }

    public void activate(String string) {
        int n = this._myRadioToggles.size();
        for (int i = 0; i < n; ++i) {
            Toggle toggle = (Toggle)this._myRadioToggles.get(i);
            if (!string.equals(toggle.name())) continue;
            toggle.activate();
            this._myValue = toggle.value();
            this.updateValues(true);
            return;
        }
    }

    public void deactivate(String string) {
        int n = this._myRadioToggles.size();
        for (int i = 0; i < n; ++i) {
            Toggle toggle = (Toggle)this._myRadioToggles.get(i);
            if (!string.equals(toggle.name())) continue;
            toggle.deactivate();
            this._myValue = -1.0f;
            this.updateValues(true);
            return;
        }
    }

    public void toggle(int n) {
        System.out.println("RadioButton.toggle() not yet implemented, working on it.");
    }

    public void controlEvent(ControlEvent controlEvent) {
        if (!this.isMultipleChoice) {
            this._myValue = -1.0f;
            int n = this._myRadioToggles.size();
            for (int i = 0; i < n; ++i) {
                Toggle toggle = (Toggle)this._myRadioToggles.get(i);
                if (!toggle.equals(controlEvent.controller())) {
                    toggle.deactivate();
                    continue;
                }
                if (!toggle.isOn) continue;
                this._myValue = toggle.internalValue();
            }
        }
        this.updateValues(true);
    }

    protected void updateValues(boolean bl) {
        int n = this._myRadioToggles.size();
        this._myArrayValue = new float[n];
        for (int i = 0; i < n; ++i) {
            Toggle toggle = (Toggle)this._myRadioToggles.get(i);
            this._myArrayValue[i] = toggle.value();
        }
        if (bl) {
            ControlEvent controlEvent = new ControlEvent(this);
            this.controlP5.controlbroadcaster().broadcast(controlEvent, 1);
        }
    }
}

