/*
 * Decompiled with CFR 0.152.
 */
package controlP5;

import controlP5.CVector3f;
import controlP5.ControlP5;
import controlP5.ControlP5XMLElement;
import controlP5.Controller;
import controlP5.Tab;
import processing.core.PApplet;

public class Toggle
extends Controller {
    int cnt;
    protected boolean isOn = false;
    protected float internalValue = -1.0f;
    protected static int autoWidth = 20;
    protected static int autoHeight = 20;
    protected CVector3f autoSpacing = new CVector3f(10.0f, 20.0f, 0.0f);

    public Toggle(ControlP5 controlP5, Tab tab, String string, float f, float f2, float f3, int n, int n2) {
        super(controlP5, tab, string, f2, f3, n, n2);
        this._myValue = f;
    }

    public void draw(PApplet pApplet) {
        pApplet.pushMatrix();
        pApplet.translate(this.position().x(), this.position().y());
        if (this.isActive) {
            pApplet.fill(this.color.colorActive);
        } else {
            pApplet.fill(this.isOn ? this.color.colorActive : this.color.colorBackground);
        }
        pApplet.rect(0.0f, 0.0f, (float)this.width, (float)this.height);
        if (this.isLabelVisible) {
            this._myCaptionLabel.draw(pApplet, 0, this.height + 4);
        }
        pApplet.popMatrix();
    }

    protected void onEnter() {
        this.isActive = true;
    }

    protected void onLeave() {
        this.isActive = false;
    }

    public void mousePressed() {
        this.setState(!this.isOn);
        this.isActive = false;
    }

    public void setValue(float f) {
        if (f == 0.0f) {
            this.setState(false);
        } else {
            this.setState(true);
        }
    }

    public void update() {
        this.setValue(this._myValue);
    }

    public void setState(boolean bl) {
        this.isOn = bl;
        this._myValue = !this.isOn ? 0.0f : 1.0f;
        this.broadcast(1);
    }

    public boolean getState() {
        return this.isOn;
    }

    protected void deactivate() {
        this.isOn = false;
        this._myValue = !this.isOn ? 0.0f : 1.0f;
    }

    protected void activate() {
        this.isOn = true;
        this._myValue = !this.isOn ? 0.0f : 1.0f;
    }

    public void toggle() {
        if (this.isOn) {
            this.setState(false);
        } else {
            this.setState(true);
        }
    }

    public void addToXMLElement(ControlP5XMLElement controlP5XMLElement) {
        controlP5XMLElement.setAttribute("type", "toggle");
    }

    public void setInternalValue(float f) {
        this.internalValue = f;
    }

    public float internalValue() {
        return this.internalValue;
    }

    public Controller linebreak() {
        this.controlP5.linebreak(this, true, autoWidth, autoHeight, this.autoSpacing);
        return this;
    }
}

