/*
 Dmitry Ivanov
 BASSMASTER 85CT
 Instagram: @youcantignoremytechno
 Patreon: https://www.patreon.com/RhythmsOfButtocks
 */

#include "wavetables.h"

#define PIN_TONE            0   // Signal out
#define PIN_PWM             1   // Vactrol out
#define ENVELOPE_ATTACK     A0  // Pot
#define ENVELOPE_DECAY      A1  // Pot

#define C3                  304 // Pot
#define SEMITONE            1.059 // Pot

//7650 Hz
//Prescaler
//Semitone 1.059
//C3
unsigned int scale[60];

byte PLAY = LOW;
volatile byte OSC = LOW;
volatile int NOTE, _NOTE;
volatile unsigned char CHANNEL;

unsigned int envelopeACC = 0, toneACC, lpfACC, fatACC, envelopeINDEX = 0, lpfINDEX = 0;
unsigned char toneINDEX = 0, envelopePWM, _envelopePWM, envelopeLPF, PWM, FAT, WAVEFORM = 2;
signed int tonePWM;
unsigned int ADC_LFO, ADC_Envelope, ADC_Tone;

#include <DigiMIDICustom.h>
DigiMIDIDevice midi;

void setup() {
  pinMode(PIN_TONE, OUTPUT);
  pinMode(PIN_PWM, OUTPUT);
  pinMode(ENVELOPE_ATTACK, INPUT);
  pinMode(ENVELOPE_DECAY, INPUT);

  //Setup Timer1 and PWM
  TCCR1 = 1<<PWM1A | 1<<COM1A1 | 1<<CS10;
  TCCR0A |= 1<<COM0A1 | 1<<WGM02;
  GTCCR = 0;
  OCR1C = 255;
  TIMSK = 1<<OCIE1A;

  scale[0] = C3;
  for (toneINDEX = 1; toneINDEX <60; toneINDEX++){scale[toneINDEX] = scale[toneINDEX - 1] * SEMITONE;}
}

void loop() {

  _NOTE = NOTE;
  midi.update(); //Check if any MIDI data is received

  if (_NOTE == 0 && NOTE >0)
  {
    if (NOTE < 36) NOTE = 36;
    ADC_Tone = scale[NOTE - 36];

    WAVEFORM = CHANNEL;
    
    envelopeACC = 0;
    envelopeINDEX = 0;
    lpfACC = 0;
    lpfINDEX = 0;

    PLAY = HIGH;
  }
  
  if (_NOTE > 0 && NOTE == 0)
  {
    PLAY = LOW;
    //ATTACK = LOW;
    //DECAY = LOW;
    //SUSTAIN = LOW;
    //RELEASE = HIGH;
  }

  ADC_LFO = analogRead(ENVELOPE_ATTACK);
  if (ADC_LFO < 4) ADC_LFO = 4;

  if (PLAY == HIGH) // ATTACK
  {
    if (envelopeINDEX < 256)
    {
      envelopeACC += ADC_LFO >> 2;
      envelopeINDEX = envelopeACC >> 7;
      envelopePWM = pgm_read_byte(&adsr[envelopeINDEX]);
      
      if (envelopePWM < _envelopePWM){envelopePWM = _envelopePWM;}
    } 
    else {envelopePWM = 255;}
    _envelopePWM = envelopePWM;
  }
  
  //ADC_LFO = 255 - analogRead(ENVELOPE_DECAY);
  //if (ADC_LFO < 16) ADC_LFO = 16;

  ADC_LFO = 32;

  if (PLAY == LOW) // RELEASE
  {
    if (envelopeINDEX < 511)
    {
      envelopeACC += ADC_LFO >> 4;
      envelopeINDEX = envelopeACC >> 7;
      envelopePWM = pgm_read_byte(&adsr[envelopeINDEX]);
    } else {envelopePWM = 0;}
    _envelopePWM = envelopePWM;
  } 

  if (OSC == HIGH)
  {
    lpfINDEX = lpfACC >> 7;
    if (envelopeINDEX < 255) lpfINDEX = envelopeINDEX;
    envelopeLPF = pgm_read_byte(&wavetable[5][lpfINDEX]);
    //if (envelopeINDEX < 256) envelopeLPF = pgm_read_byte(&wavetable[5][lpfINDEX]);
    
    //if (CHANNEL == 0 || CHANNEL == 1) envelopeLPF = 255; 
    //if (CHANNEL == 2) envelopeLPF = pgm_read_byte(&adsr[255 + lpfINDEX]) >> 1; 
    //if (CHANNEL == 3) envelopeLPF = pgm_read_byte(&adsr[255 + lpfINDEX]) >> 1; 
    if (CHANNEL == 4) envelopeLPF = 255 - pgm_read_byte(&wavetable[2][envelopeINDEX >> 1]); 
    if (CHANNEL == 5) {WAVEFORM = 2; envelopeLPF = 0; if (PLAY == LOW) envelopeLPF = 255;} 
    if (CHANNEL == 6) {WAVEFORM = 3; envelopeLPF = FAT;} 
    
    fatACC += 2;
    FAT = pgm_read_byte(&wavetable[0][fatACC >> 8]);

    toneACC += ADC_Tone;
    toneINDEX = toneACC >> 8;
    tonePWM = pgm_read_byte(&wavetable[WAVEFORM][toneINDEX]);
    
    tonePWM -= 127;
    PWM = (32768 + (envelopePWM * tonePWM)) >> 8;

    OCR1A = PWM;
    OCR0A = envelopeLPF;
    OSC = LOW;
  }
}

ISR(TIMER1_COMPA_vect)
{
    OSC = HIGH;
}
