#define FORMS             6   // Number of waveforms
#define LENGTH            256 // Length of table

const char adsr[512] PROGMEM = {
    /*
    0x0, 0x7, 0xB, 0xF, 0x13, 0x17, 0x1B, 0x1E,  
    0x22, 0x26, 0x2A, 0x2D, 0x31, 0x34, 0x38, 0x3B,  
    0x3F, 0x42, 0x46, 0x49, 0x4D, 0x50, 0x53, 0x56,  
    0x5A, 0x5D, 0x60, 0x63, 0x66, 0x69, 0x6C, 0x6F,  
    0x72, 0x75, 0x78, 0x7B, 0x7E, 0x81, 0x84, 0x86,  
    0x89, 0x8C, 0x8F, 0x91, 0x94, 0x96, 0x99, 0x9B,  
    0x9E, 0xA0, 0xA3, 0xA5, 0xA8, 0xAA, 0xAC, 0xAE,  
    0xB1, 0xB3, 0xB5, 0xB7, 0xB9, 0xBB, 0xBD, 0xBF,  
    0xC1, 0xC3, 0xC5, 0xC7, 0xC9, 0xCB, 0xCD, 0xCE,  
    0xD0, 0xD2, 0xD4, 0xD5, 0xD7, 0xD8, 0xDA, 0xDB,  
    0xDD, 0xDE, 0xE0, 0xE1, 0xE3, 0xE4, 0xE5, 0xE6,  
    0xE8, 0xE9, 0xEA, 0xEB, 0xEC, 0xED, 0xEE, 0xEF,  
    0xF0, 0xF1, 0xF2, 0xF3, 0xF4, 0xF5, 0xF6, 0xF6,  
    0xF7, 0xF8, 0xF9, 0xF9, 0xFA, 0xFA, 0xFB, 0xFB,  
    0xFC, 0xFC, 0xFD, 0xFD, 0xFE, 0xFE, 0xFE, 0xFE,  
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  
    0xF3, 0xEF, 0xEB, 0xE8, 0xE5, 0xE3, 0xE1, 0xDF,  
    0xDD, 0xDB, 0xD9, 0xD7, 0xD6, 0xD4, 0xD3, 0xD1,  
    0xD0, 0xCF, 0xCD, 0xCC, 0xCB, 0xC9, 0xC8, 0xC7,  
    0xC6, 0xC5, 0xC4, 0xC3, 0xC2, 0xC1, 0xC0, 0xBF,  
    0xBE, 0xBD, 0xBC, 0xBB, 0xBA, 0xB9, 0xB8, 0xB7,  
    0xB6, 0xB5, 0xB4, 0xB3, 0xB3, 0xB2, 0xB1, 0xB0,  
    0xAF, 0xAF, 0xAE, 0xAD, 0xAC, 0xAB, 0xAB, 0xAA,  
    0xA9, 0xA8, 0xA8, 0xA7, 0xA6, 0xA5, 0xA5, 0xA4,  
    0xA3, 0xA3, 0xA2, 0xA1, 0xA1, 0xA0, 0x9F, 0x9F,  
    0x9E, 0x9D, 0x9D, 0x9C, 0x9B, 0x9B, 0x9A, 0x99,  
    0x99, 0x98, 0x97, 0x97, 0x96, 0x96, 0x95, 0x94,  
    0x94, 0x93, 0x93, 0x92, 0x91, 0x91, 0x90, 0x90,  
    0x8F, 0x8F, 0x8E, 0x8D, 0x8D, 0x8C, 0x8C, 0x8B,  
    0x8B, 0x8A, 0x89, 0x89, 0x88, 0x88, 0x87, 0x87,  
    0x86, 0x86, 0x85, 0x85, 0x84, 0x84, 0x83, 0x83,  
    0x82, 0x82, 0x81, 0x81, 0x80, 0x80, 0x7F, 0x7F, 
    0x7F, 0x77, 0x73, 0x71, 0x6F, 0x6D, 0x6B, 0x69,  
    0x68, 0x67, 0x65, 0x64, 0x63, 0x62, 0x61, 0x60,  
    0x5F, 0x5E, 0x5D, 0x5C, 0x5B, 0x5A, 0x59, 0x58,  
    0x57, 0x57, 0x56, 0x55, 0x54, 0x54, 0x53, 0x52,  
    0x51, 0x51, 0x50, 0x4F, 0x4F, 0x4E, 0x4D, 0x4D,  
    0x4C, 0x4B, 0x4B, 0x4A, 0x4A, 0x49, 0x48, 0x48,  
    0x47, 0x47, 0x46, 0x45, 0x45, 0x44, 0x44, 0x43,  
    0x43, 0x42, 0x42, 0x41, 0x41, 0x40, 0x40, 0x3F,  
    0x3F, 0x3E, 0x3E, 0x3D, 0x3D, 0x3C, 0x3C, 0x3B,  
    0x3B, 0x3A, 0x3A, 0x39, 0x39, 0x38, 0x38, 0x38,  
    0x37, 0x37, 0x36, 0x36, 0x35, 0x35, 0x34, 0x34,  
    0x34, 0x33, 0x33, 0x32, 0x32, 0x32, 0x31, 0x31,  
    0x30, 0x30, 0x2F, 0x2F, 0x2F, 0x2E, 0x2E, 0x2D,  
    0x2D, 0x2D, 0x2C, 0x2C, 0x2C, 0x2B, 0x2B, 0x2A,  
    0x2A, 0x2A, 0x29, 0x29, 0x29, 0x28, 0x28, 0x27,  
    0x27, 0x27, 0x26, 0x26, 0x26, 0x25, 0x25, 0x25,  
    0x24, 0x24, 0x23, 0x23, 0x23, 0x22, 0x22, 0x22,  
    0x21, 0x21, 0x21, 0x20, 0x20, 0x20, 0x1F, 0x1F,  
    0x1F, 0x1E, 0x1E, 0x1E, 0x1D, 0x1D, 0x1D, 0x1C,  
    0x1C, 0x1C, 0x1B, 0x1B, 0x1B, 0x1A, 0x1A, 0x1A,  
    0x1A, 0x19, 0x19, 0x19, 0x18, 0x18, 0x18, 0x17,  
    0x17, 0x17, 0x16, 0x16, 0x16, 0x15, 0x15, 0x15,  
    0x15, 0x14, 0x14, 0x14, 0x13, 0x13, 0x13, 0x12,  
    0x12, 0x12, 0x12, 0x11, 0x11, 0x11, 0x10, 0x10,  
    0x10, 0x10, 0xF, 0xF, 0xF, 0xE, 0xE, 0xE,  
    0xE, 0xD, 0xD, 0xD, 0xC, 0xC, 0xC, 0xC,  
    0xB, 0xB, 0xB, 0xB, 0xA, 0xA, 0xA, 0x9,  
    0x9, 0x9, 0x9, 0x8, 0x8, 0x8, 0x8, 0x7,  
    0x7, 0x7, 0x6, 0x6, 0x6, 0x6, 0x5, 0x5,  
    0x5, 0x5, 0x4, 0x4, 0x4, 0x4, 0x3, 0x3,  
    0x3, 0x3, 0x2, 0x2, 0x2, 0x2, 0x1, 0x1,  
    0x1, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0
     */

    0x1,  0x3,  0x5,  0x7,  0x9,  0xB,  0xD,  0xF,  
    0x11, 0x13, 0x15, 0x17, 0x19, 0x1B, 0x1D, 0x1E,  
    0x20, 0x22, 0x24, 0x26, 0x28, 0x2A, 0x2B, 0x2D,  
    0x2F, 0x31, 0x33, 0x34, 0x36, 0x38, 0x3A, 0x3B,  
    0x3D, 0x3F, 0x41, 0x42, 0x44, 0x46, 0x48, 0x49,  
    0x4B, 0x4D, 0x4E, 0x50, 0x52, 0x53, 0x55, 0x56,  
    0x58, 0x5A, 0x5B, 0x5D, 0x5F, 0x60, 0x62, 0x63,  
    0x65, 0x66, 0x68, 0x69, 0x6B, 0x6C, 0x6E, 0x6F,  
    0x71, 0x72, 0x74, 0x75, 0x77, 0x78, 0x7A, 0x7B,  
    0x7D, 0x7E, 0x80, 0x81, 0x82, 0x84, 0x85, 0x86,  
    0x88, 0x89, 0x8B, 0x8C, 0x8D, 0x8F, 0x90, 0x91,  
    0x93, 0x94, 0x95, 0x96, 0x98, 0x99, 0x9A, 0x9B,  
    0x9D, 0x9E, 0x9F, 0xA0, 0xA2, 0xA3, 0xA4, 0xA5,  
    0xA6, 0xA8, 0xA9, 0xAA, 0xAB, 0xAC, 0xAD, 0xAE,  
    0xB0, 0xB1, 0xB2, 0xB3, 0xB4, 0xB5, 0xB6, 0xB7,  
    0xB8, 0xB9, 0xBA, 0xBB, 0xBC, 0xBD, 0xBE, 0xBF,  
    0xC0, 0xC1, 0xC2, 0xC3, 0xC4, 0xC5, 0xC6, 0xC7,  
    0xC8, 0xC9, 0xCA, 0xCB, 0xCC, 0xCD, 0xCE, 0xCE,  
    0xCF, 0xD0, 0xD1, 0xD2, 0xD3, 0xD4, 0xD4, 0xD5,  
    0xD6, 0xD7, 0xD8, 0xD8, 0xD9, 0xDA, 0xDB, 0xDB,  
    0xDC, 0xDD, 0xDE, 0xDE, 0xDF, 0xE0, 0xE1, 0xE1,  
    0xE2, 0xE3, 0xE3, 0xE4, 0xE5, 0xE5, 0xE6, 0xE6,  
    0xE7, 0xE8, 0xE8, 0xE9, 0xEA, 0xEA, 0xEB, 0xEB,  
    0xEC, 0xEC, 0xED, 0xED, 0xEE, 0xEE, 0xEF, 0xEF,  
    0xF0, 0xF0, 0xF1, 0xF1, 0xF2, 0xF2, 0xF3, 0xF3,  
    0xF4, 0xF4, 0xF5, 0xF5, 0xF5, 0xF6, 0xF6, 0xF6,  
    0xF7, 0xF7, 0xF8, 0xF8, 0xF8, 0xF9, 0xF9, 0xF9,  
    0xFA, 0xFA, 0xFA, 0xFA, 0xFB, 0xFB, 0xFB, 0xFB,  
    0xFC, 0xFC, 0xFC, 0xFC, 0xFD, 0xFD, 0xFD, 0xFD,  
    0xFD, 0xFE, 0xFE, 0xFE, 0xFE, 0xFE, 0xFE, 0xFE,  
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xEF, 0xE8, 0xE3, 0xDF, 0xDB, 0xD7, 0xD4,  
    0xD1, 0xCF, 0xCC, 0xCA, 0xC7, 0xC5, 0xC3, 0xC1,  
    0xBF, 0xBD, 0xBB, 0xB9, 0xB7, 0xB5, 0xB4, 0xB2,  
    0xB0, 0xAF, 0xAD, 0xAC, 0xAA, 0xA9, 0xA7, 0xA6,  
    0xA4, 0xA3, 0xA1, 0xA0, 0x9F, 0x9D, 0x9C, 0x9B,  
    0x9A, 0x98, 0x97, 0x96, 0x95, 0x93, 0x92, 0x91,  
    0x90, 0x8F, 0x8E, 0x8C, 0x8B, 0x8A, 0x89, 0x88,  
    0x87, 0x86, 0x85, 0x84, 0x83, 0x82, 0x81, 0x80,  
    0x7F, 0x7E, 0x7D, 0x7C, 0x7B, 0x7A, 0x79, 0x78,  
    0x77, 0x76, 0x75, 0x74, 0x73, 0x72, 0x71, 0x71,  
    0x70, 0x6F, 0x6E, 0x6D, 0x6C, 0x6B, 0x6A, 0x6A,  
    0x69, 0x68, 0x67, 0x66, 0x65, 0x65, 0x64, 0x63,  
    0x62, 0x61, 0x60, 0x60, 0x5F, 0x5E, 0x5D, 0x5C,  
    0x5C, 0x5B, 0x5A, 0x59, 0x59, 0x58, 0x57, 0x56,  
    0x56, 0x55, 0x54, 0x53, 0x53, 0x52, 0x51, 0x50,  
    0x50, 0x4F, 0x4E, 0x4D, 0x4D, 0x4C, 0x4B, 0x4B,  
    0x4A, 0x49, 0x48, 0x48, 0x47, 0x46, 0x46, 0x45,  
    0x44, 0x44, 0x43, 0x42, 0x42, 0x41, 0x40, 0x40,  
    0x3F, 0x3E, 0x3E, 0x3D, 0x3C, 0x3C, 0x3B, 0x3A,  
    0x3A, 0x39, 0x38, 0x38, 0x37, 0x36, 0x36, 0x35,  
    0x35, 0x34, 0x33, 0x33, 0x32, 0x31, 0x31, 0x30,  
    0x30, 0x2F, 0x2E, 0x2E, 0x2D, 0x2C, 0x2C, 0x2B,  
    0x2B, 0x2A, 0x29, 0x29, 0x28, 0x28, 0x27, 0x26,  
    0x26, 0x25, 0x25, 0x24, 0x24, 0x23, 0x22, 0x22,  
    0x21, 0x21, 0x20, 0x20, 0x1F, 0x1E, 0x1E, 0x1D,  
    0x1D, 0x1C, 0x1C, 0x1B, 0x1A, 0x1A, 0x19, 0x19,  
    0x18, 0x18, 0x17, 0x17, 0x16, 0x15, 0x15, 0x14,  
    0x14, 0x13, 0x13, 0x12, 0x12, 0x11, 0x11, 0x10,  
    0x10, 0xF,  0xE,  0xE,  0xD,  0xD,  0xC,  0xC,  
    0xB,  0xB,  0xA,  0xA,  0x9,  0x9,  0x8,  0x8,  
    0x7,  0x7,  0x6,  0x6,  0x5,  0x5,  0x4,  0x4,  
    0x3,  0x3,  0x2,  0x2,  0x1,  0x1,  0x0,  0x0      
};

const char wavetable[FORMS][LENGTH] PROGMEM = { // sine wavetable
  // Sin wave #00
  {
  	0x0,0x0,0x0,0x0,0x1,0x1,0x1,0x2,
  	0x2,0x3,0x4,0x5,0x5,0x6,0x7,0x9,
  	0xa,0xb,0xc,0xe,0xf,0x11,0x12,0x14,
  	0x15,0x17,0x19,0x1b,0x1d,0x1f,0x21,0x23,
  	0x25,0x28,0x2a,0x2c,0x2f,0x31,0x34,0x36,
  	0x39,0x3b,0x3e,0x41,0x43,0x46,0x49,0x4c,
  	0x4f,0x52,0x55,0x58,0x5a,0x5d,0x61,0x64,
  	0x67,0x6a,0x6d,0x70,0x73,0x76,0x79,0x7c,
  	0x80,0x83,0x86,0x89,0x8c,0x8f,0x92,0x95,
  	0x98,0x9b,0x9e,0xa2,0xa5,0xa7,0xaa,0xad,
  	0xb0,0xb3,0xb6,0xb9,0xbc,0xbe,0xc1,0xc4,
  	0xc6,0xc9,0xcb,0xce,0xd0,0xd3,0xd5,0xd7,
  	0xda,0xdc,0xde,0xe0,0xe2,0xe4,0xe6,0xe8,
  	0xea,0xeb,0xed,0xee,0xf0,0xf1,0xf3,0xf4,
  	0xf5,0xf6,0xf8,0xf9,0xfa,0xfa,0xfb,0xfc,
  	0xfd,0xfd,0xfe,0xfe,0xfe,0xff,0xff,0xff,
  	0xff,0xff,0xff,0xff,0xfe,0xfe,0xfe,0xfd,
  	0xfd,0xfc,0xfb,0xfa,0xfa,0xf9,0xf8,0xf6,
  	0xf5,0xf4,0xf3,0xf1,0xf0,0xee,0xed,0xeb,
  	0xea,0xe8,0xe6,0xe4,0xe2,0xe0,0xde,0xdc,
  	0xda,0xd7,0xd5,0xd3,0xd0,0xce,0xcb,0xc9,
  	0xc6,0xc4,0xc1,0xbe,0xbc,0xb9,0xb6,0xb3,
  	0xb0,0xad,0xaa,0xa7,0xa5,0xa2,0x9e,0x9b,
  	0x98,0x95,0x92,0x8f,0x8c,0x89,0x86,0x83,
  	0x80,0x7c,0x79,0x76,0x73,0x70,0x6d,0x6a,
  	0x67,0x64,0x61,0x5d,0x5a,0x58,0x55,0x52,
  	0x4f,0x4c,0x49,0x46,0x43,0x41,0x3e,0x3b,
  	0x39,0x36,0x34,0x31,0x2f,0x2c,0x2a,0x28,
  	0x25,0x23,0x21,0x1f,0x1d,0x1b,0x19,0x17,
  	0x15,0x14,0x12,0x11,0xf,0xe,0xc,0xb,
  	0xa,0x9,0x7,0x6,0x5,0x5,0x4,0x3,
  	0x2,0x2,0x1,0x1,0x1,0x0,0x0,0x0
  }
  ,

  // Triangular wave #01
  {
  	0x2,0x4,0x6,0x8,0xa,0xc,0xe,0x10,
  	0x12,0x14,0x16,0x18,0x1a,0x1c,0x1e,0x20,
  	0x22,0x24,0x26,0x28,0x2a,0x2c,0x2e,0x30,
  	0x32,0x34,0x36,0x38,0x3a,0x3c,0x3e,0x40,
  	0x42,0x44,0x46,0x48,0x4a,0x4c,0x4e,0x50,
  	0x52,0x54,0x56,0x58,0x5a,0x5c,0x5e,0x60,
  	0x62,0x64,0x66,0x68,0x6a,0x6c,0x6e,0x70,
  	0x72,0x74,0x76,0x78,0x7a,0x7c,0x7e,0x80,
  	0x81,0x83,0x85,0x87,0x89,0x8b,0x8d,0x8f,
  	0x91,0x93,0x95,0x97,0x99,0x9b,0x9d,0x9f,
  	0xa1,0xa3,0xa5,0xa7,0xa9,0xab,0xad,0xaf,
  	0xb1,0xb3,0xb5,0xb7,0xb9,0xbb,0xbd,0xbf,
  	0xc1,0xc3,0xc5,0xc7,0xc9,0xcb,0xcd,0xcf,
  	0xd1,0xd3,0xd5,0xd7,0xd9,0xdb,0xdd,0xdf,
  	0xe1,0xe3,0xe5,0xe7,0xe9,0xeb,0xed,0xef,
  	0xf1,0xf3,0xf5,0xf7,0xf9,0xfb,0xfd,0xff,
  	0xfd,0xfb,0xf9,0xf7,0xf5,0xf3,0xf1,0xef,
  	0xed,0xeb,0xe9,0xe7,0xe5,0xe3,0xe1,0xdf,
  	0xdd,0xdb,0xd9,0xd7,0xd5,0xd3,0xd1,0xcf,
  	0xcd,0xcb,0xc9,0xc7,0xc5,0xc3,0xc1,0xbf,
  	0xbd,0xbb,0xb9,0xb7,0xb5,0xb3,0xb1,0xaf,
  	0xad,0xab,0xa9,0xa7,0xa5,0xa3,0xa1,0x9f,
  	0x9d,0x9b,0x99,0x97,0x95,0x93,0x91,0x8f,
  	0x8d,0x8b,0x89,0x87,0x85,0x83,0x81,0x80,
  	0x7e,0x7c,0x7a,0x78,0x76,0x74,0x72,0x70,
  	0x6e,0x6c,0x6a,0x68,0x66,0x64,0x62,0x60,
  	0x5e,0x5c,0x5a,0x58,0x56,0x54,0x52,0x50,
  	0x4e,0x4c,0x4a,0x48,0x46,0x44,0x42,0x40,
  	0x3e,0x3c,0x3a,0x38,0x36,0x34,0x32,0x30,
  	0x2e,0x2c,0x2a,0x28,0x26,0x24,0x22,0x20,
  	0x1e,0x1c,0x1a,0x18,0x16,0x14,0x12,0x10,
  	0xe,0xc,0xa,0x8,0x6,0x4,0x2,0x0
  }
  ,

  // Sawtooth wave #02
  {
    0x0, 0x1, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7,  
    0x8, 0x9, 0xB, 0xC, 0xD, 0xE, 0xF, 0x10,  
    0x11, 0x12, 0x13, 0x14, 0x16, 0x17, 0x18, 0x19,  
    0x1A, 0x1B, 0x1C, 0x1D, 0x1E, 0x1F, 0x21, 0x22,  
    0x23, 0x24, 0x25, 0x26, 0x27, 0x28, 0x29, 0x2A,  
    0x2C, 0x2D, 0x2E, 0x2F, 0x30, 0x31, 0x32, 0x33,  
    0x34, 0x35, 0x37, 0x38, 0x39, 0x3A, 0x3B, 0x3C,  
    0x3D, 0x3E, 0x3F, 0x40, 0x42, 0x43, 0x44, 0x45,  
    0x46, 0x47, 0x48, 0x49, 0x4A, 0x4B, 0x4D, 0x4E,  
    0x4F, 0x50, 0x51, 0x52, 0x53, 0x54, 0x55, 0x56,  
    0x58, 0x59, 0x5A, 0x5B, 0x5C, 0x5D, 0x5E, 0x5F,  
    0x60, 0x61, 0x63, 0x64, 0x65, 0x66, 0x67, 0x68,  
    0x69, 0x6A, 0x6B, 0x6C, 0x6E, 0x6F, 0x70, 0x71,  
    0x72, 0x73, 0x74, 0x75, 0x76, 0x77, 0x79, 0x7A,  
    0x7B, 0x7C, 0x7D, 0x7E, 0x7F, 0x80, 0x81, 0x82,  
    0x84, 0x85, 0x86, 0x87, 0x88, 0x89, 0x8A, 0x71,  
    0x72, 0x73, 0x75, 0x76, 0x77, 0x78, 0x79, 0x7A,  
    0x7B, 0x7C, 0x7D, 0x7E, 0x80, 0x81, 0x82, 0x83,  
    0x84, 0x85, 0x86, 0x87, 0x88, 0x89, 0x8B, 0x8C,  
    0x8D, 0x8E, 0x8F, 0x90, 0x91, 0x92, 0x93, 0x94,  
    0x96, 0x97, 0x98, 0x99, 0x9A, 0x9B, 0x9C, 0x9D,  
    0x9E, 0x9F, 0xA1, 0xA2, 0xA3, 0xA4, 0xA5, 0xA6,  
    0xA7, 0xA8, 0xA9, 0xAA, 0xAC, 0xAD, 0xAE, 0xAF,  
    0xB0, 0xB1, 0xB2, 0xB3, 0xB4, 0xB5, 0xB7, 0xB8,  
    0xB9, 0xBA, 0xBB, 0xBC, 0xBD, 0xBE, 0xBF, 0xC0,  
    0xC2, 0xC3, 0xC4, 0xC5, 0xC6, 0xC7, 0xC8, 0xC9,  
    0xCA, 0xCB, 0xCD, 0xCE, 0xCF, 0xD0, 0xD1, 0xD2,  
    0xD3, 0xD4, 0xD5, 0xD6, 0xD8, 0xD9, 0xDA, 0xDB,  
    0xDC, 0xDD, 0xDE, 0xDF, 0xE0, 0xE1, 0xE3, 0xE4,  
    0xE5, 0xE6, 0xE7, 0xE8, 0xE9, 0xEA, 0xEB, 0xEC,  
    0xEE, 0xEF, 0xF0, 0xF1, 0xF2, 0xF3, 0xF4, 0xF5,  
    0xF6, 0xF7, 0xF9, 0xFA, 0xFB, 0xFC, 0xFD, 0xFF

    /*
    0x0, 0x1, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7,  
    0x8, 0x9, 0xA, 0xB, 0xC, 0xD, 0xE, 0xF,  
    0x10, 0x11, 0x12, 0x13, 0x14, 0x15, 0x16, 0x17,  
    0x18, 0x19, 0x1A, 0x1B, 0x1C, 0x1D, 0x1E, 0x1F,  
    0x20, 0x21, 0x22, 0x23, 0x24, 0x25, 0x26, 0x27,  
    0x28, 0x29, 0x2A, 0x2B, 0x2C, 0x2D, 0x2E, 0x2F,  
    0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37,  
    0x38, 0x39, 0x3A, 0x3B, 0x3C, 0x3D, 0x3E, 0x3F,  
    0x40, 0x41, 0x42, 0x43, 0x44, 0x45, 0x46, 0x47,  
    0x48, 0x49, 0x4A, 0x4B, 0x4C, 0x4D, 0x4E, 0x4F,  
    0x50, 0x51, 0x52, 0x53, 0x54, 0x55, 0x56, 0x57,  
    0x58, 0x59, 0x5A, 0x5B, 0x5C, 0x5D, 0x5E, 0x5F,  
    0x60, 0x61, 0x62, 0x63, 0x64, 0x65, 0x66, 0x67,  
    0x68, 0x69, 0x6A, 0x6B, 0x6C, 0x6D, 0x6E, 0x6F,  
    0x70, 0x71, 0x72, 0x73, 0x74, 0x75, 0x76, 0x77,  
    0x78, 0x79, 0x7A, 0x7B, 0x7C, 0x7D, 0x7E, 0x7F,  
    0x80, 0x81, 0x82, 0x83, 0x84, 0x85, 0x86, 0x87,  
    0x88, 0x89, 0x8A, 0x8B, 0x8C, 0x8D, 0x8E, 0x8F,  
    0x90, 0x91, 0x92, 0x93, 0x94, 0x95, 0x96, 0x97,  
    0x98, 0x99, 0x9A, 0x9B, 0x9C, 0x9D, 0x9E, 0x9F,  
    0xA0, 0xA1, 0xA2, 0xA3, 0xA4, 0xA5, 0xA6, 0xA7,  
    0xA8, 0xA9, 0xAA, 0xAB, 0xAC, 0xAD, 0xAE, 0xAF,  
    0xB0, 0xB1, 0xB2, 0xB3, 0xB4, 0xB5, 0xB6, 0xB7,  
    0xB8, 0xB9, 0xBA, 0xBB, 0xBC, 0xBD, 0xBE, 0xBF,  
    0xC0, 0xC1, 0xC2, 0xC3, 0xC4, 0xC5, 0xC6, 0xC7,  
    0xC8, 0xC9, 0xCA, 0xCB, 0xCC, 0xCD, 0xCE, 0xCF,  
    0xD0, 0xD1, 0xD2, 0xD3, 0xD4, 0xD5, 0xD6, 0xD7,  
    0xD8, 0xD9, 0xDA, 0xDB, 0xDC, 0xDD, 0xDE, 0xDF,  
    0xE0, 0xE1, 0xE2, 0xE3, 0xE4, 0xE5, 0xE6, 0xE7,  
    0xE8, 0xE9, 0xEA, 0xEB, 0xEC, 0xED, 0xEE, 0xEF,  
    0xF0, 0xF1, 0xF2, 0xF3, 0xF4, 0xF5, 0xF6, 0xF7,  
    0xF8, 0xF9, 0xFA, 0xFB, 0xFC, 0xFD, 0xFE, 0x00
    */
  }
  ,

  // Sqare wave #03
  {
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
    0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
    0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
    0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
    0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
    0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
    0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
    0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
    0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
    0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
    0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
    0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
    0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
    0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
    0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
    0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
  }
  ,

  // White noise #04
  {
    0x41, 0x37, 0x23, 0x1D, 0xE1, 0x18, 0xDF, 0x26,  
    0x62, 0x48, 0xE1, 0x77, 0x09, 0x8C, 0x8A, 0x7E,  
    0xCB, 0x77, 0x0B, 0xB2, 0xA0, 0x2A, 0x54, 0x6F,  
    0x0D, 0x50, 0x40, 0x0E, 0xEC, 0x58, 0x00, 0x44,  
    0x7F, 0xF5, 0xC5, 0xBD, 0xB5, 0xD4, 0xB2, 0xF9,  
    0xBB, 0x9D, 0x01, 0x66, 0xC6, 0x2D, 0x74, 0xBF,  
    0x20, 0x11, 0xFE, 0xA4, 0x71, 0x46, 0xB2, 0x7B,  
    0x50, 0x2F, 0xED, 0x86, 0x0A, 0xD8, 0xC0, 0x45,  
    0xB1, 0x6A, 0xA0, 0x0E, 0x69, 0xEE, 0x51, 0xEB,  
    0xEF, 0x46, 0x10, 0xB4, 0x6A, 0x69, 0x00, 0x6D,  
    0x76, 0xDE, 0xD7, 0xE2, 0x6E, 0x7C, 0xC9, 0x81,  
    0xFA, 0x60, 0xB4, 0x78, 0xDA, 0x2F, 0x8E, 0x0F,  
    0xF1, 0x8D, 0x0C, 0x48, 0x95, 0xDE, 0x94, 0xB4,  
    0x16, 0x3C, 0x66, 0x98, 0x8C, 0xB9, 0x06, 0x41,  
    0xE6, 0xD6, 0xEC, 0xA5, 0x30, 0x43, 0x6F, 0x3B,  
    0x24, 0xD9, 0xEF, 0x1C, 0xF5, 0xD6, 0x42, 0x5B,  
    0x57, 0x58, 0x61, 0xA1, 0xD2, 0x1B, 0x54, 0x0D,  
    0x49, 0x77, 0x5B, 0x4B, 0xC6, 0x95, 0x5E, 0xF3,  
    0x88, 0xF1, 0x97, 0x24, 0x4F, 0x15, 0x7D, 0x60,  
    0xE6, 0x94, 0xF4, 0xAB, 0xF2, 0x44, 0xB4, 0xE0,  
    0xFB, 0xC1, 0xF7, 0x53, 0xB8, 0x1F, 0x67, 0xAD,  
    0x9F, 0xEE, 0x47, 0x04, 0xAD, 0x74, 0xE0, 0x39,  
    0x73, 0x26, 0x2E, 0x97, 0x62, 0x68, 0xCC, 0xA9,  
    0x57, 0x87, 0x1D, 0x5C, 0x6A, 0xF3, 0xBC, 0x56,  
    0xF3, 0xC1, 0x27, 0x95, 0xDE, 0x60, 0xA7, 0x4C,  
    0x31, 0x9B, 0x82, 0xFB, 0xDB, 0xD0, 0x64, 0xCD,  
    0xC0, 0x6F, 0x0B, 0x36, 0x01, 0xB6, 0x33, 0xCD,  
    0x90, 0xAA, 0xC1, 0x67, 0xF4, 0x59, 0x33, 0x75,  
    0x5A, 0x50, 0x47, 0xA0, 0xDD, 0x57, 0xEA, 0xA3,  
    0x17, 0x74, 0x64, 0x68, 0xE8, 0x1F, 0xC3, 0x66,  
    0x86, 0xC2, 0x85, 0x3A, 0xC5, 0x75, 0x89, 0x84,  
    0xA9, 0xF7, 0x38, 0x05, 0x29, 0xF0, 0xEF, 0x24 
  }
  ,

  //LPF
  {
    0x40, 0x80, 0xC0, 0xFF, 0xDF, 0xDB, 0xD7, 0xD4,  
    0xD1, 0xCF, 0xCC, 0xCA, 0xC7, 0xC5, 0xC3, 0xC1,  
    0xBF, 0xBD, 0xBB, 0xB9, 0xB7, 0xB5, 0xB4, 0xB2,  
    0xB0, 0xAF, 0xAD, 0xAC, 0xAA, 0xA9, 0xA7, 0xA6,  
    0xA4, 0xA3, 0xA1, 0xA0, 0x9F, 0x9D, 0x9C, 0x9B,  
    0x9A, 0x98, 0x97, 0x96, 0x95, 0x93, 0x92, 0x91,  
    0x90, 0x8F, 0x8E, 0x8C, 0x8B, 0x8A, 0x89, 0x88,  
    0x87, 0x86, 0x85, 0x84, 0x83, 0x82, 0x81, 0x80,  
    0x7F, 0x7E, 0x7D, 0x7C, 0x7B, 0x7A, 0x79, 0x78,  
    0x77, 0x76, 0x75, 0x74, 0x73, 0x72, 0x71, 0x71,  
    0x70, 0x6F, 0x6E, 0x6D, 0x6C, 0x6B, 0x6A, 0x6A,  
    0x69, 0x68, 0x67, 0x66, 0x65, 0x65, 0x64, 0x63,  
    0x62, 0x61, 0x60, 0x60, 0x5F, 0x5E, 0x5D, 0x5C,  
    0x5C, 0x5B, 0x5A, 0x59, 0x59, 0x58, 0x57, 0x56,  
    0x56, 0x55, 0x54, 0x53, 0x53, 0x52, 0x51, 0x50,  
    0x50, 0x4F, 0x4E, 0x4D, 0x4D, 0x4C, 0x4B, 0x4B,  
    0x4A, 0x49, 0x48, 0x48, 0x47, 0x46, 0x46, 0x45,  
    0x44, 0x44, 0x43, 0x42, 0x42, 0x41, 0x40, 0x40,  
    0x3F, 0x3E, 0x3E, 0x3D, 0x3C, 0x3C, 0x3B, 0x3A,  
    0x3A, 0x39, 0x38, 0x38, 0x37, 0x36, 0x36, 0x35,  
    0x35, 0x34, 0x33, 0x33, 0x32, 0x31, 0x31, 0x30,  
    0x30, 0x2F, 0x2E, 0x2E, 0x2D, 0x2C, 0x2C, 0x2B,  
    0x2B, 0x2A, 0x29, 0x29, 0x28, 0x28, 0x27, 0x26,  
    0x26, 0x25, 0x25, 0x24, 0x24, 0x23, 0x22, 0x22,  
    0x21, 0x21, 0x20, 0x20, 0x1F, 0x1E, 0x1E, 0x1D,  
    0x1D, 0x1C, 0x1C, 0x1B, 0x1A, 0x1A, 0x19, 0x19,  
    0x18, 0x18, 0x17, 0x17, 0x16, 0x15, 0x15, 0x14,  
    0x14, 0x13, 0x13, 0x12, 0x12, 0x11, 0x11, 0x10,  
    0x10, 0xF,  0xE,  0xE,  0xD,  0xD,  0xC,  0xC,  
    0xB,  0xB,  0xA,  0xA,  0x9,  0x9,  0x8,  0x8,  
    0x7,  0x7,  0x6,  0x6,  0x5,  0x5,  0x4,  0x4,  
    0x3,  0x3,  0x2,  0x2,  0x1,  0x1,  0x0,  0x0 
  }
};


