unit FrmMidiCC;

interface

uses
  Winapi.Windows, Winapi.Messages, System.SysUtils, System.Variants, System.Classes, Vcl.Graphics,
  Vcl.Controls, Vcl.Forms, Vcl.Dialogs, Vcl.StdCtrls, Vcl.Buttons, knobs2013, Vcl.ExtCtrls, Vcl.Grids,

  KnobsUtils, KnobsConversions;

const

  MAX_CC = 119;

type

  TFormSelectMidiCC = class(TForm)
    PanelControl: TPanel;
    CC: TKnobsKnob;
    display_midicc: TKnobsDisplay;
    Label1: TLabel;
    BitBtnApply: TBitBtn;
    BitBtnCancel: TBitBtn;
    PanelOverview: TPanel;
    PanelOverviewTop: TPanel;
    StringGridOverview: TStringGrid;
    BitBtnUnAssign: TBitBtn;
    procedure FormResize(Sender: TObject);
    procedure BitBtnApplyClick(Sender: TObject);
    procedure BitBtnCancelClick(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure StringGridOverviewDrawCell(Sender: TObject; ACol, ARow: Integer; Rect: TRect; State: TGridDrawState);
    procedure StringGridOverviewClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure BitBtnUnAssignClick(Sender: TObject);
    procedure CCValueChanged(const aSender: TObject; const aPath, aControlType: string; aValue: Double; IsFinal,
      IsAutomation: Boolean);
  private
    FMidiCC           : Byte;
    FOriginalCC       : Byte;
    FController       : IKnobsAutomatable;
    FControlName      : string;
    FControllers      : array[ 1 .. MAX_CC] of IKnobsAutomatable;
    FControlMode      : TDistanceMode;
    FUseWheelOnKnobs  : Boolean;
    FWheelSensitivity : Integer;
  private
    procedure   SetMidiCC( aValue: Byte);
    procedure   SetControlName( const aValue: string);
    procedure   SetControlMode( aValue: TDistanceMode);
    procedure   SetUseWheelOnKnobs( aValue: Boolean);
    procedure   SetWheelSensitivity( aValue: Integer);
    procedure   FixGridData;
    procedure   FixGridSize;
  public
    procedure   View;
    function    Execute( const aControlName: string; const aMidiCC: Byte; const aController: IKnobsAutomatable): Boolean;
    procedure   RegisterControlName( const aCC: Byte; const aControlName: string; const aController: IKnobsAutomatable);
    procedure   UnregisterCC( const aCC: Byte);
    procedure   UnregisterComtrolNames;
    function    CCToControlName ( const aCC: Byte): string;
    function    CCToController( const aCC: Byte): IKnobsAutomatable;
  public
    property    MidiCC           : Byte          read FMidiCC           write SetMidiCC;
    property    ControlName      : string        read FControlName      write SetControlName;
    property    ControlMode      : TDistanceMode read FControlMode      write SetControlMode;
    property    UseWheelOnKnobs  : Boolean       read FUseWheelOnKnobs  write SetUseWheelOnKnobs;
    property    WheelSensitivity : Integer       read FWheelSensitivity write SetWheelSensitivity;
  end;

var

  FormSelectMidiCC: TFormSelectMidiCC;



implementation



// User area


//  private

    procedure   TFormSelectMidiCC.SetMidiCC( aValue: Byte);
    begin
      if aValue <> FMidiCC
      then begin
        FMidiCC := aValue;
        CC.KnobPosition := FMidiCC;
        if Assigned( StringGridOverview) and ( FMidiCC > 0) and ( fsModal in FormState)
        then begin
          StringGridOverview.TopRow := FMidiCC;
          StringGridOverview.Row    := FMidiCC;
        end;
      end;
    end;


    procedure   TFormSelectMidiCC.SetControlName( const aValue: string);
    begin
      if aValue <> FControlName
      then begin
        FControlName := aValue;
        Caption := Format( 'Set MIDI CC for ''%s''', [ aValue], AppLocale);
      end;
    end;


    procedure   TFormSelectMidiCC.SetControlMode( aValue: TDistanceMode);
    begin
      if aValue <> FControlMode
      then begin
        FControlMode   := aValue;
        CC.ControlMode := aValue;
      end;
    end;


    procedure   TFormSelectMidiCC.SetUseWheelOnKnobs( aValue: Boolean);
    begin
      if aValue <> UseWheelOnKnobs
      then begin
        FUseWheelOnKnobs := aValue;
        CC.WheelSupport  := aValue;
      end;
    end;


    procedure   TFormSelectMidiCC.SetWheelSensitivity( aValue: Integer);
    begin
      if aValue <> FWheelSensitivity
      then begin
        FWheelSensitivity   := aValue;
        CC.WheelSensitivity := aValue;
      end;
    end;


    procedure   TFormSelectMidiCC.FixGridData;
    var
      i : Integer;
    begin
      with StringGridOverview
      do begin
        RowCount := MAX_CC + 1;
        ColCount := 2;
        Rows[ 0].CommaText := '" CC", "assigned to"';
        for i := 1 to RowCount - 1
        do Rows[ i].CommaText := Format( '"%d", ""', [ i], AppLocale);
      end;
    end;


    procedure   TFormSelectMidiCC.FixGridSize;
    begin
      with StringGridOverview
      do begin
        ColWidths[ 0] := 44;
        ColWidths[ 1] := ClientWidth - 2 - ColWidths[ 0];
      end;
    end;


//  public

    procedure   TFormSelectMidiCC.View;
    begin
      if Visible
      then ModalResult := mrCancel;

      ControlName  := '';
      FController  := nil;
      MidiCC       := 0;
      FOriginalCC  := 0;
      Caption      := 'View MIDI CC assignents';

      BitBtnUnAssign.Visible := False;
      BitBtnApply   .Visible := False;
      BitBtnCancel  .Caption := 'close';

      Show;
    end;


    function    TFormSelectMidiCC.Execute( const aControlName: string; const aMidiCC: Byte; const aController: IKnobsAutomatable): Boolean;
    begin
      if Visible
      then Close;

      ControlName := aControlName;
      FController := aController;
      MidiCC      := aMidiCC;
      FOriginalCC := MidiCC;

      BitBtnApply .Visible := True;
      BitBtnCancel.Caption := 'cancel';

      Result := ShowModal = mrOk;
    end;


    procedure   TFormSelectMidiCC.RegisterControlName( const aCC: Byte; const aControlName: string; const aController: IKnobsAutomatable);
    begin
      if ( aCC > 0) and ( aCC < StringGridOverview.RowCount)
      then begin
        StringGridOverview.Cells[ 1, aCC] := aControlName;
        FControllers[ aCC] := aController;
      end;
    end;


    procedure   TFormSelectMidiCC.UnregisterCC( const aCC: Byte);
    begin
      if ( aCC > 0) and ( aCC < StringGridOverview.RowCount)
      then begin
        FControllers[ aCC] := nil;
        StringGridOverview.Cells  [ 1, aCC] := '';
      end;
    end;


    procedure   TFormSelectMidiCC.UnregisterComtrolNames;
    var
      i : Integer;
    begin
      for i := 1 to StringGridOverview.RowCount - 1
      do begin
        FControllers[ i] := nil;
        StringGridOverview.Cells  [ 1, i] := '';
      end;
    end;


    function    TFormSelectMidiCC.CCToControlName( const aCC: Byte): string;
    begin
      if ( aCC > 0) and ( aCC < StringGridOverview.RowCount)
      then Result := StringGridOverview.Cells[ 1, aCC]
      else Result := '';
    end;


    function    TFormSelectMidiCC.CCToController( const aCC: Byte): IKnobsAutomatable;
    begin
      if ( aCC > 0) and ( aCC < StringGridOverview.RowCount)
      then Result := FControllers[ aCC]
      else Result := nil;
    end;


// Delphi area


{$R *.dfm}

procedure TFormSelectMidiCC.CCValueChanged(const aSender: TObject; const aPath, aControlType: string; aValue: Double;
  IsFinal, IsAutomation: Boolean);
begin
  if fsModal in FormState
  then MidiCC := ( aSender as TKnobsValuedControl).KnobPosition;
end;


procedure TFormSelectMidiCC.BitBtnCancelClick(Sender: TObject);
begin
  if fsModal in FormState
  then ModalResult := mrCancel
  else Close;
end;


procedure TFormSelectMidiCC.BitBtnUnAssignClick(Sender: TObject);
begin
  if fsModal in FormState
  then begin
    MidiCC := 0;
    RegisterControlName( FOriginalCC, '', nil);
    ModalResult := mrOk
  end
  else Close;
end;


procedure TFormSelectMidiCC.BitBtnApplyClick(Sender: TObject);
begin
  if fsModal in FormState
  then begin
    RegisterControlName( FOriginalCC, ''         , nil        );
    RegisterControlName( MidiCC     , ControlName, FController);
    ModalResult := mrOk;
  end
  else Close;
end;


procedure TFormSelectMidiCC.FormCreate(Sender: TObject);
begin
  FixGridData;
end;


procedure TFormSelectMidiCC.FormResize(Sender: TObject);
begin
  FixGridSize;
end;


procedure TFormSelectMidiCC.FormShow(Sender: TObject);
begin
  FixGridSize;
end;


procedure TFormSelectMidiCC.StringGridOverviewClick(Sender: TObject);
begin
  MidiCC := StringGridOverview.Row;
end;


procedure TFormSelectMidiCC.StringGridOverviewDrawCell(Sender: TObject; ACol, ARow: Integer; Rect: TRect;
  State: TGridDrawState);
var
  S          : string;
  SavedAlign : Word;
begin
  if ( ACol = 0) and ( ARow > 0)
  then begin
    S := StringGridOverview.Cells[ ACol, ARow];
    SavedAlign := SetTextAlign( StringGridOverview.Canvas.Handle, TA_RIGHT);
    StringGridOverview.Canvas.TextRect( Rect, Rect.Left + ( Rect.Right - Rect.Left) div 2, Rect.Top + 2, S);
    SetTextAlign( StringGridOverview.Canvas.Handle, SavedAlign);
  end
end;


end.

